/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.PrintWriter;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntaxOntologyFormat;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.io.OWLFunctionalSyntaxOntologyFormat;
import org.semanticweb.owlapi.io.OWLOntologyCreationIOException;
import org.semanticweb.owlapi.io.OWLXMLOntologyFormat;
import org.semanticweb.owlapi.io.RDFXMLOntologyFormat;
import org.semanticweb.owlapi.io.UnparsableOntologyException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.UnloadableImportException;

public class OntologySaver {
    public static String saveOntologyToFile(String s) {
        int delim1 = s.indexOf(10);
        String pathToFile = s.substring(0, delim1);
        int delim2 = s.indexOf(10, delim1 + 1);
        String fileType = s.substring(delim1 + 1, delim2);
        String ontologyText = s.substring(delim2 + 1);
        PrintWriter ontologyFile = null;
        try {
            ontologyFile = new PrintWriter(pathToFile, "UTF8");
            ontologyFile.println(ontologyText);
        }
        catch (Exception e) {
            return "Ontology save failed: error when creating or opening file " + pathToFile + " (Java FileNotFoundException)";
        }
        ontologyFile.close();
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        File file = new File(pathToFile);
        OWLOntology ontology = null;
        try {
            ontology = manager.loadOntologyFromOntologyDocument(file);
        }
        catch (UnparsableOntologyException e) {
            return "Ontology save failed: error when parsing functional syntax (Java UnparsableOntologyException).";
        }
        catch (UnloadableImportException e) {
            return "Ontology save failed: problem with importing other ontologies (Java UnloadableImportException).";
        }
        catch (OWLOntologyCreationIOException e) {
            return "Ontology save failed: Java IOException when reading ontology (Java OWLOntologyCreationIOException.";
        }
        catch (OWLOntologyCreationException e) {
            return "Ontology save failed: unknown reason (Java OWLOntologyCreationException).";
        }
        Object ontologyFormat = null;
        ontologyFormat = fileType.compareTo("RDF/XML") == 0 ? new RDFXMLOntologyFormat() : (fileType.compareTo("OWL/XML") == 0 ? new OWLXMLOntologyFormat() : (fileType.compareTo("Functional") == 0 ? new OWLFunctionalSyntaxOntologyFormat() : new ManchesterOWLSyntaxOntologyFormat()));
        manager.setOntologyFormat(ontology, (OWLOntologyFormat)ontologyFormat);
        try {
            manager.saveOntology(ontology);
        }
        catch (OWLOntologyStorageException e) {
            return "Ontology save failed: error with accessing file (Java OWLOntologyStorageException)";
        }
        return "Ontology succesfully saved in " + fileType + " notation file at " + pathToFile;
    }
}

