/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.model;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.bind.api.CompositeStructure;
import com.sun.xml.internal.bind.api.TypeReference;
import com.sun.xml.internal.bind.v2.model.nav.Navigator;
import com.sun.xml.internal.ws.api.BindingID;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.model.ExceptionType;
import com.sun.xml.internal.ws.api.model.MEP;
import com.sun.xml.internal.ws.api.model.Parameter;
import com.sun.xml.internal.ws.api.model.ParameterBinding;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPart;
import com.sun.xml.internal.ws.model.AbstractSEIModelImpl;
import com.sun.xml.internal.ws.model.CheckedExceptionImpl;
import com.sun.xml.internal.ws.model.JavaMethodImpl;
import com.sun.xml.internal.ws.model.ParameterImpl;
import com.sun.xml.internal.ws.model.RuntimeModelerException;
import com.sun.xml.internal.ws.model.SOAPSEIModel;
import com.sun.xml.internal.ws.model.WrapperBeanGenerator;
import com.sun.xml.internal.ws.model.WrapperParameter;
import com.sun.xml.internal.ws.model.soap.SOAPBindingImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLBoundOperationImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLInputImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLPortImpl;
import com.sun.xml.internal.ws.resources.ModelerMessages;
import com.sun.xml.internal.ws.resources.ServerMessages;
import com.sun.xml.internal.ws.util.localization.Localizable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.namespace.QName;
import javax.xml.ws.Action;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.FaultAction;
import javax.xml.ws.Holder;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.Response;
import javax.xml.ws.ResponseWrapper;
import javax.xml.ws.WebFault;
import javax.xml.ws.WebServiceFeature;

public class RuntimeModeler {
    private final WebServiceFeature[] features;
    private final BindingID bindingId;
    private final Class portClass;
    private AbstractSEIModelImpl model;
    private SOAPBindingImpl defaultBinding;
    private String packageName;
    private String targetNamespace;
    private boolean isWrapped = true;
    private ClassLoader classLoader;
    private final WSDLPortImpl binding;
    private QName serviceName;
    private QName portName;
    public static final String PD_JAXWS_PACKAGE_PD = ".jaxws.";
    public static final String JAXWS_PACKAGE_PD = "jaxws.";
    public static final String RESPONSE = "Response";
    public static final String RETURN = "return";
    public static final String BEAN = "Bean";
    public static final String SERVICE = "Service";
    public static final String PORT = "Port";
    public static final Class HOLDER_CLASS = Holder.class;
    public static final Class<RemoteException> REMOTE_EXCEPTION_CLASS = RemoteException.class;
    public static final Class<RuntimeException> RUNTIME_EXCEPTION_CLASS = RuntimeException.class;
    public static final Class<Exception> EXCEPTION_CLASS = Exception.class;
    private static final Logger logger = Logger.getLogger("com.sun.xml.internal.ws.server");

    public RuntimeModeler(@NotNull Class clazz, @NotNull QName qName, @NotNull BindingID bindingID, WebServiceFeature ... webServiceFeatureArray) {
        this(clazz, qName, null, bindingID, webServiceFeatureArray);
    }

    public RuntimeModeler(@NotNull Class clazz, @NotNull QName qName, @NotNull WSDLPortImpl wSDLPortImpl, WebServiceFeature ... webServiceFeatureArray) {
        this(clazz, qName, wSDLPortImpl, wSDLPortImpl.getBinding().getBindingId(), webServiceFeatureArray);
    }

    private RuntimeModeler(@NotNull Class clazz, @NotNull QName qName, WSDLPortImpl wSDLPortImpl, BindingID bindingID, WebServiceFeature ... webServiceFeatureArray) {
        this.portClass = clazz;
        this.serviceName = qName;
        this.binding = wSDLPortImpl;
        this.bindingId = bindingID;
        this.features = webServiceFeatureArray;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setPortName(QName qName) {
        this.portName = qName;
    }

    private static <T extends Annotation> T getPrivClassAnnotation(final Class<?> clazz, final Class<T> clazz2) {
        return (T)((Annotation)AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                return clazz.getAnnotation(clazz2);
            }
        }));
    }

    private static <T extends Annotation> T getPrivMethodAnnotation(final Method method, final Class<T> clazz) {
        return (T)((Annotation)AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                return method.getAnnotation(clazz);
            }
        }));
    }

    private static Annotation[][] getPrivParameterAnnotations(final Method method) {
        return AccessController.doPrivileged(new PrivilegedAction<Annotation[][]>(){

            @Override
            public Annotation[][] run() {
                return method.getParameterAnnotations();
            }
        });
    }

    public AbstractSEIModelImpl buildRuntimeModel() {
        Object object;
        this.model = new SOAPSEIModel(this.features);
        Class clazz = this.portClass;
        WebService webService = RuntimeModeler.getPrivClassAnnotation(this.portClass, WebService.class);
        if (webService == null) {
            throw new RuntimeModelerException("runtime.modeler.no.webservice.annotation", this.portClass.getCanonicalName());
        }
        if (webService.endpointInterface().length() > 0) {
            clazz = this.getClass(webService.endpointInterface(), ModelerMessages.localizableRUNTIME_MODELER_CLASS_NOT_FOUND(webService.endpointInterface()));
            object = RuntimeModeler.getPrivClassAnnotation(clazz, WebService.class);
            if (object == null) {
                throw new RuntimeModelerException("runtime.modeler.endpoint.interface.no.webservice", webService.endpointInterface());
            }
            SOAPBinding sOAPBinding = RuntimeModeler.getPrivClassAnnotation(this.portClass, SOAPBinding.class);
            SOAPBinding sOAPBinding2 = RuntimeModeler.getPrivClassAnnotation(clazz, SOAPBinding.class);
            if (sOAPBinding != null && (sOAPBinding2 == null || sOAPBinding2.style() != sOAPBinding.style() || sOAPBinding2.use() != sOAPBinding.use())) {
                logger.warning(ServerMessages.RUNTIMEMODELER_INVALIDANNOTATION_ON_IMPL("@SOAPBinding", this.portClass.getName(), clazz.getName()));
            }
        }
        if (this.serviceName == null) {
            this.serviceName = RuntimeModeler.getServiceName(this.portClass);
        }
        this.model.setServiceQName(this.serviceName);
        object = this.portClass.getSimpleName() + PORT;
        if (webService.portName().length() > 0) {
            object = webService.portName();
        } else if (webService.name().length() > 0) {
            object = webService.name() + PORT;
        }
        if (this.portName == null) {
            this.portName = new QName(this.serviceName.getNamespaceURI(), (String)object);
        }
        if (!this.portName.getNamespaceURI().equals(this.serviceName.getNamespaceURI())) {
            throw new RuntimeModelerException("runtime.modeler.portname.servicename.namespace.mismatch", this.serviceName, this.portName);
        }
        this.model.setPortName(this.portName);
        this.processClass(clazz);
        if (this.model.getJavaMethods().size() == 0) {
            throw new RuntimeModelerException("runtime.modeler.no.operations", this.portClass.getName());
        }
        this.model.postProcess();
        if (this.binding != null) {
            this.model.freeze(this.binding);
        }
        return this.model;
    }

    private Class getClass(String string, Localizable localizable) {
        try {
            if (this.classLoader == null) {
                return Thread.currentThread().getContextClassLoader().loadClass(string);
            }
            return this.classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeModelerException(localizable);
        }
    }

    private Class getRequestWrapperClass(String string, Method method, QName qName) {
        ClassLoader classLoader = this.classLoader == null ? Thread.currentThread().getContextClassLoader() : this.classLoader;
        try {
            return classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.fine("Dynamically creating request wrapper Class " + string);
            return WrapperBeanGenerator.createRequestWrapperBean(string, method, qName, classLoader);
        }
    }

    private Class getResponseWrapperClass(String string, Method method, QName qName) {
        ClassLoader classLoader = this.classLoader == null ? Thread.currentThread().getContextClassLoader() : this.classLoader;
        try {
            return classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.fine("Dynamically creating response wrapper bean Class " + string);
            return WrapperBeanGenerator.createResponseWrapperBean(string, method, qName, classLoader);
        }
    }

    private Class getExceptionBeanClass(String string, Class clazz, String string2, String string3) {
        ClassLoader classLoader = this.classLoader == null ? Thread.currentThread().getContextClassLoader() : this.classLoader;
        try {
            return classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.fine("Dynamically creating exception bean Class " + string);
            return WrapperBeanGenerator.createExceptionBean(string, clazz, this.targetNamespace, string2, string3, classLoader);
        }
    }

    void processClass(Class clazz) {
        WebService webService = RuntimeModeler.getPrivClassAnnotation(clazz, WebService.class);
        String string = clazz.getSimpleName();
        if (webService.name().length() > 0) {
            string = webService.name();
        }
        this.targetNamespace = webService.targetNamespace();
        this.packageName = "";
        if (clazz.getPackage() != null) {
            this.packageName = clazz.getPackage().getName();
        }
        if (this.targetNamespace.length() == 0) {
            this.targetNamespace = RuntimeModeler.getNamespace(this.packageName);
        }
        this.model.setTargetNamespace(this.targetNamespace);
        QName qName = new QName(this.targetNamespace, string);
        this.model.setPortTypeName(qName);
        this.model.setWSDLLocation(webService.wsdlLocation());
        SOAPBinding sOAPBinding = RuntimeModeler.getPrivClassAnnotation(clazz, SOAPBinding.class);
        if (sOAPBinding != null) {
            if (sOAPBinding.style() == SOAPBinding.Style.RPC && sOAPBinding.parameterStyle() == SOAPBinding.ParameterStyle.BARE) {
                throw new RuntimeModelerException("runtime.modeler.invalid.soapbinding.parameterstyle", sOAPBinding, clazz);
            }
            this.isWrapped = sOAPBinding.parameterStyle() == SOAPBinding.ParameterStyle.WRAPPED;
        }
        this.defaultBinding = this.createBinding(sOAPBinding);
        for (Method method : clazz.getMethods()) {
            if (!clazz.isInterface() && !this.isWebMethodBySpec(method, clazz)) continue;
            this.processMethod(method);
        }
        XmlSeeAlso xmlSeeAlso = RuntimeModeler.getPrivClassAnnotation(clazz, XmlSeeAlso.class);
        if (xmlSeeAlso != null) {
            this.model.addAdditionalClasses(xmlSeeAlso.value());
        }
    }

    private boolean isWebMethodBySpec(Method method, Class clazz) {
        boolean bl;
        int n = method.getModifiers();
        boolean bl2 = bl = Modifier.isStatic(n) || Modifier.isFinal(n);
        assert (Modifier.isPublic(n));
        assert (!clazz.isInterface());
        WebMethod webMethod = RuntimeModeler.getPrivMethodAnnotation(method, WebMethod.class);
        if (webMethod != null) {
            if (webMethod.exclude()) {
                return false;
            }
            if (bl) {
                throw new RuntimeModelerException(ModelerMessages.localizableRUNTIME_MODELER_WEBMETHOD_MUST_BE_NONSTATICFINAL(method));
            }
            return true;
        }
        if (bl) {
            return false;
        }
        Class<?> clazz2 = method.getDeclaringClass();
        return RuntimeModeler.getPrivClassAnnotation(clazz2, WebService.class) != null;
    }

    protected SOAPBindingImpl createBinding(SOAPBinding sOAPBinding) {
        SOAPBindingImpl sOAPBindingImpl = new SOAPBindingImpl();
        SOAPBinding.Style style = sOAPBinding != null ? sOAPBinding.style() : SOAPBinding.Style.DOCUMENT;
        sOAPBindingImpl.setStyle(style);
        assert (this.bindingId != null);
        SOAPVersion sOAPVersion = this.bindingId.getSOAPVersion();
        sOAPBindingImpl.setSOAPVersion(sOAPVersion);
        return sOAPBindingImpl;
    }

    public static String getNamespace(@NotNull String string) {
        String[] stringArray;
        if (string.length() == 0) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() == 0) {
            stringArray = new String[]{};
        } else {
            stringArray = new String[stringTokenizer.countTokens()];
            for (int i = stringTokenizer.countTokens() - 1; i >= 0; --i) {
                stringArray[i] = stringTokenizer.nextToken();
            }
        }
        StringBuilder stringBuilder = new StringBuilder("http://");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append(stringArray[i]);
        }
        stringBuilder.append('/');
        return stringBuilder.toString();
    }

    private boolean isServiceException(Class<?> clazz) {
        return EXCEPTION_CLASS.isAssignableFrom(clazz) && !RUNTIME_EXCEPTION_CLASS.isAssignableFrom(clazz) && !REMOTE_EXCEPTION_CLASS.isAssignableFrom(clazz);
    }

    protected void processMethod(Method method) {
        Object object;
        Object object2;
        Object object3;
        Class<?> clazz2;
        int n = method.getModifiers();
        if (!Modifier.isPublic(n) || Modifier.isStatic(n)) {
            if (method.getAnnotation(WebMethod.class) != null) {
                if (Modifier.isStatic(n)) {
                    throw new RuntimeModelerException(ModelerMessages.localizableRUNTIME_MODELER_WEBMETHOD_MUST_BE_NONSTATIC(method));
                }
                throw new RuntimeModelerException(ModelerMessages.localizableRUNTIME_MODELER_WEBMETHOD_MUST_BE_PUBLIC(method));
            }
            return;
        }
        WebMethod webMethod = RuntimeModeler.getPrivMethodAnnotation(method, WebMethod.class);
        if (webMethod != null && webMethod.exclude()) {
            return;
        }
        String string = method.getName();
        boolean bl = method.isAnnotationPresent(Oneway.class);
        if (bl) {
            for (Class<?> clazz2 : method.getExceptionTypes()) {
                if (!this.isServiceException(clazz2)) continue;
                throw new RuntimeModelerException("runtime.modeler.oneway.operation.no.checked.exceptions", this.portClass.getCanonicalName(), string, clazz2.getName());
            }
        }
        if (method.getDeclaringClass() == this.portClass) {
            object3 = new JavaMethodImpl(this.model, method, method);
        } else {
            try {
                Method method2 = this.portClass.getMethod(method.getName(), method.getParameterTypes());
                object3 = new JavaMethodImpl(this.model, method2, method);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeModelerException("runtime.modeler.method.not.found", method.getName(), this.portClass.getName());
            }
        }
        MEP mEP = this.getMEP(method);
        ((JavaMethodImpl)object3).setMEP(mEP);
        Object object4 = null;
        clazz2 = method.getName();
        if (webMethod != null) {
            object4 = webMethod.action();
            Class<?> clazz3 = clazz2 = webMethod.operationName().length() > 0 ? webMethod.operationName() : clazz2;
        }
        if (this.binding != null && (object2 = this.binding.getBinding().get(new QName(this.targetNamespace, (String)((Object)clazz2)))) != null) {
            WSDLInputImpl wSDLInputImpl = ((WSDLBoundOperationImpl)object2).getOperation().getInput();
            object = wSDLInputImpl.getAction();
            object4 = object != null && !wSDLInputImpl.isDefaultAction() ? object : ((WSDLBoundOperationImpl)object2).getSOAPAction();
        }
        ((JavaMethodImpl)object3).setOperationName((String)((Object)clazz2));
        object2 = method.getAnnotation(SOAPBinding.class);
        if (object2 != null && object2.style() == SOAPBinding.Style.RPC) {
            logger.warning(ModelerMessages.RUNTIMEMODELER_INVALID_SOAPBINDING_ON_METHOD(object2, method.getName(), method.getDeclaringClass().getName()));
        } else if (object2 == null && !method.getDeclaringClass().equals(this.portClass) && (object2 = method.getDeclaringClass().getAnnotation(SOAPBinding.class)) != null && object2.style() == SOAPBinding.Style.RPC && object2.parameterStyle() == SOAPBinding.ParameterStyle.BARE) {
            throw new RuntimeModelerException("runtime.modeler.invalid.soapbinding.parameterstyle", object2, method.getDeclaringClass());
        }
        if (object2 != null && this.defaultBinding.getStyle() != object2.style()) {
            throw new RuntimeModelerException("runtime.modeler.soapbinding.conflict", new Object[]{object2.style(), method.getName(), this.defaultBinding.getStyle()});
        }
        boolean bl2 = this.isWrapped;
        object = this.defaultBinding.getStyle();
        if (object2 != null) {
            SOAPBindingImpl sOAPBindingImpl = this.createBinding((SOAPBinding)object2);
            object = sOAPBindingImpl.getStyle();
            if (object4 != null) {
                sOAPBindingImpl.setSOAPAction((String)object4);
            }
            bl2 = object2.parameterStyle().equals((Object)SOAPBinding.ParameterStyle.WRAPPED);
            ((JavaMethodImpl)object3).setBinding(sOAPBindingImpl);
        } else {
            SOAPBindingImpl sOAPBindingImpl = new SOAPBindingImpl(this.defaultBinding);
            if (object4 != null) {
                sOAPBindingImpl.setSOAPAction((String)object4);
            } else {
                sOAPBindingImpl.setSOAPAction("");
            }
            ((JavaMethodImpl)object3).setBinding(sOAPBindingImpl);
        }
        if (!bl2) {
            this.processDocBareMethod((JavaMethodImpl)object3, (String)((Object)clazz2), method);
        } else if (((Enum)object).equals((Object)SOAPBinding.Style.DOCUMENT)) {
            this.processDocWrappedMethod((JavaMethodImpl)object3, string, (String)((Object)clazz2), method);
        } else {
            this.processRpcMethod((JavaMethodImpl)object3, string, (String)((Object)clazz2), method);
        }
        this.model.addJavaMethod((JavaMethodImpl)object3);
    }

    private MEP getMEP(Method method) {
        if (method.isAnnotationPresent(Oneway.class)) {
            return MEP.ONE_WAY;
        }
        if (Response.class.isAssignableFrom(method.getReturnType())) {
            return MEP.ASYNC_POLL;
        }
        if (Future.class.isAssignableFrom(method.getReturnType())) {
            return MEP.ASYNC_CALLBACK;
        }
        return MEP.REQUEST_RESPONSE;
    }

    /*
     * WARNING - void declaration
     */
    protected void processDocWrappedMethod(JavaMethodImpl javaMethodImpl, String string, String string2, Method method) {
        Object object;
        Object object2;
        Object[] objectArray;
        boolean bl = false;
        boolean bl2 = method.isAnnotationPresent(Oneway.class);
        RequestWrapper requestWrapper = method.getAnnotation(RequestWrapper.class);
        ResponseWrapper responseWrapper = method.getAnnotation(ResponseWrapper.class);
        String string3 = this.packageName + PD_JAXWS_PACKAGE_PD;
        if (this.packageName == null || this.packageName != null && this.packageName.length() == 0) {
            string3 = JAXWS_PACKAGE_PD;
        }
        String string4 = requestWrapper != null && requestWrapper.className().length() > 0 ? requestWrapper.className() : string3 + RuntimeModeler.capitalize(method.getName());
        String string5 = responseWrapper != null && responseWrapper.className().length() > 0 ? responseWrapper.className() : string3 + RuntimeModeler.capitalize(method.getName()) + RESPONSE;
        String string6 = string2;
        String string7 = this.targetNamespace;
        String string8 = "parameters";
        if (requestWrapper != null) {
            if (requestWrapper.targetNamespace().length() > 0) {
                string7 = requestWrapper.targetNamespace();
            }
            if (requestWrapper.localName().length() > 0) {
                string6 = requestWrapper.localName();
            }
            try {
                if (requestWrapper.partName().length() > 0) {
                    string8 = requestWrapper.partName();
                }
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
        }
        QName qName = new QName(string7, string6);
        Class clazz = this.getRequestWrapperClass(string4, method, qName);
        Class clazz2 = null;
        String string9 = string2 + RESPONSE;
        String string10 = this.targetNamespace;
        QName qName2 = null;
        String string11 = "parameters";
        if (!bl2) {
            if (responseWrapper != null) {
                if (responseWrapper.targetNamespace().length() > 0) {
                    string10 = responseWrapper.targetNamespace();
                }
                if (responseWrapper.localName().length() > 0) {
                    string9 = responseWrapper.localName();
                }
                try {
                    if (responseWrapper.partName().length() > 0) {
                        string11 = responseWrapper.partName();
                    }
                }
                catch (LinkageError linkageError) {
                    // empty catch block
                }
            }
            qName2 = new QName(string10, string9);
            clazz2 = this.getResponseWrapperClass(string5, method, qName2);
        }
        TypeReference typeReference = new TypeReference(qName, clazz, new Annotation[0]);
        WrapperParameter wrapperParameter = new WrapperParameter(javaMethodImpl, typeReference, WebParam.Mode.IN, 0);
        wrapperParameter.setPartName(string8);
        wrapperParameter.setBinding(ParameterBinding.BODY);
        javaMethodImpl.addParameter(wrapperParameter);
        WrapperParameter wrapperParameter2 = null;
        if (!bl2) {
            typeReference = new TypeReference(qName2, clazz2, new Annotation[0]);
            wrapperParameter2 = new WrapperParameter(javaMethodImpl, typeReference, WebParam.Mode.OUT, -1);
            javaMethodImpl.addParameter(wrapperParameter2);
            wrapperParameter2.setBinding(ParameterBinding.BODY);
        }
        WebResult webResult = method.getAnnotation(WebResult.class);
        XmlElement xmlElement = method.getAnnotation(XmlElement.class);
        QName qName3 = RuntimeModeler.getReturnQName(method, webResult, xmlElement);
        Class clazz3 = method.getReturnType();
        boolean bl3 = false;
        if (webResult != null) {
            bl3 = webResult.header();
            boolean bl4 = bl = bl3 || bl;
            if (bl3 && xmlElement != null) {
                throw new RuntimeModelerException("@XmlElement cannot be specified on method " + method + " as the return value is bound to header", new Object[0]);
            }
            if (qName3.getNamespaceURI().length() == 0 && webResult.header()) {
                qName3 = new QName(this.targetNamespace, qName3.getLocalPart());
            }
        }
        if (javaMethodImpl.isAsync()) {
            clazz3 = this.getAsyncReturnType(method, clazz3);
            qName3 = new QName(RETURN);
        }
        if (!bl2 && clazz3 != null && !clazz3.getName().equals("void")) {
            objectArray = method.getAnnotations();
            if (qName3.getLocalPart() != null) {
                object2 = new TypeReference(qName3, clazz3, (Annotation[])objectArray);
                object = new ParameterImpl(javaMethodImpl, (TypeReference)object2, WebParam.Mode.OUT, -1);
                if (bl3) {
                    ((ParameterImpl)object).setBinding(ParameterBinding.HEADER);
                    javaMethodImpl.addParameter((ParameterImpl)object);
                } else {
                    ((ParameterImpl)object).setBinding(ParameterBinding.BODY);
                    wrapperParameter2.addWrapperChild((ParameterImpl)object);
                }
            }
        }
        objectArray = method.getParameterTypes();
        object2 = method.getGenericParameterTypes();
        object = RuntimeModeler.getPrivParameterAnnotations(method);
        int n = 0;
        for (Object object3 : objectArray) {
            void clazz4;
            String string12 = null;
            String string13 = "arg" + n;
            boolean bl5 = false;
            if (javaMethodImpl.isAsync() && AsyncHandler.class.isAssignableFrom((Class<?>)object3)) continue;
            boolean bl6 = HOLDER_CLASS.isAssignableFrom((Class<?>)object3);
            if (bl6 && object3 == Holder.class) {
                Class clazz5 = Navigator.REFLECTION.erasure(((ParameterizedType)object2[n]).getActualTypeArguments()[0]);
            }
            WebParam.Mode mode = bl6 ? WebParam.Mode.INOUT : WebParam.Mode.IN;
            WebParam webParam = null;
            xmlElement = null;
            for (Object object4 : object[n]) {
                if (object4.annotationType() == WebParam.class) {
                    webParam = (WebParam)object4;
                    continue;
                }
                if (object4.annotationType() != XmlElement.class) continue;
                xmlElement = (XmlElement)object4;
            }
            Object object5 = RuntimeModeler.getParameterQName(method, webParam, xmlElement, string13);
            if (webParam != null) {
                bl5 = webParam.header();
                boolean bl7 = bl = bl5 || bl;
                if (bl5 && xmlElement != null) {
                    throw new RuntimeModelerException("@XmlElement cannot be specified on method " + method + " parameter that is bound to header", new Object[0]);
                }
                string12 = webParam.partName().length() > 0 ? webParam.partName() : ((QName)object5).getLocalPart();
                if (bl5 && ((QName)object5).getNamespaceURI().equals("")) {
                    object5 = new QName(this.targetNamespace, ((QName)object5).getLocalPart());
                }
                mode = webParam.mode();
                if (bl6 && mode == WebParam.Mode.IN) {
                    mode = WebParam.Mode.INOUT;
                }
            }
            typeReference = new TypeReference((QName)object5, (Type)clazz4, (Annotation[])object[n]);
            ParameterImpl parameterImpl = new ParameterImpl(javaMethodImpl, typeReference, mode, n++);
            if (bl5) {
                parameterImpl.setBinding(ParameterBinding.HEADER);
                javaMethodImpl.addParameter(parameterImpl);
                parameterImpl.setPartName(string12);
                continue;
            }
            parameterImpl.setBinding(ParameterBinding.BODY);
            if (mode != WebParam.Mode.OUT) {
                wrapperParameter.addWrapperChild(parameterImpl);
            }
            if (mode == WebParam.Mode.IN) continue;
            if (bl2) {
                throw new RuntimeModelerException("runtime.modeler.oneway.operation.no.out.parameters", this.portClass.getCanonicalName(), string);
            }
            wrapperParameter2.addWrapperChild(parameterImpl);
        }
        if (bl) {
            string11 = "result";
        }
        if (wrapperParameter2 != null) {
            wrapperParameter2.setPartName(string11);
        }
        this.processExceptions(javaMethodImpl, method);
    }

    /*
     * WARNING - void declaration
     */
    protected void processRpcMethod(JavaMethodImpl javaMethodImpl, String string, String string2, Method method) {
        Object object;
        Object object2;
        Object[] objectArray;
        Object object3;
        QName qName;
        boolean bl = method.isAnnotationPresent(Oneway.class);
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        TreeMap<Integer, ParameterImpl> treeMap2 = new TreeMap<Integer, ParameterImpl>();
        String string3 = this.targetNamespace;
        String string4 = this.targetNamespace;
        if (this.binding != null && this.binding.getBinding().isRpcLit()) {
            qName = new QName(this.binding.getBinding().getPortTypeName().getNamespaceURI(), string2);
            object3 = this.binding.getBinding().get(qName);
            if (object3 != null) {
                if (((WSDLBoundOperationImpl)object3).getRequestNamespace() != null) {
                    string3 = ((WSDLBoundOperationImpl)object3).getRequestNamespace();
                }
                if (((WSDLBoundOperationImpl)object3).getResponseNamespace() != null) {
                    string4 = ((WSDLBoundOperationImpl)object3).getResponseNamespace();
                }
            }
        }
        qName = new QName(string3, string2);
        object3 = null;
        if (!bl) {
            object3 = new QName(string4, string2 + RESPONSE);
        }
        Class<CompositeStructure> clazz = CompositeStructure.class;
        TypeReference typeReference = new TypeReference(qName, (Type)((Object)clazz), new Annotation[0]);
        WrapperParameter wrapperParameter = new WrapperParameter(javaMethodImpl, typeReference, WebParam.Mode.IN, 0);
        wrapperParameter.setInBinding(ParameterBinding.BODY);
        javaMethodImpl.addParameter(wrapperParameter);
        WrapperParameter wrapperParameter2 = null;
        if (!bl) {
            typeReference = new TypeReference((QName)object3, (Type)((Object)clazz), new Annotation[0]);
            wrapperParameter2 = new WrapperParameter(javaMethodImpl, typeReference, WebParam.Mode.OUT, -1);
            wrapperParameter2.setOutBinding(ParameterBinding.BODY);
            javaMethodImpl.addParameter(wrapperParameter2);
        }
        Class clazz2 = method.getReturnType();
        String string5 = RETURN;
        String string6 = this.targetNamespace;
        String string7 = string5;
        boolean bl2 = false;
        WebResult webResult = method.getAnnotation(WebResult.class);
        if (webResult != null) {
            bl2 = webResult.header();
            if (webResult.name().length() > 0) {
                string5 = webResult.name();
            }
            if (webResult.partName().length() > 0) {
                string7 = webResult.partName();
                if (!bl2) {
                    string5 = string7;
                }
            } else {
                string7 = string5;
            }
            if (webResult.targetNamespace().length() > 0) {
                string6 = webResult.targetNamespace();
            }
            bl2 = webResult.header();
        }
        QName qName2 = bl2 ? new QName(string6, string5) : new QName(string5);
        if (javaMethodImpl.isAsync()) {
            clazz2 = this.getAsyncReturnType(method, clazz2);
        }
        if (!bl && clazz2 != null && clazz2 != Void.TYPE) {
            objectArray = method.getAnnotations();
            object2 = new TypeReference(qName2, clazz2, (Annotation[])objectArray);
            object = new ParameterImpl(javaMethodImpl, (TypeReference)object2, WebParam.Mode.OUT, -1);
            ((ParameterImpl)object).setPartName(string7);
            if (bl2) {
                ((ParameterImpl)object).setBinding(ParameterBinding.HEADER);
                javaMethodImpl.addParameter((ParameterImpl)object);
            } else {
                ParameterBinding parameterBinding = this.getBinding(string2, string7, false, WebParam.Mode.OUT);
                ((ParameterImpl)object).setBinding(parameterBinding);
                if (parameterBinding.isBody()) {
                    WSDLPart wSDLPart = this.getPart(new QName(this.targetNamespace, string2), string7, WebParam.Mode.OUT);
                    if (wSDLPart == null) {
                        treeMap.put(treeMap.size() + 10000, object);
                    } else {
                        treeMap.put(wSDLPart.getIndex(), object);
                    }
                } else {
                    javaMethodImpl.addParameter((ParameterImpl)object);
                }
            }
        }
        objectArray = method.getParameterTypes();
        object2 = method.getGenericParameterTypes();
        object = RuntimeModeler.getPrivParameterAnnotations(method);
        int n = 0;
        for (Object object4 : objectArray) {
            void clazz3;
            Object object5;
            String string8 = "";
            String string9 = "";
            String string10 = "";
            boolean bl3 = false;
            if (javaMethodImpl.isAsync() && AsyncHandler.class.isAssignableFrom((Class<?>)object4)) continue;
            boolean bl4 = HOLDER_CLASS.isAssignableFrom((Class<?>)object4);
            if (bl4 && object4 == Holder.class) {
                Class clazz4 = Navigator.REFLECTION.erasure(((ParameterizedType)object2[n]).getActualTypeArguments()[0]);
            }
            WebParam.Mode mode = bl4 ? WebParam.Mode.INOUT : WebParam.Mode.IN;
            for (Object object6 : object[n]) {
                if (object6.annotationType() != WebParam.class) continue;
                WebParam webParam = (WebParam)object6;
                string8 = webParam.name();
                string10 = webParam.partName();
                bl3 = webParam.header();
                WebParam.Mode mode2 = webParam.mode();
                string9 = webParam.targetNamespace();
                if (bl4 && mode2 == WebParam.Mode.IN) {
                    mode2 = WebParam.Mode.INOUT;
                }
                mode = mode2;
                break;
            }
            if (string8.length() == 0) {
                string8 = "arg" + n;
            }
            if (string10.length() == 0) {
                string10 = string8;
            } else if (!bl3) {
                string8 = string10;
            }
            if (string10.length() == 0) {
                string10 = string8;
            }
            if (!bl3) {
                object5 = new QName("", string8);
            } else {
                if (string9.length() == 0) {
                    string9 = this.targetNamespace;
                }
                object5 = new QName(string9, string8);
            }
            typeReference = new TypeReference((QName)object5, (Type)clazz3, (Annotation[])object[n]);
            ParameterImpl parameterImpl = new ParameterImpl(javaMethodImpl, typeReference, mode, n++);
            parameterImpl.setPartName(string10);
            if (mode == WebParam.Mode.INOUT) {
                ParameterBinding wSDLPart = this.getBinding(string2, string10, bl3, WebParam.Mode.IN);
                parameterImpl.setInBinding(wSDLPart);
                wSDLPart = this.getBinding(string2, string10, bl3, WebParam.Mode.OUT);
                parameterImpl.setOutBinding(wSDLPart);
            } else if (bl3) {
                parameterImpl.setBinding(ParameterBinding.HEADER);
            } else {
                ParameterBinding wSDLPart = this.getBinding(string2, string10, false, mode);
                parameterImpl.setBinding(wSDLPart);
            }
            if (parameterImpl.getInBinding().isBody()) {
                if (!parameterImpl.isOUT()) {
                    WSDLPart wSDLPart = this.getPart(new QName(this.targetNamespace, string2), string10, WebParam.Mode.IN);
                    if (wSDLPart == null) {
                        treeMap2.put(treeMap2.size() + 10000, parameterImpl);
                    } else {
                        treeMap2.put(wSDLPart.getIndex(), parameterImpl);
                    }
                }
                if (parameterImpl.isIN()) continue;
                if (bl) {
                    throw new RuntimeModelerException("runtime.modeler.oneway.operation.no.out.parameters", this.portClass.getCanonicalName(), string);
                }
                WSDLPart wSDLPart = this.getPart(new QName(this.targetNamespace, string2), string10, WebParam.Mode.OUT);
                if (wSDLPart == null) {
                    treeMap.put(treeMap.size() + 10000, parameterImpl);
                    continue;
                }
                treeMap.put(wSDLPart.getIndex(), parameterImpl);
                continue;
            }
            javaMethodImpl.addParameter(parameterImpl);
        }
        for (ParameterImpl parameterImpl : treeMap2.values()) {
            wrapperParameter.addWrapperChild(parameterImpl);
        }
        for (ParameterImpl parameterImpl : treeMap.values()) {
            wrapperParameter2.addWrapperChild(parameterImpl);
        }
        this.processExceptions(javaMethodImpl, method);
    }

    protected void processExceptions(JavaMethodImpl javaMethodImpl, Method method) {
        Action action = method.getAnnotation(Action.class);
        FaultAction[] faultActionArray = new FaultAction[]{};
        if (action != null) {
            faultActionArray = action.fault();
        }
        for (Class<?> clazz : method.getExceptionTypes()) {
            Annotation[] annotationArray;
            Class clazz2;
            if (!EXCEPTION_CLASS.isAssignableFrom(clazz) || RUNTIME_EXCEPTION_CLASS.isAssignableFrom(clazz) || REMOTE_EXCEPTION_CLASS.isAssignableFrom(clazz)) continue;
            WebFault webFault = RuntimeModeler.getPrivClassAnnotation(clazz, WebFault.class);
            Method method2 = this.getWSDLExceptionFaultInfo(clazz);
            ExceptionType exceptionType = ExceptionType.WSDLException;
            String string = this.targetNamespace;
            String string2 = clazz.getSimpleName();
            String string3 = this.packageName + PD_JAXWS_PACKAGE_PD;
            if (this.packageName.length() == 0) {
                string3 = JAXWS_PACKAGE_PD;
            }
            String string4 = string3 + string2 + BEAN;
            String string5 = clazz.getSimpleName();
            if (webFault != null) {
                if (webFault.faultBean().length() > 0) {
                    string4 = webFault.faultBean();
                }
                if (webFault.name().length() > 0) {
                    string2 = webFault.name();
                }
                if (webFault.targetNamespace().length() > 0) {
                    string = webFault.targetNamespace();
                }
                if (webFault.messageName().length() > 0) {
                    string5 = webFault.messageName();
                }
            }
            if (method2 == null) {
                clazz2 = this.getExceptionBeanClass(string4, clazz, string2, string);
                exceptionType = ExceptionType.UserDefined;
                annotationArray = clazz2.getAnnotations();
            } else {
                clazz2 = method2.getReturnType();
                annotationArray = method2.getAnnotations();
            }
            QName qName = new QName(string, string2);
            TypeReference typeReference = new TypeReference(qName, clazz2, annotationArray);
            CheckedExceptionImpl checkedExceptionImpl = new CheckedExceptionImpl(javaMethodImpl, clazz, typeReference, exceptionType);
            checkedExceptionImpl.setMessageName(string5);
            for (FaultAction faultAction : faultActionArray) {
                if (!faultAction.className().equals(clazz) || faultAction.value().equals("")) continue;
                checkedExceptionImpl.setFaultAction(faultAction.value());
                break;
            }
            javaMethodImpl.addException(checkedExceptionImpl);
        }
    }

    protected Method getWSDLExceptionFaultInfo(Class clazz) {
        if (!clazz.isAnnotationPresent(WebFault.class)) {
            return null;
        }
        try {
            return clazz.getMethod("getFaultInfo", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void processDocBareMethod(JavaMethodImpl javaMethodImpl, String string, Method method) {
        Object object;
        Object object2;
        Object[] objectArray;
        String string2 = string + RESPONSE;
        String string3 = this.targetNamespace;
        String string4 = null;
        boolean bl = false;
        WebResult webResult = method.getAnnotation(WebResult.class);
        if (webResult != null) {
            if (webResult.name().length() > 0) {
                string2 = webResult.name();
            }
            if (webResult.targetNamespace().length() > 0) {
                string3 = webResult.targetNamespace();
            }
            string4 = webResult.partName();
            bl = webResult.header();
        }
        Class clazz = method.getReturnType();
        if (javaMethodImpl.isAsync()) {
            clazz = this.getAsyncReturnType(method, clazz);
        }
        if (clazz != null && !clazz.getName().equals("void")) {
            objectArray = method.getAnnotations();
            if (string2 != null) {
                object2 = new QName(string3, string2);
                object = new TypeReference((QName)object2, clazz, (Annotation[])objectArray);
                ParameterImpl parameterImpl = new ParameterImpl(javaMethodImpl, (TypeReference)object, WebParam.Mode.OUT, -1);
                if (string4 == null || string4.length() == 0) {
                    string4 = string2;
                }
                parameterImpl.setPartName(string4);
                if (bl) {
                    parameterImpl.setBinding(ParameterBinding.HEADER);
                } else {
                    ParameterBinding object3 = this.getBinding(string, string4, false, WebParam.Mode.OUT);
                    parameterImpl.setBinding(object3);
                }
                javaMethodImpl.addParameter(parameterImpl);
            }
        }
        objectArray = method.getParameterTypes();
        object2 = method.getGenericParameterTypes();
        object = RuntimeModeler.getPrivParameterAnnotations(method);
        int n = 0;
        for (Object object3 : objectArray) {
            void var17_19;
            String string5 = string;
            String string6 = null;
            String string7 = this.targetNamespace;
            boolean bl2 = false;
            if (javaMethodImpl.isAsync() && AsyncHandler.class.isAssignableFrom((Class<?>)object3)) continue;
            boolean bl3 = HOLDER_CLASS.isAssignableFrom((Class<?>)object3);
            if (bl3 && object3 == Holder.class) {
                Class clazz2 = Navigator.REFLECTION.erasure(((ParameterizedType)object2[n]).getActualTypeArguments()[0]);
            }
            WebParam.Mode mode = bl3 ? WebParam.Mode.INOUT : WebParam.Mode.IN;
            for (Annotation annotation : object[n]) {
                if (annotation.annotationType() != WebParam.class) continue;
                WebParam webParam = (WebParam)annotation;
                mode = webParam.mode();
                if (bl3 && mode == WebParam.Mode.IN) {
                    mode = WebParam.Mode.INOUT;
                }
                if (bl2 = webParam.header()) {
                    string5 = "arg" + n;
                }
                if (mode == WebParam.Mode.OUT && !bl2) {
                    string5 = string + RESPONSE;
                }
                if (webParam.name().length() > 0) {
                    string5 = webParam.name();
                }
                string6 = webParam.partName();
                if (webParam.targetNamespace().equals("")) break;
                string7 = webParam.targetNamespace();
                break;
            }
            QName qName = new QName(string7, string5);
            TypeReference typeReference = new TypeReference(qName, (Type)var17_19, object[n]);
            ParameterImpl parameterImpl = new ParameterImpl(javaMethodImpl, typeReference, mode, n++);
            if (string6 == null || string6.length() == 0) {
                string6 = string5;
            }
            parameterImpl.setPartName(string6);
            if (mode == WebParam.Mode.INOUT) {
                ParameterBinding parameterBinding = this.getBinding(string, string6, bl2, WebParam.Mode.IN);
                parameterImpl.setInBinding(parameterBinding);
                ParameterBinding parameterBinding2 = this.getBinding(string, string6, bl2, WebParam.Mode.OUT);
                parameterImpl.setOutBinding(parameterBinding2);
            } else if (bl2) {
                parameterImpl.setBinding(ParameterBinding.HEADER);
            } else {
                ParameterBinding parameterBinding = this.getBinding(string, string6, false, mode);
                parameterImpl.setBinding(parameterBinding);
            }
            javaMethodImpl.addParameter(parameterImpl);
        }
        this.validateDocBare(javaMethodImpl);
        this.processExceptions(javaMethodImpl, method);
    }

    private void validateDocBare(JavaMethodImpl javaMethodImpl) {
        int n = 0;
        for (Parameter object : javaMethodImpl.getRequestParameters()) {
            if (object.getBinding().equals(ParameterBinding.BODY) && object.isIN()) {
                ++n;
            }
            if (n <= true) continue;
            throw new RuntimeModelerException(ModelerMessages.localizableNOT_A_VALID_BARE_METHOD(this.portClass.getName(), javaMethodImpl.getMethod().getName()));
        }
        int n2 = 0;
        for (Parameter parameter : javaMethodImpl.getResponseParameters()) {
            if (parameter.getBinding().equals(ParameterBinding.BODY) && parameter.isOUT()) {
                ++n2;
            }
            if (n2 <= true) continue;
            throw new RuntimeModelerException(ModelerMessages.localizableNOT_A_VALID_BARE_METHOD(this.portClass.getName(), javaMethodImpl.getMethod().getName()));
        }
    }

    private Class getAsyncReturnType(Method method, Class clazz) {
        if (Response.class.isAssignableFrom(clazz)) {
            Type type = method.getGenericReturnType();
            return Navigator.REFLECTION.erasure(((ParameterizedType)type).getActualTypeArguments()[0]);
        }
        Type[] typeArray = method.getGenericParameterTypes();
        Class<?>[] classArray = method.getParameterTypes();
        int n = 0;
        for (Class<?> clazz2 : classArray) {
            if (AsyncHandler.class.isAssignableFrom(clazz2)) {
                return Navigator.REFLECTION.erasure(((ParameterizedType)typeArray[n]).getActualTypeArguments()[0]);
            }
            ++n;
        }
        return clazz;
    }

    public static String capitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toUpperCase(cArray[0]);
        return new String(cArray);
    }

    public static QName getServiceName(Class<?> clazz) {
        WebService webService;
        if (clazz.isInterface()) {
            throw new RuntimeModelerException("runtime.modeler.cannot.get.serviceName.from.interface", clazz.getCanonicalName());
        }
        String string = clazz.getSimpleName() + SERVICE;
        String string2 = "";
        if (clazz.getPackage() != null) {
            string2 = clazz.getPackage().getName();
        }
        if ((webService = clazz.getAnnotation(WebService.class)) == null) {
            throw new RuntimeModelerException("runtime.modeler.no.webservice.annotation", clazz.getCanonicalName());
        }
        if (webService.serviceName().length() > 0) {
            string = webService.serviceName();
        }
        String string3 = RuntimeModeler.getNamespace(string2);
        if (webService.targetNamespace().length() > 0) {
            string3 = webService.targetNamespace();
        } else if (string3 == null) {
            throw new RuntimeModelerException("runtime.modeler.no.package", clazz.getName());
        }
        return new QName(string3, string);
    }

    public static QName getPortName(Class<?> clazz, String string) {
        WebService webService = clazz.getAnnotation(WebService.class);
        if (webService == null) {
            throw new RuntimeModelerException("runtime.modeler.no.webservice.annotation", clazz.getCanonicalName());
        }
        String string2 = webService.portName().length() > 0 ? webService.portName() : (webService.name().length() > 0 ? webService.name() + PORT : clazz.getSimpleName() + PORT);
        if (string == null) {
            if (webService.targetNamespace().length() > 0) {
                string = webService.targetNamespace();
            } else {
                String string3 = null;
                if (clazz.getPackage() != null) {
                    string3 = clazz.getPackage().getName();
                }
                if ((string = RuntimeModeler.getNamespace(string3)) == null) {
                    throw new RuntimeModelerException("runtime.modeler.no.package", clazz.getName());
                }
            }
        }
        return new QName(string, string2);
    }

    public static QName getPortTypeName(Class<?> clazz) {
        String string;
        WebService webService;
        String string2;
        assert (clazz != null);
        Class<?> clazz2 = clazz;
        if (!clazz.isAnnotationPresent(WebService.class)) {
            throw new RuntimeModelerException("runtime.modeler.no.webservice.annotation", clazz.getCanonicalName());
        }
        if (!clazz.isInterface() && (string2 = (webService = clazz.getAnnotation(WebService.class)).endpointInterface()).length() > 0) {
            try {
                clazz2 = Thread.currentThread().getContextClassLoader().loadClass(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeModelerException("runtime.modeler.class.not.found", string2);
            }
            if (!clazz2.isAnnotationPresent(WebService.class)) {
                throw new RuntimeModelerException("runtime.modeler.endpoint.interface.no.webservice", webService.endpointInterface());
            }
        }
        if ((string2 = (webService = clazz2.getAnnotation(WebService.class)).name()).length() == 0) {
            string2 = clazz2.getSimpleName();
        }
        if ((string = webService.targetNamespace()).length() == 0) {
            string = RuntimeModeler.getNamespace(clazz2.getPackage().getName());
        }
        if (string == null) {
            throw new RuntimeModelerException("runtime.modeler.no.package", clazz2.getName());
        }
        return new QName(string, string2);
    }

    private ParameterBinding getBinding(String string, String string2, boolean bl, WebParam.Mode mode) {
        if (this.binding == null) {
            if (bl) {
                return ParameterBinding.HEADER;
            }
            return ParameterBinding.BODY;
        }
        QName qName = new QName(this.binding.getBinding().getPortType().getName().getNamespaceURI(), string);
        return this.binding.getBinding().getBinding(qName, string2, mode);
    }

    private WSDLPart getPart(QName qName, String string, WebParam.Mode mode) {
        WSDLBoundOperationImpl wSDLBoundOperationImpl;
        if (this.binding != null && (wSDLBoundOperationImpl = this.binding.getBinding().get(qName)) != null) {
            return wSDLBoundOperationImpl.getPart(string, mode);
        }
        return null;
    }

    private static QName getReturnQName(Method method, WebResult webResult, XmlElement xmlElement) {
        String string = null;
        if (webResult != null && webResult.name().length() > 0) {
            string = webResult.name();
        }
        String string2 = null;
        if (xmlElement != null && !xmlElement.name().equals("##default")) {
            string2 = xmlElement.name();
        }
        if (string2 != null && string != null && !string2.equals(string)) {
            throw new RuntimeModelerException("@XmlElement(name)=" + string2 + " and @WebResult(name)=" + string + " are different for method " + method, new Object[0]);
        }
        String string3 = RETURN;
        if (string != null) {
            string3 = string;
        } else if (string2 != null) {
            string3 = string2;
        }
        String string4 = null;
        if (webResult != null && webResult.targetNamespace().length() > 0) {
            string4 = webResult.targetNamespace();
        }
        String string5 = null;
        if (xmlElement != null && !xmlElement.namespace().equals("##default")) {
            string5 = xmlElement.namespace();
        }
        if (string5 != null && string4 != null && !string5.equals(string4)) {
            throw new RuntimeModelerException("@XmlElement(namespace)=" + string5 + " and @WebResult(targetNamespace)=" + string4 + " are different for method " + method, new Object[0]);
        }
        String string6 = "";
        if (string4 != null) {
            string6 = string4;
        } else if (string5 != null) {
            string6 = string5;
        }
        return new QName(string6, string3);
    }

    private static QName getParameterQName(Method method, WebParam webParam, XmlElement xmlElement, String string) {
        String string2 = null;
        if (webParam != null && webParam.name().length() > 0) {
            string2 = webParam.name();
        }
        String string3 = null;
        if (xmlElement != null && !xmlElement.name().equals("##default")) {
            string3 = xmlElement.name();
        }
        if (string3 != null && string2 != null && !string3.equals(string2)) {
            throw new RuntimeModelerException("@XmlElement(name)=" + string3 + " and @WebParam(name)=" + string2 + " are different for method " + method, new Object[0]);
        }
        String string4 = string;
        if (string2 != null) {
            string4 = string2;
        } else if (string3 != null) {
            string4 = string3;
        }
        String string5 = null;
        if (webParam != null && webParam.targetNamespace().length() > 0) {
            string5 = webParam.targetNamespace();
        }
        String string6 = null;
        if (xmlElement != null && !xmlElement.namespace().equals("##default")) {
            string6 = xmlElement.namespace();
        }
        if (string6 != null && string5 != null && !string6.equals(string5)) {
            throw new RuntimeModelerException("@XmlElement(namespace)=" + string6 + " and @WebParam(targetNamespace)=" + string5 + " are different for method " + method, new Object[0]);
        }
        String string7 = "";
        if (string5 != null) {
            string7 = string5;
        } else if (string6 != null) {
            string7 = string6;
        }
        return new QName(string7, string4);
    }
}

