/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.impl.fx.ui;

import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.impl.fx.ui.CertificateDialog;
import com.sun.deploy.uitoolkit.impl.fx.ui.FXDialog;
import com.sun.deploy.uitoolkit.impl.fx.ui.MoreInfoDialog;
import com.sun.deploy.uitoolkit.impl.fx.ui.UITextArea;
import com.sun.deploy.uitoolkit.impl.fx.ui.resources.ResourceManager;
import com.sun.javafx.applet.HostServicesImpl;
import com.sun.javafx.application.HostServicesDelegate;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.TreeMap;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Modality;
import javafx.stage.Stage;

public class DialogTemplate {
    int theAnswer = -1;
    final Object responseLock = new Object();
    private EventHandler<ActionEvent> okHandler = new EventHandler<ActionEvent>(){

        @Override
        public void handle(ActionEvent ae) {
            DialogTemplate.this.userAnswer = 0;
            if (DialogTemplate.this.always != null && DialogTemplate.this.always.isSelected()) {
                DialogTemplate.this.userAnswer = 2;
            }
            if (DialogTemplate.this.stayAliveOnOk) {
                return;
            }
            if (DialogTemplate.this.password != null) {
                DialogTemplate.access$402(DialogTemplate.this, DialogTemplate.this.password.getText().toCharArray());
            }
            if (DialogTemplate.this.pwdName != null) {
                DialogTemplate.this.userName = DialogTemplate.this.pwdName.getText();
            }
            if (DialogTemplate.this.pwdDomain != null) {
                DialogTemplate.this.domain = DialogTemplate.this.pwdDomain.getText();
            }
            if (DialogTemplate.this.scrollList != null) {
                DialogTemplate.this.userAnswer = DialogTemplate.this.scrollList.getSelectionModel().getSelectedIndex();
            }
            DialogTemplate.this.setVisible(false);
        }
    };
    private EventHandler<ActionEvent> cancelHandler = new EventHandler<ActionEvent>(){

        @Override
        public void handle(ActionEvent ae) {
            if (DialogTemplate.this.throwable != null || DialogTemplate.this.detailPanel != null) {
                DialogTemplate.this.showMoreInfo();
                return;
            }
            DialogTemplate.this.userAnswer = 1;
            if (DialogTemplate.this.scrollList != null) {
                DialogTemplate.this.userAnswer = -1;
            }
            DialogTemplate.this.setVisible(false);
        }
    };
    private FXDialog dialog = null;
    private VBox contentPane = null;
    private AppInfo ainfo = null;
    private String topText = null;
    private String appTitle = null;
    private String appPublisher = null;
    private URL appURL = null;
    private boolean useErrorIcon = false;
    private boolean useWarningIcon = false;
    private boolean useInfoIcon = false;
    private boolean useMixcodeIcon = false;
    private Label progressStatusLabel = null;
    private BorderPane topPanel;
    private Pane centerPanel;
    private ImageView topIcon;
    private ImageView securityIcon;
    private Label nameInfo;
    private Label publisherInfo;
    private Label urlInfo;
    private Button okBtn;
    private Button cancelBtn;
    private CheckBox always;
    private Label mixedCodeLabel;
    private UITextArea masthead1 = null;
    private UITextArea masthead2 = null;
    private static final int ICON_SIZE = 48;
    private int userAnswer = -1;
    static final int DIALOG_WIDTH = 516;
    private final int MAX_LARGE_SCROLL_WIDTH = 600;
    private final String SECURITY_ALERT_HIGH = "security.alert.high.image";
    private final String SECURITY_ALERT_LOW = "security.alert.low.image";
    private static int MAIN_TEXT_WIDTH = 400;
    private final String OK_ACTION = "OK";
    private final int MAX_BUTTONS = 2;
    private int start;
    private int end;
    private Certificate[] certs;
    private String[] alertStrs;
    private String[] infoStrs;
    private int securityInfoCount;
    private Color originalColor;
    private Cursor originalCursor = null;
    protected ProgressBar progressBar = null;
    private boolean stayAliveOnOk = false;
    private String contentString = null;
    private String cacheUpgradeContentString = null;
    private String contentLabel = null;
    private String alwaysString = null;
    private String mixedCodeString = null;
    private boolean contentScroll = false;
    private boolean includeMasthead = true;
    private boolean includeAppInfo = true;
    private boolean largeScroll = false;
    private Throwable throwable = null;
    private Pane detailPanel = null;
    private char[] pwd = new char[0];
    private String userName;
    private String domain;
    private TextField pwdName;
    private TextField pwdDomain;
    private PasswordField password;
    private ListView scrollList;
    private boolean showDetails = false;
    TreeMap clientAuthCertsMap;
    private boolean majorWarning = false;

    DialogTemplate(AppInfo ainfo, Stage owner, String title, String topText) {
        Stage parent = owner;
        this.dialog = new FXDialog(title, parent, false);
        this.contentPane = new VBox(){

            protected double computePrefHeight(double width) {
                double h = super.computePrefHeight(width);
                return h;
            }
        };
        this.dialog.setContentPane(this.contentPane);
        this.ainfo = ainfo;
        this.topText = topText;
        this.appTitle = ainfo.getTitle();
        this.appPublisher = ainfo.getVendor();
        this.appURL = ainfo.getFrom();
    }

    void setSecurityContent(boolean showAlways, boolean checkAlways, String okBtnStr, String cancelBtnStr, String[] alerts, String[] info, int securityInfoCount, boolean showMoreInfo, Certificate[] certs, int start, int end, boolean majorWarning) {
        this.certs = certs;
        this.start = start;
        this.end = end;
        this.alertStrs = alerts;
        this.infoStrs = info;
        this.securityInfoCount = securityInfoCount;
        this.majorWarning = majorWarning;
        if (alerts != null && alerts.length > 0) {
            this.useWarningIcon = true;
        }
        try {
            this.contentPane.getChildren().add(this.createTopPanel(false));
            this.dialog.initModality(Modality.APPLICATION_MODAL);
            if (showAlways) {
                this.alwaysString = ResourceManager.getMessage("security.dialog.always");
            }
            this.contentPane.getChildren().add(this.createCenterPanel(checkAlways, okBtnStr, cancelBtnStr, -1));
            this.contentPane.getChildren().add(this.createBottomPanel(showMoreInfo));
            this.dialog.setResizable(false);
            this.dialog.setIconifiable(false);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    void setSSVContent(String message, String moreInfoText, URL moreInfoURL, String choiceText, String choice1Label, String choice2Label, String btnOneLabel, String btnTwoLabel) {
        try {
            BorderPane content = new BorderPane();
            content.setId("ssv-content-panel");
            this.dialog.initModality(Modality.APPLICATION_MODAL);
            this.contentPane.getChildren().add(content);
            content.setTop(this.createSSVTopPanel(this.topText, this.appTitle, "ainfo.getDisplayFrom()"));
            BorderPane riskPanel = this.createSSVRiskPanel(message, moreInfoText, moreInfoURL);
            final SSVChoicePanel choicePanel = new SSVChoicePanel(choiceText, choice1Label, choice2Label);
            BorderPane centerPanel = new BorderPane();
            centerPanel.setTop(riskPanel);
            centerPanel.setBottom(choicePanel);
            content.setCenter(centerPanel);
            FlowPane buttonsPanel = new FlowPane(6.0, 0.0);
            buttonsPanel.getStyleClass().add("button-bar");
            this.okBtn = new Button(btnOneLabel);
            this.okBtn.setOnAction(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent ae) {
                    if (choicePanel.getSelection() == 0) {
                        DialogTemplate.this.setUserAnswer(2);
                    } else {
                        DialogTemplate.this.setUserAnswer(0);
                    }
                    DialogTemplate.this.setVisible(false);
                }
            });
            buttonsPanel.getChildren().add(this.okBtn);
            this.cancelBtn = new Button(btnTwoLabel);
            this.cancelBtn.setOnAction(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent ae) {
                    DialogTemplate.this.cancelAction();
                }
            });
            this.cancelBtn.setCancelButton(true);
            buttonsPanel.getChildren().add(this.cancelBtn);
            this.okBtn.setDefaultButton(true);
            content.setBottom(buttonsPanel);
            this.dialog.setResizable(false);
            this.dialog.setIconifiable(false);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    void setSimpleContent(String contentString, boolean contentScroll, String infoString, String okBtnStr, String cancelBtnStr, boolean includeTop, boolean useWarningIcon) {
        this.contentString = contentString;
        this.contentScroll = contentScroll;
        this.includeMasthead = includeTop;
        this.includeAppInfo = includeTop;
        this.largeScroll = !includeTop;
        this.useWarningIcon = useWarningIcon;
        if (infoString != null) {
            String[] strs = new String[]{infoString};
            if (useWarningIcon) {
                this.alertStrs = strs;
            } else {
                this.infoStrs = strs;
            }
        }
        try {
            this.contentPane.getChildren().add(this.createTopPanel(false));
            this.contentPane.getChildren().add(this.createCenterPanel(false, okBtnStr, cancelBtnStr, -1));
            this.contentPane.getChildren().add(this.createBottomPanel(false));
            this.dialog.setResizable(contentScroll);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    void setMixedCodeContent(String contentString, boolean contentScroll, String infoString, String bottomString, String okBtnStr, String cancelBtnStr, boolean includeTop, boolean useWarningIcon) {
        this.contentString = contentString;
        this.contentScroll = contentScroll;
        this.includeMasthead = includeTop;
        this.includeAppInfo = includeTop;
        this.largeScroll = !includeTop;
        this.useMixcodeIcon = true;
        this.alertStrs = new String[1];
        String[] botStr = new String[]{bottomString};
        this.alertStrs = botStr;
        this.infoStrs = new String[3];
        String aStr = ResourceManager.getString("security.dialog.mixcode.info1");
        String bStr = ResourceManager.getString("security.dialog.mixcode.info2");
        String cStr = ResourceManager.getString("security.dialog.mixcode.info3");
        String[] strs = new String[]{aStr, bStr, cStr};
        this.infoStrs = strs;
        try {
            this.contentPane.getChildren().add(this.createTopPanel(false));
            this.mixedCodeString = infoString;
            this.contentPane.getChildren().add(this.createCenterPanel(false, okBtnStr, cancelBtnStr, -1));
            this.contentPane.getChildren().add(this.createBottomPanel(false));
            this.okBtn.requestFocus();
            boolean isResizable = contentScroll;
            this.dialog.setResizable(isResizable);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    void setListContent(String label, ListView scrollList, boolean showDetails, String okBtnStr, String cancelBtnStr, TreeMap clientAuthCertsMap) {
        this.useWarningIcon = true;
        this.includeAppInfo = false;
        this.clientAuthCertsMap = clientAuthCertsMap;
        this.contentLabel = label;
        this.contentScroll = true;
        this.scrollList = scrollList;
        this.showDetails = showDetails;
        try {
            this.contentPane.getChildren().add(this.createTopPanel(false));
            this.contentPane.getChildren().add(this.createCenterPanel(false, okBtnStr, cancelBtnStr, -1));
            this.contentPane.getChildren().add(this.createBottomPanel(false));
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    void setApiContent(String contentString, String contentLabel, String alwaysString, boolean alwaysChecked, String okBtnStr, String cancelBtnStr) {
        this.contentString = contentString;
        this.contentLabel = contentLabel;
        this.contentScroll = contentString != null;
        this.alwaysString = alwaysString;
        if (contentLabel == null && contentString != null) {
            this.infoStrs = new String[1];
            this.infoStrs[0] = contentString;
            this.contentString = null;
        }
        this.includeMasthead = true;
        this.includeAppInfo = this.contentString == null;
        this.largeScroll = false;
        try {
            this.contentPane.getChildren().add(this.createTopPanel(false));
            this.contentPane.getChildren().add(this.createCenterPanel(false, okBtnStr, cancelBtnStr, -1));
            this.contentPane.getChildren().add(this.createBottomPanel(false));
            this.dialog.setResizable(this.contentScroll);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    void setErrorContent(String contentString, String okBtnStr, String cancelBtnStr, Throwable throwable, Object detailPanelObject, Certificate[] certs, boolean hideLabel) {
        Pane detailPanel = (Pane)detailPanelObject;
        this.contentString = contentString;
        this.throwable = throwable;
        this.detailPanel = detailPanel;
        this.certs = certs;
        if (hideLabel) {
            this.includeAppInfo = false;
        }
        this.useErrorIcon = true;
        try {
            this.contentPane.getChildren().add(this.createTopPanel(false));
            this.contentPane.getChildren().add(this.createCenterPanel(false, okBtnStr, cancelBtnStr, -1));
            Pane bottomPanel = this.createBottomPanel(false);
            if (bottomPanel.getChildren().size() > 0) {
                this.contentPane.getChildren().add(bottomPanel);
            }
            this.dialog.setResizable(false);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    void setMultiButtonErrorContent(String message, String btnOneKey, String btnTwoKey, String btnThreeKey) {
        this.useErrorIcon = true;
        try {
            this.contentPane.getChildren().add(this.createTopPanel(false));
            BorderPane errorPanel = new BorderPane();
            errorPanel.setId("error-panel");
            errorPanel.setTop(this.createInfoPanel(message));
            errorPanel.setBottom(this.createThreeButtonsPanel(btnOneKey, btnTwoKey, btnThreeKey, false));
            this.contentPane.getChildren().add(errorPanel);
            this.dialog.setResizable(false);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    void setInfoContent(String contentString, String okBtnStr) {
        this.useInfoIcon = true;
        this.contentString = contentString;
        try {
            this.contentPane.getChildren().add(this.createTopPanel(false));
            this.contentPane.getChildren().add(this.createCenterPanel(false, okBtnStr, null, -1));
            this.dialog.setResizable(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void setPasswordContent(String details, boolean showUserName, boolean showDomain, String userName, String domain, boolean save, char[] password, String scheme) {
        try {
            this.contentPane.getChildren().add(this.createPasswordPanel(details, showUserName, showDomain, userName, domain, save, password, scheme));
            this.dialog.initModality(Modality.APPLICATION_MODAL);
            this.dialog.setResizable(false);
            this.dialog.setIconifiable(false);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    void setUpdateCheckContent(String infoStr, String yesBtnKey, String noBtnKey, String askLaterBtnKey) {
        try {
            this.contentPane.getChildren().add(this.createTopPanel(false));
            this.contentPane.getChildren().add(this.createInfoPanel(infoStr));
            this.contentPane.getChildren().add(this.createThreeButtonsPanel(yesBtnKey, noBtnKey, askLaterBtnKey, true));
            this.dialog.setResizable(false);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    void setProgressContent(String okBtnStr, String detailBtnStr, String contentStr, boolean showOkBtn, int percent) {
        try {
            this.cacheUpgradeContentString = contentStr;
            this.contentPane.getChildren().add(this.createTopPanel(false));
            this.contentPane.getChildren().add(this.createCenterPanel(false, okBtnStr, detailBtnStr, percent));
            if (this.cacheUpgradeContentString == null) {
                this.contentPane.getChildren().add(this.createBottomPanel(false));
            }
            this.dialog.setResizable(false);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    private Pane createInfoPanel(String infoStr) {
        StackPane infoPanel = new StackPane();
        infoPanel.setId("info-panel");
        UITextArea infoText = new UITextArea(484.0);
        infoText.setId("info-panel-text");
        infoText.setText(infoStr);
        infoPanel.getChildren().add(infoText);
        return infoPanel;
    }

    private Pane createThreeButtonsPanel(String btnOneKey, String btnTwoKey, String btnThreeKey, boolean isUpdateSpecific) {
        FlowPane buttonsPanel = new FlowPane(6.0, 0.0);
        buttonsPanel.getStyleClass().add("button-bar");
        Button oneBtn = new Button(ResourceManager.getMessage(btnOneKey));
        oneBtn.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent e) {
                DialogTemplate.this.setUserAnswer(0);
                DialogTemplate.this.setVisible(false);
            }
        });
        buttonsPanel.getChildren().add(oneBtn);
        Button twoBtn = new Button(ResourceManager.getMessage(btnTwoKey));
        twoBtn.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent e) {
                DialogTemplate.this.setVisible(false);
                DialogTemplate.this.setUserAnswer(1);
            }
        });
        buttonsPanel.getChildren().add(twoBtn);
        Button threeBtn = null;
        if (btnThreeKey != null) {
            threeBtn = new Button(ResourceManager.getMessage(btnThreeKey));
            threeBtn.setOnAction(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent e) {
                    DialogTemplate.this.setVisible(false);
                    DialogTemplate.this.setUserAnswer(3);
                }
            });
            buttonsPanel.getChildren().add(threeBtn);
        }
        if (isUpdateSpecific) {
            threeBtn.setTooltip(new Tooltip(ResourceManager.getMessage("autoupdatecheck.masthead")));
        }
        if (threeBtn != null) {
            DialogTemplate.resizeButtons(oneBtn, twoBtn, threeBtn);
        } else {
            DialogTemplate.resizeButtons(oneBtn, twoBtn);
        }
        return buttonsPanel;
    }

    private Pane createTopPanel(boolean useMastheadImage) {
        this.topPanel = new BorderPane();
        this.topPanel.setId("top-panel");
        if (this.includeMasthead) {
            this.masthead1 = new UITextArea(MAIN_TEXT_WIDTH);
            this.masthead1.setId("masthead-label-1");
            String str1 = this.topText;
            String str2 = null;
            for (String questionKey : new String[]{"security.dialog.caption.run.question", "security.dialog.caption.continue.question"}) {
                String question = ResourceManager.getMessage(questionKey);
                if (question == null || !str1.endsWith(question)) continue;
                str2 = str1.substring(0, str1.indexOf(question)).trim();
                str1 = question;
                break;
            }
            VBox mastheadVBox = new VBox();
            mastheadVBox.setAlignment(Pos.CENTER_LEFT);
            this.masthead1.setText(str1);
            this.masthead1.setAlignment(Pos.CENTER_LEFT);
            mastheadVBox.getChildren().add(this.masthead1);
            if (str2 != null) {
                this.masthead2 = new UITextArea(MAIN_TEXT_WIDTH);
                this.masthead2.setId("masthead-label-2");
                this.masthead2.setText(str2);
                this.masthead2.setAlignment(Pos.CENTER_LEFT);
                mastheadVBox.getChildren().add(this.masthead2);
            }
            this.topPanel.setLeft(mastheadVBox);
            BorderPane.setAlignment(mastheadVBox, Pos.CENTER_LEFT);
            if (useMastheadImage) {
                ImageView icon = ResourceManager.getIcon("progress.background.image");
            } else {
                this.topIcon = ResourceManager.getIcon("java48.image");
                if (this.useErrorIcon) {
                    this.topIcon = ResourceManager.getIcon("error48.image");
                }
                if (this.useInfoIcon) {
                    this.topIcon = ResourceManager.getIcon("info48.image");
                }
                if (this.useMixcodeIcon) {
                    this.topIcon = ResourceManager.getIcon("mixcode.image");
                }
                if (this.useWarningIcon) {
                    this.topIcon = this.majorWarning ? ResourceManager.getIcon("major-warning48.image") : ResourceManager.getIcon("warning48.image");
                } else if (this.ainfo.getIconRef() != null) {
                    this.topIcon = ResourceManager.getIcon(this.ainfo.getIconRef());
                }
                this.topPanel.setRight(this.topIcon);
            }
        }
        return this.topPanel;
    }

    private Pane createCenterPanel(boolean checkAlways, String okBtnStr, String cancelBtnStr, int progress) {
        BorderPane top;
        boolean showProgress;
        this.centerPanel = new VBox();
        this.centerPanel.setId("center-panel");
        GridPane labelsPanel = new GridPane();
        labelsPanel.setId("center-panel-grid");
        Label nameLbl = new Label(ResourceManager.getMessage("dialog.template.name"));
        nameLbl.setId("dialog-name-label");
        Label publisherLbl = new Label(ResourceManager.getMessage("dialog.template.publisher"));
        publisherLbl.setId("dialog-publisher-label");
        Label fromLbl = new Label(ResourceManager.getMessage("dialog.template.from"));
        fromLbl.setId("dialog-from-label");
        this.nameInfo = new Label();
        this.nameInfo.setId("dialog-name-value");
        this.publisherInfo = new Label();
        this.publisherInfo.setId("dialog-publisher-value");
        this.urlInfo = new Label();
        this.urlInfo.setId("dialog-from-value");
        if (this.appTitle != null) {
            GridPane.setConstraints(nameLbl, 0, 0);
            GridPane.setHalignment(nameLbl, HPos.RIGHT);
            labelsPanel.getChildren().add(nameLbl);
            GridPane.setConstraints(this.nameInfo, 1, 0);
            labelsPanel.getChildren().add(this.nameInfo);
        }
        if (this.appPublisher != null) {
            GridPane.setConstraints(publisherLbl, 0, 1);
            GridPane.setHalignment(publisherLbl, HPos.RIGHT);
            labelsPanel.getChildren().add(publisherLbl);
            GridPane.setConstraints(this.publisherInfo, 1, 1);
            labelsPanel.getChildren().add(this.publisherInfo);
        }
        if (this.appTitle != null && this.appURL != null) {
            GridPane.setConstraints(fromLbl, 0, 2);
            GridPane.setHalignment(fromLbl, HPos.RIGHT);
            labelsPanel.getChildren().add(fromLbl);
            GridPane.setConstraints(this.urlInfo, 1, 2);
            labelsPanel.getChildren().add(this.urlInfo);
        }
        this.setInfo(this.appTitle, this.appPublisher, this.appURL);
        FlowPane checkboxPanel = new FlowPane();
        checkboxPanel.setId("center-checkbox-panel");
        BorderPane mixedcodePanel = new BorderPane();
        mixedcodePanel.setId("mixed-code-panel");
        BorderPane contentPanel = new BorderPane();
        contentPanel.setId("center-content-panel");
        VBox.setVgrow(contentPanel, Priority.ALWAYS);
        if (this.alwaysString != null) {
            String key = "security.dialog.always";
            this.always = new CheckBox(this.alwaysString);
            this.always.setSelected(checkAlways);
            checkboxPanel.getChildren().add(this.always);
        }
        if (this.mixedCodeString != null) {
            this.mixedCodeLabel = new Label(this.mixedCodeString);
            BorderPane moreinfoPanel = new BorderPane();
            moreinfoPanel.setId("center-more-info-panel");
            Hyperlink moreInfoButton = new Hyperlink(ResourceManager.getMessage("dialog.template.more.info"));
            moreInfoButton.setMnemonicParsing(true);
            moreInfoButton.setOnAction(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent e) {
                    DialogTemplate.this.showMixedcodeMoreInfo();
                }
            });
            moreinfoPanel.setLeft(moreInfoButton);
            mixedcodePanel.setTop(this.mixedCodeLabel);
            mixedcodePanel.setBottom(moreinfoPanel);
        }
        boolean bl = showProgress = progress >= 0;
        if (showProgress) {
            this.progressBar = new ProgressBar();
            this.progressBar.setVisible(progress <= 100);
        }
        if (this.contentString != null) {
            if (this.contentLabel != null) {
                top = new BorderPane();
                top.setLeft(new Label(this.contentLabel));
                contentPanel.setTop(top);
            }
            if (this.contentScroll) {
                Label text;
                boolean limitWidth = this.largeScroll;
                if (this.largeScroll) {
                    text = new Label(this.contentString);
                    text.setPrefWidth(640.0);
                    text.setPrefHeight(240.0);
                } else {
                    text = new Label(this.contentString);
                    text.setPrefWidth(320.0);
                    text.setPrefHeight(48.0);
                }
                ScrollPane sp = new ScrollPane();
                sp.setContent(text);
                sp.setFitToWidth(true);
                VBox.setVgrow(sp, Priority.ALWAYS);
                if (limitWidth) {
                    sp.setMaxWidth(600.0);
                }
                contentPanel.setCenter(sp);
            } else {
                UITextArea ta = new UITextArea(this.contentString);
                ta.setId("center-content-area");
                ta.setAlignment(Pos.TOP_LEFT);
                contentPanel.setCenter(ta);
            }
            contentPanel.setPadding(new Insets(0.0, 0.0, 12.0, 0.0));
        }
        if (this.scrollList != null) {
            if (this.contentLabel != null) {
                top = new BorderPane();
                top.setLeft(new Label(this.contentLabel));
                contentPanel.setTop(top);
            }
            if (this.contentScroll) {
                ScrollPane sp = new ScrollPane();
                sp.setContent(this.scrollList);
                VBox.setVgrow(sp, Priority.ALWAYS);
                contentPanel.setCenter(sp);
            }
            if (this.showDetails) {
                Hyperlink certDetails = new Hyperlink(ResourceManager.getMessage("security.more.info.details"));
                certDetails.setMnemonicParsing(true);
                certDetails.setOnAction(new EventHandler<ActionEvent>(){

                    @Override
                    public void handle(ActionEvent e) {
                        DialogTemplate.this.showCertificateDetails();
                    }
                });
                FlowPane certDetailsPanel = new FlowPane();
                certDetailsPanel.setPadding(new Insets(12.0, 0.0, 12.0, 0.0));
                certDetailsPanel.setAlignment(Pos.TOP_LEFT);
                certDetailsPanel.getChildren().add(certDetails);
                contentPanel.setBottom(certDetailsPanel);
            }
        }
        FlowPane buttonsPanel = new FlowPane(6.0, 0.0);
        buttonsPanel.getStyleClass().add("button-bar");
        buttonsPanel.setId("center-bottom-button-bar");
        this.okBtn = new Button(okBtnStr == null ? "" : ResourceManager.getMessage(okBtnStr));
        this.okBtn.setOnAction(this.okHandler);
        buttonsPanel.getChildren().add(this.okBtn);
        this.okBtn.setVisible(okBtnStr != null);
        this.cancelBtn = new Button(cancelBtnStr == null ? "" : ResourceManager.getMessage(cancelBtnStr));
        this.cancelBtn.setOnAction(this.cancelHandler);
        buttonsPanel.getChildren().add(this.cancelBtn);
        this.cancelBtn.setVisible(cancelBtnStr != null);
        if (this.okBtn.isVisible()) {
            this.okBtn.setDefaultButton(true);
        } else {
            this.cancelBtn.setCancelButton(true);
        }
        DialogTemplate.resizeButtons(this.okBtn, this.cancelBtn);
        if (this.cacheUpgradeContentString != null) {
            UITextArea cacheUpgradeContentTa = new UITextArea(this.cacheUpgradeContentString);
            cacheUpgradeContentTa.setId("cache-upgrade-content");
            contentPanel.setTop(cacheUpgradeContentTa);
        } else {
            if (this.includeAppInfo) {
                this.centerPanel.getChildren().add(labelsPanel);
            }
            if (this.alwaysString != null) {
                this.centerPanel.getChildren().add(checkboxPanel);
            }
            if (this.mixedCodeString != null) {
                this.centerPanel.getChildren().add(mixedcodePanel);
            }
        }
        if (contentPanel.getChildren().size() > 0) {
            this.centerPanel.getChildren().add(contentPanel);
        }
        BorderPane bottomPanel = new BorderPane();
        bottomPanel.setId("center-bottom-panel");
        if (showProgress) {
            this.progressStatusLabel = new Label(" ");
            this.progressStatusLabel.getStyleClass().add("progress-label");
            BorderPane progressStatusPanel = new BorderPane();
            progressStatusPanel.setId("center-progress-status-panel");
            this.centerPanel.getChildren().add(progressStatusPanel);
            progressStatusPanel.setLeft(this.progressStatusLabel);
            progressStatusPanel.setPadding(new Insets(2.0, 0.0, 2.0, 0.0));
            bottomPanel.setCenter(this.progressBar);
        }
        bottomPanel.setRight(buttonsPanel);
        this.centerPanel.getChildren().add(bottomPanel);
        return this.centerPanel;
    }

    private Pane createBottomPanel(boolean showMoreInfo) {
        HBox bottomPanel = new HBox();
        bottomPanel.setId("bottom-panel");
        if (this.alertStrs != null || this.infoStrs != null) {
            String imageFile = "security.alert.high.image";
            if (this.alertStrs == null || this.alertStrs.length == 0) {
                imageFile = "security.alert.low.image";
                if (this.always != null) {
                    this.always.setSelected(true);
                }
            } else if (this.mixedCodeString == null) {
                this.okBtn.setDefaultButton(false);
                this.cancelBtn.setCancelButton(true);
            }
            this.securityIcon = ResourceManager.getIcon(imageFile);
            bottomPanel.getChildren().add(this.securityIcon);
            boolean moreInfoLength = false;
            Hyperlink moreInfoLbl = null;
            if (showMoreInfo) {
                moreInfoLbl = new Hyperlink(ResourceManager.getMessage("dialog.template.more.info"));
                moreInfoLbl.setMnemonicParsing(true);
                moreInfoLbl.setId("bottom-more-info-link");
                moreInfoLbl.setOnAction(new EventHandler<ActionEvent>(){

                    @Override
                    public void handle(ActionEvent e) {
                        DialogTemplate.this.showMoreInfo();
                    }
                });
            }
            int textAreaWidth = 333;
            UITextArea bulletText = new UITextArea(textAreaWidth);
            bulletText.setId("bottom-text");
            if ((this.alertStrs == null || this.alertStrs.length == 0) && this.infoStrs != null && this.infoStrs.length != 0) {
                bulletText.setText(this.infoStrs[0] != null ? this.infoStrs[0] : " ");
            } else if (this.alertStrs != null && this.alertStrs.length != 0) {
                bulletText.setText(this.alertStrs[0] != null ? this.alertStrs[0] : " ");
            }
            bottomPanel.getChildren().add(bulletText);
            if (moreInfoLbl != null) {
                bottomPanel.getChildren().add(moreInfoLbl);
            }
        }
        return bottomPanel;
    }

    private BorderPane createSSVTopPanel(String message, String name, String url) {
        BorderPane top = new BorderPane();
        top.setPadding(new Insets(16.0, 0.0, 16.0, 16.0));
        Label messageLabel = new Label(message);
        messageLabel.getStyleClass().add("ssv-big-bold-label");
        top.setTop(messageLabel);
        Label nameLabel = new Label(ResourceManager.getMessage("dialog.template.name"));
        nameLabel.getStyleClass().add("ssv-small-bold-label");
        nameLabel.setId("ssv-top-panel-name-label");
        Label fromLabel = new Label(ResourceManager.getMessage("dialog.template.from"));
        fromLabel.getStyleClass().add("ssv-small-bold-label");
        fromLabel.setId("ssv-top-panel-from-label");
        this.nameInfo = new Label(name);
        this.nameInfo.getStyleClass().add("ssv-big-bold-label");
        Label fromInfo = new Label(url);
        fromInfo.getStyleClass().add("ssv-small-label");
        BorderPane[] parts = new BorderPane[4];
        for (int i = 0; i < 4; ++i) {
            parts[i] = new BorderPane();
        }
        ImageView warningIcon = ResourceManager.getIcon("warning48.image");
        parts[2].setTop(nameLabel);
        parts[2].setBottom(fromLabel);
        parts[2].setPadding(new Insets(2.0, 0.0, 0.0, 0.0));
        parts[3].setTop(this.nameInfo);
        parts[3].setBottom(fromInfo);
        parts[1].setLeft(parts[2]);
        parts[1].setCenter(parts[3]);
        parts[1].setPadding(new Insets(12.0, 0.0, 12.0, 0.0));
        parts[0].setLeft(warningIcon);
        parts[0].setRight(parts[1]);
        parts[0].setPadding(new Insets(8.0, 0.0, 0.0, 32.0));
        top.setBottom(parts[0]);
        return top;
    }

    private BorderPane createSSVRiskPanel(String message, String moreInfoText, final URL moreInfoURL) {
        BorderPane risk = new BorderPane();
        risk.setPadding(new Insets(8.0, 8.0, 0.0, 8.0));
        int index = message.indexOf(" ");
        if (index < message.length() - 2) {
            String riskLabelText = message.substring(0, index);
            String riskText = message.substring(index + 1);
            BorderPane left = new BorderPane();
            Label riskLabel = new Label(riskLabelText);
            riskLabel.getStyleClass().add("ssv-small-bold-label");
            left.setTop(riskLabel);
            left.setPadding(new Insets(0.0, 8.0, 0.0, 8.0));
            BorderPane right = new BorderPane();
            Label riskTextLabel = new Label(riskText);
            right.setLeft(riskTextLabel);
            riskTextLabel.getStyleClass().add("ssv-small-label");
            Hyperlink link = new Hyperlink(moreInfoText);
            link.setOnAction(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent e) {
                    HostServicesDelegate services = HostServicesImpl.getInstance(null);
                    if (services != null && moreInfoURL != null) {
                        services.showDocument(moreInfoURL.toExternalForm());
                    }
                }
            });
            right.setRight(link);
            risk.setLeft(left);
            risk.setCenter(right);
        }
        return risk;
    }

    private Pane createPasswordPanel(String details, boolean showUserName, boolean showDomain, String userName, String domain, boolean saveEnabled, char[] sugPass, String scheme) {
        Label uNameLbl = new Label();
        Label domainLbl = new Label();
        ImageView banner = ResourceManager.getIcon("pwd-masthead.png");
        if (showUserName) {
            String userNameKey = "password.dialog.username";
            uNameLbl.setText(ResourceManager.getMessage(userNameKey));
            uNameLbl.setMnemonicParsing(true);
            this.pwdName = new TextField();
            this.pwdName.setId("user-name-field");
            this.pwdName.setText(userName);
            uNameLbl.setLabelFor(this.pwdName);
            uNameLbl.setId("user-name-label");
        }
        String passwordKey = "password.dialog.password";
        Label passwordLbl = new Label(ResourceManager.getMessage(passwordKey));
        this.password = new PasswordField();
        this.password.setText(String.valueOf(sugPass));
        passwordLbl.setLabelFor(this.password);
        passwordLbl.setMnemonicParsing(true);
        passwordLbl.setId("password-label");
        if (showDomain) {
            String domainKey = "password.dialog.domain";
            domainLbl.setText(ResourceManager.getMessage(domainKey));
            this.pwdDomain = new TextField();
            this.pwdDomain.setText(domain);
            domainLbl.setLabelFor(this.pwdDomain);
            domainLbl.setMnemonicParsing(true);
            domainLbl.setId("password-domain-label");
        }
        VBox elementsPanel = new VBox();
        elementsPanel.setMaxWidth(banner.getImage().getWidth());
        elementsPanel.getChildren().add(banner);
        VBox passwordContentPanel = new VBox(10.0);
        passwordContentPanel.setId("password-panel");
        Label detailsText = new Label();
        detailsText.setId("password-details");
        detailsText.setWrapText(true);
        detailsText.setText(details);
        passwordContentPanel.getChildren().add(detailsText);
        GridPane gridPane = new GridPane();
        gridPane.setId("password-panel-grid");
        int row = 0;
        if (showUserName) {
            GridPane.setConstraints(uNameLbl, 0, row);
            GridPane.setHalignment(uNameLbl, HPos.RIGHT);
            gridPane.getChildren().add(uNameLbl);
            GridPane.setConstraints(this.pwdName, 1, row++);
            gridPane.getChildren().add(this.pwdName);
        }
        GridPane.setConstraints(passwordLbl, 0, row);
        GridPane.setHalignment(passwordLbl, HPos.RIGHT);
        gridPane.getChildren().add(passwordLbl);
        GridPane.setConstraints(this.password, 1, row++);
        gridPane.getChildren().add(this.password);
        if (showDomain) {
            GridPane.setConstraints(domainLbl, 0, row);
            GridPane.setHalignment(domainLbl, HPos.RIGHT);
            gridPane.getChildren().add(domainLbl);
            GridPane.setConstraints(this.pwdDomain, 1, row++);
            gridPane.getChildren().add(this.pwdDomain);
        }
        if (saveEnabled) {
            this.always = new CheckBox(ResourceManager.getMessage("password.dialog.save"));
            this.always.setId("password-always-checkbox");
            this.always.setSelected(sugPass.length > 0);
            GridPane.setConstraints(this.always, 1, row++);
            gridPane.getChildren().add(this.always);
        }
        passwordContentPanel.getChildren().add(gridPane);
        FlowPane btnsPanel = new FlowPane(6.0, 0.0);
        btnsPanel.setPrefWrapLength(300.0);
        btnsPanel.getStyleClass().add("button-bar");
        btnsPanel.setId("password-button-bar");
        this.okBtn = new Button(ResourceManager.getMessage("common.ok_btn"));
        this.okBtn.setOnAction(this.okHandler);
        this.okBtn.setDefaultButton(true);
        this.cancelBtn = new Button(ResourceManager.getMessage("common.cancel_btn"));
        this.cancelBtn.setOnAction(this.cancelHandler);
        DialogTemplate.resizeButtons(this.okBtn, this.cancelBtn);
        btnsPanel.getChildren().addAll((Node[])new Node[]{this.okBtn, this.cancelBtn});
        passwordContentPanel.getChildren().add(btnsPanel);
        if (scheme != null) {
            MessageFormat mf = new MessageFormat(ResourceManager.getMessage("password.dialog.scheme"));
            Object[] args = new Object[]{scheme};
            Label schemeLabel = new Label(mf.format(args));
            passwordContentPanel.getChildren().add(schemeLabel);
        }
        elementsPanel.getChildren().add(passwordContentPanel);
        return elementsPanel;
    }

    void showMoreInfo() {
        MoreInfoDialog info = this.throwable == null && this.detailPanel == null ? new MoreInfoDialog(this.dialog, this.alertStrs, this.infoStrs, this.securityInfoCount, this.certs, this.start, this.end) : new MoreInfoDialog(this.dialog, this.detailPanel, this.throwable, this.certs);
        info.show();
    }

    void showMixedcodeMoreInfo() {
        MoreInfoDialog info = new MoreInfoDialog(this.dialog, null, this.infoStrs, 0, null, 0, 0);
        info.show();
    }

    void showCertificateDetails() {
        Certificate[] selectCert = null;
        Iterator iter = this.clientAuthCertsMap.values().iterator();
        for (long selectedIndex = (long)this.scrollList.getSelectionModel().getSelectedIndex(); selectedIndex >= 0L && iter.hasNext(); --selectedIndex) {
            selectCert = (X509Certificate[])iter.next();
        }
        if (selectCert != null) {
            CertificateDialog.showCertificates(this.dialog, selectCert, 0, selectCert.length);
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            final FXDialog dlg = this.dialog;
            Runnable runner = new Runnable(){

                public void run() {
                    dlg.showAndWait();
                }
            };
            runner.run();
        } else {
            this.dialog.hide();
        }
    }

    public static void resizeButtons(Button ... buttons) {
        int len = buttons.length;
        double widest = 50.0;
        for (int i = 0; i < len; ++i) {
            if (!(buttons[i].prefWidth(-1.0) > widest)) continue;
            widest = buttons[i].prefWidth(-1.0);
        }
    }

    public void cancelAction() {
        this.userAnswer = 1;
        this.setVisible(false);
    }

    int getUserAnswer() {
        return this.userAnswer;
    }

    void setUserAnswer(int answer) {
        this.userAnswer = answer;
    }

    char[] getPassword() {
        return this.pwd;
    }

    String getUserName() {
        return this.userName;
    }

    String getDomain() {
        return this.domain;
    }

    public boolean isPasswordSaved() {
        return this.always != null && this.always.isSelected();
    }

    public void progress(int progress) {
        if (this.progressBar != null) {
            if (progress <= 100) {
                this.progressBar.setProgress((double)progress / 100.0);
                this.progressBar.setVisible(true);
            } else {
                this.progressBar.setVisible(false);
            }
        }
    }

    public FXDialog getDialog() {
        return this.dialog;
    }

    public void setInfo(String name, String publisher, URL urlFrom) {
        if (this.nameInfo != null) {
            this.nameInfo.setText(name);
        }
        if (this.publisherInfo != null) {
            this.appPublisher = publisher;
            this.publisherInfo.setText(publisher);
        }
        if (this.urlInfo != null) {
            this.appURL = urlFrom;
            String from = " ";
            String tooltip = "";
            if (urlFrom != null) {
                from = urlFrom.getProtocol() + "://" + urlFrom.getHost();
                int port = urlFrom.getPort();
                if (port != -1) {
                    from = from + ":" + Integer.toString(port);
                }
                tooltip = urlFrom.toString();
            }
            this.urlInfo.setText(from);
            this.urlInfo.setTooltip(new Tooltip(tooltip));
        }
    }

    void showOk(boolean show) {
        DialogTemplate.resizeButtons(this.okBtn, this.cancelBtn);
        this.okBtn.setVisible(show);
    }

    void stayAlive() {
        this.stayAliveOnOk = true;
    }

    public void setProgressStatusText(String text) {
        if (this.progressStatusLabel != null) {
            if (text == null || text.length() == 0) {
                text = " ";
            }
            this.progressStatusLabel.setText(text);
        }
    }

    static /* synthetic */ char[] access$402(DialogTemplate x0, char[] x1) {
        x0.pwd = x1;
        return x1;
    }

    private class SSVChoicePanel
    extends BorderPane {
        ToggleGroup group;
        RadioButton button1;
        RadioButton button2;

        public SSVChoicePanel(String choiceText, String choice1Label, String choice2Label) {
            this.setPadding(new Insets(8.0, 16.0, 0.0, 16.0));
            BorderPane top = new BorderPane();
            VBox bot = new VBox();
            bot.setSpacing(4.0);
            Label textLabel = new Label(choiceText);
            textLabel.getStyleClass().add("ssv-small-bold-label");
            top.setCenter(textLabel);
            this.button1 = new RadioButton(choice1Label);
            this.button1.getStyleClass().add("ssv-small-label");
            this.button2 = new RadioButton(choice2Label);
            this.button2.getStyleClass().add("ssv-small-label");
            this.group = new ToggleGroup();
            this.button1.setToggleGroup(this.group);
            this.button2.setToggleGroup(this.group);
            this.button1.setSelected(true);
            bot.getChildren().addAll((Node[])new Node[]{this.button1, this.button2});
            bot.setPadding(new Insets(0.0, 16.0, 0.0, 32.0));
            this.setTop(top);
            this.setBottom(bot);
            this.button1.requestFocus();
        }

        public int getSelection() {
            if (this.button2.isSelected()) {
                return 1;
            }
            return 0;
        }
    }
}

