/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.win;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.MenuItem;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.win.WinMenuDelegate;
import com.sun.glass.ui.win.WinMenuItemDelegate;

class WinMenuImpl {
    private static final boolean LOG_ERROR = true;
    private long ptr = 0L;

    static native void _initIDs();

    WinMenuImpl() {
    }

    long getHMENU() {
        return this.ptr;
    }

    boolean create() {
        this.ptr = this._create();
        return this.ptr != 0L;
    }

    void destroy() {
        if (this.ptr != 0L) {
            this._destroy(this.ptr);
            this.ptr = 0L;
        }
    }

    boolean insertSubmenu(WinMenuDelegate menu, int pos) {
        menu.setParent(this);
        if (!this._insertSubmenu(this.ptr, pos, menu.getHMENU(), menu.getOwner().getTitle(), menu.getOwner().isEnabled())) {
            menu.setParent(null);
            return false;
        }
        return true;
    }

    boolean insertItem(WinMenuItemDelegate item, int pos) {
        if (item == null) {
            return this._insertSeparator(this.ptr, pos);
        }
        item.setParent(this);
        if (!this._insertItem(this.ptr, pos, item.getCmdID(), item.getOwner().getTitle(), item.getOwner().isEnabled(), item.getOwner().isChecked(), item.getOwner().getCallback(), item.getOwner().getShortcutKey(), item.getOwner().getShortcutModifiers())) {
            item.setParent(null);
            return false;
        }
        return true;
    }

    boolean removeMenu(WinMenuDelegate submenu, int pos) {
        if (this._removeAtPos(this.ptr, pos)) {
            submenu.setParent(null);
            return true;
        }
        return false;
    }

    boolean removeItem(WinMenuItemDelegate item, int pos) {
        if (this._removeAtPos(this.ptr, pos)) {
            if (item != null) {
                item.setParent(null);
            }
            return true;
        }
        return false;
    }

    boolean setSubmenuTitle(WinMenuDelegate submenu, String title) {
        return this._setSubmenuTitle(this.ptr, submenu.getHMENU(), title);
    }

    boolean setItemTitle(WinMenuItemDelegate submenu, String title) {
        return this._setItemTitle(this.ptr, submenu.getCmdID(), title);
    }

    boolean enableSubmenu(WinMenuDelegate submenu, boolean enable) {
        return this._enableSubmenu(this.ptr, submenu.getHMENU(), enable);
    }

    boolean enableItem(WinMenuItemDelegate item, boolean enable) {
        return this._enableItem(this.ptr, item.getCmdID(), enable);
    }

    public boolean checkItem(WinMenuItemDelegate item, boolean check) {
        return this._checkItem(this.ptr, item.getCmdID(), check);
    }

    private static boolean notifyCommand(Window window, int cmdID) {
        MenuItem.Callback callback;
        WinMenuItemDelegate item = WinMenuItemDelegate.CommandIDManager.getHandler(cmdID);
        if (item != null && (callback = item.getOwner().getCallback()) != null) {
            callback.action();
            return true;
        }
        return false;
    }

    private native long _create();

    private native void _destroy(long var1);

    private native boolean _insertItem(long var1, int var3, int var4, String var5, boolean var6, boolean var7, MenuItem.Callback var8, int var9, int var10);

    private native boolean _insertSubmenu(long var1, int var3, long var4, String var6, boolean var7);

    private native boolean _insertSeparator(long var1, int var3);

    private native boolean _removeAtPos(long var1, int var3);

    private native boolean _setItemTitle(long var1, int var3, String var4);

    private native boolean _setSubmenuTitle(long var1, long var3, String var5);

    private native boolean _enableItem(long var1, int var3, boolean var4);

    private native boolean _enableSubmenu(long var1, long var3, boolean var5);

    private native boolean _checkItem(long var1, int var3, boolean var4);

    static {
        Application.loadNativeLibrary();
        WinMenuImpl._initIDs();
    }
}

