/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.platform.graphics;

import com.sun.webpane.platform.graphics.Ref;
import com.sun.webpane.platform.graphics.WCFont;
import com.sun.webpane.platform.graphics.WCGraphicsContext;
import com.sun.webpane.platform.graphics.WCIcon;
import com.sun.webpane.platform.graphics.WCImage;
import com.sun.webpane.platform.graphics.WCImageFrame;
import com.sun.webpane.platform.graphics.WCImgDecoder;
import com.sun.webpane.platform.graphics.WCMediaPlayer;
import com.sun.webpane.platform.graphics.WCPageBackBuffer;
import com.sun.webpane.platform.graphics.WCPath;
import com.sun.webpane.platform.graphics.WCRenderQueue;
import com.sun.webpane.platform.graphics.WCTransform;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class WCGraphicsManager {
    private AtomicInteger idCount = new AtomicInteger(0);
    HashMap<Integer, Ref> refMap = new HashMap();
    private static ResourceBundle imageProperties = null;
    private static WCGraphicsManager manager = null;

    public static void setGraphicsManager(WCGraphicsManager wCGraphicsManager) {
        manager = wCGraphicsManager;
    }

    public static WCGraphicsManager getGraphicsManager() {
        return manager;
    }

    public abstract WCImgDecoder getImgDecoder();

    public abstract WCGraphicsContext createGraphicsContext(Object var1);

    public abstract WCRenderQueue createBufferedContextRQ(WCImage var1);

    public abstract WCPageBackBuffer createPageBackBuffer();

    public abstract WCFont getWCFont(String var1, boolean var2, boolean var3, float var4);

    public abstract WCPath createWCPath();

    public abstract WCPath createWCPath(WCPath var1);

    public abstract WCImage createWCImage(int var1, int var2);

    public abstract WCImage createRTImage(int var1, int var2);

    protected abstract WCImageFrame createFrame(int var1, int var2, ByteBuffer var3);

    public static String getResourceName(String string) {
        if (imageProperties == null) {
            imageProperties = ResourceBundle.getBundle("com.sun.webpane.platform.graphics.Images");
        }
        try {
            return imageProperties.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    public void loadFromResource(String string, long l) {
        InputStream inputStream = this.getClass().getResourceAsStream(WCGraphicsManager.getResourceName(string));
        if (inputStream == null) {
            return;
        }
        byte[] byArray = new byte[1024];
        try {
            int n;
            while ((n = inputStream.read(byArray)) > -1) {
                WCGraphicsManager.append(l, byArray, n);
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public abstract WCTransform createTransform(double var1, double var3, double var5, double var7, double var9, double var11);

    public abstract WCIcon getSystemIcon(String var1);

    public String[] getSupportedMediaTypes() {
        return new String[0];
    }

    public WCMediaPlayer createMediaPlayer(long l) {
        throw new UnsupportedOperationException();
    }

    int createID() {
        return this.idCount.incrementAndGet();
    }

    synchronized void ref(Ref ref) {
        this.refMap.put(ref.id, ref);
    }

    synchronized Ref deref(Ref ref) {
        return this.refMap.remove(ref.id);
    }

    public synchronized Ref getRef(int n) {
        return this.refMap.get(n);
    }

    private static native void append(long var0, byte[] var2, int var3);
}

