/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.Utils;
import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.css.CssError;
import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.StyleableStringProperty;
import com.sun.javafx.css.converters.StringConverter;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.control.Logging;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.WritableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.scene.control.Skinnable;
import javafx.scene.control.UAStylesheetLoader;
import javafx.stage.PopupWindow;

public class PopupControl
extends PopupWindow
implements Skinnable {
    public static final double USE_PREF_SIZE = Double.NEGATIVE_INFINITY;
    public static final double USE_COMPUTED_SIZE = -1.0;
    protected CSSBridge bridge;
    private final StringProperty id = new SimpleStringProperty(this, "id");
    private final ObservableList<String> styleClass = new TrackableObservableList<String>(){

        @Override
        protected void onChanged(ListChangeListener.Change<String> change) {
            PopupControl.this.bridge.getStyleClass().setAll(PopupControl.this.styleClass);
        }

        @Override
        public String toString() {
            if (this.size() == 0) {
                return "";
            }
            if (this.size() == 1) {
                return (String)this.get(0);
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.size(); ++i) {
                stringBuilder.append((String)this.get(i));
                if (i + 1 >= this.size()) continue;
                stringBuilder.append(' ');
            }
            return stringBuilder.toString();
        }
    };
    private final StringProperty style = new SimpleStringProperty(this, "style");
    private DoubleProperty minWidth;
    private DoubleProperty minHeight;
    private DoubleProperty prefWidth;
    private DoubleProperty prefHeight;
    private DoubleProperty maxWidth;
    private DoubleProperty maxHeight;
    private double prefWidthCache = -1.0;
    private double prefHeightCache = -1.0;
    private double minWidthCache = -1.0;
    private double minHeightCache = -1.0;
    private double maxWidthCache = -1.0;
    private double maxHeightCache = -1.0;
    private boolean skinSizeComputed = false;
    @Deprecated
    protected Styleable styleable;

    public PopupControl() {
        this.bridge = new CSSBridge();
        this.bridge.idProperty().bind(this.idProperty());
        this.bridge.styleProperty().bind(this.styleProperty());
        this.getContent().add(this.bridge);
    }

    public final StringProperty idProperty() {
        return this.id;
    }

    public final void setId(String string) {
        this.id.set(string);
    }

    public final String getId() {
        return (String)this.id.get();
    }

    public final ObservableList<String> getStyleClass() {
        return this.styleClass;
    }

    public final void setStyle(String string) {
        this.style.set(string);
    }

    public final String getStyle() {
        return (String)this.style.get();
    }

    public final StringProperty styleProperty() {
        return this.style;
    }

    @Override
    public final ObjectProperty<Skin<?>> skinProperty() {
        return this.bridge.skin;
    }

    @Override
    public final void setSkin(Skin<?> skin) {
        this.skinProperty().set(skin);
    }

    @Override
    public final Skin<?> getSkin() {
        return (Skin)this.skinProperty().getValue();
    }

    private Node getSkinNode() {
        return this.getSkin() == null ? null : this.getSkin().getNode();
    }

    public final void setMinWidth(double d) {
        this.minWidthProperty().set(d);
    }

    public final double getMinWidth() {
        return this.minWidth == null ? -1.0 : this.minWidth.get();
    }

    public final DoubleProperty minWidthProperty() {
        if (this.minWidth == null) {
            this.minWidth = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (PopupControl.this.isShowing()) {
                        PopupControl.this.bridge.requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return PopupControl.this;
                }

                @Override
                public String getName() {
                    return "minWidth";
                }
            };
        }
        return this.minWidth;
    }

    public final void setMinHeight(double d) {
        this.minHeightProperty().set(d);
    }

    public final double getMinHeight() {
        return this.minHeight == null ? -1.0 : this.minHeight.get();
    }

    public final DoubleProperty minHeightProperty() {
        if (this.minHeight == null) {
            this.minHeight = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (PopupControl.this.isShowing()) {
                        PopupControl.this.bridge.requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return PopupControl.this;
                }

                @Override
                public String getName() {
                    return "minHeight";
                }
            };
        }
        return this.minHeight;
    }

    public void setMinSize(double d, double d2) {
        this.setMinWidth(d);
        this.setMinHeight(d2);
    }

    public final void setPrefWidth(double d) {
        this.prefWidthProperty().set(d);
    }

    public final double getPrefWidth() {
        return this.prefWidth == null ? -1.0 : this.prefWidth.get();
    }

    public final DoubleProperty prefWidthProperty() {
        if (this.prefWidth == null) {
            this.prefWidth = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (PopupControl.this.isShowing()) {
                        PopupControl.this.bridge.requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return PopupControl.this;
                }

                @Override
                public String getName() {
                    return "prefWidth";
                }
            };
        }
        return this.prefWidth;
    }

    public final void setPrefHeight(double d) {
        this.prefHeightProperty().set(d);
    }

    public final double getPrefHeight() {
        return this.prefHeight == null ? -1.0 : this.prefHeight.get();
    }

    public final DoubleProperty prefHeightProperty() {
        if (this.prefHeight == null) {
            this.prefHeight = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (PopupControl.this.isShowing()) {
                        PopupControl.this.bridge.requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return PopupControl.this;
                }

                @Override
                public String getName() {
                    return "prefHeight";
                }
            };
        }
        return this.prefHeight;
    }

    public void setPrefSize(double d, double d2) {
        this.setPrefWidth(d);
        this.setPrefHeight(d2);
    }

    public final void setMaxWidth(double d) {
        this.maxWidthProperty().set(d);
    }

    public final double getMaxWidth() {
        return this.maxWidth == null ? -1.0 : this.maxWidth.get();
    }

    public final DoubleProperty maxWidthProperty() {
        if (this.maxWidth == null) {
            this.maxWidth = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (PopupControl.this.isShowing()) {
                        PopupControl.this.bridge.requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return PopupControl.this;
                }

                @Override
                public String getName() {
                    return "maxWidth";
                }
            };
        }
        return this.maxWidth;
    }

    public final void setMaxHeight(double d) {
        this.maxHeightProperty().set(d);
    }

    public final double getMaxHeight() {
        return this.maxHeight == null ? -1.0 : this.maxHeight.get();
    }

    public final DoubleProperty maxHeightProperty() {
        if (this.maxHeight == null) {
            this.maxHeight = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (PopupControl.this.isShowing()) {
                        PopupControl.this.bridge.requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return PopupControl.this;
                }

                @Override
                public String getName() {
                    return "maxHeight";
                }
            };
        }
        return this.maxHeight;
    }

    public void setMaxSize(double d, double d2) {
        this.setMaxWidth(d);
        this.setMaxHeight(d2);
    }

    public final double minWidth(double d) {
        double d2 = this.getMinWidth();
        if (d2 == -1.0) {
            if (this.minWidthCache == -1.0) {
                this.minWidthCache = this.recalculateMinWidth(d);
            }
            return this.minWidthCache;
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return this.prefWidth(d);
        }
        return d2;
    }

    public final double minHeight(double d) {
        double d2 = this.getMinHeight();
        if (d2 == -1.0) {
            if (this.minHeightCache == -1.0) {
                this.minHeightCache = this.recalculateMinHeight(d);
            }
            return this.minHeightCache;
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return this.prefHeight(d);
        }
        return d2;
    }

    public final double prefWidth(double d) {
        double d2 = this.getPrefWidth();
        if (d2 == -1.0) {
            if (this.prefWidthCache == -1.0) {
                this.prefWidthCache = this.recalculatePrefWidth(d);
            }
            return this.prefWidthCache;
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return this.prefWidth(d);
        }
        return d2;
    }

    public final double prefHeight(double d) {
        double d2 = this.getPrefHeight();
        if (d2 == -1.0) {
            if (this.prefHeightCache == -1.0) {
                this.prefHeightCache = this.recalculatePrefHeight(d);
            }
            return this.prefHeightCache;
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return this.prefHeight(d);
        }
        return d2;
    }

    public final double maxWidth(double d) {
        double d2 = this.getMaxWidth();
        if (d2 == -1.0) {
            if (this.maxWidthCache == -1.0) {
                this.maxWidthCache = this.recalculateMaxWidth(d);
            }
            return this.maxWidthCache;
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return this.prefWidth(d);
        }
        return d2;
    }

    public final double maxHeight(double d) {
        double d2 = this.getMaxHeight();
        if (d2 == -1.0) {
            if (this.maxHeightCache == -1.0) {
                this.maxHeightCache = this.recalculateMaxHeight(d);
            }
            return this.maxHeightCache;
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return this.prefHeight(d);
        }
        return d2;
    }

    private double recalculateMinWidth(double d) {
        this.recomputeSkinSize();
        return this.getSkinNode() == null ? 0.0 : this.getSkinNode().minWidth(d);
    }

    private double recalculateMinHeight(double d) {
        this.recomputeSkinSize();
        return this.getSkinNode() == null ? 0.0 : this.getSkinNode().minHeight(d);
    }

    private double recalculateMaxWidth(double d) {
        this.recomputeSkinSize();
        return this.getSkinNode() == null ? 0.0 : this.getSkinNode().maxWidth(d);
    }

    private double recalculateMaxHeight(double d) {
        this.recomputeSkinSize();
        return this.getSkinNode() == null ? 0.0 : this.getSkinNode().maxHeight(d);
    }

    private double recalculatePrefWidth(double d) {
        this.recomputeSkinSize();
        return this.getSkinNode() == null ? 0.0 : this.getSkinNode().prefWidth(d);
    }

    private double recalculatePrefHeight(double d) {
        this.recomputeSkinSize();
        return this.getSkinNode() == null ? 0.0 : this.getSkinNode().prefHeight(d);
    }

    private void recomputeSkinSize() {
        if (!this.skinSizeComputed && this.getScene() != null && this.getScene().getRoot() != null) {
            this.getScene().getRoot().impl_processCSS(true);
            this.skinSizeComputed = true;
        }
    }

    private void updateChildren() {
        this.prefWidthCache = -1.0;
        this.prefHeightCache = -1.0;
        this.minWidthCache = -1.0;
        this.minHeightCache = -1.0;
        this.maxWidthCache = -1.0;
        this.maxHeightCache = -1.0;
        this.skinSizeComputed = false;
        Node node = this.getSkinNode();
        if (node != null) {
            this.bridge.getChildren().setAll((Node[])new Node[]{node});
        } else {
            this.bridge.getChildren().clear();
        }
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return PopupControl.impl_CSS_STYLEABLES();
    }

    @Deprecated
    protected void impl_pseudoClassStateChanged(String string) {
        this.bridge.impl_pseudoClassStateChanged(string);
    }

    @Deprecated
    public Styleable impl_getStyleable() {
        if (this.styleable == null) {
            this.styleable = new Styleable(){

                @Override
                public String getId() {
                    return PopupControl.this.getId();
                }

                @Override
                public List<String> getStyleClass() {
                    return PopupControl.this.getStyleClass();
                }

                @Override
                public String getStyle() {
                    return PopupControl.this.getStyle();
                }

                @Override
                public Styleable getStyleableParent() {
                    return null;
                }

                @Override
                @Deprecated
                public List<StyleableProperty> getStyleableProperties() {
                    return PopupControl.this.impl_getStyleableProperties();
                }

                @Override
                public Node getNode() {
                    return PopupControl.this.bridge;
                }
            };
        }
        return this.styleable;
    }

    static {
        UAStylesheetLoader.doLoad();
    }

    protected class CSSBridge
    extends Group {
        private String currentSkinClassName = null;
        private ObjectProperty<Skin<?>> skin = new ObjectPropertyBase<Skin<?>>(){
            private Skin<?> oldValue;

            @Override
            public void set(Skin<?> skin) {
                if (skin == null ? this.oldValue == null : this.oldValue != null && skin.getClass().equals(this.oldValue.getClass())) {
                    return;
                }
                super.set(skin);
                CSSBridge.this.currentSkinClassName = skin == null ? null : skin.getClass().getName();
                CSSBridge.this.skinClassNameProperty().set(CSSBridge.this.currentSkinClassName);
            }

            @Override
            protected void invalidated() {
                if (this.oldValue != null) {
                    this.oldValue.dispose();
                }
                Skin skin = this.oldValue = (Skin)this.getValue();
                PopupControl.this.updateChildren();
                PlatformLogger platformLogger = Logging.getControlsLogger();
                if (platformLogger.isLoggable(300)) {
                    platformLogger.finest("Stored skin[" + this.getValue() + "] on " + this);
                }
            }

            @Override
            public Object getBean() {
                return CSSBridge.this;
            }

            @Override
            public String getName() {
                return "skin";
            }
        };
        private StringProperty skinClassName = null;

        protected CSSBridge() {
        }

        @Override
        @Deprecated
        public void impl_pseudoClassStateChanged(String string) {
            super.impl_pseudoClassStateChanged(string);
        }

        @Override
        @Deprecated
        public List<StyleableProperty> impl_getStyleableProperties() {
            return PopupControl.this.impl_getStyleableProperties();
        }

        @Override
        public void requestLayout() {
            PopupControl.this.prefWidthCache = -1.0;
            PopupControl.this.prefHeightCache = -1.0;
            PopupControl.this.minWidthCache = -1.0;
            PopupControl.this.minHeightCache = -1.0;
            PopupControl.this.maxWidthCache = -1.0;
            PopupControl.this.maxHeightCache = -1.0;
            PopupControl.this.skinSizeComputed = false;
            super.requestLayout();
        }

        private StringProperty skinClassNameProperty() {
            if (this.skinClassName == null) {
                this.skinClassName = new StyleableStringProperty(){

                    @Override
                    public void set(String string) {
                        if (string == null || string.isEmpty() || string.equals(this.get())) {
                            return;
                        }
                        super.set(string);
                    }

                    @Override
                    public void invalidated() {
                        Skin skin = (Skin)PopupControl.this.skinProperty().get();
                        if (this.get() != null && !this.get().equals(CSSBridge.this.currentSkinClassName)) {
                            CSSBridge.this.loadSkinClass();
                        }
                    }

                    @Override
                    public Object getBean() {
                        return CSSBridge.this;
                    }

                    @Override
                    public String getName() {
                        return "skinClassName";
                    }

                    @Override
                    public StyleableProperty getStyleableProperty() {
                        return StyleableProperties.SKIN;
                    }
                };
            }
            return this.skinClassName;
        }

        protected void setSkinClassName(String string) {
            this.skinClassNameProperty().set(string);
        }

        private void loadSkinClass() {
            if (this.skinClassName == null || this.skinClassName.get() == null || ((String)this.skinClassName.get()).isEmpty()) {
                String string = "Empty -fx-skin property specified for popup control " + this;
                ObservableList<CssError> observableList = StyleManager.getInstance().getErrors();
                if (observableList != null) {
                    CssError cssError = new CssError(string);
                    observableList.add(cssError);
                }
                Logging.getControlsLogger().severe(string);
                return;
            }
            try {
                Class<?> clazz = Utils.loadClass((String)this.skinClassName.get(), this);
                Constructor<?>[] constructorArray = clazz.getConstructors();
                Constructor<?> constructor = null;
                for (Constructor<?> constructor2 : constructorArray) {
                    Class<?>[] classArray = constructor2.getParameterTypes();
                    if (classArray.length != 1 || !PopupControl.class.isAssignableFrom(classArray[0])) continue;
                    constructor = constructor2;
                    break;
                }
                if (constructor == null) {
                    String cssError = "No valid constructor defined in '" + this.skinClassName + "' for popup control " + this + ".\r\nYou must provide a constructor that accepts a single " + "PopupControl parameter in " + this.skinClassName + ".";
                    ObservableList<CssError> observableList = StyleManager.getInstance().getErrors();
                    if (observableList != null) {
                        CssError cssError2 = new CssError(cssError);
                        observableList.add(cssError2);
                    }
                    Logging.getControlsLogger().severe(cssError);
                    return;
                }
                Skin cssError = (Skin)constructor.newInstance(PopupControl.this);
                PopupControl.this.skinProperty().set(cssError);
            }
            catch (InvocationTargetException invocationTargetException) {
                String string = "Failed to load skin '" + this.skinClassName + "' for popup control " + this;
                ObservableList<CssError> observableList = StyleManager.getInstance().getErrors();
                if (observableList != null) {
                    CssError cssError = new CssError(string + " :" + invocationTargetException.getLocalizedMessage());
                    observableList.add(cssError);
                }
                Logging.getControlsLogger().severe(string, invocationTargetException.getCause());
            }
            catch (Exception exception) {
                String string = "Failed to load skin '" + this.skinClassName + "' for popup control " + this;
                ObservableList<CssError> observableList = StyleManager.getInstance().getErrors();
                if (observableList != null) {
                    CssError cssError = new CssError(string + " :" + exception.getLocalizedMessage());
                    observableList.add(cssError);
                }
                Logging.getControlsLogger().severe(string, exception.getCause());
            }
        }
    }

    private static class StyleableProperties {
        private static final StyleableProperty<CSSBridge, String> SKIN = new StyleableProperty<CSSBridge, String>("-fx-skin", (StyleConverter)StringConverter.getInstance()){

            @Override
            public boolean isSettable(CSSBridge cSSBridge) {
                return cSSBridge.skin == null || !cSSBridge.skin.isBound();
            }

            @Override
            public WritableValue<String> getWritableValue(CSSBridge cSSBridge) {
                return cSSBridge.skinClassNameProperty();
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList arrayList = new ArrayList();
            Collections.addAll(arrayList, SKIN);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

