/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.ASeq;
import clojure.lang.ArraySeq;
import clojure.lang.Counted;
import clojure.lang.IFn;
import clojure.lang.IObj;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentList;
import clojure.lang.IPersistentMap;
import clojure.lang.IReduce;
import clojure.lang.ISeq;
import clojure.lang.Obj;
import clojure.lang.RT;
import clojure.lang.RestFn;
import clojure.lang.Sequential;
import clojure.lang.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class PersistentList
extends ASeq
implements IPersistentList,
IReduce,
List,
Counted {
    private final Object _first;
    private final IPersistentList _rest;
    private final int _count;
    public static IFn creator = new RestFn(){

        public final int getRequiredArity() {
            return 0;
        }

        protected final Object doInvoke(Object args) {
            if (args instanceof ArraySeq) {
                Object[] argsarray = (Object[])((ArraySeq)args).array;
                IPersistentList ret = EMPTY;
                for (int i = argsarray.length - 1; i >= 0; --i) {
                    ret = (IPersistentList)ret.cons(argsarray[i]);
                }
                return ret;
            }
            LinkedList<Object> list = new LinkedList<Object>();
            for (ISeq s = RT.seq(args); s != null; s = s.next()) {
                list.add(s.first());
            }
            return PersistentList.create(list);
        }

        public IObj withMeta(IPersistentMap meta2) {
            throw new UnsupportedOperationException();
        }

        public IPersistentMap meta() {
            return null;
        }
    };
    public static final EmptyList EMPTY = new EmptyList(null);

    public PersistentList(Object first2) {
        this._first = first2;
        this._rest = null;
        this._count = 1;
    }

    PersistentList(IPersistentMap meta2, Object _first, IPersistentList _rest, int _count) {
        super(meta2);
        this._first = _first;
        this._rest = _rest;
        this._count = _count;
    }

    public static IPersistentList create(List init2) {
        IPersistentList ret = EMPTY;
        ListIterator i = init2.listIterator(init2.size());
        while (i.hasPrevious()) {
            ret = (IPersistentList)ret.cons(i.previous());
        }
        return ret;
    }

    public Object first() {
        return this._first;
    }

    public ISeq next() {
        if (this._count == 1) {
            return null;
        }
        return (ISeq)((Object)this._rest);
    }

    public Object peek() {
        return this.first();
    }

    public IPersistentList pop() {
        if (this._rest == null) {
            return EMPTY.withMeta(this._meta);
        }
        return this._rest;
    }

    public int count() {
        return this._count;
    }

    public PersistentList cons(Object o) {
        return new PersistentList(this.meta(), o, this, this._count + 1);
    }

    public IPersistentCollection empty() {
        return EMPTY.withMeta(this.meta());
    }

    public PersistentList withMeta(IPersistentMap meta2) {
        if (meta2 != this._meta) {
            return new PersistentList(meta2, this._first, this._rest, this._count);
        }
        return this;
    }

    public Object reduce(IFn f) {
        Object ret = this.first();
        for (ISeq s = this.next(); s != null; s = s.next()) {
            ret = f.invoke(ret, s.first());
        }
        return ret;
    }

    public Object reduce(IFn f, Object start) {
        Object ret = f.invoke(start, this.first());
        for (ISeq s = this.next(); s != null; s = s.next()) {
            ret = f.invoke(ret, s.first());
        }
        return ret;
    }

    static class EmptyList
    extends Obj
    implements IPersistentList,
    List,
    ISeq,
    Counted {
        public int hashCode() {
            return 1;
        }

        public boolean equals(Object o) {
            return (o instanceof Sequential || o instanceof List) && RT.seq(o) == null;
        }

        public boolean equiv(Object o) {
            return this.equals(o);
        }

        EmptyList(IPersistentMap meta2) {
            super(meta2);
        }

        public Object first() {
            return null;
        }

        public ISeq next() {
            return null;
        }

        public ISeq more() {
            return this;
        }

        public PersistentList cons(Object o) {
            return new PersistentList(this.meta(), o, null, 1);
        }

        public IPersistentCollection empty() {
            return this;
        }

        public EmptyList withMeta(IPersistentMap meta2) {
            if (meta2 != this.meta()) {
                return new EmptyList(meta2);
            }
            return this;
        }

        public Object peek() {
            return null;
        }

        public IPersistentList pop() {
            throw new IllegalStateException("Can't pop empty list");
        }

        public int count() {
            return 0;
        }

        public ISeq seq() {
            return null;
        }

        public int size() {
            return 0;
        }

        public boolean isEmpty() {
            return true;
        }

        public boolean contains(Object o) {
            return false;
        }

        public Iterator iterator() {
            return new Iterator(){

                public boolean hasNext() {
                    return false;
                }

                public Object next() {
                    throw new NoSuchElementException();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public Object[] toArray() {
            return RT.EMPTY_ARRAY;
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(Collection collection) {
            return collection.isEmpty();
        }

        public Object[] toArray(Object[] objects) {
            if (objects.length > 0) {
                objects[0] = null;
            }
            return objects;
        }

        private List reify() {
            return Collections.unmodifiableList(new ArrayList(this));
        }

        public List subList(int fromIndex, int toIndex) {
            return this.reify().subList(fromIndex, toIndex);
        }

        public Object set(int index2, Object element) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int index2) {
            throw new UnsupportedOperationException();
        }

        public int indexOf(Object o) {
            ISeq s = this.seq();
            int i = 0;
            while (s != null) {
                if (Util.equiv(s.first(), o)) {
                    return i;
                }
                s = s.next();
                ++i;
            }
            return -1;
        }

        public int lastIndexOf(Object o) {
            return this.reify().lastIndexOf(o);
        }

        public ListIterator listIterator() {
            return this.reify().listIterator();
        }

        public ListIterator listIterator(int index2) {
            return this.reify().listIterator(index2);
        }

        public Object get(int index2) {
            return RT.nth(this, index2);
        }

        public void add(int index2, Object element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index2, Collection c) {
            throw new UnsupportedOperationException();
        }
    }
}

