/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.layout;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormSpecParser;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.util.LayoutStyle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public final class LayoutMap {
    private static final char VARIABLE_PREFIX_CHAR = '$';
    private static final Map COLUMN_ALIASES = new HashMap();
    private static final Map ROW_ALIASES = new HashMap();
    private static LayoutMap root = null;
    private final LayoutMap parent;
    private final Map columnMap;
    private final Map columnMapCache;
    private final Map rowMap;
    private final Map rowMapCache;

    public LayoutMap() {
        this(LayoutMap.getRoot());
    }

    public LayoutMap(LayoutMap parent) {
        this.parent = parent;
        this.columnMap = new HashMap();
        this.rowMap = new HashMap();
        this.columnMapCache = new HashMap();
        this.rowMapCache = new HashMap();
    }

    public static LayoutMap getRoot() {
        if (root == null) {
            root = LayoutMap.createRoot();
        }
        return root;
    }

    public boolean columnContainsKey(String key2) {
        String resolvedKey = this.resolveColumnKey(key2);
        return this.columnMap.containsKey(resolvedKey) || this.parent != null && this.parent.columnContainsKey(resolvedKey);
    }

    public String columnGet(String key2) {
        String resolvedKey = this.resolveColumnKey(key2);
        String cachedValue = (String)this.columnMapCache.get(resolvedKey);
        if (cachedValue != null) {
            return cachedValue;
        }
        String value = (String)this.columnMap.get(resolvedKey);
        if (value == null && this.parent != null) {
            value = this.parent.columnGet(resolvedKey);
        }
        if (value == null) {
            return null;
        }
        String expandedString = this.expand(value, true);
        this.columnMapCache.put(resolvedKey, expandedString);
        return expandedString;
    }

    public String columnPut(String key2, String value) {
        String resolvedKey = this.resolveColumnKey(key2);
        if (value == null) {
            throw new NullPointerException("The column expression value must not be null.");
        }
        this.columnMapCache.clear();
        return this.columnMap.put(resolvedKey, value.toLowerCase(Locale.ENGLISH));
    }

    public String columnPut(String key2, ColumnSpec value) {
        return this.columnPut(key2, value.encode());
    }

    public String columnPut(String key2, Size value) {
        return this.columnPut(key2, value.encode());
    }

    public String columnRemove(String key2) {
        String resolvedKey = this.resolveColumnKey(key2);
        this.columnMapCache.clear();
        return (String)this.columnMap.remove(resolvedKey);
    }

    public boolean rowContainsKey(String key2) {
        String resolvedKey = this.resolveRowKey(key2);
        return this.rowMap.containsKey(resolvedKey) || this.parent != null && this.parent.rowContainsKey(resolvedKey);
    }

    public String rowGet(String key2) {
        String resolvedKey = this.resolveRowKey(key2);
        String cachedValue = (String)this.rowMapCache.get(resolvedKey);
        if (cachedValue != null) {
            return cachedValue;
        }
        String value = (String)this.rowMap.get(resolvedKey);
        if (value == null && this.parent != null) {
            value = this.parent.rowGet(resolvedKey);
        }
        if (value == null) {
            return null;
        }
        String expandedString = this.expand(value, false);
        this.rowMapCache.put(resolvedKey, expandedString);
        return expandedString;
    }

    public String rowPut(String key2, String value) {
        String resolvedKey = this.resolveRowKey(key2);
        if (value == null) {
            throw new NullPointerException("The row expression value must not be null.");
        }
        this.rowMapCache.clear();
        return this.rowMap.put(resolvedKey, value.toLowerCase(Locale.ENGLISH));
    }

    public String rowPut(String key2, RowSpec value) {
        return this.rowPut(key2, value.encode());
    }

    public String rowPut(String key2, Size value) {
        return this.rowPut(key2, value.encode());
    }

    public String rowRemove(String key2) {
        String resolvedKey = this.resolveRowKey(key2);
        this.rowMapCache.clear();
        return (String)this.rowMap.remove(resolvedKey);
    }

    public String toString() {
        Map.Entry name2;
        StringBuffer buffer = new StringBuffer(super.toString());
        buffer.append("\n  Column associations:");
        Iterator iterator = this.columnMap.entrySet().iterator();
        while (iterator.hasNext()) {
            name2 = iterator.next();
            buffer.append("\n    ");
            buffer.append(name2.getKey());
            buffer.append("->");
            buffer.append(name2.getValue());
        }
        buffer.append("\n  Row associations:");
        iterator = this.rowMap.entrySet().iterator();
        while (iterator.hasNext()) {
            name2 = iterator.next();
            buffer.append("\n    ");
            buffer.append(name2.getKey());
            buffer.append("->");
            buffer.append(name2.getValue());
        }
        return buffer.toString();
    }

    String expand(String expression, boolean horizontal) {
        String variableName;
        int cursor = 0;
        int start = expression.indexOf(36, cursor);
        if (start == -1) {
            return expression;
        }
        StringBuffer buffer = new StringBuffer();
        do {
            buffer.append(expression.substring(cursor, start));
            variableName = this.nextVariableName(expression, start);
            buffer.append(this.expansion(variableName, horizontal));
        } while ((start = expression.indexOf(36, cursor = start + variableName.length() + 1)) != -1);
        buffer.append(expression.substring(cursor));
        return buffer.toString();
    }

    private String nextVariableName(String expression, int start) {
        int end;
        int length = expression.length();
        if (length <= start) {
            FormSpecParser.fail(expression, start, "Missing variable name after variable char '$'.");
        }
        if (expression.charAt(start + 1) == '{') {
            int end2 = expression.indexOf(125, start + 1);
            if (end2 == -1) {
                FormSpecParser.fail(expression, start, "Missing closing brace '}' for variable.");
            }
            return expression.substring(start + 1, end2 + 1);
        }
        for (end = start + 1; end < length && Character.isUnicodeIdentifierPart(expression.charAt(end)); ++end) {
        }
        return expression.substring(start + 1, end);
    }

    private String expansion(String variableName, boolean horizontal) {
        String expansion;
        String key2 = LayoutMap.stripBraces(variableName);
        String string2 = expansion = horizontal ? this.columnGet(key2) : this.rowGet(key2);
        if (expansion == null) {
            String orientation = horizontal ? "column" : "row";
            throw new IllegalArgumentException("Unknown " + orientation + " layout variable \"" + key2 + "\"");
        }
        return expansion;
    }

    private static String stripBraces(String variableName) {
        return variableName.charAt(0) == '{' ? variableName.substring(1, variableName.length() - 1) : variableName;
    }

    private String resolveColumnKey(String key2) {
        if (key2 == null) {
            throw new NullPointerException("The key must not be null.");
        }
        String lowercaseKey = key2.toLowerCase(Locale.ENGLISH);
        String defaultKey = (String)COLUMN_ALIASES.get(lowercaseKey);
        return defaultKey == null ? lowercaseKey : defaultKey;
    }

    private String resolveRowKey(String key2) {
        if (key2 == null) {
            throw new NullPointerException("The key must not be null.");
        }
        String lowercaseKey = key2.toLowerCase(Locale.ENGLISH);
        String defaultKey = (String)ROW_ALIASES.get(lowercaseKey);
        return defaultKey == null ? lowercaseKey : defaultKey;
    }

    private static LayoutMap createRoot() {
        LayoutMap map2 = new LayoutMap(null);
        map2.columnPut("label-component-gap", new String[]{"lcg", "lcgap"}, FormFactory.LABEL_COMPONENT_GAP_COLSPEC);
        map2.columnPut("related-gap", new String[]{"rg", "rgap"}, FormFactory.RELATED_GAP_COLSPEC);
        map2.columnPut("unrelated-gap", new String[]{"ug", "ugap"}, FormFactory.UNRELATED_GAP_COLSPEC);
        map2.columnPut("button", new String[]{"b"}, FormFactory.BUTTON_COLSPEC);
        map2.columnPut("growing-button", new String[]{"gb"}, FormFactory.GROWING_BUTTON_COLSPEC);
        map2.columnPut("dialog-margin", new String[]{"dm", "dmargin"}, ColumnSpec.createGap(LayoutStyle.getCurrent().getDialogMarginX()));
        map2.columnPut("tabbed-dialog-margin", new String[]{"tdm", "tdmargin"}, ColumnSpec.createGap(LayoutStyle.getCurrent().getTabbedDialogMarginX()));
        map2.columnPut("glue", FormFactory.GLUE_COLSPEC.toShortString());
        map2.rowPut("related-gap", new String[]{"rg", "rgap"}, FormFactory.RELATED_GAP_ROWSPEC);
        map2.rowPut("unrelated-gap", new String[]{"ug", "ugap"}, FormFactory.UNRELATED_GAP_ROWSPEC);
        map2.rowPut("narrow-line-gap", new String[]{"nlg", "nlgap"}, FormFactory.NARROW_LINE_GAP_ROWSPEC);
        map2.rowPut("line-gap", new String[]{"lg", "lgap"}, FormFactory.LINE_GAP_ROWSPEC);
        map2.rowPut("paragraph-gap", new String[]{"pg", "pgap"}, FormFactory.PARAGRAPH_GAP_ROWSPEC);
        map2.rowPut("dialog-margin", new String[]{"dm", "dmargin"}, RowSpec.createGap(LayoutStyle.getCurrent().getDialogMarginY()));
        map2.rowPut("tabbed-dialog-margin", new String[]{"tdm", "tdmargin"}, RowSpec.createGap(LayoutStyle.getCurrent().getTabbedDialogMarginY()));
        map2.rowPut("button", new String[]{"b"}, FormFactory.BUTTON_ROWSPEC);
        map2.rowPut("glue", FormFactory.GLUE_ROWSPEC);
        return map2;
    }

    private void columnPut(String key2, String[] aliases, ColumnSpec value) {
        this.ensureLowerCase(key2);
        this.columnPut(key2, value);
        for (int i = 0; i < aliases.length; ++i) {
            this.ensureLowerCase(aliases[i]);
            COLUMN_ALIASES.put(aliases[i], key2);
        }
    }

    private void rowPut(String key2, String[] aliases, RowSpec value) {
        this.ensureLowerCase(key2);
        this.rowPut(key2, value);
        for (int i = 0; i < aliases.length; ++i) {
            this.ensureLowerCase(aliases[i]);
            ROW_ALIASES.put(aliases[i], key2);
        }
    }

    private void ensureLowerCase(String str2) {
        String lowerCase = str2.toLowerCase(Locale.ENGLISH);
        if (!lowerCase.equals(str2)) {
            throw new IllegalArgumentException("The string \"" + str2 + "\" should be lower case.");
        }
    }
}

