/*
 * Decompiled with CFR 0.152.
 */
package de.uulm.ecs.ai.owlapi.krssparser;

import de.uulm.ecs.ai.owlapi.krssparser.KRSS2OWLParserException;
import de.uulm.ecs.ai.owlapi.krssparser.KRSS2OntologyFormat;
import de.uulm.ecs.ai.owlapi.krssparser.KRSS2Parser;
import de.uulm.ecs.ai.owlapi.krssparser.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.UnloadableImportException;

public class KRSS2OWLParser
extends AbstractOWLParser {
    @Override
    public OWLOntologyFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology) throws OWLParserException, IOException, UnloadableImportException {
        return this.parse(documentSource, ontology, new OWLOntologyLoaderConfiguration());
    }

    @Override
    public OWLOntologyFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) throws OWLParserException, IOException, OWLOntologyChangeException, UnloadableImportException {
        Reader reader2 = null;
        InputStream is2 = null;
        try {
            KRSS2Parser parser;
            KRSS2OntologyFormat format2 = new KRSS2OntologyFormat();
            if (documentSource.isReaderAvailable()) {
                reader2 = documentSource.getReader();
                parser = new KRSS2Parser(reader2);
            } else if (documentSource.isInputStreamAvailable()) {
                is2 = documentSource.getInputStream();
                parser = new KRSS2Parser(is2);
            } else {
                is2 = this.getInputStream(documentSource.getDocumentIRI(), configuration);
                parser = new KRSS2Parser(is2);
            }
            parser.setOntology(ontology, ontology.getOWLOntologyManager().getOWLDataFactory());
            parser.parse();
            KRSS2OntologyFormat kRSS2OntologyFormat = format2;
            return kRSS2OntologyFormat;
        }
        catch (ParseException e2) {
            throw new KRSS2OWLParserException(e2);
        }
        finally {
            if (is2 != null) {
                is2.close();
            } else if (reader2 != null) {
                reader2.close();
            }
        }
    }
}

