/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.validation;

import java.io.File;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactoryFinder;
import javax.xml.validation.SecuritySupport;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public abstract class SchemaFactory {
    private static SecuritySupport ss = new SecuritySupport();

    protected SchemaFactory() {
    }

    public static final SchemaFactory newInstance(String schemaLanguage) {
        SchemaFactory f;
        ClassLoader cl = ss.getContextClassLoader();
        if (cl == null) {
            cl = SchemaFactory.class.getClassLoader();
        }
        if ((f = new SchemaFactoryFinder(cl).newFactory(schemaLanguage)) == null) {
            throw new IllegalArgumentException("No SchemaFactory that implements the schema language specified by: " + schemaLanguage + " could be loaded");
        }
        return f;
    }

    public static SchemaFactory newInstance(String schemaLanguage, String factoryClassName, ClassLoader classLoader) {
        SchemaFactory f;
        ClassLoader cl = classLoader;
        if (cl == null) {
            cl = ss.getContextClassLoader();
        }
        if ((f = new SchemaFactoryFinder(cl).createInstance(factoryClassName)) == null) {
            throw new IllegalArgumentException("Factory " + factoryClassName + " could not be loaded to implement the schema language specified by: " + schemaLanguage);
        }
        if (f.isSchemaLanguageSupported(schemaLanguage)) {
            return f;
        }
        throw new IllegalArgumentException("Factory " + f.getClass().getName() + " does not implement the schema language specified by: " + schemaLanguage);
    }

    public abstract boolean isSchemaLanguageSupported(String var1);

    public boolean getFeature(String name2) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name2 == null) {
            throw new NullPointerException("the name parameter is null");
        }
        throw new SAXNotRecognizedException(name2);
    }

    public void setFeature(String name2, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name2 == null) {
            throw new NullPointerException("the name parameter is null");
        }
        throw new SAXNotRecognizedException(name2);
    }

    public void setProperty(String name2, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name2 == null) {
            throw new NullPointerException("the name parameter is null");
        }
        throw new SAXNotRecognizedException(name2);
    }

    public Object getProperty(String name2) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name2 == null) {
            throw new NullPointerException("the name parameter is null");
        }
        throw new SAXNotRecognizedException(name2);
    }

    public abstract void setErrorHandler(ErrorHandler var1);

    public abstract ErrorHandler getErrorHandler();

    public abstract void setResourceResolver(LSResourceResolver var1);

    public abstract LSResourceResolver getResourceResolver();

    public Schema newSchema(Source schema) throws SAXException {
        return this.newSchema(new Source[]{schema});
    }

    public Schema newSchema(File schema) throws SAXException {
        return this.newSchema(new StreamSource(schema));
    }

    public Schema newSchema(URL schema) throws SAXException {
        return this.newSchema(new StreamSource(schema.toExternalForm()));
    }

    public abstract Schema newSchema(Source[] var1) throws SAXException;

    public abstract Schema newSchema() throws SAXException;
}

