/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import org.apache.axiom.attachments.BoundaryDelimitedStream;
import org.apache.axiom.attachments.IncomingAttachmentInputStream;
import org.apache.axiom.attachments.IncomingAttachmentStreams;
import org.apache.axiom.om.OMException;

public final class MultipartAttachmentStreams
extends IncomingAttachmentStreams {
    private BoundaryDelimitedStream _delimitedStream = null;

    public MultipartAttachmentStreams(BoundaryDelimitedStream delimitedStream) throws OMException {
        this._delimitedStream = delimitedStream;
    }

    public IncomingAttachmentInputStream getNextStream() throws OMException {
        InternetHeaders headers;
        if (!this.isReadyToGetNextStream()) {
            throw new IllegalStateException("nextStreamNotReady");
        }
        try {
            this._delimitedStream = this._delimitedStream.getNextStream();
            if (this._delimitedStream == null) {
                return null;
            }
            headers = new InternetHeaders((InputStream)this._delimitedStream);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new OMException(ioe);
        }
        catch (MessagingException me) {
            me.printStackTrace();
            throw new OMException(me);
        }
        IncomingAttachmentInputStream stream = new IncomingAttachmentInputStream(this._delimitedStream, this);
        Enumeration e2 = headers.getAllHeaders();
        while (e2 != null && e2.hasMoreElements()) {
            Header header = (Header)e2.nextElement();
            String name2 = header.getName();
            String value = header.getValue();
            if ("content-id".equals(name2) || "content-type".equals(name2) || "content-location".equals(name2)) {
                value = value.trim();
            }
            stream.addHeader(name2, value);
        }
        this.setReadyToGetNextStream(false);
        return stream;
    }
}

