/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments.lifecycle.impl;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import org.apache.axiom.attachments.lifecycle.LifecycleManager;
import org.apache.axiom.attachments.lifecycle.impl.FileAccessor;
import org.apache.axiom.attachments.lifecycle.impl.VMShutdownHook;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LifecycleManagerImpl
implements LifecycleManager {
    private static final Log log = LogFactory.getLog(class$org$apache$axiom$attachments$lifecycle$impl$LifecycleManagerImpl == null ? (class$org$apache$axiom$attachments$lifecycle$impl$LifecycleManagerImpl = LifecycleManagerImpl.class$("org.apache.axiom.attachments.lifecycle.impl.LifecycleManagerImpl")) : class$org$apache$axiom$attachments$lifecycle$impl$LifecycleManagerImpl);
    private static Hashtable table = new Hashtable();
    private VMShutdownHook hook = null;
    static /* synthetic */ Class class$org$apache$axiom$attachments$lifecycle$impl$LifecycleManagerImpl;

    public FileAccessor create(String attachmentDir) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Start Create()");
        }
        File file2 = null;
        File dir2 = null;
        if (attachmentDir != null && !(dir2 = new File(attachmentDir)).exists()) {
            dir2.mkdirs();
        }
        if (!dir2.isDirectory()) {
            throw new IllegalArgumentException("Given Axis2 Attachment File Cache Location " + dir2 + "  should be a directory.");
        }
        String id2 = UUIDGenerator.getUUID();
        id2 = id2.replaceAll(":", "_");
        String fileString = "Axis2" + id2 + ".att";
        file2 = new File(dir2, fileString);
        FileAccessor fa = new FileAccessor(this, file2);
        table.put(fileString, fa);
        this.deleteOnExit(file2);
        if (log.isDebugEnabled()) {
            log.debug("End Create()");
        }
        return fa;
    }

    public void delete(File file2) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Start delete()");
        }
        if (file2 != null && file2.exists()) {
            table.remove(file2);
            if (log.isDebugEnabled()) {
                log.debug("invoking file.delete()");
            }
            if (file2.delete()) {
                if (log.isDebugEnabled()) {
                    log.debug("delete() successful");
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Cannot delete file, set to delete on VM shutdown");
                }
                this.deleteOnExit(file2);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("End delete()");
        }
    }

    public void deleteOnExit(File file2) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Start deleteOnExit()");
        }
        if (this.hook == null) {
            this.hook = this.RegisterVMShutdownHook();
        }
        if (file2 != null) {
            if (log.isDebugEnabled()) {
                log.debug("Invoking deleteOnExit() for file = " + file2.getAbsolutePath());
            }
            this.hook.add(file2);
            table.remove(file2);
        }
        if (log.isDebugEnabled()) {
            log.debug("End deleteOnExit()");
        }
    }

    public void deleteOnTimeInterval(int interval, File file2) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Start deleteOnTimeInterval()");
        }
        Thread t = new Thread(new FileDeletor(interval, file2));
        t.setDaemon(true);
        t.start();
        if (log.isDebugEnabled()) {
            log.debug("End deleteOnTimeInterval()");
        }
    }

    private VMShutdownHook RegisterVMShutdownHook() throws RuntimeException {
        if (log.isDebugEnabled()) {
            log.debug("Start RegisterVMShutdownHook()");
        }
        try {
            this.hook = (VMShutdownHook)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws SecurityException, IllegalStateException, IllegalArgumentException {
                    VMShutdownHook hook = VMShutdownHook.hook();
                    if (!hook.isRegistered()) {
                        Runtime.getRuntime().addShutdownHook(hook);
                        hook.setRegistered(true);
                    }
                    return hook;
                }
            });
        }
        catch (PrivilegedActionException e2) {
            if (log.isDebugEnabled()) {
                log.debug("Exception thrown from AccessController: " + e2);
                log.debug("VM Shutdown Hook not registered.");
            }
            throw new RuntimeException(e2);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit RegisterVMShutdownHook()");
        }
        return this.hook;
    }

    public FileAccessor getFileAccessor(String fileName) throws IOException {
        return (FileAccessor)table.get(fileName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class FileDeletor
    implements Runnable {
        int interval;
        File _file;

        public FileDeletor(int interval, File file2) {
            this.interval = interval;
            this._file = file2;
        }

        public void run() {
            block3: {
                try {
                    Thread.sleep(this.interval * 1000);
                    if (this._file.exists()) {
                        table.remove(this._file);
                        this._file.delete();
                    }
                }
                catch (InterruptedException e2) {
                    if (!log.isDebugEnabled()) break block3;
                    log.warn("InterruptedException occured " + e2.getMessage());
                }
            }
        }
    }
}

