/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.c14n.helpers;

import org.apache.axiom.c14n.exceptions.CanonicalizationException;
import org.apache.axiom.c14n.omwrapper.interfaces.Attr;
import org.apache.axiom.c14n.omwrapper.interfaces.Element;
import org.apache.axiom.c14n.omwrapper.interfaces.NamedNodeMap;

public class C14nHelper {
    private C14nHelper() {
    }

    public static boolean namespaceIsRelative(Attr namespace2) {
        return !C14nHelper.namespaceIsAbsolute(namespace2);
    }

    public static boolean namespaceIsRelative(String namespaceValue) {
        return !C14nHelper.namespaceIsAbsolute(namespaceValue);
    }

    public static boolean namespaceIsAbsolute(Attr namespace2) {
        return C14nHelper.namespaceIsAbsolute(namespace2.getValue());
    }

    public static boolean namespaceIsAbsolute(String namespaceValue) {
        if (namespaceValue.length() == 0) {
            return true;
        }
        return namespaceValue.indexOf(58) > 0;
    }

    public static void assertNotRelativeNS(Attr attr) throws CanonicalizationException {
        if (attr == null) {
            return;
        }
        String nodeAttrName = attr.getNodeName();
        boolean definesDefaultNS = nodeAttrName.equals("xmlns");
        boolean definesNonDefaultNS = nodeAttrName.startsWith("xmlns:");
        if ((definesDefaultNS || definesNonDefaultNS) && C14nHelper.namespaceIsRelative(attr)) {
            String parentName = attr.getOwnerElement().getTagName();
            String attrValue = attr.getValue();
            Object[] exArgs = new Object[]{parentName, nodeAttrName, attrValue};
            throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", exArgs);
        }
    }

    public static void checkForRelativeNamespace(Element ctxNode) throws CanonicalizationException {
        if (ctxNode != null) {
            NamedNodeMap attributes = ctxNode.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                C14nHelper.assertNotRelativeNS((Attr)attributes.item(i));
            }
        } else {
            throw new CanonicalizationException("Called checkForRelativeNamespace() on null");
        }
    }
}

