/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.c14n.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.axiom.c14n.CanonicalizerSpi;
import org.apache.axiom.c14n.exceptions.CanonicalizationException;
import org.apache.axiom.c14n.helpers.AttrCompare;
import org.apache.axiom.c14n.impl.NameSpaceSymbTable;
import org.apache.axiom.c14n.impl.UtfHelper;
import org.apache.axiom.c14n.omwrapper.AttrImpl;
import org.apache.axiom.c14n.omwrapper.interfaces.Attr;
import org.apache.axiom.c14n.omwrapper.interfaces.Comment;
import org.apache.axiom.c14n.omwrapper.interfaces.Element;
import org.apache.axiom.c14n.omwrapper.interfaces.NamedNodeMap;
import org.apache.axiom.c14n.omwrapper.interfaces.Node;
import org.apache.axiom.c14n.omwrapper.interfaces.ProcessingInstruction;
import org.apache.axiom.c14n.utils.UnsyncByteArrayOutputStream;
import org.apache.axiom.om.OMAbstractFactory;

public abstract class CanonicalizerBase
extends CanonicalizerSpi {
    private static final byte[] _END_PI = new byte[]{63, 62};
    private static final byte[] _BEGIN_PI = new byte[]{60, 63};
    private static final byte[] _END_COMM = new byte[]{45, 45, 62};
    private static final byte[] _BEGIN_COMM = new byte[]{60, 33, 45, 45};
    private static final byte[] __XA_ = new byte[]{38, 35, 120, 65, 59};
    private static final byte[] __X9_ = new byte[]{38, 35, 120, 57, 59};
    private static final byte[] _QUOT_ = new byte[]{38, 113, 117, 111, 116, 59};
    private static final byte[] __XD_ = new byte[]{38, 35, 120, 68, 59};
    private static final byte[] _GT_ = new byte[]{38, 103, 116, 59};
    private static final byte[] _LT_ = new byte[]{38, 108, 116, 59};
    private static final byte[] _END_TAG = new byte[]{60, 47};
    private static final byte[] _AMP_ = new byte[]{38, 97, 109, 112, 59};
    static final AttrCompare COMPARE = new AttrCompare();
    static final String XML = "xml";
    static final String XMLNS = "xmlns";
    static final byte[] equalsStr = new byte[]{61, 34};
    static final int NODE_BEFORE_DOCUMENT_ELEMENT = -1;
    static final int NODE_NOT_BEFORE_OR_AFTER_DOCUMENT_ELEMENT = 0;
    static final int NODE_AFTER_DOCUMENT_ELEMENT = 1;
    protected static final Attr nullNode;
    List nodeFilter;
    boolean _includeComments;
    Node _excludeNode = null;
    OutputStream _writer = new UnsyncByteArrayOutputStream();

    public CanonicalizerBase(boolean includeComments) {
        this._includeComments = includeComments;
    }

    public byte[] engineCanonicalizeSubTree(Node rootNode) throws CanonicalizationException {
        return this.engineCanonicalizeSubTree(rootNode, (Node)null);
    }

    public void setWriter(OutputStream _writer) {
        this._writer = _writer;
    }

    byte[] engineCanonicalizeSubTree(Node rootNode, Node excludeNode) throws CanonicalizationException {
        this._excludeNode = excludeNode;
        try {
            NameSpaceSymbTable ns2 = new NameSpaceSymbTable();
            int nodeLevel = -1;
            if (rootNode instanceof Element) {
                this.getParentNameSpaces((Element)rootNode, ns2);
                nodeLevel = 0;
            }
            this.canonicalizeSubTree(rootNode, ns2, rootNode, nodeLevel);
            this._writer.close();
            if (this._writer instanceof ByteArrayOutputStream) {
                byte[] result = ((ByteArrayOutputStream)this._writer).toByteArray();
                if (this.reset) {
                    ((ByteArrayOutputStream)this._writer).reset();
                }
                return result;
            }
            if (this._writer instanceof UnsyncByteArrayOutputStream) {
                byte[] result = ((UnsyncByteArrayOutputStream)this._writer).toByteArray();
                if (this.reset) {
                    ((UnsyncByteArrayOutputStream)this._writer).reset();
                }
                return result;
            }
            return null;
        }
        catch (UnsupportedEncodingException ex) {
            throw new CanonicalizationException("empty", ex);
        }
        catch (IOException ex) {
            throw new CanonicalizationException("empty", ex);
        }
    }

    final void canonicalizeSubTree(Node currentNode, NameSpaceSymbTable ns2, Node endnode, int documentLevel) throws CanonicalizationException, IOException {
        Node sibling = null;
        Node parentNode = null;
        OutputStream writer2 = this._writer;
        Node excludeNode = this._excludeNode;
        boolean includeComments = this._includeComments;
        HashMap cache = new HashMap();
        while (true) {
            switch (currentNode.getNodeType()) {
                default: {
                    break;
                }
                case 2: 
                case 6: 
                case 12: {
                    throw new CanonicalizationException("empty");
                }
                case 9: 
                case 11: {
                    ns2.outputNodePush();
                    sibling = currentNode.getFirstChild();
                    break;
                }
                case 8: {
                    if (!includeComments) break;
                    CanonicalizerBase.outputCommentToWriter((Comment)currentNode, writer2, documentLevel);
                    break;
                }
                case 7: {
                    CanonicalizerBase.outputPItoWriter((ProcessingInstruction)currentNode, writer2, documentLevel);
                    break;
                }
                case 3: {
                    CanonicalizerBase.outputTextToWriter(currentNode.getNodeValue(), writer2);
                    break;
                }
                case 1: 
                case 4: {
                    documentLevel = 0;
                    if (currentNode == excludeNode) break;
                    Element currentElement = (Element)currentNode;
                    ns2.outputNodePush();
                    writer2.write(60);
                    String name2 = currentElement.getTagName();
                    UtfHelper.writeByte(name2, writer2, cache);
                    Iterator attrs = this.handleAttributesSubtree(currentElement, ns2);
                    if (attrs != null) {
                        while (attrs.hasNext()) {
                            Attr attr = (Attr)attrs.next();
                            CanonicalizerBase.outputAttrToWriter(attr.getNodeName(), attr.getNodeValue(), writer2, cache);
                        }
                    }
                    writer2.write(62);
                    sibling = currentNode.getFirstChild();
                    if (sibling == null) {
                        writer2.write(_END_TAG);
                        UtfHelper.writeStringToUtf8(name2, writer2);
                        writer2.write(62);
                        ns2.outputNodePop();
                        if (parentNode == null) break;
                        sibling = currentNode.getNextSibling();
                        break;
                    }
                    parentNode = currentElement;
                }
            }
            while (sibling == null && parentNode != null) {
                writer2.write(_END_TAG);
                UtfHelper.writeByte(((Element)parentNode).getTagName(), writer2, cache);
                writer2.write(62);
                ns2.outputNodePop();
                if (parentNode == endnode) {
                    return;
                }
                sibling = parentNode.getNextSibling();
                if ((parentNode = parentNode.getParentNode()) instanceof Element) continue;
                documentLevel = 1;
                parentNode = null;
            }
            if (sibling == null) {
                return;
            }
            currentNode = sibling;
            sibling = currentNode.getNextSibling();
        }
    }

    void handleParent(Element e2, NameSpaceSymbTable ns2) {
        if (!e2.hasAttributes()) {
            return;
        }
        NamedNodeMap attrs = e2.getAttributes();
        int attrsLength = attrs.getLength();
        for (int i = 0; i < attrsLength; ++i) {
            Attr N = (Attr)attrs.item(i);
            if ("http://www.w3.org/2000/xmlns/" != N.getNamespaceURI()) continue;
            String NName = N.getLocalName();
            String NValue = N.getNodeValue();
            if (XML.equals(NName) && "http://www.w3.org/XML/1998/namespace".equals(NValue)) continue;
            ns2.addMapping(NName, NValue, N);
        }
    }

    final void getParentNameSpaces(Element el, NameSpaceSymbTable ns2) {
        ArrayList<Element> parents2 = new ArrayList<Element>(10);
        Node n1 = el.getParentNode();
        if (!(n1 instanceof Element)) {
            return;
        }
        Element parent = (Element)n1;
        while (parent != null) {
            parents2.add(parent);
            Node n = parent.getParentNode();
            if (!(n instanceof Element)) break;
            parent = (Element)n;
        }
        ListIterator it = parents2.listIterator(parents2.size());
        while (it.hasPrevious()) {
            Element ele = (Element)it.previous();
            this.handleParent(ele, ns2);
        }
        Attr nsprefix = ns2.getMappingWithoutRendered(XMLNS);
        if (nsprefix != null && "".equals(nsprefix.getValue())) {
            ns2.addMappingAndRender(XMLNS, "", nullNode);
        }
    }

    abstract Iterator handleAttributesSubtree(Element var1, NameSpaceSymbTable var2) throws CanonicalizationException;

    static final void outputAttrToWriter(String name2, String value, OutputStream writer2, Map cache) throws IOException {
        writer2.write(32);
        UtfHelper.writeByte(name2, writer2, cache);
        writer2.write(equalsStr);
        int length = value.length();
        int i = 0;
        block8: while (i < length) {
            byte[] toWrite;
            char c = value.charAt(i++);
            switch (c) {
                case '&': {
                    toWrite = _AMP_;
                    break;
                }
                case '<': {
                    toWrite = _LT_;
                    break;
                }
                case '\"': {
                    toWrite = _QUOT_;
                    break;
                }
                case '\t': {
                    toWrite = __X9_;
                    break;
                }
                case '\n': {
                    toWrite = __XA_;
                    break;
                }
                case '\r': {
                    toWrite = __XD_;
                    break;
                }
                default: {
                    if (c < '\u0080') {
                        writer2.write(c);
                        continue block8;
                    }
                    UtfHelper.writeCharToUtf8(c, writer2);
                    continue block8;
                }
            }
            writer2.write(toWrite);
        }
        writer2.write(34);
    }

    static final void outputPItoWriter(ProcessingInstruction currentPI, OutputStream writer2, int position) throws IOException {
        if (position == 1) {
            writer2.write(10);
        }
        writer2.write(_BEGIN_PI);
        String target = currentPI.getTarget();
        int length = target.length();
        for (int i = 0; i < length; ++i) {
            char c = target.charAt(i);
            if (c == '\r') {
                writer2.write(__XD_);
                continue;
            }
            if (c < '\u0080') {
                writer2.write(c);
                continue;
            }
            UtfHelper.writeCharToUtf8(c, writer2);
        }
        String data2 = currentPI.getData();
        length = data2.length();
        if (length > 0) {
            writer2.write(32);
            for (int i = 0; i < length; ++i) {
                char c = data2.charAt(i);
                if (c == '\r') {
                    writer2.write(__XD_);
                    continue;
                }
                UtfHelper.writeCharToUtf8(c, writer2);
            }
        }
        writer2.write(_END_PI);
        if (position == -1) {
            writer2.write(10);
        }
    }

    static final void outputCommentToWriter(Comment currentComment, OutputStream writer2, int position) throws IOException {
        if (position == 1) {
            writer2.write(10);
        }
        writer2.write(_BEGIN_COMM);
        String data2 = currentComment.getData();
        int length = data2.length();
        for (int i = 0; i < length; ++i) {
            char c = data2.charAt(i);
            if (c == '\r') {
                writer2.write(__XD_);
                continue;
            }
            if (c < '\u0080') {
                writer2.write(c);
                continue;
            }
            UtfHelper.writeCharToUtf8(c, writer2);
        }
        writer2.write(_END_COMM);
        if (position == -1) {
            writer2.write(10);
        }
    }

    static final void outputTextToWriter(String text, OutputStream writer2) throws IOException {
        int length = text.length();
        block6: for (int i = 0; i < length; ++i) {
            byte[] toWrite;
            char c = text.charAt(i);
            switch (c) {
                case '&': {
                    toWrite = _AMP_;
                    break;
                }
                case '<': {
                    toWrite = _LT_;
                    break;
                }
                case '>': {
                    toWrite = _GT_;
                    break;
                }
                case '\r': {
                    toWrite = __XD_;
                    break;
                }
                default: {
                    if (c < '\u0080') {
                        writer2.write(c);
                        continue block6;
                    }
                    UtfHelper.writeCharToUtf8(c, writer2);
                    continue block6;
                }
            }
            writer2.write(toWrite);
        }
    }

    static {
        try {
            nullNode = new AttrImpl(OMAbstractFactory.getOMFactory().createOMNamespace("", ""), null, null);
        }
        catch (Exception e2) {
            throw new RuntimeException("Unable to create nullNode" + e2);
        }
    }
}

