/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.c14n.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.axiom.c14n.impl.NameSpaceSymbEntry;

class SymbMap
implements Cloneable {
    int free = 23;
    NameSpaceSymbEntry[] entries = new NameSpaceSymbEntry[this.free];
    String[] keys = new String[this.free];

    SymbMap() {
    }

    void put(String key2, NameSpaceSymbEntry value) {
        int index2 = this.index(key2);
        String oldKey = this.keys[index2];
        this.keys[index2] = key2;
        this.entries[index2] = value;
        if (!(oldKey != null && oldKey.equals(key2) || --this.free != 0)) {
            this.free = this.entries.length;
            int newCapacity = this.free << 2;
            this.rehash(newCapacity);
        }
    }

    List entrySet() {
        ArrayList<NameSpaceSymbEntry> a = new ArrayList<NameSpaceSymbEntry>();
        for (int i = 0; i < this.entries.length; ++i) {
            if (this.entries[i] == null || "".equals(this.entries[i].uri)) continue;
            a.add(this.entries[i]);
        }
        return a;
    }

    protected int index(Object obj) {
        String[] set2 = this.keys;
        int length = set2.length;
        int index2 = (obj.hashCode() & Integer.MAX_VALUE) % length;
        String cur = set2[index2];
        if (cur == null || cur.equals(obj)) {
            return index2;
        }
        --length;
        while ((cur = set2[index2 = index2 == length ? 0 : ++index2]) != null && !cur.equals(obj)) {
        }
        return index2;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.keys.length;
        String[] oldKeys = this.keys;
        NameSpaceSymbEntry[] oldVals = this.entries;
        this.keys = new String[newCapacity];
        this.entries = new NameSpaceSymbEntry[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldKeys[i] == null) continue;
            String o = oldKeys[i];
            int index2 = this.index(o);
            this.keys[index2] = o;
            this.entries[index2] = oldVals[i];
        }
    }

    NameSpaceSymbEntry get(String key2) {
        return this.entries[this.index(key2)];
    }

    protected Object clone() {
        try {
            SymbMap copy2 = (SymbMap)super.clone();
            copy2.entries = new NameSpaceSymbEntry[this.entries.length];
            System.arraycopy(this.entries, 0, copy2.entries, 0, this.entries.length);
            copy2.keys = new String[this.keys.length];
            System.arraycopy(this.keys, 0, copy2.keys, 0, this.keys.length);
            return copy2;
        }
        catch (CloneNotSupportedException e2) {
            e2.printStackTrace();
            return null;
        }
    }
}

