/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.ds;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.ds.OMDataSourceExtBase;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;

public class InputStreamDataSource
extends OMDataSourceExtBase {
    Data data = new Data();
    private static final int BUFFER_LEN = 4096;

    public InputStreamDataSource(InputStream is2, String encoding2) {
        this.data.is = is2;
        this.data.encoding = encoding2;
    }

    public void serialize(OutputStream output, OMOutputFormat format2) throws XMLStreamException {
        if (this.data == null) {
            throw new OMException("The InputStreamDataSource does not have a backing object");
        }
        String encoding2 = format2.getCharSetEncoding();
        try {
            if (!this.data.encoding.equalsIgnoreCase(encoding2)) {
                byte[] bytes2 = this.getXMLBytes(encoding2);
                output.write(bytes2);
            } else {
                InputStreamDataSource.inputStream2OutputStream(this.data.is, output);
            }
        }
        catch (UnsupportedEncodingException e2) {
            throw new XMLStreamException(e2);
        }
        catch (IOException e3) {
            throw new XMLStreamException(e3);
        }
    }

    public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (this.data == null) {
            throw new OMException("The InputStreamDataSource does not have a backing object");
        }
        super.serialize(xmlWriter);
    }

    public XMLStreamReader getReader() throws XMLStreamException {
        if (this.data == null) {
            throw new OMException("The InputStreamDataSource does not have a backing object");
        }
        return StAXUtils.createXMLStreamReader(this.data.is, this.data.encoding);
    }

    public InputStream getXMLInputStream(String encoding2) throws UnsupportedEncodingException {
        if (this.data == null) {
            throw new OMException("The InputStreamDataSource does not have a backing object");
        }
        return this.data.is;
    }

    public Object getObject() {
        return this.data;
    }

    public boolean isDestructiveRead() {
        if (this.data == null) {
            throw new OMException("The InputStreamDataSource does not have a backing object");
        }
        return true;
    }

    public boolean isDestructiveWrite() {
        if (this.data == null) {
            throw new OMException("The InputStreamDataSource does not have a backing object");
        }
        return true;
    }

    public byte[] getXMLBytes(String encoding2) throws UnsupportedEncodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OMOutputFormat format2 = new OMOutputFormat();
        format2.setCharSetEncoding(encoding2);
        try {
            this.serialize(baos, format2);
        }
        catch (XMLStreamException e2) {
            throw new OMException(e2);
        }
        return baos.toByteArray();
    }

    public void close() {
        if (this.data.is != null) {
            try {
                this.data.is.close();
            }
            catch (IOException e2) {
                throw new OMException(e2);
            }
            this.data.is = null;
        }
    }

    public OMDataSourceExt copy() {
        byte[] bytes2;
        try {
            bytes2 = this.getXMLBytes(this.data.encoding);
        }
        catch (UnsupportedEncodingException e2) {
            throw new OMException(e2);
        }
        ByteArrayInputStream is1 = new ByteArrayInputStream(bytes2);
        ByteArrayInputStream is2 = new ByteArrayInputStream(bytes2);
        this.data.is = is1;
        return new InputStreamDataSource(is2, this.data.encoding);
    }

    private static void inputStream2OutputStream(InputStream is2, OutputStream os) throws IOException {
        byte[] buffer = new byte[4096];
        int bytesRead = is2.read(buffer);
        while (bytesRead > 0) {
            os.write(buffer, 0, bytesRead);
            bytesRead = is2.read(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reader2writer(XMLStreamReader reader2, XMLStreamWriter writer2) throws XMLStreamException {
        StAXOMBuilder builder = new StAXOMBuilder(reader2);
        builder.releaseParserOnClose(true);
        try {
            OMDocument omDocument = builder.getDocument();
            Iterator it = omDocument.getChildren();
            while (it.hasNext()) {
                OMNode omNode = (OMNode)it.next();
                omNode.serializeAndConsume(writer2);
            }
        }
        finally {
            builder.close();
        }
    }

    public class Data {
        public String encoding;
        public InputStream is;
    }
}

