/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.ds;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class OMDataSourceExtBase
implements OMDataSourceExt {
    private static final Log log = LogFactory.getLog(class$org$apache$axiom$om$ds$OMDataSourceExtBase == null ? (class$org$apache$axiom$om$ds$OMDataSourceExtBase = OMDataSourceExtBase.class$("org.apache.axiom.om.ds.OMDataSourceExtBase")) : class$org$apache$axiom$om$ds$OMDataSourceExtBase);
    private static boolean DEBUG_ENABLED = log.isDebugEnabled();
    HashMap map = null;
    static /* synthetic */ Class class$org$apache$axiom$om$ds$OMDataSourceExtBase;

    public Object getProperty(String key2) {
        if (this.map == null) {
            return null;
        }
        return this.map.get(key2);
    }

    public Object setProperty(String key2, Object value) {
        if (this.map == null) {
            this.map = new HashMap();
        }
        return this.map.put(key2, value);
    }

    public boolean hasProperty(String key2) {
        if (this.map == null) {
            return false;
        }
        return this.map.containsKey(key2);
    }

    public InputStream getXMLInputStream(String encoding2) throws UnsupportedEncodingException {
        if (DEBUG_ENABLED) {
            log.debug("getXMLInputStream encoding=" + encoding2);
        }
        return new ByteArrayInputStream(this.getXMLBytes(encoding2));
    }

    public void serialize(OutputStream output, OMOutputFormat format2) throws XMLStreamException {
        if (DEBUG_ENABLED) {
            log.debug("serialize output=" + output + " format=" + format2);
        }
        try {
            output.write(this.getXMLBytes(format2.getCharSetEncoding()));
        }
        catch (IOException e2) {
            throw new XMLStreamException(e2);
        }
    }

    public void serialize(Writer writer2, OMOutputFormat format2) throws XMLStreamException {
        if (DEBUG_ENABLED) {
            log.debug("serialize writer=" + writer2 + " format=" + format2);
        }
        try {
            String text = new String(this.getXMLBytes(format2.getCharSetEncoding()));
            writer2.write(text);
        }
        catch (UnsupportedEncodingException e2) {
            throw new XMLStreamException(e2);
        }
        catch (IOException e3) {
            throw new XMLStreamException(e3);
        }
    }

    public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        OutputStream os;
        if (DEBUG_ENABLED) {
            log.debug("serialize xmlWriter=" + xmlWriter);
        }
        if ((os = OMDataSourceExtBase.getOutputStream(xmlWriter)) != null) {
            if (DEBUG_ENABLED) {
                log.debug("serialize OutputStream optimisation: true");
            }
            String encoding2 = OMDataSourceExtBase.getCharacterEncoding(xmlWriter);
            OMOutputFormat format2 = new OMOutputFormat();
            format2.setCharSetEncoding(encoding2);
            this.serialize(os, format2);
        } else {
            if (DEBUG_ENABLED) {
                log.debug("serialize OutputStream optimisation: false");
            }
            XMLStreamReader xmlReader = this.getReader();
            OMDataSourceExtBase.reader2writer(xmlReader, xmlWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reader2writer(XMLStreamReader reader2, XMLStreamWriter writer2) throws XMLStreamException {
        StAXOMBuilder builder = new StAXOMBuilder(reader2);
        builder.releaseParserOnClose(true);
        try {
            OMDocument omDocument = builder.getDocument();
            Iterator it = omDocument.getChildren();
            while (it.hasNext()) {
                OMNode omNode = (OMNode)it.next();
                omNode.serializeAndConsume(writer2);
            }
        }
        finally {
            builder.close();
        }
    }

    private static OutputStream getOutputStream(XMLStreamWriter writer2) throws XMLStreamException {
        if (writer2 instanceof MTOMXMLStreamWriter) {
            return ((MTOMXMLStreamWriter)writer2).getOutputStream();
        }
        return null;
    }

    private static String getCharacterEncoding(XMLStreamWriter writer2) {
        if (writer2 instanceof MTOMXMLStreamWriter) {
            return ((MTOMXMLStreamWriter)writer2).getCharSetEncoding();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

