/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.ds.custombuilder;

import java.io.ByteArrayOutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.ds.ByteArrayDataSource;
import org.apache.axiom.om.impl.builder.CustomBuilder;
import org.apache.axiom.om.impl.serialize.StreamingOMSerializer;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;

public class ByteArrayCustomBuilder
implements CustomBuilder {
    private String encoding = null;

    public ByteArrayCustomBuilder(String encoding2) {
        this.encoding = encoding2 == null ? "utf-8" : encoding2;
    }

    public OMElement create(String namespace2, String localPart, OMContainer parent, XMLStreamReader reader2, OMFactory factory) throws OMException {
        try {
            String prefix = reader2.getPrefix();
            StreamingOMSerializer ser = new StreamingOMSerializer();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLStreamWriter writer2 = StAXUtils.createXMLStreamWriter(baos, this.encoding);
            ser.serialize(reader2, writer2, false);
            writer2.flush();
            byte[] bytes2 = baos.toByteArray();
            String text = new String(bytes2, "utf-8");
            ByteArrayDataSource ds = new ByteArrayDataSource(bytes2, this.encoding);
            OMNamespace ns2 = factory.createOMNamespace(namespace2, prefix);
            OMSourcedElement om = null;
            om = parent instanceof SOAPHeader && factory instanceof SOAPFactory ? ((SOAPFactory)factory).createSOAPHeaderBlock(localPart, ns2, ds) : factory.createOMElement(ds, localPart, ns2);
            parent.addChild(om);
            return om;
        }
        catch (XMLStreamException e2) {
            throw new OMException(e2);
        }
        catch (OMException e3) {
            throw e3;
        }
        catch (Throwable t) {
            throw new OMException(t);
        }
    }
}

