/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.builder;

import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.OMContainerEx;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.builder.XOPBuilder;
import org.apache.axiom.om.util.ElementHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XOPAwareStAXOMBuilder
extends StAXOMBuilder
implements XOPBuilder {
    private static final Log log = LogFactory.getLog(class$org$apache$axiom$om$impl$builder$XOPAwareStAXOMBuilder == null ? (class$org$apache$axiom$om$impl$builder$XOPAwareStAXOMBuilder = XOPAwareStAXOMBuilder.class$("org.apache.axiom.om.impl.builder.XOPAwareStAXOMBuilder")) : class$org$apache$axiom$om$impl$builder$XOPAwareStAXOMBuilder);
    Attachments attachments;
    static /* synthetic */ Class class$org$apache$axiom$om$impl$builder$XOPAwareStAXOMBuilder;

    public XOPAwareStAXOMBuilder(OMFactory ombuilderFactory, XMLStreamReader parser, Attachments attachments) {
        super(ombuilderFactory, parser);
        this.attachments = attachments;
    }

    public XOPAwareStAXOMBuilder(OMFactory factory, XMLStreamReader parser, OMElement element, Attachments attachments) {
        super(factory, parser, element);
        this.attachments = attachments;
    }

    public XOPAwareStAXOMBuilder(String filePath, Attachments attachments) throws XMLStreamException, FileNotFoundException {
        super(filePath);
        this.attachments = attachments;
    }

    public XOPAwareStAXOMBuilder(InputStream inStream, Attachments attachments) throws XMLStreamException {
        super(inStream);
        this.attachments = attachments;
    }

    public XOPAwareStAXOMBuilder(XMLStreamReader parser, Attachments attachments) {
        super(parser);
        this.attachments = attachments;
    }

    protected OMNode createOMElement() throws OMException {
        String elementName = this.parser.getLocalName();
        String namespaceURI = this.parser.getNamespaceURI();
        if ("Include".equals(elementName) && "http://www.w3.org/2004/08/xop/include".equals(namespaceURI)) {
            OMText node2;
            String contentID = ElementHelper.getContentID(this.parser);
            if (log.isDebugEnabled()) {
                log.debug("Encountered xop:include for cid:" + contentID);
            }
            if (this.lastNode == null) {
                throw new OMException("XOP:Include element is not supported here");
            }
            if (this.lastNode.isComplete() & this.lastNode.getParent() != null) {
                node2 = this.omfactory.createOMText(contentID, (OMElement)this.lastNode.getParent(), this);
                if (log.isDebugEnabled()) {
                    log.debug("Create createOMText for cid:" + contentID);
                    Object dh = node2.getDataHandler();
                    String dhClass = dh == null ? "null" : dh.getClass().toString();
                    log.debug("The datahandler is " + dhClass);
                }
                ((OMNodeEx)this.lastNode).setNextOMSibling(node2);
                ((OMNodeEx)((Object)node2)).setPreviousOMSibling(this.lastNode);
            } else {
                OMContainerEx e2 = (OMContainerEx)((Object)this.lastNode);
                node2 = this.omfactory.createOMText(contentID, (OMElement)this.lastNode, this);
                e2.setFirstChild(node2);
            }
            return node2;
        }
        return super.createOMElement();
    }

    public DataHandler getDataHandler(String blobContentID) throws OMException {
        return this.attachments.getDataHandler(blobContentID);
    }

    public Attachments getAttachments() {
        return this.attachments;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

