/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.dom.ChildNode;
import org.apache.axiom.om.impl.dom.DOMMessageFormatter;
import org.apache.axiom.om.impl.dom.DocumentImpl;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;

public abstract class CharacterImpl
extends ChildNode
implements CharacterData {
    protected StringBuffer textValue;

    protected CharacterImpl(OMFactory factory) {
        super(factory);
    }

    public CharacterImpl(DocumentImpl ownerNode, OMFactory factory) {
        super(ownerNode, factory);
    }

    public CharacterImpl(DocumentImpl ownerNode, String value, OMFactory factory) {
        super(ownerNode, factory);
        this.textValue = value != null ? new StringBuffer(value) : new StringBuffer("");
    }

    public void appendData(String value) throws DOMException {
        if (this.isReadonly()) {
            throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
        }
        this.textValue.append(value);
    }

    public void deleteData(int offset, int count2) throws DOMException {
        this.replaceData(offset, count2, null);
    }

    public void replaceData(int offset, int count2, String data2) throws DOMException {
        if (this.isReadonly()) {
            throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
        }
        int length = this.textValue.length();
        if (offset < 0 || offset > length - 1 || count2 < 0) {
            throw new DOMException(1, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INDEX_SIZE_ERR", null));
        }
        int end = Math.min(count2 + offset, length);
        if (data2 == null) {
            this.textValue.delete(offset, end);
        } else {
            this.textValue.replace(offset, end, data2);
        }
    }

    public String getData() throws DOMException {
        return this.textValue != null ? this.textValue.toString() : "";
    }

    public void insertData(int offset, String data2) throws DOMException {
        int length = this.getLength();
        if (this.isReadonly()) {
            throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
        }
        if (offset < 0 || offset > length - 1) {
            throw new DOMException(1, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INDEX_SIZE_ERR", null));
        }
        this.textValue.insert(offset, data2);
    }

    public void setData(String data2) throws DOMException {
        if (this.isReadonly()) {
            throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
        }
        this.textValue.replace(0, this.getLength(), data2);
    }

    public String substringData(int offset, int count2) throws DOMException {
        if (offset < 0 || offset > this.getLength() || count2 < 0) {
            throw new DOMException(1, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INDEX_SIZE_ERR", null));
        }
        int end = Math.min(count2 + offset, this.textValue.length());
        return this.textValue.substring(offset, end);
    }

    public int getLength() {
        return this.textValue != null ? this.textValue.length() : 0;
    }
}

