/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.dom.ChildNode;
import org.apache.axiom.om.impl.dom.ElementImpl;
import org.apache.axiom.om.impl.dom.NodeImpl;

public class DOMNavigator {
    protected OMNode node;
    private boolean visited;
    private OMNode next;
    private OMNode root;
    private boolean backtracked;
    private boolean end = false;
    private boolean start = true;

    public DOMNavigator() {
    }

    public DOMNavigator(OMNode node2) {
        this.init(node2);
    }

    public void init(OMNode node2) {
        this.next = node2;
        this.root = node2;
        this.backtracked = false;
    }

    public OMNode next() {
        if (this.next == null) {
            return null;
        }
        this.node = this.next;
        this.visited = this.backtracked;
        this.backtracked = false;
        this.updateNextNode();
        if (this.root.equals(this.node)) {
            if (!this.start) {
                this.end = true;
            } else {
                this.start = false;
            }
        }
        return this.node;
    }

    private void updateNextNode() {
        if (this.next instanceof OMElement && !this.visited) {
            ElementImpl e2 = (ElementImpl)this.next;
            if (e2.firstChild != null) {
                this.next = e2.firstChild;
            } else if (e2.isComplete()) {
                this.backtracked = true;
            } else {
                this.next = null;
            }
        } else {
            ChildNode nextSibling = ((ChildNode)this.next).nextSibling;
            OMContainer parent = this.next.getParent();
            if (nextSibling != null) {
                this.next = nextSibling;
            } else if (parent != null && parent.isComplete()) {
                this.next = (NodeImpl)((Object)parent);
                this.backtracked = true;
            } else {
                this.next = null;
            }
        }
    }

    public boolean visited() {
        return this.visited;
    }

    public void step() {
        if (!this.end) {
            this.next = this.node;
            this.updateNextNode();
        }
    }

    public boolean isNavigable() {
        if (this.end) {
            return false;
        }
        return this.next != null;
    }

    public boolean isCompleted() {
        return this.end;
    }
}

