/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.attachments.utils.DataHandlerUtils;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.OMNamespaceImpl;
import org.apache.axiom.om.impl.builder.XOPBuilder;
import org.apache.axiom.om.impl.dom.AttrImpl;
import org.apache.axiom.om.impl.dom.CharacterImpl;
import org.apache.axiom.om.impl.dom.DOMMessageFormatter;
import org.apache.axiom.om.impl.dom.DocumentImpl;
import org.apache.axiom.om.impl.dom.ElementImpl;
import org.apache.axiom.om.impl.dom.NamespaceImpl;
import org.apache.axiom.om.impl.dom.ParentNode;
import org.apache.axiom.om.util.TextHelper;
import org.apache.axiom.om.util.UUIDGenerator;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TextImpl
extends CharacterImpl
implements Text,
OMText {
    private String mimeType;
    private boolean optimize;
    private boolean isBinary;
    private String contentID = null;
    protected OMNamespace textNS = null;
    protected char[] charArray;
    private Object dataHandlerObject = null;
    protected OMNamespace ns = null;
    protected String localName = "Include";
    protected OMAttribute attribute;
    public static final OMNamespace XOP_NS = new OMNamespaceImpl("http://www.w3.org/2004/08/xop/include", "xop");

    public TextImpl(String text, OMFactory factory) {
        super(factory);
        this.textValue = text != null ? new StringBuffer(text) : new StringBuffer("");
        this.done = true;
        this.ns = XOP_NS;
    }

    public TextImpl(String contentID, OMContainer parent, OMXMLParserWrapper builder, OMFactory factory) {
        super((DocumentImpl)((ParentNode)parent).getOwnerDocument(), factory);
        this.contentID = contentID;
        this.optimize = true;
        this.isBinary = true;
        this.done = true;
        this.builder = builder;
        this.ns = XOP_NS;
    }

    public TextImpl(OMContainer parent, TextImpl source2, OMFactory factory) {
        super((DocumentImpl)((ParentNode)parent).getOwnerDocument(), factory);
        this.done = true;
        if (source2.textValue != null) {
            this.textValue = new StringBuffer();
            this.textValue.append(source2.textValue.toString());
        }
        if (source2.charArray != null) {
            this.charArray = new char[source2.charArray.length];
            for (int i = 0; i < source2.charArray.length; ++i) {
                this.charArray[i] = source2.charArray[i];
            }
        }
        this.textNS = null;
        this.optimize = source2.optimize;
        this.mimeType = source2.mimeType;
        this.isBinary = source2.isBinary;
        this.contentID = source2.contentID;
        this.dataHandlerObject = source2.dataHandlerObject;
        this.localName = source2.localName;
        if (source2.ns != null) {
            this.ns = new OMNamespaceImpl(source2.ns.getNamespaceURI(), source2.ns.getPrefix());
        }
        if (source2.attribute != null) {
            this.attribute = factory.createOMAttribute(source2.attribute.getLocalName(), source2.attribute.getNamespace(), source2.attribute.getAttributeValue());
        }
    }

    public TextImpl(String text, String mimeType, boolean optimize, OMFactory factory) {
        this(text, mimeType, optimize, true, factory);
    }

    public TextImpl(String text, String mimeType, boolean optimize, boolean isBinary, OMFactory factory) {
        this(text, factory);
        this.mimeType = mimeType;
        this.optimize = optimize;
        this.isBinary = isBinary;
    }

    public TextImpl(DocumentImpl ownerNode, Object dataHandler, boolean optimize, OMFactory factory) {
        super(ownerNode, factory);
        this.dataHandlerObject = dataHandler;
        this.isBinary = true;
        this.optimize = optimize;
        this.done = true;
        this.ns = XOP_NS;
    }

    public TextImpl(DocumentImpl ownerNode, OMFactory factory) {
        super(ownerNode, factory);
        this.done = true;
        this.ns = XOP_NS;
    }

    public TextImpl(DocumentImpl ownerNode, String value, OMFactory factory) {
        super(ownerNode, value, factory);
        this.done = true;
        this.ns = XOP_NS;
    }

    public TextImpl(DocumentImpl ownerNode, char[] value, OMFactory factory) {
        super(ownerNode, factory);
        this.charArray = value;
        this.done = true;
        this.ns = XOP_NS;
    }

    public TextImpl(DocumentImpl ownerNode, String value, String mimeType, boolean optimize, OMFactory factory) {
        this(ownerNode, value, factory);
        this.mimeType = mimeType;
        this.optimize = optimize;
        this.isBinary = true;
        this.done = true;
    }

    public TextImpl(OMContainer parent, QName text, OMFactory factory) {
        this(parent, text, 4, factory);
    }

    public TextImpl(OMContainer parent, QName text, int nodeType, OMFactory factory) {
        this(((ElementImpl)parent).ownerNode, factory);
        if (text != null) {
            this.textNS = ((ElementImpl)parent).findNamespace(text.getNamespaceURI(), text.getPrefix());
        }
        this.textValue = new StringBuffer(text == null ? "" : text.getLocalPart());
        this.done = true;
    }

    public Text splitText(int offset) throws DOMException {
        if (this.isReadonly()) {
            throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
        }
        if (offset < 0 || offset > this.textValue.length()) {
            throw new DOMException(1, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INDEX_SIZE_ERR", null));
        }
        String newValue = this.textValue.substring(offset);
        this.deleteData(offset, this.textValue.length());
        TextImpl newText = (TextImpl)this.getOwnerDocument().createTextNode(newValue);
        if (this.parentNode != null) {
            newText.setParent(this.parentNode);
        }
        this.insertSiblingAfter(newText);
        return newText;
    }

    public String getNodeName() {
        return "#text";
    }

    public short getNodeType() {
        return 3;
    }

    public int getType() throws OMException {
        return 4;
    }

    public void setType(int nodeType) throws OMException {
    }

    public void internalSerialize(XMLStreamWriter writer2) throws XMLStreamException {
        this.internalSerializeLocal(writer2);
    }

    public void internalSerializeAndConsume(XMLStreamWriter writer2) throws XMLStreamException {
        this.internalSerializeLocal(writer2);
    }

    public boolean isOptimized() {
        return this.optimize;
    }

    public void setOptimize(boolean value) {
        this.optimize = value;
        if (value) {
            this.isBinary = true;
        }
    }

    public void discard() throws OMException {
        if (this.done) {
            this.detach();
        }
    }

    private void writeOutput(XMLStreamWriter writer2) throws XMLStreamException {
        int type2 = this.getType();
        if (type2 == 4 || type2 == 6) {
            writer2.writeCharacters(this.getText());
        } else if (type2 == 12) {
            writer2.writeCData(this.getText());
        } else if (type2 == 9) {
            writer2.writeEntityRef(this.getText());
        }
    }

    public String getText() {
        if (this.textNS != null) {
            return this.getTextString();
        }
        if (this.charArray != null || this.textValue != null) {
            return this.getTextFromProperPlace();
        }
        try {
            return TextHelper.toString(this.getInputStream());
        }
        catch (Exception e2) {
            throw new OMException(e2);
        }
    }

    public String getData() throws DOMException {
        return this.getText();
    }

    public char[] getTextCharacters() {
        return this.charArray != null ? this.charArray : this.textValue.toString().toCharArray();
    }

    public boolean isCharacters() {
        return this.charArray != null;
    }

    private String getTextFromProperPlace() {
        return this.charArray != null ? new String(this.charArray) : this.textValue.toString();
    }

    private String getTextString() {
        if (this.textNS != null) {
            String prefix = this.textNS.getPrefix();
            if (prefix == null || "".equals(prefix)) {
                return this.getTextFromProperPlace();
            }
            return prefix + ":" + this.getTextFromProperPlace();
        }
        return null;
    }

    public QName getTextAsQName() {
        if (this.textNS != null) {
            String prefix = this.textNS.getPrefix();
            String name2 = this.textNS.getNamespaceURI();
            if (prefix == null || "".equals(prefix)) {
                return new QName(name2, this.getTextFromProperPlace());
            }
            return new QName(this.textNS.getNamespaceURI(), this.getTextFromProperPlace(), prefix);
        }
        if (this.textValue != null || this.charArray != null) {
            return new QName(this.getTextFromProperPlace());
        }
        try {
            return new QName(TextHelper.toString(this.getInputStream()));
        }
        catch (Exception e2) {
            throw new OMException(e2);
        }
    }

    public String getNodeValue() throws DOMException {
        return this.getText();
    }

    public String getContentID() {
        if (this.contentID == null) {
            this.contentID = UUIDGenerator.getUUID() + "@apache.org";
        }
        return this.contentID;
    }

    public Object getDataHandler() {
        if ((this.textValue != null || this.charArray != null || this.textNS != null) & this.isBinary) {
            String text = this.textNS == null ? this.getTextFromProperPlace() : this.getTextString();
            return DataHandlerUtils.getDataHandlerFromText(text, this.mimeType);
        }
        if (this.dataHandlerObject == null) {
            if (this.contentID == null) {
                throw new RuntimeException("ContentID is null");
            }
            this.dataHandlerObject = ((XOPBuilder)((Object)this.builder)).getDataHandler(this.contentID);
        }
        return this.dataHandlerObject;
    }

    public InputStream getInputStream() throws OMException {
        if (this.isBinary) {
            InputStream inStream;
            if (this.dataHandlerObject == null) {
                this.getDataHandler();
            }
            DataHandler dataHandler = (DataHandler)this.dataHandlerObject;
            try {
                inStream = dataHandler.getDataSource().getInputStream();
            }
            catch (IOException e2) {
                throw new OMException("Cannot get InputStream from DataHandler." + e2);
            }
            return inStream;
        }
        throw new OMException("Unsupported Operation");
    }

    private void internalSerializeLocal(XMLStreamWriter writer2) throws XMLStreamException {
        MTOMXMLStreamWriter writer3 = (MTOMXMLStreamWriter)writer2;
        if (!this.isBinary) {
            this.writeOutput(writer3);
        } else if (writer3.isOptimized()) {
            if (this.contentID == null) {
                this.contentID = writer3.getNextContentId();
            }
            this.attribute = new AttrImpl(this.ownerNode, "href", new NamespaceImpl("", ""), "cid:" + this.getContentID(), this.factory);
            this.serializeStartpart(writer3);
            writer3.writeOptimized(this);
            writer3.writeEndElement();
        } else {
            writer3.writeCharacters(this.getText());
        }
    }

    private void serializeStartpart(XMLStreamWriter writer2) throws XMLStreamException {
        String nameSpaceName = XOP_NS.getNamespaceURI();
        String writer_prefix = writer2.getPrefix(nameSpaceName);
        String prefix = XOP_NS.getPrefix();
        if (writer_prefix != null) {
            writer2.writeStartElement(nameSpaceName, this.getLocalName());
        } else {
            writer2.writeStartElement(prefix, this.getLocalName(), nameSpaceName);
            writer2.setPrefix(prefix, nameSpaceName);
        }
        TextImpl.serializeAttribute(this.attribute, writer2);
        TextImpl.serializeNamespace(XOP_NS, writer2);
    }

    static void serializeAttribute(OMAttribute attr, XMLStreamWriter writer2) throws XMLStreamException {
        OMNamespace ns2 = attr.getNamespace();
        if (ns2 != null) {
            String prefix = ns2.getPrefix();
            String namespaceName = ns2.getNamespaceURI();
            if (prefix != null) {
                writer2.writeAttribute(prefix, namespaceName, attr.getLocalName(), attr.getAttributeValue());
            } else {
                writer2.writeAttribute(namespaceName, attr.getLocalName(), attr.getAttributeValue());
            }
        } else {
            writer2.writeAttribute(attr.getLocalName(), attr.getAttributeValue());
        }
    }

    static void serializeNamespace(OMNamespace namespace2, XMLStreamWriter writer2) throws XMLStreamException {
        if (namespace2 != null) {
            String uri = namespace2.getNamespaceURI();
            String ns_prefix = namespace2.getPrefix();
            writer2.writeNamespace(ns_prefix, namespace2.getNamespaceURI());
            writer2.setPrefix(ns_prefix, uri);
        }
    }

    public Node cloneNode(boolean deep) {
        TextImpl textImpl = new TextImpl(this.textValue.toString(), this.factory);
        textImpl.setOwnerDocument(this.ownerNode);
        return textImpl;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getWholeText() {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean isElementContentWhitespace() {
        throw new UnsupportedOperationException("TODO");
    }

    public Text replaceWholeText(String arg0) throws DOMException {
        throw new UnsupportedOperationException("TODO");
    }

    public String toString() {
        return this.textValue != null ? this.textValue.toString() : "";
    }

    public void buildWithAttachments() {
        this.build();
        if (this.isOptimized()) {
            this.getDataHandler();
        }
    }

    public boolean isBinary() {
        return this.isBinary;
    }

    public void setBinary(boolean value) {
        this.isBinary = value;
    }

    public OMNamespace getNamespace() {
        return this.textNS;
    }

    public void setContentID(String cid) {
        this.contentID = cid;
    }
}

