/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.llom;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMConstants;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.OMXMLStreamReader;
import org.apache.axiom.om.impl.OMContainerEx;
import org.apache.axiom.om.impl.OMNamespaceImpl;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.builder.XOPAwareStAXOMBuilder;
import org.apache.axiom.om.impl.builder.XOPBuilder;
import org.apache.axiom.om.impl.llom.OMAttributeImpl;
import org.apache.axiom.om.impl.llom.OMNodeImpl;
import org.apache.axiom.om.impl.llom.OMStAXWrapper;
import org.apache.axiom.om.impl.llom.factory.OMLinkedListImplFactory;
import org.apache.axiom.om.impl.traverse.OMChildElementIterator;
import org.apache.axiom.om.impl.traverse.OMChildrenIterator;
import org.apache.axiom.om.impl.traverse.OMChildrenLegacyQNameIterator;
import org.apache.axiom.om.impl.traverse.OMChildrenLocalNameIterator;
import org.apache.axiom.om.impl.traverse.OMChildrenNamespaceIterator;
import org.apache.axiom.om.impl.traverse.OMChildrenQNameIterator;
import org.apache.axiom.om.impl.util.EmptyIterator;
import org.apache.axiom.om.impl.util.OMSerializerUtil;
import org.apache.axiom.om.util.ElementHelper;
import org.apache.axiom.om.util.OMXMLStreamReaderValidator;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OMElementImpl
extends OMNodeImpl
implements OMElement,
OMConstants,
OMContainerEx {
    private static final Log log = LogFactory.getLog(class$org$apache$axiom$om$impl$llom$OMElementImpl == null ? (class$org$apache$axiom$om$impl$llom$OMElementImpl = OMElementImpl.class$("org.apache.axiom.om.impl.llom.OMElementImpl")) : class$org$apache$axiom$om$impl$llom$OMElementImpl);
    private static boolean DEBUG_ENABLED = log.isDebugEnabled();
    public static final OMNamespace DEFAULT_DEFAULT_NS_OBJECT = new OMNamespaceImpl("", "");
    protected OMNamespace ns;
    protected String localName;
    protected QName qName;
    protected OMNode firstChild;
    protected HashMap namespaces = null;
    protected HashMap attributes = null;
    protected int noPrefixNamespaceCounter = 0;
    protected OMNode lastChild;
    private int lineNumber;
    private static final EmptyIterator EMPTY_ITERATOR = new EmptyIterator();
    static final OMNamespaceImpl xmlns = new OMNamespaceImpl("http://www.w3.org/XML/1998/namespace", "xml");
    static /* synthetic */ Class class$org$apache$axiom$om$impl$llom$OMElementImpl;

    public OMElementImpl(String localName, OMNamespace ns2, OMContainer parent, OMXMLParserWrapper builder, OMFactory factory) {
        super(parent, factory, false);
        this.localName = localName;
        if (ns2 != null) {
            this.setNamespace(ns2);
        }
        this.builder = builder;
        this.firstChild = null;
    }

    public OMElementImpl(String localName, OMNamespace ns2, OMFactory factory) {
        this(localName, ns2, null, factory);
    }

    public OMElementImpl(String localName, OMNamespace ns2, OMContainer parent, OMFactory factory) {
        super(parent, factory, true);
        if (localName == null || localName.trim().length() == 0) {
            throw new OMException("localname can not be null or empty");
        }
        this.localName = localName;
        if (ns2 != null) {
            this.setNamespace(ns2);
        }
    }

    public OMElementImpl(QName qname, OMContainer parent, OMFactory factory) throws OMException {
        this(qname.getLocalPart(), null, parent, factory);
        this.ns = this.handleNamespace(qname);
    }

    OMNamespace handleNamespace(QName qname) {
        OMNamespace ns2 = null;
        String namespaceURI = qname.getNamespaceURI();
        if (namespaceURI != null && namespaceURI.length() > 0) {
            String prefix = qname.getPrefix();
            ns2 = this.findNamespace(qname.getNamespaceURI(), prefix);
            if (ns2 == null) {
                if ("".equals(prefix)) {
                    prefix = OMSerializerUtil.getNextNSPrefix();
                }
                ns2 = this.declareNamespace(namespaceURI, prefix);
            }
            if (ns2 != null) {
                this.ns = ns2;
            }
        }
        return ns2;
    }

    private OMNamespace handleNamespace(OMNamespace ns2) {
        OMNamespace namespace2 = this.findNamespace(ns2.getNamespaceURI(), ns2.getPrefix());
        if (namespace2 == null) {
            namespace2 = this.declareNamespace(ns2);
        }
        return namespace2;
    }

    OMNamespace handleNamespace(String namespaceURI, String prefix) {
        OMNamespace namespace2 = this.findNamespace(namespaceURI, prefix);
        if (namespace2 == null) {
            namespace2 = this.declareNamespace(namespaceURI, prefix);
        }
        return namespace2;
    }

    public void addChild(OMNode child) {
        if (child.getOMFactory() instanceof OMLinkedListImplFactory) {
            this.addChild((OMNodeImpl)child);
        } else {
            this.addChild(this.importNode(child));
        }
    }

    public Iterator getChildrenWithName(QName elementQName) {
        OMNode firstChild = this.getFirstOMChild();
        OMChildrenQNameIterator it = new OMChildrenQNameIterator(firstChild, elementQName);
        if (elementQName.getNamespaceURI().length() == 0 && firstChild != null && !it.hasNext()) {
            if (log.isTraceEnabled()) {
                log.trace("There are no child elements that match the unqualifed name: " + elementQName);
                log.trace("Now looking for child elements that have the same local name.");
            }
            it = new OMChildrenLegacyQNameIterator(this.getFirstOMChild(), elementQName);
        }
        return it;
    }

    public Iterator getChildrenWithLocalName(String localName) {
        return new OMChildrenLocalNameIterator(this.getFirstOMChild(), localName);
    }

    public Iterator getChildrenWithNamespaceURI(String uri) {
        return new OMChildrenNamespaceIterator(this.getFirstOMChild(), uri);
    }

    public OMElement getFirstChildWithName(QName elementQName) throws OMException {
        OMChildrenQNameIterator omChildrenQNameIterator = new OMChildrenQNameIterator(this.getFirstOMChild(), elementQName);
        OMNode omNode = null;
        if (omChildrenQNameIterator.hasNext()) {
            omNode = (OMNode)omChildrenQNameIterator.next();
        }
        return omNode != null && 1 == omNode.getType() ? (OMElement)omNode : null;
    }

    private void addChild(OMNodeImpl child) {
        if (child.parent != this || child != this.lastChild) {
            child.setParent(this);
            if (this.firstChild == null) {
                this.firstChild = child;
                child.previousSibling = null;
            } else {
                child.previousSibling = (OMNodeImpl)this.lastChild;
                ((OMNodeImpl)this.lastChild).nextSibling = child;
            }
            child.nextSibling = null;
            this.lastChild = child;
        }
        if (!child.isComplete() && !(child instanceof OMSourcedElement)) {
            this.setComplete(false);
        }
    }

    public OMNode getNextOMSibling() throws OMException {
        while (!this.done && this.builder != null) {
            if (this.builder.isCompleted()) {
                if (DEBUG_ENABLED) {
                    log.debug("Builder is complete.  Setting OMElement to complete.");
                }
                this.setComplete(true);
                continue;
            }
            int token = this.builder.next();
            if (token != 8) continue;
            throw new OMException("Parser has already reached end of the document. No siblings found");
        }
        return super.getNextOMSibling();
    }

    public Iterator getChildren() {
        return new OMChildrenIterator(this.getFirstOMChild());
    }

    public Iterator getChildElements() {
        return new OMChildElementIterator(this.getFirstElement());
    }

    public OMNamespace declareNamespace(String uri, String prefix) {
        if ("".equals(prefix)) {
            prefix = OMSerializerUtil.getNextNSPrefix();
        }
        OMNamespaceImpl ns2 = new OMNamespaceImpl(uri, prefix);
        return this.declareNamespace(ns2);
    }

    public OMNamespace declareDefaultNamespace(String uri) {
        OMNamespaceImpl namespace2 = new OMNamespaceImpl(uri == null ? "" : uri, "");
        if (this.namespaces == null) {
            this.namespaces = new HashMap(5);
        }
        this.namespaces.put("", namespace2);
        if (this.ns == null || "".equals(this.ns.getPrefix())) {
            this.ns = namespace2;
            this.qName = null;
        }
        return namespace2;
    }

    public OMNamespace getDefaultNamespace() {
        OMNamespace defaultNS;
        if (this.namespaces != null && (defaultNS = (OMNamespace)this.namespaces.get("")) != null) {
            return defaultNS;
        }
        if (this.parent instanceof OMElementImpl) {
            return ((OMElementImpl)this.parent).getDefaultNamespace();
        }
        return null;
    }

    public OMNamespace declareNamespace(OMNamespace namespace2) {
        String prefix;
        if (this.namespaces == null) {
            this.namespaces = new HashMap(5);
        }
        if ((prefix = namespace2.getPrefix()) == null) {
            prefix = OMSerializerUtil.getNextNSPrefix();
            namespace2 = new OMNamespaceImpl(namespace2.getNamespaceURI(), prefix);
        }
        this.namespaces.put(prefix, namespace2);
        return namespace2;
    }

    public OMNamespace findNamespace(String uri, String prefix) {
        OMNamespace namespace2 = this.findDeclaredNamespace(uri, prefix);
        if (namespace2 != null) {
            return namespace2;
        }
        if (this.parent != null && this.parent instanceof OMElement) {
            namespace2 = ((OMElementImpl)this.parent).findNamespace(uri, prefix);
        }
        return namespace2;
    }

    public OMNamespace findNamespaceURI(String prefix) {
        OMNamespace ns2;
        OMNamespace oMNamespace = ns2 = this.namespaces == null ? null : (OMNamespace)this.namespaces.get(prefix);
        if (ns2 == null && this.parent instanceof OMElement) {
            ns2 = ((OMElement)((Object)this.parent)).findNamespaceURI(prefix);
        }
        return ns2;
    }

    private OMNamespace findDeclaredNamespace(String uri, String prefix) {
        if (uri == null) {
            return this.namespaces == null ? null : (OMNamespace)this.namespaces.get(prefix);
        }
        if (prefix != null && prefix.equals("xml") && uri.equals("http://www.w3.org/XML/1998/namespace")) {
            return xmlns;
        }
        if (this.namespaces == null) {
            return null;
        }
        if (prefix == null || "".equals(prefix)) {
            OMNamespace defaultNamespace = this.getDefaultNamespace();
            if (defaultNamespace != null && uri.equals(defaultNamespace.getNamespaceURI())) {
                return defaultNamespace;
            }
            Iterator namespaceListIterator = this.namespaces.values().iterator();
            while (namespaceListIterator.hasNext()) {
                OMNamespace omNamespace = (OMNamespace)namespaceListIterator.next();
                String nsUri = omNamespace.getNamespaceURI();
                if (nsUri == null || !nsUri.equals(uri)) continue;
                return omNamespace;
            }
        } else {
            OMNamespace namespace2 = (OMNamespace)this.namespaces.get(prefix);
            if (namespace2 != null && uri.equals(namespace2.getNamespaceURI())) {
                return namespace2;
            }
        }
        return null;
    }

    public Iterator getAllDeclaredNamespaces() {
        if (this.namespaces == null) {
            return EMPTY_ITERATOR;
        }
        return this.namespaces.values().iterator();
    }

    public Iterator getAllAttributes() {
        if (this.attributes == null) {
            return EMPTY_ITERATOR;
        }
        return this.attributes.values().iterator();
    }

    public OMAttribute getAttribute(QName qname) {
        return this.attributes == null ? null : (OMAttribute)this.attributes.get(qname);
    }

    public String getAttributeValue(QName qname) {
        OMAttribute attr = this.getAttribute(qname);
        return attr == null ? null : attr.getAttributeValue();
    }

    public OMAttribute addAttribute(OMAttribute attr) {
        String nsPrefix;
        String nsURI;
        OMNamespace namespace2;
        if (attr.getOwner() != null) {
            attr = new OMAttributeImpl(attr.getLocalName(), attr.getNamespace(), attr.getAttributeValue(), attr.getOMFactory());
        }
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap(5);
        }
        if ((namespace2 = attr.getNamespace()) != null && (nsURI = namespace2.getNamespaceURI()) != null && !"".equals(nsURI) && this.findNamespace(nsURI, nsPrefix = namespace2.getPrefix()) == null) {
            this.declareNamespace(nsURI, nsPrefix);
        }
        ((OMAttributeImpl)attr).owner = this;
        this.attributes.put(attr.getQName(), attr);
        return attr;
    }

    public void removeAttribute(OMAttribute attr) {
        if (this.attributes != null) {
            ((OMAttributeImpl)attr).owner = null;
            this.attributes.remove(attr.getQName());
        }
    }

    public OMAttribute addAttribute(String attributeName, String value, OMNamespace ns2) {
        String prefix;
        String namespaceURI;
        OMNamespace namespace2 = null;
        if (ns2 != null && (namespace2 = this.findNamespace(namespaceURI = ns2.getNamespaceURI(), prefix = ns2.getPrefix())) == null) {
            namespace2 = new OMNamespaceImpl(namespaceURI, prefix);
        }
        return this.addAttribute(new OMAttributeImpl(attributeName, namespace2, value, this.factory));
    }

    public void setBuilder(OMXMLParserWrapper wrapper) {
        this.builder = wrapper;
    }

    public OMXMLParserWrapper getBuilder() {
        return this.builder;
    }

    public void buildNext() {
        if (this.builder != null) {
            if (!this.builder.isCompleted()) {
                this.builder.next();
            } else {
                this.setComplete(true);
                if (DEBUG_ENABLED) {
                    log.debug("Builder is complete.  Setting OMElement to complete.");
                }
            }
        }
    }

    public OMNode getFirstOMChild() {
        while (this.firstChild == null && !this.done) {
            this.buildNext();
        }
        return this.firstChild;
    }

    public void setFirstChild(OMNode firstChild) {
        if (firstChild != null) {
            ((OMNodeEx)firstChild).setParent(this);
        }
        this.firstChild = firstChild;
    }

    public void setLastChild(OMNode omNode) {
        this.lastChild = omNode;
    }

    public OMNode detach() throws OMException {
        if (!this.done) {
            this.build();
        }
        super.detach();
        return this;
    }

    public boolean isComplete() {
        return this.done;
    }

    public int getType() {
        return 1;
    }

    public void build() throws OMException {
        if (this.builder == null && !this.done) {
            Iterator childrenIterator = this.getChildren();
            while (childrenIterator.hasNext()) {
                OMNode omNode = (OMNode)childrenIterator.next();
                omNode.build();
            }
        } else {
            super.build();
        }
    }

    public XMLStreamReader getXMLStreamReader() {
        return this.getXMLStreamReader(true);
    }

    public XMLStreamReader getXMLStreamReaderWithoutCaching() {
        return this.getXMLStreamReader(false);
    }

    private XMLStreamReader getXMLStreamReader(boolean cache) {
        if (this.builder != null && this.builder instanceof StAXOMBuilder && !this.isComplete() && ((StAXOMBuilder)this.builder).isLookahead()) {
            this.buildNext();
        }
        OMXMLStreamReader reader2 = null;
        if (this.builder == null && this.done) {
            reader2 = new OMStAXWrapper(null, this, false);
        } else {
            if (this.builder == null && !cache) {
                throw new UnsupportedOperationException("This element was not created in a manner to be switched");
            }
            if (this.builder != null && this.builder.isCompleted() && !cache && !this.done) {
                throw new UnsupportedOperationException("The parser is already consumed!");
            }
            reader2 = new OMStAXWrapper(this.builder, this, cache);
        }
        if (DEBUG_ENABLED) {
            reader2 = new OMXMLStreamReaderValidator(reader2, false);
        }
        return reader2;
    }

    public void setText(String text) {
        for (OMNode child = this.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
            if (child.getType() != 4) continue;
            child.detach();
        }
        OMAbstractFactory.getOMFactory().createOMText((OMContainer)this, text);
    }

    public void setText(QName text) {
        for (OMNode child = this.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
            if (child.getType() != 4) continue;
            child.detach();
        }
        OMAbstractFactory.getOMFactory().createOMText((OMContainer)this, text);
    }

    public String getText() {
        String childText = null;
        StringBuffer buffer = null;
        for (OMNode child = this.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
            OMText textNode;
            String textValue;
            int type2 = child.getType();
            if (type2 != 4 && type2 != 12 || (textValue = (textNode = (OMText)child).getText()) == null || textValue.length() == 0) continue;
            if (childText == null) {
                childText = textValue;
                continue;
            }
            if (buffer == null) {
                buffer = new StringBuffer(childText);
            }
            buffer.append(textValue);
        }
        if (childText == null) {
            return "";
        }
        if (buffer != null) {
            return buffer.toString();
        }
        return childText;
    }

    public QName getTextAsQName() {
        String childText = this.getTrimmedText();
        if (childText != null) {
            return this.resolveQName(childText);
        }
        return null;
    }

    public String getTrimmedText() {
        String childText = null;
        StringBuffer buffer = null;
        for (OMNode child = this.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
            OMText textNode;
            String textValue;
            if (child.getType() != 4 || (textValue = (textNode = (OMText)child).getText()) == null || textValue.length() == 0) continue;
            if (childText == null) {
                childText = textValue.trim();
                continue;
            }
            if (buffer == null) {
                buffer = new StringBuffer(childText);
            }
            buffer.append(textValue.trim());
        }
        if (childText == null) {
            return "";
        }
        if (buffer != null) {
            return buffer.toString();
        }
        return childText;
    }

    public void internalSerialize(XMLStreamWriter writer2) throws XMLStreamException {
        this.internalSerialize(writer2, true);
    }

    protected void internalSerialize(XMLStreamWriter writer2, boolean cache) throws XMLStreamException {
        if (cache) {
            OMSerializerUtil.serializeStartpart(this, writer2);
            Iterator children2 = this.getChildren();
            while (children2.hasNext()) {
                ((OMNodeEx)children2.next()).internalSerialize(writer2);
            }
            OMSerializerUtil.serializeEndpart(writer2);
        } else if (this.done || this.builder == null) {
            OMSerializerUtil.serializeStartpart(this, writer2);
            OMNodeImpl child = (OMNodeImpl)this.firstChild;
            while (child != null) {
                if (!(child instanceof OMElement) || child.isComplete() || child.builder == null) {
                    child.internalSerializeAndConsume(writer2);
                } else {
                    OMElement element = (OMElement)((Object)child);
                    element.getBuilder().setCache(false);
                    OMSerializerUtil.serializeByPullStream(element, writer2, cache);
                }
                child = child.nextSibling;
            }
            OMSerializerUtil.serializeEndpart(writer2);
        } else {
            OMSerializerUtil.serializeByPullStream(this, writer2, cache);
        }
    }

    public void internalSerializeAndConsume(XMLStreamWriter writer2) throws XMLStreamException {
        this.internalSerialize(writer2, false);
    }

    public OMElement getFirstElement() {
        for (OMNode node2 = this.getFirstOMChild(); node2 != null; node2 = node2.getNextOMSibling()) {
            if (node2.getType() != 1) continue;
            return (OMElement)node2;
        }
        return null;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
        this.qName = null;
    }

    public OMNamespace getNamespace() throws OMException {
        OMNamespace parentDefaultNS;
        if (this.ns == null && (parentDefaultNS = this.findNamespaceURI("")) != null && !"".equals(parentDefaultNS.getNamespaceURI())) {
            this.ns = DEFAULT_DEFAULT_NS_OBJECT;
            this.qName = null;
        }
        return this.ns;
    }

    public void setNamespace(OMNamespace namespace2) {
        OMNamespace nsObject = null;
        if (namespace2 != null) {
            nsObject = this.handleNamespace(namespace2);
        }
        this.ns = nsObject;
        this.qName = null;
    }

    public void setNamespaceWithNoFindInCurrentScope(OMNamespace namespace2) {
        this.ns = namespace2;
        this.qName = null;
    }

    public QName getQName() {
        if (this.qName != null) {
            return this.qName;
        }
        this.qName = this.ns != null ? (this.ns.getPrefix() != null ? new QName(this.ns.getNamespaceURI(), this.localName, this.ns.getPrefix()) : new QName(this.ns.getNamespaceURI(), this.localName)) : new QName(this.localName);
        return this.qName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStringWithConsume() throws XMLStreamException {
        StringWriter writer2 = new StringWriter();
        XMLStreamWriter writer22 = StAXUtils.createXMLStreamWriter(writer2);
        try {
            this.serializeAndConsume(writer22);
            writer22.flush();
        }
        finally {
            writer22.close();
        }
        return writer2.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringWriter writer2 = new StringWriter();
        try {
            XMLStreamWriter writer22 = StAXUtils.createXMLStreamWriter(writer2);
            try {
                this.serialize(writer22);
                writer22.flush();
            }
            finally {
                writer22.close();
            }
        }
        catch (XMLStreamException e2) {
            throw new RuntimeException("Can not serialize OM Element " + this.getLocalName(), e2);
        }
        return writer2.toString();
    }

    public void discard() throws OMException {
        if (this.done || this.builder == null) {
            this.detach();
        } else {
            this.builder.discard(this);
        }
    }

    public QName resolveQName(String qname) {
        ElementHelper helper = new ElementHelper(this);
        return helper.resolveQName(qname);
    }

    public OMElement cloneOMElement() {
        if (log.isDebugEnabled()) {
            log.debug("cloneOMElement start");
            log.debug("  element string =" + this.getLocalName());
            log.debug(" isComplete = " + this.isComplete());
            log.debug("  builder = " + this.builder);
        }
        if (!this.isComplete()) {
            this.build();
        }
        XMLStreamReader xmlStreamReader = this.getXMLStreamReader(true);
        if (log.isDebugEnabled()) {
            log.debug("  reader = " + xmlStreamReader);
        }
        StAXOMBuilder newBuilder = null;
        if (this.builder instanceof XOPBuilder) {
            Attachments attachments = ((XOPBuilder)((Object)this.builder)).getAttachments();
            attachments.getAllContentIDs();
            if (xmlStreamReader instanceof OMXMLStreamReader) {
                if (log.isDebugEnabled()) {
                    log.debug("  read optimized xop:include");
                }
                ((OMXMLStreamReader)xmlStreamReader).setInlineMTOM(false);
            }
            newBuilder = new XOPAwareStAXOMBuilder(xmlStreamReader, attachments);
        } else {
            newBuilder = new StAXOMBuilder(xmlStreamReader);
        }
        if (log.isDebugEnabled()) {
            log.debug("  newBuilder = " + newBuilder);
        }
        OMElement clonedElement = newBuilder.getDocumentElement();
        clonedElement.build();
        return clonedElement;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void buildWithAttachments() {
        if (!this.done) {
            this.build();
        }
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            OMNode node2 = (OMNode)iterator.next();
            node2.buildWithAttachments();
        }
    }

    protected void notifyChildComplete() {
        if (!this.done && this.builder == null) {
            Iterator iterator = this.getChildren();
            while (iterator.hasNext()) {
                OMNode node2 = (OMNode)iterator.next();
                if (node2.isComplete()) continue;
                return;
            }
            this.setComplete(true);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

