/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.llom;

import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.attachments.utils.DataHandlerUtils;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMConstants;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.OMNamespaceImpl;
import org.apache.axiom.om.impl.builder.XOPBuilder;
import org.apache.axiom.om.impl.llom.OMAttributeImpl;
import org.apache.axiom.om.impl.llom.OMElementImpl;
import org.apache.axiom.om.impl.llom.OMNodeImpl;
import org.apache.axiom.om.impl.util.OMSerializerUtil;
import org.apache.axiom.om.util.TextHelper;
import org.apache.axiom.om.util.UUIDGenerator;

public class OMTextImpl
extends OMNodeImpl
implements OMText,
OMConstants {
    public static final OMNamespace XOP_NS = new OMNamespaceImpl("http://www.w3.org/2004/08/xop/include", "xop");
    protected String value = null;
    protected char[] charArray;
    private boolean calcNS;
    protected OMNamespace textNS;
    protected String mimeType;
    protected boolean optimize = false;
    protected boolean isBinary = false;
    private String contentID = null;
    private Object dataHandlerObject = null;
    protected String localName = "Include";
    protected OMAttribute attribute;
    private static final String EMTPY_STRING = "";

    public OMTextImpl(String s, OMFactory factory) {
        this(s, 4, factory);
    }

    public OMTextImpl(String s, int nodeType, OMFactory factory) {
        this(null, s, nodeType, factory);
    }

    public OMTextImpl(OMContainer parent, String text, OMFactory factory) {
        this(parent, text, 4, factory);
    }

    public OMTextImpl(OMContainer parent, OMTextImpl source2, OMFactory factory) {
        super(parent, factory, true);
        this.value = source2.value;
        this.nodeType = source2.nodeType;
        if (source2.charArray != null) {
            this.charArray = new char[source2.charArray.length];
            System.arraycopy(source2.charArray, 0, this.charArray, 0, source2.charArray.length);
        }
        this.calcNS = false;
        this.textNS = null;
        this.optimize = source2.optimize;
        this.mimeType = source2.mimeType;
        this.isBinary = source2.isBinary;
        this.contentID = source2.contentID;
        this.dataHandlerObject = source2.dataHandlerObject;
        this.localName = source2.localName;
        if (source2.attribute != null) {
            this.attribute = factory.createOMAttribute(source2.attribute.getLocalName(), source2.attribute.getNamespace(), source2.attribute.getAttributeValue());
        }
    }

    public OMTextImpl(OMContainer parent, String text, int nodeType, OMFactory factory) {
        super(parent, factory, true);
        this.value = text == null ? EMTPY_STRING : text;
        this.nodeType = nodeType;
    }

    public OMTextImpl(OMContainer parent, char[] charArray, int nodeType, OMFactory factory) {
        super(parent, factory, true);
        this.charArray = charArray;
        this.nodeType = nodeType;
    }

    public OMTextImpl(OMContainer parent, QName text, OMFactory factory) {
        this(parent, text, 4, factory);
    }

    public OMTextImpl(OMContainer parent, QName text, int nodeType, OMFactory factory) {
        super(parent, factory, true);
        if (text == null) {
            throw new IllegalArgumentException("QName text arg cannot be null!");
        }
        this.calcNS = true;
        this.textNS = ((OMElementImpl)parent).handleNamespace(text.getNamespaceURI(), text.getPrefix());
        this.value = this.textNS.getPrefix() + ":" + text.getLocalPart();
        this.nodeType = nodeType;
    }

    public OMTextImpl(String s, String mimeType, boolean optimize, OMFactory factory) {
        this(null, s, mimeType, optimize, factory);
    }

    public OMTextImpl(OMContainer parent, String s, String mimeType, boolean optimize, OMFactory factory) {
        this(parent, s, factory);
        this.mimeType = mimeType;
        this.optimize = optimize;
        this.isBinary = true;
        this.done = true;
        this.nodeType = 4;
    }

    public OMTextImpl(Object dataHandler, OMFactory factory) {
        this(dataHandler, true, factory);
    }

    public OMTextImpl(Object dataHandler, boolean optimize, OMFactory factory) {
        super(factory);
        this.dataHandlerObject = dataHandler;
        this.isBinary = true;
        this.optimize = optimize;
        this.done = true;
        this.nodeType = 4;
    }

    public OMTextImpl(String contentID, OMContainer parent, OMXMLParserWrapper builder, OMFactory factory) {
        super(parent, factory, false);
        this.contentID = contentID;
        this.optimize = true;
        this.isBinary = true;
        this.builder = builder;
        this.nodeType = 4;
    }

    public void internalSerialize(XMLStreamWriter writer2) throws XMLStreamException {
        this.internalSerializeLocal(writer2);
    }

    private void writeOutput(XMLStreamWriter writer2) throws XMLStreamException {
        int type2 = this.getType();
        if (type2 == 4 || type2 == 6) {
            writer2.writeCharacters(this.getText());
        } else if (type2 == 12) {
            writer2.writeCData(this.getText());
        } else if (type2 == 9) {
            writer2.writeEntityRef(this.getText());
        }
    }

    public String getText() throws OMException {
        if (this.charArray != null || this.value != null) {
            return this.getTextFromProperPlace();
        }
        try {
            return TextHelper.toString(this.getInputStream());
        }
        catch (Exception e2) {
            throw new OMException(e2);
        }
    }

    public char[] getTextCharacters() {
        return this.charArray != null ? this.charArray : this.value.toCharArray();
    }

    public boolean isCharacters() {
        return this.charArray != null;
    }

    private String getTextFromProperPlace() {
        return this.charArray != null ? new String(this.charArray) : this.value;
    }

    public QName getTextAsQName() throws OMException {
        return ((OMElement)((Object)this.parent)).resolveQName(this.getTextFromProperPlace());
    }

    public OMNamespace getNamespace() {
        int colon;
        String text;
        if (this.calcNS) {
            return this.textNS;
        }
        this.calcNS = true;
        if (this.getParent() != null && (text = this.getTextFromProperPlace()) != null && (colon = text.indexOf(58)) > 0) {
            this.textNS = ((OMElementImpl)this.getParent()).findNamespaceURI(text.substring(0, colon));
            if (this.textNS != null) {
                this.charArray = null;
                this.value = text.substring(colon + 1);
            }
        }
        return this.textNS;
    }

    public boolean isOptimized() {
        return this.optimize;
    }

    public void setOptimize(boolean value) {
        this.optimize = value;
        if (value) {
            this.isBinary = true;
        }
    }

    public void setBinary(boolean value) {
        this.isBinary = value;
    }

    public boolean isBinary() {
        return this.isBinary;
    }

    public Object getDataHandler() {
        if ((this.value != null || this.charArray != null) && this.isBinary) {
            String text = this.getTextFromProperPlace();
            return DataHandlerUtils.getDataHandlerFromText(text, this.mimeType);
        }
        if (this.dataHandlerObject == null) {
            if (this.contentID == null) {
                throw new RuntimeException("ContentID is null");
            }
            this.dataHandlerObject = ((XOPBuilder)((Object)this.builder)).getDataHandler(this.contentID);
        }
        return this.dataHandlerObject;
    }

    public String getLocalName() {
        return this.localName;
    }

    public InputStream getInputStream() throws OMException {
        if (this.isBinary) {
            InputStream inStream;
            if (this.dataHandlerObject == null) {
                this.getDataHandler();
            }
            DataHandler dataHandler = (DataHandler)this.dataHandlerObject;
            try {
                inStream = dataHandler.getDataSource().getInputStream();
            }
            catch (IOException e2) {
                throw new OMException("Cannot get InputStream from DataHandler." + e2);
            }
            return inStream;
        }
        throw new OMException("Unsupported Operation");
    }

    public String getContentID() {
        if (this.contentID == null) {
            this.contentID = UUIDGenerator.getUUID() + "@apache.org";
        }
        return this.contentID;
    }

    public void internalSerializeAndConsume(XMLStreamWriter writer2) throws XMLStreamException {
        this.internalSerializeLocal(writer2);
    }

    private void internalSerializeLocal(XMLStreamWriter writer2) throws XMLStreamException {
        if (!this.isBinary || !this.isOptimized()) {
            this.writeOutput(writer2);
        } else if (writer2 instanceof MTOMXMLStreamWriter) {
            MTOMXMLStreamWriter writer3 = (MTOMXMLStreamWriter)writer2;
            if (writer3.isOptimized() && writer3.isOptimizedThreshold(this)) {
                if (this.contentID == null) {
                    this.contentID = writer3.getNextContentId();
                }
                this.attribute = new OMAttributeImpl("href", new OMNamespaceImpl(EMTPY_STRING, EMTPY_STRING), "cid:" + this.getContentID(), this.factory);
                this.serializeStartpart(writer3);
                writer3.writeOptimized(this);
                writer3.writeEndElement();
            } else {
                this.writeOutput(writer3);
            }
        } else {
            this.writeOutput(writer2);
        }
    }

    private void serializeStartpart(XMLStreamWriter writer2) throws XMLStreamException {
        String nameSpaceName = XOP_NS.getNamespaceURI();
        String writer_prefix = writer2.getPrefix(nameSpaceName);
        String prefix = XOP_NS.getPrefix();
        if (writer_prefix != null) {
            writer2.writeStartElement(nameSpaceName, this.getLocalName());
        } else if (OMSerializerUtil.isSetPrefixBeforeStartElement(writer2)) {
            writer2.setPrefix(prefix, nameSpaceName);
            writer2.writeStartElement(prefix, this.getLocalName(), nameSpaceName);
        } else {
            writer2.writeStartElement(prefix, this.getLocalName(), nameSpaceName);
            writer2.setPrefix(prefix, nameSpaceName);
        }
        OMTextImpl.serializeAttribute(this.attribute, writer2);
        OMTextImpl.serializeNamespace(XOP_NS, writer2);
    }

    static void serializeAttribute(OMAttribute attr, XMLStreamWriter writer2) throws XMLStreamException {
        OMNamespace ns2 = attr.getNamespace();
        if (ns2 != null) {
            String prefix = ns2.getPrefix();
            String namespaceName = ns2.getNamespaceURI();
            if (prefix != null) {
                writer2.writeAttribute(prefix, namespaceName, attr.getLocalName(), attr.getAttributeValue());
            } else {
                writer2.writeAttribute(namespaceName, attr.getLocalName(), attr.getAttributeValue());
            }
        } else {
            writer2.writeAttribute(attr.getLocalName(), attr.getAttributeValue());
        }
    }

    static void serializeNamespace(OMNamespace namespace2, XMLStreamWriter writer2) throws XMLStreamException {
        if (namespace2 != null) {
            String uri = namespace2.getNamespaceURI();
            String ns_prefix = namespace2.getPrefix();
            writer2.writeNamespace(ns_prefix, namespace2.getNamespaceURI());
            writer2.setPrefix(ns_prefix, uri);
        }
    }

    public void discard() throws OMException {
        if (this.done) {
            this.detach();
        }
    }

    public void buildWithAttachments() {
        if (!this.done) {
            this.build();
        }
        if (this.isOptimized()) {
            this.getDataHandler();
        }
    }

    public void setContentID(String cid) {
        this.contentID = cid;
    }
}

