/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.llom.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public class NamespaceContextImpl
implements NamespaceContext {
    protected Map namespaces;

    public NamespaceContextImpl(Map map2) {
        this.namespaces = map2;
    }

    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("null prefix argument is invalid");
        }
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        if (this.namespaces.containsKey(prefix)) {
            return (String)this.namespaces.get(prefix);
        }
        return null;
    }

    public String getPrefix(String nsURI) {
        if (nsURI == null) {
            throw new IllegalArgumentException("invalid null nsURI");
        }
        if (nsURI.length() == 0) {
            throw new IllegalArgumentException("invalid empty nsURI");
        }
        if (nsURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (nsURI.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        Iterator iter = this.namespaces.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String uri = (String)entry.getValue();
            if (!uri.equals(nsURI)) continue;
            return (String)entry.getKey();
        }
        if (nsURI.length() == 0) {
            return "";
        }
        return null;
    }

    public Iterator getPrefixes(String nsURI) {
        if (nsURI == null) {
            throw new IllegalArgumentException("invalid null nsURI");
        }
        if (nsURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return Collections.singleton("xml").iterator();
        }
        if (nsURI.equals("http://www.w3.org/2000/xmlns/")) {
            return Collections.singleton("xmlns").iterator();
        }
        HashSet prefixes = null;
        Iterator iter = this.namespaces.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String uri = (String)entry.getValue();
            if (!uri.equals(nsURI)) continue;
            if (prefixes == null) {
                prefixes = new HashSet();
            }
            prefixes.add(entry.getKey());
        }
        if (prefixes != null) {
            return Collections.unmodifiableSet(prefixes).iterator();
        }
        if (nsURI.length() == 0) {
            return Collections.singleton("").iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }
}

