/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.serialize;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class OMXMLReader
implements XMLReader {
    private static final String URI_LEXICAL_HANDLER = "http://xml.org/sax/properties/lexical-handler";
    private final OMElement element;
    private final AttributesAdapter attributesAdapter = new AttributesAdapter();
    private boolean namespaces = true;
    private boolean namespacePrefixes = false;
    private ContentHandler contentHandler;
    private LexicalHandler lexicalHandler;
    private DTDHandler dtdHandler;
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler;

    public OMXMLReader(OMElement element) {
        this.element = element;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setDTDHandler(DTDHandler dtdHandler) {
        this.dtdHandler = dtdHandler;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public boolean getFeature(String name2) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(name2);
    }

    public void setFeature(String name2, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/namespaces".equals(name2)) {
            this.namespaces = value;
        } else if ("http://xml.org/sax/features/namespace-prefixes".equals(name2)) {
            this.namespacePrefixes = value;
        } else {
            throw new SAXNotRecognizedException(name2);
        }
    }

    public Object getProperty(String name2) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/namespaces".equals(name2)) {
            return this.namespaces;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(name2)) {
            return this.namespacePrefixes;
        }
        if (URI_LEXICAL_HANDLER.equals(name2)) {
            return this.lexicalHandler;
        }
        throw new SAXNotRecognizedException(name2);
    }

    public void setProperty(String name2, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (!URI_LEXICAL_HANDLER.equals(name2)) {
            throw new SAXNotRecognizedException(name2);
        }
        this.lexicalHandler = (LexicalHandler)value;
    }

    public void parse(InputSource input) throws IOException, SAXException {
        this.parse();
    }

    public void parse(String systemId) throws IOException, SAXException {
        this.parse();
    }

    private void parse() throws SAXException {
        this.contentHandler.startDocument();
        this.generateEvents(this.element);
        this.contentHandler.endDocument();
    }

    private void generatePrefixMappingEvents(OMElement omElement, boolean start) throws SAXException {
        Iterator it = omElement.getAllDeclaredNamespaces();
        while (it.hasNext()) {
            OMNamespace ns2 = (OMNamespace)it.next();
            String prefix = ns2.getPrefix();
            if (prefix == null) continue;
            if (start) {
                this.contentHandler.startPrefixMapping(prefix, ns2.getNamespaceURI());
                continue;
            }
            this.contentHandler.endPrefixMapping(prefix);
        }
    }

    private void generateEvents(OMElement omElement) throws SAXException {
        String prefix;
        String uri;
        this.generatePrefixMappingEvents(omElement, true);
        OMNamespace omNamespace = omElement.getNamespace();
        if (omNamespace != null) {
            uri = omNamespace.getNamespaceURI();
            prefix = omNamespace.getPrefix();
        } else {
            uri = "";
            prefix = null;
        }
        String localName = omElement.getLocalName();
        String qName = prefix == null || prefix.length() == 0 ? localName : prefix + ":" + localName;
        this.attributesAdapter.setAttributes(omElement);
        this.contentHandler.startElement(uri, localName, qName, this.attributesAdapter);
        Iterator it = omElement.getChildren();
        while (it.hasNext()) {
            OMNode node2 = (OMNode)it.next();
            switch (node2.getType()) {
                case 1: {
                    this.generateEvents((OMElement)node2);
                    break;
                }
                case 4: {
                    this.generateEvents((OMText)node2);
                    break;
                }
                case 12: {
                    if (this.lexicalHandler != null) {
                        this.lexicalHandler.startCDATA();
                    }
                    this.generateEvents((OMText)node2);
                    if (this.lexicalHandler == null) break;
                    this.lexicalHandler.endCDATA();
                    break;
                }
                case 5: {
                    if (this.lexicalHandler == null) break;
                    char[] ch = ((OMComment)node2).getValue().toCharArray();
                    this.lexicalHandler.comment(ch, 0, ch.length);
                }
            }
        }
        this.contentHandler.endElement(uri, localName, qName);
        this.generatePrefixMappingEvents(omElement, false);
    }

    private void generateEvents(OMText omText) throws SAXException {
        char[] ch = omText.getTextCharacters();
        this.contentHandler.characters(ch, 0, ch.length);
    }

    protected static class AttributesAdapter
    implements Attributes {
        private List attributes = new ArrayList(5);

        protected AttributesAdapter() {
        }

        public void setAttributes(OMElement element) {
            this.attributes.clear();
            Iterator it = element.getAllAttributes();
            while (it.hasNext()) {
                this.attributes.add(it.next());
            }
        }

        public int getLength() {
            return this.attributes.size();
        }

        public int getIndex(String qName) {
            int len = this.attributes.size();
            for (int i = 0; i < len; ++i) {
                if (!this.getQName(i).equals(qName)) continue;
                return i;
            }
            return -1;
        }

        public int getIndex(String uri, String localName) {
            int len = this.attributes.size();
            for (int i = 0; i < len; ++i) {
                if (!this.getURI(i).equals(uri) || !this.getLocalName(i).equals(localName)) continue;
                return i;
            }
            return -1;
        }

        public String getLocalName(int index2) {
            return ((OMAttribute)this.attributes.get(index2)).getLocalName();
        }

        public String getQName(int index2) {
            OMAttribute attribute = (OMAttribute)this.attributes.get(index2);
            OMNamespace ns2 = attribute.getNamespace();
            if (ns2 == null) {
                return attribute.getLocalName();
            }
            String prefix = ns2.getPrefix();
            if (prefix == null || prefix.length() == 0) {
                return attribute.getLocalName();
            }
            return ns2.getPrefix() + ":" + attribute.getLocalName();
        }

        public String getType(int index2) {
            return ((OMAttribute)this.attributes.get(index2)).getAttributeType();
        }

        public String getType(String qName) {
            int index2 = this.getIndex(qName);
            return index2 == -1 ? null : this.getType(index2);
        }

        public String getType(String uri, String localName) {
            int index2 = this.getIndex(uri, localName);
            return index2 == -1 ? null : this.getType(index2);
        }

        public String getURI(int index2) {
            OMNamespace ns2 = ((OMAttribute)this.attributes.get(index2)).getNamespace();
            return ns2 == null ? "" : ns2.getNamespaceURI();
        }

        public String getValue(int index2) {
            return ((OMAttribute)this.attributes.get(index2)).getAttributeValue();
        }

        public String getValue(String qName) {
            int index2 = this.getIndex(qName);
            return index2 == -1 ? null : this.getValue(index2);
        }

        public String getValue(String uri, String localName) {
            int index2 = this.getIndex(uri, localName);
            return index2 == -1 ? null : this.getValue(index2);
        }
    }
}

