/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.serialize;

import java.net.URLDecoder;
import java.util.ArrayList;
import javax.activation.DataHandler;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttachmentAccessor;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMSerializer;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.util.OMSerializerUtil;
import org.apache.axiom.om.util.ElementHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StreamingOMSerializer
implements XMLStreamConstants,
OMSerializer {
    Log log = LogFactory.getLog(class$org$apache$axiom$om$impl$serialize$StreamingOMSerializer == null ? (class$org$apache$axiom$om$impl$serialize$StreamingOMSerializer = StreamingOMSerializer.class$("org.apache.axiom.om.impl.serialize.StreamingOMSerializer")) : class$org$apache$axiom$om$impl$serialize$StreamingOMSerializer);
    private static int namespaceSuffix = 0;
    public static final String NAMESPACE_PREFIX = "ns";
    private int depth = 0;
    public static final QName XOP_INCLUDE = new QName("http://www.w3.org/2004/08/xop/include", "Include");
    private boolean inputHasAttachments = false;
    private boolean skipEndElement = false;
    static /* synthetic */ Class class$org$apache$axiom$om$impl$serialize$StreamingOMSerializer;

    public void serialize(XMLStreamReader node2, XMLStreamWriter writer2) throws XMLStreamException {
        this.serialize(node2, writer2, true);
    }

    public void serialize(XMLStreamReader node2, XMLStreamWriter writer2, boolean startAtNext) throws XMLStreamException {
        if (node2 instanceof OMAttachmentAccessor) {
            this.inputHasAttachments = true;
        }
        this.serializeNode(node2, writer2, startAtNext);
    }

    protected void serializeNode(XMLStreamReader reader2, XMLStreamWriter writer2) throws XMLStreamException {
        this.serializeNode(reader2, writer2, true);
    }

    protected void serializeNode(XMLStreamReader reader2, XMLStreamWriter writer2, boolean startAtNext) throws XMLStreamException {
        boolean useCurrentEvent;
        boolean bl = useCurrentEvent = !startAtNext;
        while (reader2.hasNext() || useCurrentEvent) {
            int event = 0;
            if (useCurrentEvent) {
                event = reader2.getEventType();
                useCurrentEvent = false;
            } else {
                event = reader2.next();
            }
            if (event == 1) {
                this.serializeElement(reader2, writer2);
                ++this.depth;
            } else if (event == 10) {
                this.serializeAttributes(reader2, writer2);
            } else if (event == 4) {
                this.serializeText(reader2, writer2);
            } else if (event == 5) {
                this.serializeComment(reader2, writer2);
            } else if (event == 12) {
                this.serializeCData(reader2, writer2);
            } else if (event == 2) {
                this.serializeEndElement(writer2);
                --this.depth;
            } else if (event == 7) {
                ++this.depth;
            } else if (event == 8) {
                if (this.depth != 0) {
                    --this.depth;
                }
                try {
                    this.serializeEndElement(writer2);
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            if (this.depth != 0) continue;
            break;
        }
    }

    protected void serializeElement(XMLStreamReader reader2, XMLStreamWriter writer2) throws XMLStreamException {
        String namespace2;
        String prefix;
        int i;
        boolean setPrefixFirst;
        ArrayList<String> writePrefixList = null;
        ArrayList<String> writeNSList = null;
        String ePrefix = reader2.getPrefix();
        ePrefix = ePrefix != null && ePrefix.length() == 0 ? null : ePrefix;
        String eNamespace = reader2.getNamespaceURI();
        String string2 = eNamespace = eNamespace != null && eNamespace.length() == 0 ? null : eNamespace;
        if (this.inputHasAttachments && XOP_INCLUDE.getNamespaceURI().equals(eNamespace)) {
            String eLocalPart = reader2.getLocalName();
            if (XOP_INCLUDE.getLocalPart().equals(eLocalPart) && this.serializeXOPInclude(reader2, writer2)) {
                this.skipEndElement = true;
                return;
            }
        }
        if (!(setPrefixFirst = OMSerializerUtil.isSetPrefixBeforeStartElement(writer2))) {
            if (eNamespace != null) {
                if (ePrefix == null) {
                    if (!OMSerializerUtil.isAssociated("", eNamespace, writer2)) {
                        if (writePrefixList == null) {
                            writePrefixList = new ArrayList<String>();
                            writeNSList = new ArrayList<String>();
                        }
                        writePrefixList.add("");
                        writeNSList.add(eNamespace);
                    }
                    writer2.writeStartElement("", reader2.getLocalName(), eNamespace);
                } else {
                    if (!OMSerializerUtil.isAssociated(ePrefix, eNamespace, writer2)) {
                        if (writePrefixList == null) {
                            writePrefixList = new ArrayList();
                            writeNSList = new ArrayList();
                        }
                        writePrefixList.add(ePrefix);
                        writeNSList.add(eNamespace);
                    }
                    writer2.writeStartElement(ePrefix, reader2.getLocalName(), eNamespace);
                }
            } else {
                writer2.writeStartElement(reader2.getLocalName());
            }
        }
        int count2 = reader2.getNamespaceCount();
        for (int i2 = 0; i2 < count2; ++i2) {
            String prefix2 = reader2.getNamespacePrefix(i2);
            prefix2 = prefix2 != null && prefix2.length() == 0 ? null : prefix2;
            String namespace3 = reader2.getNamespaceURI(i2);
            String newPrefix = OMSerializerUtil.generateSetPrefix(prefix2, namespace3 = namespace3 != null && namespace3.length() == 0 ? null : namespace3, writer2, false, setPrefixFirst);
            if (newPrefix == null) continue;
            if (writePrefixList == null) {
                writePrefixList = new ArrayList();
                writeNSList = new ArrayList();
            }
            if (writePrefixList.contains(newPrefix)) continue;
            writePrefixList.add(newPrefix);
            writeNSList.add(namespace3);
        }
        String newPrefix = OMSerializerUtil.generateSetPrefix(ePrefix, eNamespace, writer2, false, setPrefixFirst);
        if (newPrefix != null) {
            if (writePrefixList == null) {
                writePrefixList = new ArrayList();
                writeNSList = new ArrayList();
            }
            if (!writePrefixList.contains(newPrefix)) {
                writePrefixList.add(newPrefix);
                writeNSList.add(eNamespace);
            }
        }
        count2 = reader2.getAttributeCount();
        for (i = 0; i < count2; ++i) {
            prefix = reader2.getAttributePrefix(i);
            prefix = prefix != null && prefix.length() == 0 ? null : prefix;
            namespace2 = reader2.getAttributeNamespace(i);
            String string3 = namespace2 = namespace2 != null && namespace2.length() == 0 ? null : namespace2;
            if (prefix == null && namespace2 != null) {
                String writerPrefix = writer2.getPrefix(namespace2);
                writerPrefix = writerPrefix != null && writerPrefix.length() == 0 ? null : writerPrefix;
                String string4 = prefix = writerPrefix != null ? writerPrefix : this.generateUniquePrefix(writer2.getNamespaceContext());
            }
            if ((newPrefix = OMSerializerUtil.generateSetPrefix(prefix, namespace2, writer2, true, setPrefixFirst)) == null) continue;
            if (writePrefixList == null) {
                writePrefixList = new ArrayList();
                writeNSList = new ArrayList();
            }
            if (writePrefixList.contains(newPrefix)) continue;
            writePrefixList.add(newPrefix);
            writeNSList.add(namespace2);
        }
        if (setPrefixFirst) {
            if (eNamespace != null) {
                if (ePrefix == null) {
                    writer2.writeStartElement("", reader2.getLocalName(), eNamespace);
                } else {
                    writer2.writeStartElement(ePrefix, reader2.getLocalName(), eNamespace);
                }
            } else {
                writer2.writeStartElement(reader2.getLocalName());
            }
        }
        if (writePrefixList != null) {
            for (i = 0; i < writePrefixList.size(); ++i) {
                prefix = (String)writePrefixList.get(i);
                namespace2 = (String)writeNSList.get(i);
                if (prefix != null) {
                    if (namespace2 == null) {
                        writer2.writeNamespace(prefix, "");
                        continue;
                    }
                    writer2.writeNamespace(prefix, namespace2);
                    continue;
                }
                writer2.writeDefaultNamespace(namespace2);
            }
        }
        count2 = reader2.getAttributeCount();
        for (i = 0; i < count2; ++i) {
            String writerPrefix;
            prefix = reader2.getAttributePrefix(i);
            prefix = prefix != null && prefix.length() == 0 ? null : prefix;
            namespace2 = reader2.getAttributeNamespace(i);
            String string5 = namespace2 = namespace2 != null && namespace2.length() == 0 ? null : namespace2;
            if (prefix == null && namespace2 != null) {
                prefix = writer2.getPrefix(namespace2);
                if (prefix == null || "".equals(prefix)) {
                    for (int j = 0; j < writePrefixList.size(); ++j) {
                        if (!namespace2.equals((String)writeNSList.get(j))) continue;
                        prefix = (String)writePrefixList.get(j);
                    }
                }
            } else if (namespace2 != null && !prefix.equals(writerPrefix = writer2.getPrefix(namespace2)) && !"".equals(writerPrefix)) {
                prefix = writerPrefix;
            }
            if (namespace2 != null) {
                writer2.writeAttribute(prefix, namespace2, reader2.getAttributeLocalName(i), reader2.getAttributeValue(i));
                continue;
            }
            writer2.writeAttribute(reader2.getAttributeLocalName(i), reader2.getAttributeValue(i));
        }
    }

    protected void serializeEndElement(XMLStreamWriter writer2) throws XMLStreamException {
        if (this.skipEndElement) {
            this.skipEndElement = false;
            return;
        }
        writer2.writeEndElement();
    }

    protected void serializeText(XMLStreamReader reader2, XMLStreamWriter writer2) throws XMLStreamException {
        writer2.writeCharacters(reader2.getText());
    }

    protected void serializeCData(XMLStreamReader reader2, XMLStreamWriter writer2) throws XMLStreamException {
        writer2.writeCData(reader2.getText());
    }

    protected void serializeComment(XMLStreamReader reader2, XMLStreamWriter writer2) throws XMLStreamException {
        writer2.writeComment(reader2.getText());
    }

    protected void serializeAttributes(XMLStreamReader reader2, XMLStreamWriter writer2) throws XMLStreamException {
        int count2 = reader2.getAttributeCount();
        String prefix = null;
        String namespaceName = null;
        String writerPrefix = null;
        for (int i = 0; i < count2; ++i) {
            prefix = reader2.getAttributePrefix(i);
            namespaceName = reader2.getAttributeNamespace(i);
            namespaceName = namespaceName == null ? "" : namespaceName;
            writerPrefix = writer2.getPrefix(namespaceName);
            if (!"".equals(namespaceName)) {
                if (writerPrefix != null && (prefix == null || prefix.equals(""))) {
                    writer2.writeAttribute(writerPrefix, namespaceName, reader2.getAttributeLocalName(i), reader2.getAttributeValue(i));
                    continue;
                }
                if (prefix != null && !"".equals(prefix) && !prefix.equals(writerPrefix)) {
                    writer2.writeNamespace(prefix, namespaceName);
                    writer2.writeAttribute(prefix, namespaceName, reader2.getAttributeLocalName(i), reader2.getAttributeValue(i));
                    continue;
                }
                prefix = this.generateUniquePrefix(writer2.getNamespaceContext());
                writer2.writeNamespace(prefix, namespaceName);
                writer2.writeAttribute(prefix, namespaceName, reader2.getAttributeLocalName(i), reader2.getAttributeValue(i));
                continue;
            }
            writer2.writeAttribute(reader2.getAttributeLocalName(i), reader2.getAttributeValue(i));
        }
    }

    private String generateUniquePrefix(NamespaceContext nsCtxt) {
        String prefix = NAMESPACE_PREFIX + namespaceSuffix++;
        while (nsCtxt.getNamespaceURI(prefix) != null) {
            prefix = NAMESPACE_PREFIX + namespaceSuffix++;
        }
        return prefix;
    }

    private void serializeNamespace(String prefix, String URI2, XMLStreamWriter writer2) throws XMLStreamException {
        String prefix1 = writer2.getPrefix(URI2);
        if (prefix1 == null) {
            writer2.writeNamespace(prefix, URI2);
            writer2.setPrefix(prefix, URI2);
        }
    }

    protected boolean serializeXOPInclude(XMLStreamReader reader2, XMLStreamWriter writer2) {
        MTOMXMLStreamWriter mtomWriter;
        String cid = ElementHelper.getContentID(reader2);
        DataHandler dh = this.getDataHandler(cid, (OMAttachmentAccessor)((Object)reader2));
        if (dh == null) {
            return false;
        }
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        OMText omText = omFactory.createOMText(dh, true);
        omText.setContentID(cid);
        MTOMXMLStreamWriter mTOMXMLStreamWriter = mtomWriter = writer2 instanceof MTOMXMLStreamWriter ? (MTOMXMLStreamWriter)writer2 : null;
        if (mtomWriter != null && mtomWriter.isOptimized() && mtomWriter.isOptimizedThreshold(omText)) {
            mtomWriter.writeOptimized(omText);
            return false;
        }
        omText.setOptimize(false);
        try {
            writer2.writeCharacters(omText.getText());
            return true;
        }
        catch (XMLStreamException e2) {
            return false;
        }
    }

    private DataHandler getDataHandler(String cid, OMAttachmentAccessor oaa) {
        DataHandler dh = null;
        String blobcid = cid;
        if (blobcid.startsWith("cid:")) {
            blobcid = blobcid.substring(4);
        }
        if (oaa != null) {
            dh = oaa.getDataHandler(blobcid);
        }
        if (dh == null) {
            blobcid = this.getNewCID(cid);
            if (blobcid.startsWith("cid:")) {
                blobcid = blobcid.substring(4);
            }
            if (oaa != null) {
                dh = oaa.getDataHandler(blobcid);
            }
        }
        return dh;
    }

    private String getNewCID(String cid) {
        String cid2;
        block2: {
            cid2 = cid;
            try {
                cid2 = URLDecoder.decode(cid, "UTF-8");
            }
            catch (Exception e2) {
                if (!this.log.isDebugEnabled()) break block2;
                this.log.debug("getNewCID decoding " + cid + " as UTF-8 decoding error: " + e2);
            }
        }
        return cid2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

