/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.traverse;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.traverse.OMChildrenIterator;

public class OMChildrenWithSpecificAttributeIterator
extends OMChildrenIterator {
    private QName attributeName;
    private String attributeValue;
    private boolean detach;
    private boolean doCaseSensitiveValueChecks = true;

    public OMChildrenWithSpecificAttributeIterator(OMNode currentChild, QName attributeName, String attributeValue, boolean detach) {
        super(currentChild);
        this.attributeName = attributeName;
        this.attributeValue = attributeValue;
        this.detach = detach;
    }

    public void setCaseInsensitiveValueChecks(boolean val2) {
        this.doCaseSensitiveValueChecks = val2;
    }

    public boolean hasNext() {
        if (this.currentChild == null) {
            return false;
        }
        boolean isMatchingNodeFound = false;
        boolean needToMoveForward = true;
        while (needToMoveForward) {
            if (this.currentChild instanceof OMElement) {
                OMAttribute attr = ((OMElement)this.currentChild).getAttribute(this.attributeName);
                if (attr != null && (this.doCaseSensitiveValueChecks ? attr.getAttributeValue().equals(this.attributeValue) : attr.getAttributeValue().equalsIgnoreCase(this.attributeValue))) {
                    isMatchingNodeFound = true;
                    needToMoveForward = false;
                    continue;
                }
                this.currentChild = this.currentChild.getNextOMSibling();
                needToMoveForward = this.currentChild != null;
                continue;
            }
            this.currentChild = this.currentChild.getNextOMSibling();
            needToMoveForward = this.currentChild != null;
        }
        return isMatchingNodeFound;
    }

    public Object next() {
        this.nextCalled = true;
        this.removeCalled = false;
        this.lastChild = this.currentChild;
        this.currentChild = this.currentChild.getNextOMSibling();
        if (this.lastChild != null && this.detach && this.lastChild.getParent() != null) {
            this.lastChild.detach();
        }
        return this.lastChild;
    }
}

