/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.util;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.serialize.StreamingOMSerializer;
import org.apache.axiom.om.util.CommonUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OMSerializerUtil {
    private static Log log = LogFactory.getLog(class$org$apache$axiom$om$impl$util$OMSerializerUtil == null ? (class$org$apache$axiom$om$impl$util$OMSerializerUtil = OMSerializerUtil.class$("org.apache.axiom.om.impl.util.OMSerializerUtil")) : class$org$apache$axiom$om$impl$util$OMSerializerUtil);
    private static boolean DEBUG_ENABLED = log.isDebugEnabled();
    private static boolean ADV_DEBUG_ENABLED = true;
    static long nsCounter = 0L;
    private static final String IS_SET_PREFIX_BEFORE_PROPERTY = "javax.xml.stream.XMLStreamWriter.isSetPrefixBeforeStartElement";
    private static boolean cache_isSetPrefixBeforeStartElement;
    private static XMLStreamWriter cache_isSetPrefixBeforeStartElement_writer;
    private static String semifore;
    static /* synthetic */ Class class$org$apache$axiom$om$impl$util$OMSerializerUtil;

    public static void serializeEndpart(XMLStreamWriter writer2) throws XMLStreamException {
        writer2.writeEndElement();
    }

    public static void serializeAttribute(OMAttribute attr, XMLStreamWriter writer2) throws XMLStreamException {
        OMNamespace ns2 = attr.getNamespace();
        String prefix = null;
        String namespaceName = null;
        if (ns2 != null) {
            prefix = ns2.getPrefix();
            namespaceName = ns2.getNamespaceURI();
            if (prefix != null) {
                writer2.writeAttribute(prefix, namespaceName, attr.getLocalName(), attr.getAttributeValue());
            } else {
                writer2.writeAttribute(namespaceName, attr.getLocalName(), attr.getAttributeValue());
            }
        } else {
            String localName = attr.getLocalName();
            String attributeValue = attr.getAttributeValue();
            writer2.writeAttribute(localName, attributeValue);
        }
    }

    public static void serializeNamespace(OMNamespace namespace2, XMLStreamWriter writer2) throws XMLStreamException {
        if (namespace2 == null) {
            return;
        }
        String uri = namespace2.getNamespaceURI();
        String prefix = namespace2.getPrefix();
        if (uri != null && !"".equals(uri)) {
            String prefixFromWriter = writer2.getPrefix(uri);
            if ("".equals(prefix) && "".equals(prefixFromWriter) && !uri.equals(writer2.getNamespaceContext().getNamespaceURI("")) || prefix != null && "".equals(prefix) && (prefixFromWriter == null || !prefix.equals(prefixFromWriter))) {
                writer2.writeDefaultNamespace(uri);
                writer2.setDefaultNamespace(uri);
            } else {
                String string2 = prefix = prefix == null ? OMSerializerUtil.getNextNSPrefix(writer2) : prefix;
                if (prefix != null && !prefix.equals(prefixFromWriter) && !OMSerializerUtil.checkForPrefixInTheCurrentContext(writer2, uri, prefix)) {
                    writer2.writeNamespace(prefix, uri);
                    writer2.setPrefix(prefix, uri);
                }
            }
        } else {
            String currentDefaultNSURI = writer2.getNamespaceContext().getNamespaceURI("");
            if (currentDefaultNSURI != null && !currentDefaultNSURI.equals(uri) || uri != null && !uri.equals(currentDefaultNSURI)) {
                writer2.writeDefaultNamespace(uri);
                writer2.setDefaultNamespace(uri);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSetPrefixBeforeStartElement(XMLStreamWriter writer2) {
        boolean ret;
        block14: {
            if (cache_isSetPrefixBeforeStartElement_writer == writer2) {
                String string2 = semifore;
                synchronized (string2) {
                    if (cache_isSetPrefixBeforeStartElement_writer == writer2) {
                        return cache_isSetPrefixBeforeStartElement;
                    }
                }
            }
            ret = false;
            try {
                Boolean value = (Boolean)writer2.getProperty(IS_SET_PREFIX_BEFORE_PROPERTY);
                if (value == null) break block14;
                ret = value;
                String string3 = semifore;
                synchronized (string3) {
                    cache_isSetPrefixBeforeStartElement_writer = writer2;
                    cache_isSetPrefixBeforeStartElement = ret;
                }
                return ret;
            }
            catch (IllegalArgumentException e2) {
                // empty catch block
            }
        }
        if (!ret) {
            NamespaceContext nc = writer2.getNamespaceContext();
            ret = nc == null || nc.getClass().getName().indexOf("wstx") == -1 && nc.getClass().getName().indexOf("weblogic") == -1 && nc.getClass().getName().indexOf("sun") == -1;
        }
        String string4 = semifore;
        synchronized (string4) {
            cache_isSetPrefixBeforeStartElement_writer = writer2;
            cache_isSetPrefixBeforeStartElement = ret;
        }
        return ret;
    }

    public static void serializeStartpart(OMElement element, XMLStreamWriter writer2) throws XMLStreamException {
        OMSerializerUtil.serializeStartpart(element, element.getLocalName(), writer2);
    }

    public static void serializeStartpart(OMElement element, String localName, XMLStreamWriter writer2) throws XMLStreamException {
        String namespace2;
        String prefix;
        OMNamespace omNamespace;
        ArrayList<String> writePrefixList = null;
        ArrayList<String> writeNSList = null;
        OMNamespace eOMNamespace = element.getNamespace();
        String ePrefix = null;
        String eNamespace = null;
        if (eOMNamespace != null) {
            ePrefix = eOMNamespace.getPrefix();
            eNamespace = eOMNamespace.getNamespaceURI();
        }
        ePrefix = ePrefix != null && ePrefix.length() == 0 ? null : ePrefix;
        eNamespace = eNamespace != null && eNamespace.length() == 0 ? null : eNamespace;
        boolean setPrefixFirst = OMSerializerUtil.isSetPrefixBeforeStartElement(writer2);
        if (!setPrefixFirst) {
            if (eNamespace != null) {
                if (ePrefix == null) {
                    if (!OMSerializerUtil.isAssociated("", eNamespace, writer2)) {
                        if (writePrefixList == null) {
                            writePrefixList = new ArrayList<String>();
                            writeNSList = new ArrayList<String>();
                        }
                        if (!writePrefixList.contains("")) {
                            writePrefixList.add("");
                            writeNSList.add(eNamespace);
                        }
                    }
                    writer2.writeStartElement("", localName, eNamespace);
                } else {
                    if (!OMSerializerUtil.isAssociated(ePrefix, eNamespace, writer2)) {
                        if (writePrefixList == null) {
                            writePrefixList = new ArrayList();
                            writeNSList = new ArrayList();
                        }
                        if (!writePrefixList.contains(ePrefix)) {
                            writePrefixList.add(ePrefix);
                            writeNSList.add(eNamespace);
                        }
                    }
                    writer2.writeStartElement(ePrefix, localName, eNamespace);
                }
            } else {
                writer2.writeStartElement(localName);
            }
        }
        Iterator it = element.getAllDeclaredNamespaces();
        while (it != null && it.hasNext()) {
            String newPrefix;
            OMNamespace omNamespace2 = (OMNamespace)it.next();
            String prefix2 = null;
            String namespace3 = null;
            if (omNamespace2 != null) {
                prefix2 = omNamespace2.getPrefix();
                namespace3 = omNamespace2.getNamespaceURI();
            }
            if ((newPrefix = OMSerializerUtil.generateSetPrefix(prefix2 = prefix2 != null && prefix2.length() == 0 ? null : prefix2, namespace3 = namespace3 != null && namespace3.length() == 0 ? null : namespace3, writer2, false, setPrefixFirst)) == null) continue;
            if (writePrefixList == null) {
                writePrefixList = new ArrayList();
                writeNSList = new ArrayList();
            }
            if (writePrefixList.contains(newPrefix)) continue;
            writePrefixList.add(newPrefix);
            writeNSList.add(namespace3);
        }
        String newPrefix = OMSerializerUtil.generateSetPrefix(ePrefix, eNamespace, writer2, false, setPrefixFirst);
        if (newPrefix != null) {
            if (writePrefixList == null) {
                writePrefixList = new ArrayList();
                writeNSList = new ArrayList();
            }
            if (!writePrefixList.contains(newPrefix)) {
                writePrefixList.add(newPrefix);
                writeNSList.add(eNamespace);
            }
        }
        Iterator attrs = element.getAllAttributes();
        while (attrs != null && attrs.hasNext()) {
            OMAttribute attr = (OMAttribute)attrs.next();
            omNamespace = attr.getNamespace();
            prefix = null;
            namespace2 = null;
            if (omNamespace != null) {
                prefix = omNamespace.getPrefix();
                namespace2 = omNamespace.getNamespaceURI();
            }
            prefix = prefix != null && prefix.length() == 0 ? null : prefix;
            String string2 = namespace2 = namespace2 != null && namespace2.length() == 0 ? null : namespace2;
            if (prefix == null && namespace2 != null) {
                String writerPrefix = writer2.getPrefix(namespace2);
                writerPrefix = writerPrefix != null && writerPrefix.length() == 0 ? null : writerPrefix;
                String string3 = prefix = writerPrefix != null ? writerPrefix : OMSerializerUtil.getNextNSPrefix();
            }
            if ((newPrefix = OMSerializerUtil.generateSetPrefix(prefix, namespace2, writer2, true, setPrefixFirst)) == null) continue;
            if (writePrefixList == null) {
                writePrefixList = new ArrayList();
                writeNSList = new ArrayList();
            }
            if (writePrefixList.contains(newPrefix)) continue;
            writePrefixList.add(newPrefix);
            writeNSList.add(namespace2);
        }
        if (setPrefixFirst) {
            if (eNamespace != null) {
                if (ePrefix == null) {
                    writer2.writeStartElement("", localName, eNamespace);
                } else {
                    writer2.writeStartElement(ePrefix, localName, eNamespace);
                }
            } else {
                writer2.writeStartElement(localName);
            }
        }
        if (writePrefixList != null) {
            for (int i = 0; i < writePrefixList.size(); ++i) {
                String prefix3 = (String)writePrefixList.get(i);
                String namespace4 = (String)writeNSList.get(i);
                if (prefix3 != null) {
                    if (namespace4 == null) {
                        writer2.writeNamespace(prefix3, "");
                        continue;
                    }
                    writer2.writeNamespace(prefix3, namespace4);
                    continue;
                }
                writer2.writeDefaultNamespace(namespace4);
            }
        }
        attrs = element.getAllAttributes();
        while (attrs != null && attrs.hasNext()) {
            String writerPrefix;
            OMAttribute attr = (OMAttribute)attrs.next();
            omNamespace = attr.getNamespace();
            prefix = null;
            namespace2 = null;
            if (omNamespace != null) {
                prefix = omNamespace.getPrefix();
                namespace2 = omNamespace.getNamespaceURI();
            }
            prefix = prefix != null && prefix.length() == 0 ? null : prefix;
            String string4 = namespace2 = namespace2 != null && namespace2.length() == 0 ? null : namespace2;
            if (prefix == null && namespace2 != null) {
                prefix = writer2.getPrefix(namespace2);
                if (prefix == null || "".equals(prefix)) {
                    for (int i = 0; i < writePrefixList.size(); ++i) {
                        if (!namespace2.equals((String)writeNSList.get(i))) continue;
                        prefix = (String)writePrefixList.get(i);
                    }
                }
            } else if (namespace2 != null && !prefix.equals(writerPrefix = writer2.getPrefix(namespace2)) && writerPrefix != null && !"".equals(writerPrefix)) {
                prefix = writerPrefix;
            }
            if (namespace2 != null) {
                if (prefix == null && "http://www.w3.org/XML/1998/namespace".equals(namespace2)) {
                    prefix = "xml";
                }
                writer2.writeAttribute(prefix, namespace2, attr.getLocalName(), attr.getAttributeValue());
                continue;
            }
            writer2.writeAttribute(attr.getLocalName(), attr.getAttributeValue());
        }
    }

    private static boolean checkForPrefixInTheCurrentContext(XMLStreamWriter writer2, String nameSpaceName, String prefix) throws XMLStreamException {
        Iterator prefixesIter = writer2.getNamespaceContext().getPrefixes(nameSpaceName);
        while (prefixesIter.hasNext()) {
            String prefix_w = (String)prefixesIter.next();
            if (!prefix_w.equals(prefix)) continue;
            return true;
        }
        return false;
    }

    public static void serializeNamespaces(OMElement element, XMLStreamWriter writer2) throws XMLStreamException {
        Iterator namespaces = element.getAllDeclaredNamespaces();
        if (namespaces != null) {
            while (namespaces.hasNext()) {
                OMSerializerUtil.serializeNamespace((OMNamespace)namespaces.next(), writer2);
            }
        }
    }

    public static void serializeAttributes(OMElement element, XMLStreamWriter writer2) throws XMLStreamException {
        Iterator attributes = element.getAllAttributes();
        if (attributes != null && attributes.hasNext()) {
            while (attributes.hasNext()) {
                OMSerializerUtil.serializeAttribute((OMAttribute)attributes.next(), writer2);
            }
        }
    }

    public static void serializeNormal(OMElement element, XMLStreamWriter writer2, boolean cache) throws XMLStreamException {
        if (cache) {
            element.build();
        }
        OMSerializerUtil.serializeStartpart(element, writer2);
        OMNode firstChild = element.getFirstOMChild();
        if (firstChild != null) {
            if (cache) {
                firstChild.serialize(writer2);
            } else {
                firstChild.serializeAndConsume(writer2);
            }
        }
        OMSerializerUtil.serializeEndpart(writer2);
    }

    public static void serializeByPullStream(OMElement element, XMLStreamWriter writer2) throws XMLStreamException {
        OMSerializerUtil.serializeByPullStream(element, writer2, false);
    }

    public static void serializeByPullStream(OMElement element, XMLStreamWriter writer2, boolean cache) throws XMLStreamException {
        StreamingOMSerializer streamingOMSerializer = new StreamingOMSerializer();
        if (cache) {
            streamingOMSerializer.serialize(element.getXMLStreamReader(), writer2);
        } else {
            XMLStreamReader xmlStreamReaderWithoutCaching = element.getXMLStreamReaderWithoutCaching();
            streamingOMSerializer.serialize(xmlStreamReaderWithoutCaching, writer2);
        }
    }

    public static String getNextNSPrefix() {
        String prefix = "axis2ns" + ++nsCounter % Long.MAX_VALUE;
        if (DEBUG_ENABLED) {
            log.debug("Obtained next prefix:" + prefix);
            if (ADV_DEBUG_ENABLED && log.isTraceEnabled()) {
                log.trace(CommonUtils.callStackToString());
            }
        }
        return prefix;
    }

    public static String getNextNSPrefix(XMLStreamWriter writer2) {
        String prefix = OMSerializerUtil.getNextNSPrefix();
        while (writer2.getNamespaceContext().getNamespaceURI(prefix) != null) {
            prefix = OMSerializerUtil.getNextNSPrefix();
        }
        return prefix;
    }

    public static String generateSetPrefix(String prefix, String namespace2, XMLStreamWriter writer2, boolean attr, boolean isSetPrefixFirst) throws XMLStreamException {
        String string2 = prefix = prefix == null ? "" : prefix;
        if (OMSerializerUtil.isAssociated(prefix, namespace2, writer2)) {
            return null;
        }
        if (prefix.length() == 0 && namespace2 == null && attr) {
            return null;
        }
        String newPrefix = null;
        if (namespace2 != null) {
            if (prefix.length() == 0) {
                writer2.setDefaultNamespace(namespace2);
                newPrefix = "";
            } else {
                writer2.setPrefix(prefix, namespace2);
                newPrefix = prefix;
            }
        } else {
            writer2.setDefaultNamespace("");
            newPrefix = "";
        }
        return newPrefix;
    }

    public static boolean isAssociated(String prefix, String namespace2, XMLStreamWriter writer2) throws XMLStreamException {
        String writerNS;
        NamespaceContext nsContext;
        block8: {
            if ("xml".equals(prefix)) {
                return true;
            }
            prefix = prefix == null ? "" : prefix;
            String string2 = namespace2 = namespace2 == null ? "" : namespace2;
            if (namespace2.length() > 0) {
                NamespaceContext nsContext2;
                String writerPrefix = writer2.getPrefix(namespace2);
                if (prefix.equals(writerPrefix)) {
                    return true;
                }
                if (writerPrefix != null && (nsContext2 = writer2.getNamespaceContext()) != null) {
                    String writerNS2 = nsContext2.getNamespaceURI(prefix);
                    return namespace2.equals(writerNS2);
                }
                return false;
            }
            if (prefix.length() > 0) {
                return true;
            }
            try {
                String writerPrefix = writer2.getPrefix("");
                if (writerPrefix != null && writerPrefix.length() == 0) {
                    return true;
                }
            }
            catch (Throwable t) {
                if (!DEBUG_ENABLED) break block8;
                log.debug("Caught exception from getPrefix(\"\"). Processing continues: " + t);
            }
        }
        return (nsContext = writer2.getNamespaceContext()) == null || (writerNS = nsContext.getNamespaceURI("")) == null || writerNS.length() <= 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        cache_isSetPrefixBeforeStartElement_writer = null;
        semifore = "isSetPrefixBeforeStartElement";
    }
}

