/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.util;

import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.util.LogOutputStream;
import org.apache.commons.logging.Log;

public class CommonUtils {
    private CommonUtils() {
    }

    public static final String replace(String name2, String oldT, String newT) {
        if (name2 == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(name2.length() * 2);
        int len = oldT.length();
        try {
            int start = 0;
            int i = name2.indexOf(oldT, start);
            while (i >= 0) {
                sb.append(name2.substring(start, i));
                sb.append(newT);
                start = i + len;
                i = name2.indexOf(oldT, start);
            }
            if (start < name2.length()) {
                sb.append(name2.substring(start));
            }
        }
        catch (NullPointerException e2) {
            // empty catch block
        }
        return new String(sb);
    }

    public static String callStackToString() {
        return CommonUtils.stackToString(new RuntimeException());
    }

    public static String stackToString(Throwable e2) {
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        PrintWriter pw = new PrintWriter(bw);
        e2.printStackTrace(pw);
        pw.close();
        String text = sw.getBuffer().toString();
        text = text.substring(text.indexOf("at"));
        text = CommonUtils.replace(text, "at ", "DEBUG_FRAME = ");
        return text;
    }

    public static long logDebug(OMElement om, Log log) {
        return CommonUtils.logDebug(om, log, Integer.MAX_VALUE);
    }

    public static long logDebug(OMElement om, Log log, int limit) {
        OMOutputFormat format2 = new OMOutputFormat();
        format2.setDoOptimize(true);
        format2.setAutoCloseWriter(true);
        format2.setIgnoreXMLDeclaration(true);
        return CommonUtils.logDebug(om, log, limit, format2);
    }

    public static long logDebug(OMElement om, Log log, int limit, OMOutputFormat format2) {
        LogOutputStream logStream = new LogOutputStream(log, limit);
        try {
            om.serialize(logStream, format2);
            logStream.flush();
            logStream.close();
        }
        catch (Throwable t) {
            log.debug(t);
            log.error(t);
        }
        return logStream.getLength();
    }

    public static boolean isTextualPart(String contentType) {
        String ct = contentType.trim();
        return ct.startsWith("text/") || ct.startsWith("application/soap") || ct.startsWith("application/xml") || ct.indexOf("charset") != -1;
    }
}

