/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMText;

public class DigestGenerator {
    public static final String md5DigestAlgorithm = "MD5";
    public static final String shaDigestAlgorithm = "SHA";
    public static final String sha1DigestAlgorithm = "SHA1";

    public byte[] getDigest(OMDocument document, String digestAlgorithm) throws OMException {
        byte[] digest = new byte[]{};
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt(9);
            Collection childNodes = this.getValidElements(document);
            dos.writeInt(childNodes.size());
            Iterator itr = childNodes.iterator();
            while (itr.hasNext()) {
                OMNode node2 = (OMNode)itr.next();
                if (node2.getType() == 3) {
                    dos.write(this.getDigest((OMProcessingInstruction)node2, digestAlgorithm));
                    continue;
                }
                if (node2.getType() != 1) continue;
                dos.write(this.getDigest((OMElement)node2, digestAlgorithm));
            }
            dos.close();
            md.update(baos.toByteArray());
            digest = md.digest();
        }
        catch (NoSuchAlgorithmException e2) {
            throw new OMException(e2);
        }
        catch (IOException e3) {
            throw new OMException(e3);
        }
        return digest;
    }

    public byte[] getDigest(OMNode node2, String digestAlgorithm) {
        if (node2.getType() == 1) {
            return this.getDigest((OMElement)node2, digestAlgorithm);
        }
        if (node2.getType() == 4) {
            return this.getDigest((OMText)node2, digestAlgorithm);
        }
        if (node2.getType() == 3) {
            return this.getDigest((OMProcessingInstruction)node2, digestAlgorithm);
        }
        return new byte[0];
    }

    public byte[] getDigest(OMElement element, String digestAlgorithm) throws OMException {
        byte[] digest = new byte[]{};
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt(1);
            dos.write(this.getExpandedName(element).getBytes("UnicodeBigUnmarked"));
            dos.write(0);
            dos.write(0);
            Collection attrs = this.getAttributesWithoutNS(element);
            dos.writeInt(attrs.size());
            Iterator itr = attrs.iterator();
            while (itr.hasNext()) {
                dos.write(this.getDigest((OMAttribute)itr.next(), digestAlgorithm));
            }
            OMNode node2 = element.getFirstOMChild();
            int length = 0;
            itr = element.getChildElements();
            while (itr.hasNext()) {
                ++length;
                itr.next();
            }
            dos.writeInt(length);
            while (node2 != null) {
                dos.write(this.getDigest(node2, digestAlgorithm));
                node2 = node2.getNextOMSibling();
            }
            dos.close();
            md.update(baos.toByteArray());
            digest = md.digest();
        }
        catch (NoSuchAlgorithmException e2) {
            throw new OMException(e2);
        }
        catch (IOException e3) {
            throw new OMException(e3);
        }
        return digest;
    }

    public byte[] getDigest(OMProcessingInstruction pi, String digestAlgorithm) throws OMException {
        byte[] digest = new byte[]{};
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
            md.update((byte)0);
            md.update((byte)0);
            md.update((byte)0);
            md.update((byte)7);
            md.update(pi.getTarget().getBytes("UnicodeBigUnmarked"));
            md.update((byte)0);
            md.update((byte)0);
            md.update(pi.getValue().getBytes("UnicodeBigUnmarked"));
            digest = md.digest();
        }
        catch (NoSuchAlgorithmException e2) {
            throw new OMException(e2);
        }
        catch (UnsupportedEncodingException e3) {
            throw new OMException(e3);
        }
        return digest;
    }

    public byte[] getDigest(OMAttribute attribute, String digestAlgorithm) throws OMException {
        byte[] digest = new byte[]{};
        if (!attribute.getLocalName().equals("xmlns") && !attribute.getLocalName().startsWith("xmlns:")) {
            try {
                MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
                md.update((byte)0);
                md.update((byte)0);
                md.update((byte)0);
                md.update((byte)2);
                md.update(this.getExpandedName(attribute).getBytes("UnicodeBigUnmarked"));
                md.update((byte)0);
                md.update((byte)0);
                md.update(attribute.getAttributeValue().getBytes("UnicodeBigUnmarked"));
                digest = md.digest();
            }
            catch (NoSuchAlgorithmException e2) {
                throw new OMException(e2);
            }
            catch (UnsupportedEncodingException e3) {
                throw new OMException(e3);
            }
        }
        return digest;
    }

    public byte[] getDigest(OMText text, String digestAlgorithm) throws OMException {
        byte[] digest = new byte[]{};
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
            md.update((byte)0);
            md.update((byte)0);
            md.update((byte)0);
            md.update((byte)3);
            md.update(text.getText().getBytes("UnicodeBigUnmarked"));
            digest = md.digest();
        }
        catch (NoSuchAlgorithmException e2) {
            throw new OMException(e2);
        }
        catch (UnsupportedEncodingException e3) {
            throw new OMException(e3);
        }
        return digest;
    }

    public String getExpandedName(OMElement element) {
        return element.getNamespace().getNamespaceURI() + ":" + element.getLocalName();
    }

    public String getExpandedName(OMAttribute attribute) {
        return attribute.getNamespace().getNamespaceURI() + ":" + attribute.getLocalName();
    }

    public Collection getAttributesWithoutNS(OMElement element) {
        TreeMap<String, OMAttribute> map2 = new TreeMap<String, OMAttribute>();
        Iterator itr = element.getAllAttributes();
        while (itr.hasNext()) {
            OMAttribute attribute = (OMAttribute)itr.next();
            if (attribute.getLocalName().equals("xmlns") || attribute.getLocalName().startsWith("xmlns:")) continue;
            map2.put(this.getExpandedName(attribute), attribute);
        }
        return map2.values();
    }

    public Collection getValidElements(OMDocument document) {
        ArrayList<OMNode> list = new ArrayList<OMNode>();
        Iterator itr = document.getChildren();
        while (itr.hasNext()) {
            OMNode node2 = (OMNode)itr.next();
            if (node2.getType() != 1 && node2.getType() != 3) continue;
            list.add(node2);
        }
        return list;
    }

    public String getStringRepresentation(byte[] array2) {
        String str2 = "";
        for (int i = 0; i < array2.length; ++i) {
            str2 = str2 + array2[i];
        }
        return str2;
    }

    public boolean compareOMNode(OMNode node2, OMNode comparingNode, String digestAlgorithm) {
        return Arrays.equals(this.getDigest(node2, digestAlgorithm), this.getDigest(comparingNode, digestAlgorithm));
    }

    public boolean compareOMDocument(OMDocument document, OMDocument comparingDocument, String digestAlgorithm) {
        return Arrays.equals(this.getDigest(document, digestAlgorithm), this.getDigest(comparingDocument, digestAlgorithm));
    }

    public boolean compareOMAttribute(OMAttribute attribute, OMAttribute comparingAttribute, String digestAlgorithm) {
        return Arrays.equals(this.getDigest(attribute, digestAlgorithm), this.getDigest(comparingAttribute, digestAlgorithm));
    }
}

