/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Random;
import org.apache.axiom.om.OMException;

public class UUIDGenerator {
    private static String baseUUID = null;
    private static long incrementingValue = 0L;
    private static Random myRand = null;

    public static synchronized String getUUID() {
        if (baseUUID == null) {
            baseUUID = UUIDGenerator.getInitialUUID();
            baseUUID = "urn:uuid:" + baseUUID;
        }
        if (++incrementingValue >= Long.MAX_VALUE) {
            incrementingValue = 0L;
        }
        return baseUUID + (System.currentTimeMillis() + incrementingValue);
    }

    protected static String getInitialUUID() {
        String sid;
        if (myRand == null) {
            myRand = new Random();
        }
        long rand2 = myRand.nextLong();
        try {
            sid = InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException e2) {
            sid = Thread.currentThread().getName();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(sid);
        sb.append(":");
        sb.append(Long.toString(rand2));
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e3) {
            throw new OMException(e3);
        }
        md5.update(sb.toString().getBytes());
        byte[] array2 = md5.digest();
        StringBuffer sb2 = new StringBuffer();
        for (int j = 0; j < array2.length; ++j) {
            int b = array2[j] & 0xFF;
            sb2.append(Integer.toHexString(b));
        }
        int begin = myRand.nextInt();
        if (begin < 0) {
            begin *= -1;
        }
        return sb2.toString().substring(begin %= 8, begin + 18).toUpperCase();
    }

    public static void main(String[] args) {
        long startTime = new Date().getTime();
        for (int i = 0; i < 100000; ++i) {
            UUIDGenerator.getInitialUUID();
        }
        long endTime = new Date().getTime();
        System.out.println("getInitialUUID Difference = " + (endTime - startTime));
        startTime = new Date().getTime();
        for (int i = 0; i < 100000; ++i) {
            UUIDGenerator.getUUID();
        }
        endTime = new Date().getTime();
        System.out.println("getUUID Difference = " + (endTime - startTime));
    }
}

