/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.builder;

import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.exception.OMBuilderException;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;

public abstract class SOAPBuilderHelper {
    protected StAXSOAPModelBuilder builder;
    protected XMLStreamReader parser;

    protected SOAPBuilderHelper(StAXSOAPModelBuilder builder) {
        this.builder = builder;
    }

    public abstract OMElement handleEvent(XMLStreamReader var1, OMElement var2, int var3) throws SOAPProcessingException;

    protected void processNamespaceData(OMElement node2, boolean checkSOAPNamespace) {
        int namespaceCount = this.parser.getNamespaceCount();
        for (int i = 0; i < namespaceCount; ++i) {
            String namespaceURI = this.parser.getNamespaceURI(i);
            if (namespaceURI == null) continue;
            node2.declareNamespace(this.parser.getNamespaceURI(i), this.parser.getNamespacePrefix(i));
        }
        String namespaceURI = this.parser.getNamespaceURI();
        String prefix = this.parser.getPrefix();
        OMNamespace namespace2 = null;
        if (namespaceURI != null && namespaceURI.length() > 0) {
            if (prefix == null) {
                namespace2 = node2.findNamespace(namespaceURI, "");
                if (namespace2 == null) {
                    namespace2 = node2.declareNamespace(namespaceURI, "");
                }
            } else {
                namespace2 = node2.findNamespace(namespaceURI, prefix);
            }
            node2.setNamespace(namespace2);
        }
        if (checkSOAPNamespace && node2.getNamespace() != null && !node2.getNamespace().getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/") && !node2.getNamespace().getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope")) {
            throw new OMBuilderException("invalid SOAP namespace URI");
        }
    }

    protected void processAttributes(OMElement node2) {
        int attribCount = this.parser.getAttributeCount();
        for (int i = 0; i < attribCount; ++i) {
            OMNamespace ns2 = null;
            String uri = this.parser.getAttributeNamespace(i);
            if (uri != null && uri.hashCode() != 0) {
                ns2 = node2.findNamespace(uri, this.parser.getAttributePrefix(i));
            }
            node2.addAttribute(this.parser.getAttributeLocalName(i), this.parser.getAttributeValue(i), ns2);
        }
    }
}

