/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.functionalrenderer;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.coode.owlapi.functionalrenderer.OWLObjectRenderer;
import org.semanticweb.owlapi.io.OWLFunctionalSyntaxOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.util.AbstractOWLOntologyStorer;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.semanticweb.owlapi.vocab.PrefixOWLOntologyFormat;

public class OWLFunctionalSyntaxOntologyStorer
extends AbstractOWLOntologyStorer {
    private static final long serialVersionUID = 30406L;

    @Override
    public boolean canStoreOntology(OWLOntologyFormat ontologyFormat) {
        return ontologyFormat.equals(new OWLFunctionalSyntaxOntologyFormat());
    }

    @Override
    protected void storeOntology(OWLOntologyManager manager, OWLOntology ontology, Writer writer2, OWLOntologyFormat format2) throws OWLOntologyStorageException {
        this.storeOntology(ontology, writer2, format2);
    }

    @Override
    protected void storeOntology(OWLOntology ontology, Writer writer2, OWLOntologyFormat format2) throws OWLOntologyStorageException {
        try {
            OWLObjectRenderer ren = new OWLObjectRenderer(ontology, writer2);
            if (format2 instanceof PrefixOWLOntologyFormat) {
                PrefixOWLOntologyFormat prefixFormat = (PrefixOWLOntologyFormat)format2;
                DefaultPrefixManager man = new DefaultPrefixManager();
                Map<String, String> map2 = prefixFormat.getPrefixName2PrefixMap();
                for (Map.Entry<String, String> e2 : map2.entrySet()) {
                    man.setPrefix(e2.getKey(), e2.getValue());
                }
                ren.setPrefixManager(man);
            }
            ontology.accept(ren);
            writer2.flush();
        }
        catch (IOException e3) {
            throw new OWLOntologyStorageException(e3);
        }
    }
}

