/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.manchesterowlsyntax;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntax;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntaxOntologyFormat;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntaxOntologyHeader;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntaxParser;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntaxTokenizer;
import org.coode.owlapi.manchesterowlsyntax.OntologyAxiomPair;
import org.semanticweb.owlapi.expression.OWLEntityChecker;
import org.semanticweb.owlapi.expression.OWLOntologyChecker;
import org.semanticweb.owlapi.expression.ParserException;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyCharacteristicAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNaryPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyCharacteristicAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLQuantifiedObjectRestriction;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.semanticweb.owlapi.util.NamespaceUtil;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLFacet;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.semanticweb.owlapi.vocab.SWRLBuiltInsVocabulary;
import org.semanticweb.owlapi.vocab.XSDVocabulary;

public class ManchesterOWLSyntaxEditorParser
implements ManchesterOWLSyntaxParser {
    private OWLOntologyLoaderConfiguration configuration;
    protected OWLDataFactory dataFactory;
    private List<ManchesterOWLSyntaxTokenizer.Token> tokens;
    private int tokenIndex;
    private OWLEntityChecker owlEntityChecker;
    private OWLOntologyChecker owlOntologyChecker = new OWLOntologyChecker(){

        @Override
        public OWLOntology getOntology(String name2) {
            return null;
        }
    };
    protected Set<String> classNames = new HashSet<String>();
    protected Set<String> objectPropertyNames = new HashSet<String>();
    protected Set<String> dataPropertyNames = new HashSet<String>();
    protected Set<String> individualNames = new HashSet<String>();
    protected Set<String> dataTypeNames = new HashSet<String>();
    protected Set<String> annotationPropertyNames = new HashSet<String>();
    private Map<String, SWRLBuiltInsVocabulary> ruleBuiltIns = new TreeMap<String, SWRLBuiltInsVocabulary>();
    protected DefaultPrefixManager pm = new DefaultPrefixManager();
    protected Set<ManchesterOWLSyntax> potentialKeywords = new HashSet<ManchesterOWLSyntax>();
    private OWLOntology defaultOntology = null;
    private boolean allowEmptyFrameSections = false;
    private Map<ManchesterOWLSyntax, AnnotatedListItemParser<OWLDataProperty, ?>> dataPropertyFrameSections = new HashMap();
    private Map<ManchesterOWLSyntax, AnnotatedListItemParser<OWLClass, ?>> classFrameSections = new HashMap();
    private Map<ManchesterOWLSyntax, AnnotatedListItemParser<OWLObjectProperty, ?>> objectPropertyFrameSections = new HashMap();
    private Map<ManchesterOWLSyntax, AnnotatedListItemParser<OWLAnnotationProperty, ?>> annotationPropertyFrameSections = new HashMap();
    private Map<ManchesterOWLSyntax, AnnotatedListItemParser<OWLIndividual, ?>> individualFrameSections = new HashMap();
    private Map<String, IRI> nameIRIMap = new HashMap<String, IRI>();

    public ManchesterOWLSyntaxEditorParser(OWLDataFactory dataFactory, String s) {
        this(new OWLOntologyLoaderConfiguration(), dataFactory, s);
    }

    public ManchesterOWLSyntaxEditorParser(OWLOntologyLoaderConfiguration configuration, OWLDataFactory dataFactory, String s) {
        this.configuration = configuration;
        this.dataFactory = dataFactory;
        this.pm.setPrefix("rdf:", Namespaces.RDF.toString());
        this.pm.setPrefix("rdfs:", Namespaces.RDFS.toString());
        this.pm.setPrefix("owl:", Namespaces.OWL.toString());
        this.pm.setPrefix("dc:", "http://purl.org/dc/elements/1.1/");
        NamespaceUtil u = new NamespaceUtil();
        this.initialiseClassFrameSections();
        this.initialiseObjectPropertyFrameSections();
        this.initialiseDataPropertyFrameSections();
        this.initialiseAnnotationPropertyFrameSections();
        this.initialiseIndividualFrameSections();
        for (XSDVocabulary xSDVocabulary : XSDVocabulary.values()) {
            this.dataTypeNames.add(xSDVocabulary.getIRI().toString());
            this.dataTypeNames.add(xSDVocabulary.getIRI().toQuotedString());
            this.dataTypeNames.add("xsd:" + xSDVocabulary.getIRI().getFragment());
        }
        this.dataTypeNames.add("rdfs:" + OWLRDFVocabulary.RDFS_LITERAL.getIRI().getFragment());
        this.dataTypeNames.add(OWLRDFVocabulary.RDF_XML_LITERAL.getIRI().getFragment());
        this.dataTypeNames.add("rdf:" + OWLRDFVocabulary.RDF_XML_LITERAL.getIRI().getFragment());
        for (IRI iri : OWLRDFVocabulary.BUILT_IN_ANNOTATION_PROPERTY_IRIS) {
            String string2 = iri.toString();
            String string3 = XMLUtils.getNCNamePrefix(string2);
            String fragment = XMLUtils.getNCNameSuffix(string2);
            this.annotationPropertyNames.add(u.getPrefix(string3) + ":" + (fragment != null ? fragment : ""));
        }
        this.owlEntityChecker = new DefaultEntityChecker();
        this.tokens = new ArrayList<ManchesterOWLSyntaxTokenizer.Token>();
        this.tokens.addAll(this.getTokenizer(s).tokenize());
        this.tokenIndex = 0;
        for (Enum enum_ : SWRLBuiltInsVocabulary.values()) {
            this.ruleBuiltIns.put(((SWRLBuiltInsVocabulary)enum_).getShortName(), (SWRLBuiltInsVocabulary)enum_);
            this.ruleBuiltIns.put(((SWRLBuiltInsVocabulary)enum_).getIRI().toQuotedString(), (SWRLBuiltInsVocabulary)enum_);
        }
    }

    protected ManchesterOWLSyntaxTokenizer getTokenizer(String s) {
        return new ManchesterOWLSyntaxTokenizer(s);
    }

    private void initialiseClassFrameSections() {
        this.initialiseSection(new EntityAnnotationsListItemParser(), this.classFrameSections, new ManchesterOWLSyntax[0]);
        this.initialiseSection(new ClassSubClassOfListItemParser(), this.classFrameSections, new ManchesterOWLSyntax[0]);
        this.initialiseSection(new ClassEquivalentToListItemParser(), this.classFrameSections, new ManchesterOWLSyntax[0]);
        this.initialiseSection(new ClassDisjointWithListItemParser(), this.classFrameSections, new ManchesterOWLSyntax[0]);
        this.initialiseSection(new ClassHasKeyListItemParser(), this.classFrameSections, new ManchesterOWLSyntax[0]);
        this.initialiseSection(new ClassDisjointUnionOfListItemParser(), this.classFrameSections, new ManchesterOWLSyntax[0]);
        this.initialiseSection(new ClassSuperClassOfListItemParser(), this.classFrameSections, new ManchesterOWLSyntax[0]);
        this.initialiseSection(new ClassDisjointClassesListItemParser(), this.classFrameSections, new ManchesterOWLSyntax[0]);
        this.initialiseSection(new ClassIndividualsListItemParser(), this.classFrameSections, new ManchesterOWLSyntax[0]);
    }

    private void initialiseObjectPropertyFrameSections() {
        this.initialiseSection(new EntityAnnotationsListItemParser(), this.objectPropertyFrameSections, new ManchesterOWLSyntax[0]);
        this.initialiseSection(new ObjectPropertySubPropertyOfListItemParser(), this.objectPropertyFrameSections, new ManchesterOWLSyntax[0]);
        this.initialiseSection(new ObjectPropertyEquivalentToListItemParser(), this.objectPropertyFrameSections, new ManchesterOWLSyntax[0]);
        this.initialiseSection(new ObjectPropertyDisjointWithListItemParser(), this.objectPropertyFrameSections, new ManchesterOWLSyntax[0]);
        this.initialiseSection(new ObjectPropertyDomainListItemParser(), this.objectPropertyFrameSections, new ManchesterOWLSyntax[0]);
        this.initialiseSection(new ObjectPropertyRangeListItemParser(), this.objectPropertyFrameSections, new ManchesterOWLSyntax[0]);
        this.initialiseSection(new ObjectPropertyInverseOfListItemParser(), this.objectPropertyFrameSections, new ManchesterOWLSyntax[0]);
        this.initialiseSection(new ObjectPropertyCharacteristicsItemParser(), this.objectPropertyFrameSections, new ManchesterOWLSyntax[0]);
        this.initialiseSection(new ObjectPropertySubPropertyChainListItemParser(), this.objectPropertyFrameSections, new ManchesterOWLSyntax[0]);
        this.initialiseSection(new ObjectPropertySuperPropertyOfListItemParser(), this.objectPropertyFrameSections, new ManchesterOWLSyntax[0]);
    }

    private void initialiseDataPropertyFrameSections() {
        this.initialiseSection(new DataPropertySubPropertyOfListItemParser(), this.dataPropertyFrameSections, new ManchesterOWLSyntax[0]);
        this.initialiseSection(new DataPropertyEquivalentToListItemParser(), this.dataPropertyFrameSections, new ManchesterOWLSyntax[0]);
        this.initialiseSection(new DataPropertyDisjointWithListItemParser(), this.dataPropertyFrameSections, new ManchesterOWLSyntax[0]);
        this.initialiseSection(new DataPropertyDomainListItemParser(), this.dataPropertyFrameSections, new ManchesterOWLSyntax[0]);
        this.initialiseSection(new DataPropertyRangeListItemParser(), this.dataPropertyFrameSections, new ManchesterOWLSyntax[0]);
        this.initialiseSection(new DataPropertyCharacteristicsItemParser(), this.dataPropertyFrameSections, new ManchesterOWLSyntax[0]);
        this.initialiseSection(new EntityAnnotationsListItemParser(), this.dataPropertyFrameSections, new ManchesterOWLSyntax[0]);
    }

    private void initialiseAnnotationPropertyFrameSections() {
        this.initialiseSection(new AnnotationPropertySubPropertyOfListItemParser(), this.annotationPropertyFrameSections, new ManchesterOWLSyntax[0]);
        this.initialiseSection(new AnnotationPropertyDomainListItemParser(), this.annotationPropertyFrameSections, new ManchesterOWLSyntax[0]);
        this.initialiseSection(new AnnotationPropertyRangeListItemParser(), this.annotationPropertyFrameSections, new ManchesterOWLSyntax[0]);
        this.initialiseSection(new EntityAnnotationsListItemParser(), this.annotationPropertyFrameSections, new ManchesterOWLSyntax[0]);
    }

    private void initialiseIndividualFrameSections() {
        this.initialiseSection(new IndividualAnnotationItemParser(), this.individualFrameSections, new ManchesterOWLSyntax[0]);
        this.initialiseSection(new IndividualTypesItemParser(), this.individualFrameSections, new ManchesterOWLSyntax[0]);
        this.initialiseSection(new IndividualFactsItemParser(), this.individualFrameSections, new ManchesterOWLSyntax[0]);
        this.initialiseSection(new IndividualSameAsItemParser(), this.individualFrameSections, new ManchesterOWLSyntax[0]);
        this.initialiseSection(new IndividualDifferentFromItemParser(), this.individualFrameSections, new ManchesterOWLSyntax[0]);
        this.initialiseSection(new IndividualDifferentIndividualsItemParser(), this.individualFrameSections, new ManchesterOWLSyntax[0]);
    }

    @Override
    public void setOWLEntityChecker(OWLEntityChecker owlEntityChecker) {
        this.owlEntityChecker = owlEntityChecker;
    }

    private boolean isOntologyName(String name2) {
        return this.owlOntologyChecker.getOntology(name2) != null;
    }

    private boolean isClassName(String name2) {
        return this.classNames.contains(name2) || this.owlEntityChecker != null && this.owlEntityChecker.getOWLClass(name2) != null;
    }

    private OWLOntology getOntology(String name2) {
        return this.owlOntologyChecker.getOntology(name2);
    }

    @Override
    public void setOWLOntologyChecker(OWLOntologyChecker owlOntologyChecker) {
        this.owlOntologyChecker = owlOntologyChecker;
    }

    private boolean isObjectPropertyName(String name2) {
        return this.objectPropertyNames.contains(name2) || this.owlEntityChecker != null && this.owlEntityChecker.getOWLObjectProperty(name2) != null;
    }

    private boolean isAnnotationPropertyName(String name2) {
        return this.annotationPropertyNames.contains(name2) || this.owlEntityChecker != null && this.owlEntityChecker.getOWLAnnotationProperty(name2) != null;
    }

    private boolean isDataPropertyName(String name2) {
        return this.dataPropertyNames.contains(name2) || this.owlEntityChecker != null && this.owlEntityChecker.getOWLDataProperty(name2) != null;
    }

    private boolean isIndividualName(String name2) {
        return this.individualNames.contains(name2) || this.owlEntityChecker != null && this.owlEntityChecker.getOWLIndividual(name2) != null;
    }

    private boolean isDatatypeName(String name2) {
        return this.dataTypeNames.contains(name2) || this.owlEntityChecker != null && this.owlEntityChecker.getOWLDatatype(name2) != null;
    }

    private boolean isSWRLBuiltin(String name2) {
        return this.ruleBuiltIns.containsKey(name2);
    }

    private OWLClass getOWLClass(String name2) {
        OWLClass cls = this.owlEntityChecker.getOWLClass(name2);
        if (cls == null && this.classNames.contains(name2)) {
            cls = this.dataFactory.getOWLClass(this.getIRI(name2));
        }
        return cls;
    }

    private OWLObjectProperty getOWLObjectProperty(String name2) {
        OWLObjectProperty prop = this.owlEntityChecker.getOWLObjectProperty(name2);
        if (prop == null && this.objectPropertyNames.contains(name2)) {
            prop = this.dataFactory.getOWLObjectProperty(this.getIRI(name2));
        }
        return prop;
    }

    private OWLIndividual getOWLIndividual(String name2) {
        if (name2.startsWith("_:")) {
            return this.dataFactory.getOWLAnonymousIndividual(name2);
        }
        return this.getOWLNamedIndividual(name2);
    }

    private OWLNamedIndividual getOWLNamedIndividual(String name2) {
        OWLNamedIndividual ind = this.owlEntityChecker.getOWLIndividual(name2);
        if (ind == null && this.individualNames.contains(name2)) {
            ind = this.dataFactory.getOWLNamedIndividual(this.getIRI(name2));
        }
        return ind;
    }

    private OWLDataProperty getOWLDataProperty(String name2) {
        OWLDataProperty prop = this.owlEntityChecker.getOWLDataProperty(name2);
        if (prop == null && this.dataPropertyNames.contains(name2)) {
            prop = this.dataFactory.getOWLDataProperty(this.getIRI(name2));
        }
        return prop;
    }

    private OWLDatatype getOWLDatatype(String name2) {
        OWLDatatype dt = this.owlEntityChecker.getOWLDatatype(name2);
        if (dt == null && this.dataTypeNames.contains(name2)) {
            dt = this.dataFactory.getOWLDatatype(this.getIRI(name2));
        }
        return dt;
    }

    private OWLAnnotationProperty getOWLAnnotationProperty(String name2) {
        OWLAnnotationProperty prop = this.owlEntityChecker.getOWLAnnotationProperty(name2);
        if (prop == null && this.annotationPropertyNames.contains(name2)) {
            prop = this.dataFactory.getOWLAnnotationProperty(this.getIRI(name2));
        }
        return prop;
    }

    protected ManchesterOWLSyntaxTokenizer.Token getLastToken() {
        if (this.tokenIndex - 1 > -1) {
            return this.tokens.get(this.tokenIndex - 1);
        }
        return this.tokens.get(0);
    }

    private String peekToken() {
        return this.getToken().getToken();
    }

    private String consumeToken() {
        String token = this.getToken().getToken();
        if (this.tokenIndex < this.tokens.size() - 1) {
            ++this.tokenIndex;
        }
        return token;
    }

    private void consumeToken(String expected) {
        String tok = this.consumeToken();
        if (!tok.equals(expected)) {
            throw new ExceptionBuilder().withKeyword(expected).build();
        }
    }

    private void consumeToken(ManchesterOWLSyntax expected) {
        String tok = this.consumeToken();
        if (!expected.matches(tok)) {
            throw new ExceptionBuilder().withKeyword(expected).build();
        }
    }

    private ManchesterOWLSyntaxTokenizer.Token getToken() {
        return this.tokens.get(this.tokenIndex < this.tokens.size() ? this.tokenIndex : this.tokenIndex - 1);
    }

    @Override
    public OWLClassExpression parseClassExpression() throws ParserException {
        OWLClassExpression desc = this.parseUnion();
        if (!ManchesterOWLSyntaxTokenizer.EOF(this.consumeToken())) {
            throw new ExceptionBuilder().withKeyword("|EOF|").build();
        }
        return desc;
    }

    protected OWLClassExpression parseIntersection() {
        HashSet<OWLClassExpression> ops = new HashSet<OWLClassExpression>();
        String kw = ManchesterOWLSyntax.AND.keyword();
        while (ManchesterOWLSyntax.AND.matches(kw)) {
            this.potentialKeywords.remove((Object)ManchesterOWLSyntax.AND);
            ops.add(this.parseNonNaryClassExpression());
            this.potentialKeywords.add(ManchesterOWLSyntax.AND);
            kw = this.peekToken();
            if (ManchesterOWLSyntax.AND.matches(kw)) {
                kw = this.consumeToken();
                continue;
            }
            if (!ManchesterOWLSyntax.THAT.matches(kw)) continue;
            this.consumeToken();
            kw = ManchesterOWLSyntax.AND.keyword();
        }
        if (ops.size() == 1) {
            return (OWLClassExpression)ops.iterator().next();
        }
        return this.dataFactory.getOWLObjectIntersectionOf(ops);
    }

    protected OWLClassExpression parseUnion() {
        HashSet<OWLClassExpression> ops = new HashSet<OWLClassExpression>();
        String kw = ManchesterOWLSyntax.OR.keyword();
        while (ManchesterOWLSyntax.OR.matches(kw)) {
            this.potentialKeywords.remove((Object)ManchesterOWLSyntax.OR);
            ops.add(this.parseIntersection());
            this.potentialKeywords.add(ManchesterOWLSyntax.OR);
            kw = this.peekToken();
            if (!ManchesterOWLSyntax.OR.matches(kw)) continue;
            kw = this.consumeToken();
        }
        if (ops.size() == 1) {
            return (OWLClassExpression)ops.iterator().next();
        }
        return this.dataFactory.getOWLObjectUnionOf(ops);
    }

    protected OWLObjectPropertyExpression parseObjectPropertyExpression(boolean allowUndeclared) {
        String tok = this.consumeToken();
        if (ManchesterOWLSyntax.INVERSE.matches(tok)) {
            String close;
            String open = this.peekToken();
            boolean brackets = false;
            if (ManchesterOWLSyntax.OPEN.matches(open)) {
                this.consumeToken();
                brackets = true;
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression(false);
            if (brackets && !ManchesterOWLSyntax.CLOSE.matches(close = this.consumeToken())) {
                throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.CLOSE).build();
            }
            return this.dataFactory.getOWLObjectInverseOf(prop);
        }
        if (!allowUndeclared && !this.isObjectPropertyName(tok)) {
            throw new ExceptionBuilder().withObject().build();
        }
        return this.getOWLObjectProperty(tok);
    }

    private OWLPropertyExpression<?, ?> parsePropertyExpression() {
        String tok = this.peekToken();
        if (this.isObjectPropertyName(tok)) {
            return this.parseObjectPropertyExpression(false);
        }
        if (ManchesterOWLSyntax.INVERSE.matches(tok)) {
            return this.parseObjectPropertyExpression(false);
        }
        if (this.isDataPropertyName(tok)) {
            return this.parseDataProperty();
        }
        this.consumeToken();
        throw new ExceptionBuilder().withObject().withData().build();
    }

    private OWLClassExpression parseNonNaryClassExpression() {
        String tok = this.peekToken();
        if (ManchesterOWLSyntax.NOT.matches(tok)) {
            this.consumeToken();
            OWLClassExpression complemented = this.parseNestedClassExpression(false);
            return this.dataFactory.getOWLObjectComplementOf(complemented);
        }
        if (this.isObjectPropertyName(tok) || ManchesterOWLSyntax.INVERSE.matches(tok)) {
            return this.parseObjectRestriction();
        }
        if (this.isDataPropertyName(tok)) {
            return this.parseDataRestriction();
        }
        if (ManchesterOWLSyntax.OPENBRACE.matches(tok)) {
            return this.parseObjectOneOf();
        }
        if (ManchesterOWLSyntax.OPEN.matches(tok)) {
            return this.parseNestedClassExpression(false);
        }
        if (this.isClassName(tok)) {
            this.consumeToken();
            return this.getOWLClass(tok);
        }
        this.consumeToken();
        throw new ExceptionBuilder().withClass().withObject().withData().withKeyword(ManchesterOWLSyntax.OPEN, ManchesterOWLSyntax.OPENBRACE, ManchesterOWLSyntax.NOT, ManchesterOWLSyntax.INVERSE).build();
    }

    private OWLClassExpression parseObjectRestriction() {
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression(false);
        String kw = this.consumeToken();
        if (ManchesterOWLSyntax.SOME.matches(kw)) {
            String possSelfToken = this.peekToken();
            if (ManchesterOWLSyntax.SELF.matches(possSelfToken)) {
                this.consumeToken();
                return this.dataFactory.getOWLObjectHasSelf(prop);
            }
            OWLClassExpression filler = null;
            try {
                filler = this.parseNestedClassExpression(false);
            }
            catch (ParserException e2) {
                e2.getExpectedKeywords().add(ManchesterOWLSyntax.SELF.keyword());
                throw e2;
            }
            return this.dataFactory.getOWLObjectSomeValuesFrom(prop, filler);
        }
        if (ManchesterOWLSyntax.ONLY.matches(kw)) {
            OWLClassExpression filler = this.parseNestedClassExpression(false);
            return this.dataFactory.getOWLObjectAllValuesFrom(prop, filler);
        }
        if (ManchesterOWLSyntax.VALUE.matches(kw)) {
            String indName = this.consumeToken();
            if (!this.isIndividualName(indName)) {
                throw new ExceptionBuilder().withInd().build();
            }
            return this.dataFactory.getOWLObjectHasValue(prop, this.getOWLIndividual(indName));
        }
        if (ManchesterOWLSyntax.MIN.matches(kw)) {
            int card = this.parseInteger();
            OWLClassExpression filler = this.parseNestedClassExpression(true);
            if (filler != null) {
                return this.dataFactory.getOWLObjectMinCardinality(card, prop, filler);
            }
            return this.dataFactory.getOWLObjectMinCardinality(card, prop);
        }
        if (ManchesterOWLSyntax.MAX.matches(kw)) {
            int card = this.parseInteger();
            OWLClassExpression filler = this.parseNestedClassExpression(true);
            if (filler != null) {
                return this.dataFactory.getOWLObjectMaxCardinality(card, prop, filler);
            }
            return this.dataFactory.getOWLObjectMaxCardinality(card, prop);
        }
        if (ManchesterOWLSyntax.EXACTLY.matches(kw)) {
            int card = this.parseInteger();
            OWLClassExpression filler = this.parseNestedClassExpression(true);
            if (filler != null) {
                return this.dataFactory.getOWLObjectExactCardinality(card, prop, filler);
            }
            return this.dataFactory.getOWLObjectExactCardinality(card, prop);
        }
        if (ManchesterOWLSyntax.ONLYSOME.matches(kw)) {
            String tok = this.peekToken();
            HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
            if (!ManchesterOWLSyntax.OPENBRACKET.matches(tok)) {
                descs.add(this.parseUnion());
            } else {
                descs.addAll(this.parseClassExpressionList(ManchesterOWLSyntax.OPENBRACKET, ManchesterOWLSyntax.CLOSEBRACKET));
            }
            HashSet<OWLQuantifiedObjectRestriction> ops = new HashSet<OWLQuantifiedObjectRestriction>();
            for (OWLClassExpression desc : descs) {
                ops.add(this.dataFactory.getOWLObjectSomeValuesFrom(prop, desc));
            }
            OWLClassExpression filler = descs.size() == 1 ? (OWLClassExpression)descs.iterator().next() : this.dataFactory.getOWLObjectUnionOf(descs);
            ops.add(this.dataFactory.getOWLObjectAllValuesFrom(prop, filler));
            return this.dataFactory.getOWLObjectIntersectionOf(ops);
        }
        if (ManchesterOWLSyntax.SELF.matches(kw)) {
            return this.dataFactory.getOWLObjectHasSelf(prop);
        }
        throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.SOME, ManchesterOWLSyntax.ONLY, ManchesterOWLSyntax.VALUE, ManchesterOWLSyntax.MIN, ManchesterOWLSyntax.MAX, ManchesterOWLSyntax.EXACTLY, ManchesterOWLSyntax.SELF).build();
    }

    private OWLClassExpression parseDataRestriction() {
        OWLDataProperty prop = this.parseDataProperty();
        String kw = this.consumeToken();
        if (ManchesterOWLSyntax.SOME.matches(kw)) {
            OWLDataRange rng = this.parseDataRange();
            if (rng == null) {
                throw new ExceptionBuilder().withOnto().withInd().build();
            }
            return this.dataFactory.getOWLDataSomeValuesFrom(prop, rng);
        }
        if (ManchesterOWLSyntax.ONLY.matches(kw)) {
            OWLDataRange rng = this.parseDataRange();
            return this.dataFactory.getOWLDataAllValuesFrom(prop, rng);
        }
        if (ManchesterOWLSyntax.VALUE.matches(kw)) {
            OWLLiteral con = this.parseLiteral(null);
            return this.dataFactory.getOWLDataHasValue(prop, con);
        }
        if (ManchesterOWLSyntax.MIN.matches(kw)) {
            int card = this.parseInteger();
            OWLDataRange rng = this.parseDataRange();
            if (rng != null) {
                return this.dataFactory.getOWLDataMinCardinality(card, prop, rng);
            }
            return this.dataFactory.getOWLDataMinCardinality(card, prop);
        }
        if (ManchesterOWLSyntax.EXACTLY.matches(kw)) {
            int card = this.parseInteger();
            OWLDataRange rng = this.parseDataRange();
            if (rng != null) {
                return this.dataFactory.getOWLDataExactCardinality(card, prop, rng);
            }
            return this.dataFactory.getOWLDataExactCardinality(card, prop);
        }
        if (ManchesterOWLSyntax.MAX.matches(kw)) {
            int card = this.parseInteger();
            OWLDataRange rng = this.parseDataRange();
            if (rng != null) {
                return this.dataFactory.getOWLDataMaxCardinality(card, prop, rng);
            }
            return this.dataFactory.getOWLDataMaxCardinality(card, prop);
        }
        throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.SOME, ManchesterOWLSyntax.ONLY, ManchesterOWLSyntax.VALUE, ManchesterOWLSyntax.MIN, ManchesterOWLSyntax.EXACTLY, ManchesterOWLSyntax.MAX).build();
    }

    private OWLFacet parseFacet() {
        String facet = this.consumeToken();
        if (ManchesterOWLSyntax.MIN_INCLUSIVE_FACET.matches(facet, this.peekToken())) {
            this.consumeToken();
            return OWLFacet.MIN_INCLUSIVE;
        }
        if (ManchesterOWLSyntax.MAX_INCLUSIVE_FACET.matches(facet, this.peekToken())) {
            this.consumeToken();
            return OWLFacet.MAX_INCLUSIVE;
        }
        if (ManchesterOWLSyntax.MIN_EXCLUSIVE_FACET.matches(facet)) {
            return OWLFacet.MIN_EXCLUSIVE;
        }
        if (ManchesterOWLSyntax.MAX_EXCLUSIVE_FACET.matches(facet)) {
            return OWLFacet.MAX_EXCLUSIVE;
        }
        return OWLFacet.getFacetBySymbolicName(facet);
    }

    private OWLDatatype parseDatatype() {
        String name2 = this.peekToken();
        OWLDatatype d = this.getOWLDatatype(name2);
        if (d != null) {
            this.consumeToken();
        }
        return d;
    }

    @Override
    public OWLDataRange parseDataRange() {
        return this.parseDataIntersectionOf();
    }

    private OWLDataRange parseDataIntersectionOf() {
        String sep = ManchesterOWLSyntax.AND.keyword();
        HashSet<OWLDataRange> ranges = new HashSet<OWLDataRange>();
        while (ManchesterOWLSyntax.AND.matches(sep)) {
            ranges.add(this.parseDataUnionOf());
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.AND.matches(sep)) continue;
            this.consumeToken();
        }
        if (ranges.size() == 1) {
            return (OWLDataRange)ranges.iterator().next();
        }
        return this.dataFactory.getOWLDataIntersectionOf(ranges);
    }

    private OWLDataRange parseDataUnionOf() {
        String sep = ManchesterOWLSyntax.OR.keyword();
        HashSet<OWLDataRange> ranges = new HashSet<OWLDataRange>();
        while (ManchesterOWLSyntax.OR.matches(sep)) {
            ranges.add(this.parseDataRangePrimary());
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.OR.matches(sep)) continue;
            this.consumeToken();
        }
        if (ranges.size() == 1) {
            return (OWLDataRange)ranges.iterator().next();
        }
        return this.dataFactory.getOWLDataUnionOf(ranges);
    }

    private OWLDataRange parseDataRangePrimary() {
        String tok = this.peekToken();
        if (this.isDatatypeName(tok)) {
            this.consumeToken();
            OWLDatatype datatype = this.getOWLDatatype(tok);
            String next2 = this.peekToken();
            if (ManchesterOWLSyntax.OPENBRACKET.matches(next2)) {
                this.consumeToken();
                String sep = ManchesterOWLSyntax.COMMA.keyword();
                HashSet<OWLFacetRestriction> facetRestrictions = new HashSet<OWLFacetRestriction>();
                while (ManchesterOWLSyntax.COMMA.matches(sep)) {
                    OWLFacet fv = this.parseFacet();
                    if (fv == null) {
                        throw new ExceptionBuilder().withKeyword(OWLFacet.getFacets()).build();
                    }
                    OWLLiteral con = this.parseLiteral(datatype);
                    facetRestrictions.add(this.dataFactory.getOWLFacetRestriction(fv, con));
                    sep = this.consumeToken();
                }
                if (!ManchesterOWLSyntax.CLOSEBRACKET.matches(sep)) {
                    throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.CLOSEBRACKET).build();
                }
                return this.dataFactory.getOWLDatatypeRestriction(datatype, facetRestrictions);
            }
            return datatype;
        }
        if (ManchesterOWLSyntax.NOT.matches(tok)) {
            return this.parseDataComplementOf();
        }
        if (ManchesterOWLSyntax.OPENBRACE.matches(tok)) {
            return this.parseDataOneOf();
        }
        if (ManchesterOWLSyntax.OPEN.matches(tok)) {
            this.consumeToken();
            OWLDataRange rng = this.parseDataRange();
            this.consumeToken(ManchesterOWLSyntax.CLOSE.keyword());
            return rng;
        }
        if (!ManchesterOWLSyntaxTokenizer.EOF(tok)) {
            this.consumeToken();
            throw new ExceptionBuilder().withDt().withKeyword(ManchesterOWLSyntax.OPENBRACE, ManchesterOWLSyntax.NOT).build();
        }
        return null;
    }

    private Set<OWLDataRange> parseDataRangeList() {
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        HashSet<OWLDataRange> ranges = new HashSet<OWLDataRange>();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            this.potentialKeywords.remove((Object)ManchesterOWLSyntax.COMMA);
            OWLDataRange rng = this.parseDataRange();
            ranges.add(rng);
            this.potentialKeywords.add(ManchesterOWLSyntax.COMMA);
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.COMMA.matches(sep)) continue;
            this.consumeToken();
        }
        return ranges;
    }

    private OWLDataRange parseDataOneOf() {
        this.consumeToken();
        HashSet<OWLLiteral> cons2 = new HashSet<OWLLiteral>();
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            OWLLiteral con = this.parseLiteral(null);
            cons2.add(con);
            sep = this.consumeToken();
        }
        if (!ManchesterOWLSyntax.CLOSEBRACE.matches(sep)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.COMMA, ManchesterOWLSyntax.CLOSEBRACE).build();
        }
        return this.dataFactory.getOWLDataOneOf(cons2);
    }

    private OWLDataRange parseDataComplementOf() {
        String not2 = this.consumeToken();
        if (!ManchesterOWLSyntax.NOT.matches(not2)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.NOT).build();
        }
        OWLDataRange complementedDataRange = this.parseDataRangePrimary();
        return this.dataFactory.getOWLDataComplementOf(complementedDataRange);
    }

    @Override
    @Deprecated
    public OWLLiteral parseConstant() {
        return this.parseLiteral(null);
    }

    @Override
    public OWLLiteral parseLiteral(OWLDatatype datatype) {
        String tok = this.consumeToken();
        if (tok.startsWith("\"")) {
            String lit = "";
            if (tok.length() > 2) {
                lit = tok.substring(1, tok.length() - 1);
            }
            if (this.peekToken().equals("^")) {
                this.consumeToken();
                if (!this.peekToken().equals("^")) {
                    throw new ExceptionBuilder().withKeyword("^").build();
                }
                this.consumeToken();
                return this.dataFactory.getOWLLiteral(lit, this.parseDatatype());
            }
            if (this.peekToken().startsWith("@")) {
                String lang = this.consumeToken().substring(1);
                return this.dataFactory.getOWLLiteral(lit, lang);
            }
            return this.dataFactory.getOWLLiteral(lit, "");
        }
        if (datatype != null) {
            return this.dataFactory.getOWLLiteral(tok, datatype);
        }
        try {
            int i = Integer.parseInt(tok);
            return this.dataFactory.getOWLLiteral(i);
        }
        catch (NumberFormatException e2) {
            if (tok.endsWith("f") || tok.endsWith("F")) {
                try {
                    float f = Float.parseFloat(tok.replace("INF", "Infinity").replace("inf", "Infinity"));
                    return this.dataFactory.getOWLLiteral(Float.toString(f).replace("Infinity", "INF"), OWL2Datatype.XSD_FLOAT);
                }
                catch (NumberFormatException e3) {
                    // empty catch block
                }
            }
            try {
                double d = Double.parseDouble(tok);
                OWLDatatype dt = this.parseDatatype();
                if (dt == null) {
                    return this.dataFactory.getOWLLiteral(tok, OWL2Datatype.XSD_DECIMAL);
                }
                return this.dataFactory.getOWLLiteral(d);
            }
            catch (NumberFormatException numberFormatException) {
                if (ManchesterOWLSyntax.LITERAL_TRUE.matches(tok)) {
                    return this.dataFactory.getOWLLiteral(true);
                }
                if (ManchesterOWLSyntax.LITERAL_FALSE.matches(tok)) {
                    return this.dataFactory.getOWLLiteral(false);
                }
                throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.LITERAL_TRUE, ManchesterOWLSyntax.LITERAL_FALSE, ManchesterOWLSyntax.LITERAL_INTEGER, ManchesterOWLSyntax.LITERAL_FLOAT, ManchesterOWLSyntax.LITERAL_DOUBLE, ManchesterOWLSyntax.LITERAL_LITERAL, ManchesterOWLSyntax.LITERAL_LIT_DATATYPE, ManchesterOWLSyntax.LITERAL_LIT_LANG).build();
            }
        }
    }

    private int parseInteger() {
        String i = this.consumeToken();
        try {
            return Integer.parseInt(i);
        }
        catch (NumberFormatException e2) {
            throw new ExceptionBuilder().withInt().build();
        }
    }

    private OWLClassExpression parseNestedClassExpression(boolean lookaheadCheck) {
        String tok = this.peekToken();
        if (ManchesterOWLSyntax.OPEN.matches(tok)) {
            this.consumeToken();
            OWLClassExpression desc = this.parseUnion();
            String closeBracket = this.consumeToken();
            if (!ManchesterOWLSyntax.CLOSE.matches(closeBracket)) {
                throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.CLOSE).build();
            }
            return desc;
        }
        if (ManchesterOWLSyntax.OPENBRACE.matches(tok)) {
            return this.parseObjectOneOf();
        }
        if (this.isClassName(tok)) {
            String name2 = this.consumeToken();
            return this.getOWLClass(name2);
        }
        if (!ManchesterOWLSyntaxTokenizer.EOF(tok) || !lookaheadCheck) {
            this.consumeToken();
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.OPEN, ManchesterOWLSyntax.OPENBRACE).withClass().build();
        }
        return null;
    }

    private OWLClassExpression parseObjectOneOf() {
        String open = this.consumeToken();
        if (!ManchesterOWLSyntax.OPENBRACE.matches(open)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.OPENBRACE).build();
        }
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            inds.add(this.parseIndividual());
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.COMMA.matches(sep)) continue;
            this.consumeToken();
        }
        String close = this.consumeToken();
        if (!ManchesterOWLSyntax.CLOSEBRACE.matches(close)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.CLOSEBRACE, ManchesterOWLSyntax.COMMA).build();
        }
        return this.dataFactory.getOWLObjectOneOf(inds);
    }

    private <F> void initialiseSection(AnnotatedListItemParser<F, ?> parser, Map<ManchesterOWLSyntax, AnnotatedListItemParser<F, ?>> map2, ManchesterOWLSyntax ... synonyms) {
        map2.put(parser.getFrameSectionKeyword(), parser);
        for (ManchesterOWLSyntax syn : synonyms) {
            map2.put(syn, parser);
        }
    }

    public Set<OntologyAxiomPair> parseFrames() throws ParserException {
        String tok;
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        HashSet<ManchesterOWLSyntax> possible = new HashSet<ManchesterOWLSyntax>();
        this.resetPossible(possible);
        while (true) {
            if (ManchesterOWLSyntax.CLASS.matches(tok = this.peekToken())) {
                this.potentialKeywords.clear();
                this.resetPossible(possible);
                axioms.addAll(this.parseClassFrame());
                possible.addAll(this.classFrameSections.keySet());
                continue;
            }
            if (ManchesterOWLSyntax.OBJECT_PROPERTY.matches(tok)) {
                this.potentialKeywords.clear();
                this.resetPossible(possible);
                axioms.addAll(this.parseObjectPropertyFrame());
                possible.addAll(this.objectPropertyFrameSections.keySet());
                continue;
            }
            if (ManchesterOWLSyntax.DATA_PROPERTY.matches(tok)) {
                this.potentialKeywords.clear();
                this.resetPossible(possible);
                axioms.addAll(this.parseDataPropertyFrame());
                possible.addAll(this.dataPropertyFrameSections.keySet());
                continue;
            }
            if (ManchesterOWLSyntax.ANNOTATION_PROPERTY.matches(tok)) {
                this.potentialKeywords.clear();
                this.resetPossible(possible);
                axioms.addAll(this.parseAnnotationPropertyFrame());
                possible.addAll(Arrays.asList(ManchesterOWLSyntax.SUB_PROPERTY_OF, ManchesterOWLSyntax.DOMAIN, ManchesterOWLSyntax.RANGE));
                continue;
            }
            if (ManchesterOWLSyntax.INDIVIDUAL.matches(tok)) {
                this.potentialKeywords.clear();
                this.resetPossible(possible);
                axioms.addAll(this.parseIndividualFrame());
                possible.addAll(Arrays.asList(ManchesterOWLSyntax.TYPES, ManchesterOWLSyntax.FACTS, ManchesterOWLSyntax.DIFFERENT_FROM, ManchesterOWLSyntax.SAME_AS));
                continue;
            }
            if (ManchesterOWLSyntax.DATATYPE.matches(tok)) {
                this.potentialKeywords.clear();
                this.resetPossible(possible);
                axioms.addAll(this.parseDatatypeFrame());
                possible.add(ManchesterOWLSyntax.EQUIVALENT_TO);
                continue;
            }
            if (ManchesterOWLSyntax.VALUE_PARTITION.matches(tok)) {
                this.potentialKeywords.clear();
                this.resetPossible(possible);
                this.parseValuePartitionFrame();
                continue;
            }
            if (!ManchesterOWLSyntax.RULE.matches(tok)) break;
            this.potentialKeywords.clear();
            this.resetPossible(possible);
            axioms.addAll(this.parseRuleFrame());
        }
        if (!ManchesterOWLSyntaxTokenizer.EOF(tok)) {
            this.consumeToken();
            throw new ExceptionBuilder().withKeyword(possible).build();
        }
        return axioms;
    }

    private Set<OntologyAxiomPair> parseDatatypeFrame() {
        String tok = this.consumeToken();
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        if (!ManchesterOWLSyntax.DATATYPE.matches(tok)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.DATATYPE).build();
        }
        String subj = this.consumeToken();
        OWLDatatype datatype = this.getOWLDatatype(subj);
        if (datatype == null) {
            throw new ExceptionBuilder().withDt().build();
        }
        axioms.add(new OntologyAxiomPair(this.defaultOntology, this.dataFactory.getOWLDeclarationAxiom(datatype)));
        block0: while (true) {
            String sect;
            if (ManchesterOWLSyntax.EQUIVALENT_TO.matches(sect = this.peekToken())) {
                this.potentialKeywords.clear();
                this.consumeToken();
                Set<OWLOntology> onts = this.getOntologies();
                Set<OWLDataRange> drs = this.parseDataRangeList();
                Iterator<OWLOntology> i$ = onts.iterator();
                block1: while (true) {
                    if (!i$.hasNext()) continue block0;
                    OWLOntology ont = i$.next();
                    Iterator<OWLDataRange> i$2 = drs.iterator();
                    while (true) {
                        if (!i$2.hasNext()) continue block1;
                        OWLDataRange dr = i$2.next();
                        axioms.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLDatatypeDefinitionAxiom(datatype, dr)));
                    }
                    break;
                }
            }
            if (!ManchesterOWLSyntax.ANNOTATIONS.matches(sect)) break;
            this.potentialKeywords.clear();
            axioms.addAll(this.parseAnnotations(datatype.getIRI()));
        }
        return axioms;
    }

    private void resetPossible(Set<ManchesterOWLSyntax> possible) {
        possible.clear();
        possible.add(ManchesterOWLSyntax.ANNOTATIONS);
        possible.add(ManchesterOWLSyntax.ANNOTATION_PROPERTY);
        possible.add(ManchesterOWLSyntax.CLASS);
        possible.add(ManchesterOWLSyntax.OBJECT_PROPERTY);
        possible.add(ManchesterOWLSyntax.DATATYPE);
        possible.add(ManchesterOWLSyntax.DATA_PROPERTY);
        possible.add(ManchesterOWLSyntax.INDIVIDUAL);
        possible.add(ManchesterOWLSyntax.VALUE_PARTITION);
        possible.add(ManchesterOWLSyntax.RULE);
    }

    private Set<OntologyAxiomPair> parseNaryEquivalentClasses() {
        String tok = this.consumeToken();
        if (!ManchesterOWLSyntax.EQUIVALENT_CLASSES.matches(tok)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.EQUIVALENT_CLASSES).build();
        }
        Set<OWLOntology> ontologies = this.getOntologies();
        Set<OWLAnnotation> annotations = this.parseAnnotations();
        Set<OWLClassExpression> classExpressions = this.parseClassExpressionList();
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        for (OWLOntology ont : ontologies) {
            pairs.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLEquivalentClassesAxiom(classExpressions, annotations)));
        }
        return pairs;
    }

    private Set<OntologyAxiomPair> parseNaryEquivalentProperties() {
        OWLNaryPropertyAxiom<OWLObjectPropertyExpression> propertyAxiom;
        String tok = this.consumeToken();
        if (!ManchesterOWLSyntax.EQUIVALENT_PROPERTIES.matches(tok)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.EQUIVALENT_PROPERTIES).build();
        }
        Set<OWLOntology> ontologies = this.getOntologies();
        Set<OWLAnnotation> annotations = this.parseAnnotations();
        Set<OWLPropertyExpression<?, ?>> properties = this.parsePropertyList();
        if (properties.iterator().next().isObjectPropertyExpression()) {
            HashSet<OWLObjectPropertyExpression> ope = new HashSet<OWLObjectPropertyExpression>();
            for (OWLPropertyExpression<?, ?> pe : properties) {
                ope.add((OWLObjectPropertyExpression)pe);
            }
            propertyAxiom = this.dataFactory.getOWLEquivalentObjectPropertiesAxiom(ope, annotations);
        } else {
            HashSet<OWLDataPropertyExpression> dpe = new HashSet<OWLDataPropertyExpression>();
            for (OWLPropertyExpression<?, ?> pe : properties) {
                dpe.add((OWLDataPropertyExpression)pe);
            }
            propertyAxiom = this.dataFactory.getOWLEquivalentDataPropertiesAxiom(dpe, annotations);
        }
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        for (OWLOntology ont : ontologies) {
            pairs.add(new OntologyAxiomPair(ont, propertyAxiom));
        }
        return pairs;
    }

    private Set<OWLAnnotation> parseAnnotations() {
        String next2 = this.peekToken();
        Set<OWLAnnotation> annotations = Collections.emptySet();
        if (ManchesterOWLSyntax.ANNOTATIONS.matches(next2)) {
            this.consumeToken();
            annotations = this.parseAnnotationList();
        }
        return annotations;
    }

    private Set<OntologyAxiomPair> parseAnnotations(OWLAnnotationSubject s) {
        String header = this.consumeToken();
        if (!ManchesterOWLSyntax.ANNOTATIONS.matches(header)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.ANNOTATIONS).build();
        }
        Set<OWLOntology> onts = this.getOntologies();
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        Set<OWLAnnotation> annos = this.parseAnnotationList();
        for (OWLOntology ont : onts) {
            for (OWLAnnotation anno : annos) {
                if (!this.configuration.isLoadAnnotationAxioms()) continue;
                pairs.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLAnnotationAssertionAxiom(s, anno)));
            }
        }
        return pairs;
    }

    private Set<OWLAnnotation> parseAnnotationList() {
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        HashSet<OWLAnnotation> annos = new HashSet<OWLAnnotation>();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            this.potentialKeywords.clear();
            Set<OWLAnnotation> annotations = this.parseAnnotations();
            OWLAnnotation anno = this.parseAnnotation();
            if (anno != null) {
                anno = anno.getAnnotatedAnnotation(annotations);
                annos.add(anno);
            }
            if (!ManchesterOWLSyntax.COMMA.matches(sep = this.peekToken())) continue;
            this.consumeToken();
        }
        return annos;
    }

    protected OWLAnnotation parseAnnotation() {
        OWLAnnotationProperty annoProp = this.parseAnnotationProperty();
        String obj = this.peekToken();
        OWLAnnotation anno = null;
        if (this.isIndividualName(obj) || this.isClassName(obj) || this.isObjectPropertyName(obj) || this.isDataPropertyName(obj)) {
            this.consumeToken();
            OWLAnnotationValue value = obj.startsWith("_:") ? this.dataFactory.getOWLAnonymousIndividual(obj) : this.getIRI(obj);
            anno = this.dataFactory.getOWLAnnotation(annoProp, value);
        } else if (obj.startsWith("<")) {
            IRI value = this.parseIRI();
            anno = this.dataFactory.getOWLAnnotation(annoProp, value);
        } else {
            OWLLiteral con = this.parseLiteral(null);
            anno = this.dataFactory.getOWLAnnotation(annoProp, con);
        }
        return anno;
    }

    private Set<OntologyAxiomPair> parseClassFrame() {
        return this.parseClassFrame(false);
    }

    @Override
    public Set<OntologyAxiomPair> parseClassFrameEOF() throws ParserException {
        return this.parseClassFrame(true);
    }

    private Set<OntologyAxiomPair> parseClassFrame(boolean eof) {
        String tok = this.consumeToken();
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        if (!ManchesterOWLSyntax.CLASS.matches(tok)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.CLASS).build();
        }
        String subj = this.consumeToken();
        OWLClass cls = this.getOWLClass(subj);
        if (cls == null) {
            throw new ExceptionBuilder().withClass().build();
        }
        axioms.add(new OntologyAxiomPair(this.defaultOntology, this.dataFactory.getOWLDeclarationAxiom(cls)));
        this.parseFrameSections(eof, axioms, cls, this.classFrameSections);
        return axioms;
    }

    private Set<OWLOntology> parseOntologyList() {
        this.potentialKeywords.clear();
        this.consumeToken(ManchesterOWLSyntax.OPENBRACKET.keyword());
        this.consumeToken("in");
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        HashSet<OWLOntology> onts = new HashSet<OWLOntology>();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            String tok = this.consumeToken();
            if (this.isOntologyName(tok)) {
                OWLOntology ont = this.getOntology(tok);
                if (ont != null) {
                    onts.add(ont);
                }
            } else {
                throw new ExceptionBuilder().withOnto().build();
            }
            sep = this.consumeToken();
            if (sep.equals(ManchesterOWLSyntax.CLOSEBRACKET.keyword())) break;
            if (ManchesterOWLSyntax.COMMA.matches(sep)) continue;
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.COMMA, ManchesterOWLSyntax.CLOSEBRACKET).build();
        }
        return onts;
    }

    private Set<OWLOntology> getOntologies() {
        if (this.peekToken().equals(ManchesterOWLSyntax.OPENBRACKET.keyword())) {
            return this.parseOntologyList();
        }
        return Collections.singleton(this.defaultOntology);
    }

    public void setDefaultOntology(OWLOntology defaultOntology) {
        this.defaultOntology = defaultOntology;
    }

    private boolean isEmptyFrameSection(Map<ManchesterOWLSyntax, ?> parsers) {
        if (!this.allowEmptyFrameSections) {
            return false;
        }
        String next2 = this.peekToken();
        return !ManchesterOWLSyntax.ANNOTATIONS.matches(next2) && (parsers.containsKey((Object)ManchesterOWLSyntax.parse(next2)) || ManchesterOWLSyntaxTokenizer.EOF(next2));
    }

    private <F> void parseFrameSections(boolean eof, Set<OntologyAxiomPair> axioms, F frameSubject, Map<ManchesterOWLSyntax, AnnotatedListItemParser<F, ?>> sectionParsers) {
        String sect;
        AnnotatedListItemParser<F, ?> parser;
        while ((parser = sectionParsers.get((Object)ManchesterOWLSyntax.parse(sect = this.peekToken()))) != null) {
            this.consumeToken();
            Set<OWLOntology> onts = this.getOntologies();
            if (this.isEmptyFrameSection(sectionParsers)) continue;
            axioms.addAll(this.parseAnnotatedListItems(frameSubject, parser, onts));
        }
        if (eof && !ManchesterOWLSyntaxTokenizer.EOF(sect)) {
            ArrayList<ManchesterOWLSyntax> expected = new ArrayList<ManchesterOWLSyntax>();
            expected.addAll(sectionParsers.keySet());
            if (frameSubject instanceof OWLAnnotationSubject || frameSubject instanceof OWLEntity) {
                expected.add(ManchesterOWLSyntax.ANNOTATIONS);
            }
            throw new ExceptionBuilder().withKeyword(expected).build();
        }
    }

    private Set<OntologyAxiomPair> parseObjectPropertyFrame() {
        return this.parseObjectPropertyFrame(false);
    }

    private Set<OntologyAxiomPair> parseObjectPropertyFrame(boolean eof) {
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        this.consumeToken(ManchesterOWLSyntax.OBJECT_PROPERTY);
        String token = this.consumeToken();
        OWLObjectProperty prop = this.getOWLObjectProperty(token);
        if (prop == null) {
            throw new ExceptionBuilder().withObject().build();
        }
        if (!prop.isAnonymous()) {
            axioms.add(new OntologyAxiomPair(this.defaultOntology, this.dataFactory.getOWLDeclarationAxiom(prop.asOWLObjectProperty())));
        }
        this.parseFrameSections(eof, axioms, prop, this.objectPropertyFrameSections);
        return axioms;
    }

    private Set<OntologyAxiomPair> parseDataPropertyFrame() {
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        String tok = this.consumeToken();
        if (!ManchesterOWLSyntax.DATA_PROPERTY.matches(tok)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.DATA_PROPERTY).build();
        }
        String subj = this.consumeToken();
        OWLDataProperty prop = this.getOWLDataProperty(subj);
        if (prop == null) {
            throw new ExceptionBuilder().withData().build();
        }
        axioms.add(new OntologyAxiomPair(this.defaultOntology, this.dataFactory.getOWLDeclarationAxiom(prop)));
        this.parseFrameSections(false, axioms, prop, this.dataPropertyFrameSections);
        return axioms;
    }

    private Set<OntologyAxiomPair> parseAnnotationPropertyFrame() {
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        String tok = this.consumeToken();
        if (!ManchesterOWLSyntax.ANNOTATION_PROPERTY.matches(tok)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.ANNOTATION_PROPERTY).build();
        }
        String subj = this.consumeToken();
        OWLAnnotationProperty prop = this.getOWLAnnotationProperty(subj);
        for (OWLOntology ont : this.getOntologies()) {
            axioms.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLDeclarationAxiom(prop)));
        }
        if (prop == null) {
            throw new ExceptionBuilder().withData().build();
        }
        this.parseFrameSections(false, axioms, prop, this.annotationPropertyFrameSections);
        return axioms;
    }

    private Set<OntologyAxiomPair> parseIndividualFrame() {
        String tok = this.consumeToken();
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        if (!ManchesterOWLSyntax.INDIVIDUAL.matches(tok)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.INDIVIDUAL).build();
        }
        String subj = this.consumeToken();
        OWLIndividual ind = this.getOWLIndividual(subj);
        if (ind == null) {
            throw new ExceptionBuilder().withInd().build();
        }
        if (!ind.isAnonymous()) {
            axioms.add(new OntologyAxiomPair(this.getOntology(null), this.dataFactory.getOWLDeclarationAxiom(ind.asOWLNamedIndividual())));
        }
        this.parseFrameSections(false, axioms, ind, this.individualFrameSections);
        return axioms;
    }

    protected OWLPropertyAssertionAxiom<?, ?> parseFact(OWLIndividual ind) {
        String prop;
        boolean negative = false;
        if (ManchesterOWLSyntax.NOT.matches(this.peekToken())) {
            this.consumeToken();
            negative = true;
        }
        if (this.isDataPropertyName(prop = this.peekToken())) {
            OWLDataProperty p = this.parseDataProperty();
            OWLLiteral con = this.parseLiteral(null);
            if (!negative) {
                return this.dataFactory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)p, ind, con);
            }
            return this.dataFactory.getOWLNegativeDataPropertyAssertionAxiom(p, ind, con);
        }
        if (this.isObjectPropertyName(prop)) {
            OWLObjectPropertyExpression p = this.parseObjectPropertyExpression(false);
            if (!negative) {
                return this.dataFactory.getOWLObjectPropertyAssertionAxiom(p, ind, this.parseIndividual());
            }
            return this.dataFactory.getOWLNegativeObjectPropertyAssertionAxiom(p, ind, this.parseIndividual());
        }
        this.consumeToken();
        throw new ExceptionBuilder().withObject().withData().build();
    }

    private Set<OntologyAxiomPair> parseValuePartitionFrame() {
        String section = this.consumeToken();
        if (!ManchesterOWLSyntax.VALUE_PARTITION.matches(section)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.VALUE_PARTITION).build();
        }
        Set<OWLOntology> onts = this.getOntologies();
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression(false);
        String clsName = this.consumeToken();
        if (ManchesterOWLSyntaxTokenizer.EOF(clsName)) {
            throw new ExceptionBuilder().withObject().build();
        }
        OWLClass cls = this.getOWLClass(clsName);
        if (cls == null) {
            throw new ExceptionBuilder().withClass().build();
        }
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        axioms.addAll(this.parseValuePartitionValues(onts, cls));
        for (OWLOntology ont : onts) {
            axioms.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLFunctionalObjectPropertyAxiom(prop)));
            axioms.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLObjectPropertyRangeAxiom(prop, cls)));
        }
        return axioms;
    }

    private Set<OntologyAxiomPair> parseValuePartitionValues(Set<OWLOntology> onts, OWLClass superclass) {
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        HashSet<OWLClass> siblings = new HashSet<OWLClass>();
        this.consumeToken(ManchesterOWLSyntax.OPENBRACKET.keyword());
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            String clsName = this.consumeToken();
            OWLClass cls = this.getOWLClass(clsName);
            if (cls == null) {
                throw new ExceptionBuilder().withKeyword(this.potentialKeywords).withClass().build();
            }
            siblings.add(cls);
            OWLSubClassOfAxiom ax = this.dataFactory.getOWLSubClassOfAxiom(cls, superclass);
            for (OWLOntology ont : onts) {
                axioms.add(new OntologyAxiomPair(ont, ax));
            }
            if (this.peekToken().equals(ManchesterOWLSyntax.OPENBRACKET.keyword())) {
                axioms.addAll(this.parseValuePartitionValues(onts, cls));
            }
            if (!ManchesterOWLSyntax.COMMA.matches(sep = this.peekToken())) continue;
            this.consumeToken();
        }
        this.consumeToken(ManchesterOWLSyntax.CLOSEBRACKET.keyword());
        OWLDisjointClassesAxiom ax = this.dataFactory.getOWLDisjointClassesAxiom(siblings);
        for (OWLOntology ont : onts) {
            axioms.add(new OntologyAxiomPair(ont, ax));
        }
        return axioms;
    }

    @Override
    public List<OntologyAxiomPair> parseRuleFrame() {
        String section = this.consumeToken();
        if (!ManchesterOWLSyntax.RULE.matches(section)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.RULE).build();
        }
        Set<OWLOntology> ontologies = this.getOntologies();
        List<SWRLAtom> body = this.parseRuleAtoms();
        String tok = this.consumeToken();
        if (!ManchesterOWLSyntax.DASH.matches(tok)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.DASH, ManchesterOWLSyntax.COMMA).build();
        }
        this.consumeToken(">");
        List<SWRLAtom> head = this.parseRuleAtoms();
        SWRLRule rule = this.dataFactory.getSWRLRule(new LinkedHashSet<SWRLAtom>(body), new LinkedHashSet<SWRLAtom>(head));
        ArrayList<OntologyAxiomPair> pairs = new ArrayList<OntologyAxiomPair>();
        for (OWLOntology ont : ontologies) {
            pairs.add(new OntologyAxiomPair(ont, rule));
        }
        return pairs;
    }

    private List<SWRLAtom> parseRuleAtoms() {
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        ArrayList<SWRLAtom> atoms = new ArrayList<SWRLAtom>();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            this.potentialKeywords.remove((Object)ManchesterOWLSyntax.COMMA);
            SWRLAtom atom2 = this.parseRuleAtom();
            atoms.add(atom2);
            sep = this.peekToken();
            if (ManchesterOWLSyntax.COMMA.matches(sep)) {
                this.consumeToken();
            }
            this.potentialKeywords.add(ManchesterOWLSyntax.COMMA);
        }
        return atoms;
    }

    private SWRLAtom parseRuleAtom() {
        String predicate = this.peekToken();
        if (this.isClassName(predicate)) {
            return this.parseClassAtom();
        }
        if (ManchesterOWLSyntax.OPEN.matches(predicate)) {
            return this.parseClassAtom();
        }
        if (this.isObjectPropertyName(predicate)) {
            return this.parseObjectPropertyAtom();
        }
        if (this.isDataPropertyName(predicate)) {
            return this.parseDataPropertyAtom();
        }
        if (this.isDatatypeName(predicate)) {
            return this.parseDataRangeAtom();
        }
        if (ManchesterOWLSyntax.DIFFERENT_FROM.matchesEitherForm(predicate)) {
            return this.parseDifferentFromAtom();
        }
        if (ManchesterOWLSyntax.SAME_AS.matchesEitherForm(predicate)) {
            return this.parseSameAsAtom();
        }
        if (this.isSWRLBuiltin(predicate) || predicate.startsWith("<")) {
            return this.parseBuiltInAtom();
        }
        this.consumeToken();
        TreeSet<String> kw = new TreeSet<String>();
        kw.addAll(this.ruleBuiltIns.keySet());
        kw.add(ManchesterOWLSyntax.DIFFERENT_FROM.toString());
        kw.add(ManchesterOWLSyntax.SAME_AS.toString());
        throw new ExceptionBuilder().withKeyword(kw).withClass().withObject().withData().build();
    }

    private SWRLAtom parseDataPropertyAtom() {
        String predicate = this.consumeToken();
        if (!this.isDataPropertyName(predicate)) {
            throw new ExceptionBuilder().withData().build();
        }
        this.consumeToken(ManchesterOWLSyntax.OPEN.keyword());
        SWRLIArgument obj1 = this.parseIObject();
        this.consumeToken(ManchesterOWLSyntax.COMMA.keyword());
        SWRLDArgument obj2 = this.parseDObject();
        this.consumeToken(ManchesterOWLSyntax.CLOSE.keyword());
        return this.dataFactory.getSWRLDataPropertyAtom(this.getOWLDataProperty(predicate), obj1, obj2);
    }

    private SWRLAtom parseDataRangeAtom() {
        OWLDataRange range2 = this.parseDataRange();
        this.consumeToken(ManchesterOWLSyntax.OPEN.keyword());
        SWRLVariable obj1 = this.parseDVariable();
        this.consumeToken(ManchesterOWLSyntax.CLOSE.keyword());
        return this.dataFactory.getSWRLDataRangeAtom(range2, obj1);
    }

    private SWRLAtom parseObjectPropertyAtom() {
        String predicate = this.consumeToken();
        if (!this.isObjectPropertyName(predicate)) {
            throw new ExceptionBuilder().withObject().build();
        }
        this.consumeToken(ManchesterOWLSyntax.OPEN.keyword());
        SWRLIArgument obj1 = this.parseIObject();
        this.consumeToken(ManchesterOWLSyntax.COMMA.keyword());
        SWRLIArgument obj2 = this.parseIObject();
        this.consumeToken(ManchesterOWLSyntax.CLOSE.keyword());
        return this.dataFactory.getSWRLObjectPropertyAtom(this.getOWLObjectProperty(predicate), obj1, obj2);
    }

    private SWRLAtom parseClassAtom() {
        OWLClassExpression predicate = this.parseUnion();
        this.consumeToken(ManchesterOWLSyntax.OPEN.keyword());
        SWRLIArgument obj = this.parseIObject();
        this.consumeToken(ManchesterOWLSyntax.CLOSE.keyword());
        return this.dataFactory.getSWRLClassAtom(predicate, obj);
    }

    private SWRLDifferentIndividualsAtom parseDifferentFromAtom() {
        this.consumeToken(ManchesterOWLSyntax.DIFFERENT_FROM.toString());
        this.consumeToken(ManchesterOWLSyntax.OPEN.keyword());
        SWRLIArgument obj1 = this.parseIObject();
        this.consumeToken(ManchesterOWLSyntax.COMMA.keyword());
        SWRLIArgument obj2 = this.parseIObject();
        this.consumeToken(ManchesterOWLSyntax.CLOSE.keyword());
        return this.dataFactory.getSWRLDifferentIndividualsAtom(obj1, obj2);
    }

    private SWRLSameIndividualAtom parseSameAsAtom() {
        this.consumeToken(ManchesterOWLSyntax.SAME_AS.toString());
        this.consumeToken(ManchesterOWLSyntax.OPEN.keyword());
        SWRLIArgument obj1 = this.parseIObject();
        this.consumeToken(ManchesterOWLSyntax.COMMA.keyword());
        SWRLIArgument obj2 = this.parseIObject();
        this.consumeToken(ManchesterOWLSyntax.CLOSE.keyword());
        return this.dataFactory.getSWRLSameIndividualAtom(obj1, obj2);
    }

    private SWRLIArgument parseIObject() {
        String s = this.peekToken();
        if (this.isIndividualName(s)) {
            return this.parseIIndividualObject();
        }
        if (s.equals("?")) {
            return this.parseIVariable();
        }
        this.consumeToken();
        throw new ExceptionBuilder().withInd().withKeyword("?$var$").build();
    }

    private SWRLVariable parseIVariable() {
        return this.dataFactory.getSWRLVariable(this.parseVariable());
    }

    private SWRLIndividualArgument parseIIndividualObject() {
        return this.dataFactory.getSWRLIndividualArgument(this.parseIndividual());
    }

    @Override
    public IRI parseVariable() throws ParserException {
        this.consumeToken("?");
        String fragment = this.peekToken();
        if (fragment.startsWith("<")) {
            return this.parseIRI();
        }
        this.consumeToken();
        return IRI.create("urn:swrl#", fragment);
    }

    private SWRLDArgument parseDObject() {
        String s = this.peekToken();
        if (s.equals("?")) {
            return this.parseDVariable();
        }
        try {
            return this.parseLiteralObject();
        }
        catch (ParserException e2) {
            e2.getExpectedKeywords().add("?");
            throw e2;
        }
    }

    private SWRLVariable parseDVariable() {
        IRI var = this.parseVariable();
        return this.dataFactory.getSWRLVariable(var);
    }

    private SWRLLiteralArgument parseLiteralObject() {
        OWLLiteral lit = this.parseLiteral(null);
        return this.dataFactory.getSWRLLiteralArgument(lit);
    }

    private SWRLBuiltInAtom parseBuiltInAtom() {
        String predicate = this.consumeToken();
        this.consumeToken(ManchesterOWLSyntax.OPEN.keyword());
        SWRLBuiltInsVocabulary v = null;
        IRI iri = null;
        if (!this.ruleBuiltIns.containsKey(predicate)) {
            iri = this.getIRI(predicate);
        } else {
            v = this.ruleBuiltIns.get(predicate);
            iri = v.getIRI();
        }
        ArrayList<SWRLDArgument> args = new ArrayList<SWRLDArgument>();
        if (v != null && v.getMaxArity() >= 0) {
            for (int i = 0; i < v.getMaxArity(); ++i) {
                SWRLDArgument obj = this.parseDObject();
                args.add(obj);
                if (i < v.getMinArity() - 1) {
                    this.consumeToken(ManchesterOWLSyntax.COMMA.keyword());
                    continue;
                }
                if (i >= v.getMaxArity() - 1) continue;
                if (this.peekToken().equals(ManchesterOWLSyntax.COMMA.keyword())) {
                    this.consumeToken();
                    continue;
                }
                break;
            }
        } else {
            String sep = ManchesterOWLSyntax.COMMA.keyword();
            while (ManchesterOWLSyntax.COMMA.matches(sep)) {
                SWRLDArgument arg = this.parseDObject();
                args.add(arg);
                sep = this.peekToken();
                if (!ManchesterOWLSyntax.COMMA.matches(sep)) continue;
                this.consumeToken();
            }
        }
        this.consumeToken(ManchesterOWLSyntax.CLOSE.keyword());
        return this.dataFactory.getSWRLBuiltInAtom(iri, args);
    }

    private Set<OntologyAxiomPair> parseDisjointClasses() {
        String section = this.consumeToken();
        if (!ManchesterOWLSyntax.DISJOINT_CLASSES.matches(section)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.DISJOINT_CLASSES).build();
        }
        Set<OWLOntology> ontologies = this.getOntologies();
        Set<OWLAnnotation> annotations = this.parseAnnotations();
        Set<OWLClassExpression> classExpressions = this.parseClassExpressionList();
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        for (OWLOntology ont : ontologies) {
            pairs.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLDisjointClassesAxiom(classExpressions, annotations)));
        }
        return pairs;
    }

    private Set<OntologyAxiomPair> parseSameIndividual() {
        String section = this.consumeToken();
        if (!ManchesterOWLSyntax.SAME_INDIVIDUAL.matches(section)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.SAME_INDIVIDUAL).build();
        }
        Set<OWLIndividual> individuals = this.parseIndividualList();
        Set<OWLOntology> ontologies = this.getOntologies();
        Set<OWLAnnotation> annotations = this.parseAnnotations();
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        for (OWLOntology ont : ontologies) {
            pairs.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLSameIndividualAxiom(individuals, annotations)));
        }
        return pairs;
    }

    private Set<OntologyAxiomPair> parseDisjointProperties() {
        OWLNaryPropertyAxiom<OWLObjectPropertyExpression> propertiesAxiom;
        String section = this.consumeToken();
        if (!ManchesterOWLSyntax.DISJOINT_PROPERTIES.matches(section)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.DISJOINT_PROPERTIES).build();
        }
        Set<OWLOntology> ontologies = this.getOntologies();
        Set<OWLAnnotation> annotations = this.parseAnnotations();
        Set<OWLPropertyExpression<?, ?>> props = this.parsePropertyList();
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        if (props.iterator().next().isObjectPropertyExpression()) {
            HashSet<OWLObjectPropertyExpression> ope = new HashSet<OWLObjectPropertyExpression>();
            for (OWLPropertyExpression<?, ?> pe : props) {
                ope.add((OWLObjectPropertyExpression)pe);
            }
            propertiesAxiom = this.dataFactory.getOWLDisjointObjectPropertiesAxiom(ope, annotations);
        } else {
            HashSet<OWLDataPropertyExpression> dpe = new HashSet<OWLDataPropertyExpression>();
            for (OWLPropertyExpression<?, ?> pe : props) {
                dpe.add((OWLDataPropertyExpression)pe);
            }
            propertiesAxiom = this.dataFactory.getOWLDisjointDataPropertiesAxiom(dpe, annotations);
        }
        for (OWLOntology ont : ontologies) {
            pairs.add(new OntologyAxiomPair(ont, propertiesAxiom));
        }
        return pairs;
    }

    private Set<OntologyAxiomPair> parseDifferentIndividuals() {
        String section = this.consumeToken();
        if (!ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS.matches(section)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS).build();
        }
        Set<OWLOntology> ontologies = this.getOntologies();
        Set<OWLAnnotation> annotations = this.parseAnnotations();
        Set<OWLIndividual> individuals = this.parseIndividualList();
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        for (OWLOntology ontology : ontologies) {
            pairs.add(new OntologyAxiomPair(ontology, this.dataFactory.getOWLDifferentIndividualsAxiom(individuals, annotations)));
        }
        return pairs;
    }

    protected OWLObjectPropertyCharacteristicAxiom parseObjectPropertyCharacteristic(OWLObjectPropertyExpression prop) {
        String characteristic = this.consumeToken();
        if (ManchesterOWLSyntax.FUNCTIONAL.matches(characteristic)) {
            return this.dataFactory.getOWLFunctionalObjectPropertyAxiom(prop);
        }
        if (ManchesterOWLSyntax.INVERSE_FUNCTIONAL.matches(characteristic)) {
            return this.dataFactory.getOWLInverseFunctionalObjectPropertyAxiom(prop);
        }
        if (ManchesterOWLSyntax.SYMMETRIC.matches(characteristic)) {
            return this.dataFactory.getOWLSymmetricObjectPropertyAxiom(prop);
        }
        if (ManchesterOWLSyntax.ANTI_SYMMETRIC.matches(characteristic) || ManchesterOWLSyntax.ASYMMETRIC.matches(characteristic)) {
            return this.dataFactory.getOWLAsymmetricObjectPropertyAxiom(prop);
        }
        if (ManchesterOWLSyntax.TRANSITIVE.matches(characteristic)) {
            return this.dataFactory.getOWLTransitiveObjectPropertyAxiom(prop);
        }
        if (ManchesterOWLSyntax.REFLEXIVE.matches(characteristic)) {
            return this.dataFactory.getOWLReflexiveObjectPropertyAxiom(prop);
        }
        if (ManchesterOWLSyntax.IRREFLEXIVE.matches(characteristic)) {
            return this.dataFactory.getOWLIrreflexiveObjectPropertyAxiom(prop);
        }
        throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.FUNCTIONAL, ManchesterOWLSyntax.INVERSE_FUNCTIONAL, ManchesterOWLSyntax.SYMMETRIC, ManchesterOWLSyntax.ANTI_SYMMETRIC, ManchesterOWLSyntax.TRANSITIVE, ManchesterOWLSyntax.REFLEXIVE, ManchesterOWLSyntax.IRREFLEXIVE).build();
    }

    protected OWLDataPropertyCharacteristicAxiom parseDataPropertyCharacteristic(OWLDataPropertyExpression prop) {
        String characteristic = this.consumeToken();
        if (ManchesterOWLSyntax.FUNCTIONAL.matches(characteristic)) {
            return this.dataFactory.getOWLFunctionalDataPropertyAxiom(prop);
        }
        throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.FUNCTIONAL).build();
    }

    @Override
    public Set<OWLClassExpression> parseClassExpressionList(boolean ignored) {
        return this.parseClassExpressionList();
    }

    @Override
    public Set<OWLClassExpression> parseClassExpressionList() {
        HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            this.potentialKeywords.remove((Object)ManchesterOWLSyntax.COMMA);
            descs.add(this.parseUnion());
            this.potentialKeywords.add(ManchesterOWLSyntax.COMMA);
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.COMMA.matches(sep)) continue;
            sep = this.consumeToken();
        }
        return descs;
    }

    private Set<OWLClassExpression> parseClassExpressionList(ManchesterOWLSyntax expectedOpen, ManchesterOWLSyntax expectedClose) {
        String open = this.consumeToken();
        HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        if (!expectedOpen.matches(open)) {
            throw new ExceptionBuilder().withKeyword(expectedOpen).build();
        }
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            this.potentialKeywords.remove((Object)ManchesterOWLSyntax.COMMA);
            OWLClassExpression desc = this.parseUnion();
            this.potentialKeywords.add(ManchesterOWLSyntax.COMMA);
            descs.add(desc);
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.COMMA.matches(sep)) continue;
            sep = this.consumeToken();
        }
        String close = this.consumeToken();
        if (!expectedClose.matches(close)) {
            throw new ExceptionBuilder().withKeyword(expectedClose).build();
        }
        return descs;
    }

    @Override
    public Set<OWLPropertyExpression<?, ?>> parsePropertyList() {
        HashSet props = new HashSet();
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            OWLPropertyExpression<?, ?> prop = this.parsePropertyExpression();
            props.add(prop);
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.COMMA.matches(sep)) continue;
            this.consumeToken();
        }
        return props;
    }

    @Override
    public Set<OWLObjectPropertyExpression> parseObjectPropertyList() throws ParserException {
        HashSet<OWLObjectPropertyExpression> props = new HashSet<OWLObjectPropertyExpression>();
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression(false);
            props.add(prop);
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.COMMA.matches(sep)) continue;
            this.consumeToken();
        }
        return props;
    }

    protected Set<OWLIndividual> parseIndividualList() {
        HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            inds.add(this.parseIndividual());
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.COMMA.matches(sep)) continue;
            this.consumeToken();
        }
        return inds;
    }

    @Override
    public List<OWLObjectPropertyExpression> parseObjectPropertyChain() {
        String delim = "o";
        ArrayList<OWLObjectPropertyExpression> properties = new ArrayList<OWLObjectPropertyExpression>();
        while (delim.equals("o")) {
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression(false);
            properties.add(prop);
            delim = this.peekToken();
            if (!delim.equals("o")) continue;
            this.consumeToken();
        }
        return properties;
    }

    protected OWLIndividual parseIndividual() {
        String name2 = this.consumeToken();
        if (!this.isIndividualName(name2) && !name2.startsWith("_:")) {
            throw new ExceptionBuilder().withInd().build();
        }
        return this.getOWLIndividual(name2);
    }

    protected OWLDataProperty parseDataProperty() {
        String name2 = this.consumeToken();
        if (!this.isDataPropertyName(name2)) {
            throw new ExceptionBuilder().withData().build();
        }
        return this.getOWLDataProperty(name2);
    }

    protected OWLAnnotationProperty parseAnnotationProperty() {
        String name2 = this.consumeToken();
        if (!this.isAnnotationPropertyName(name2)) {
            throw new ExceptionBuilder().withAnn().build();
        }
        return this.getOWLAnnotationProperty(name2);
    }

    private Map<String, IRI> parsePrefixDeclaration() {
        this.consumeToken(ManchesterOWLSyntax.PREFIX);
        HashMap<String, IRI> map2 = new HashMap<String, IRI>(2);
        String prefixName = this.consumeToken();
        if (this.peekToken().equals("=")) {
            this.consumeToken();
        }
        IRI iri = this.parseIRI();
        map2.put(prefixName, iri);
        return map2;
    }

    private OWLImportsDeclaration parseImportsDeclaration() {
        this.consumeToken(ManchesterOWLSyntax.IMPORT);
        return this.dataFactory.getOWLImportsDeclaration(this.parseIRI());
    }

    protected IRI parseIRI() {
        String iriString = this.consumeToken();
        if (!iriString.startsWith("<") || !iriString.endsWith(">")) {
            throw new ExceptionBuilder().withKeyword("<$IRI$>").build();
        }
        return IRI.create(iriString.substring(1, iriString.length() - 1));
    }

    private void processDeclaredEntities() {
        for (int i = 0; i < this.tokens.size(); ++i) {
            String token = this.tokens.get(i).getToken();
            String name2 = null;
            if (i + 1 < this.tokens.size()) {
                name2 = this.tokens.get(i + 1).getToken();
            }
            if (ManchesterOWLSyntax.CLASS.matches(token)) {
                if (name2 == null) continue;
                this.classNames.add(name2);
                continue;
            }
            if (ManchesterOWLSyntax.OBJECT_PROPERTY.matches(token)) {
                if (name2 == null) continue;
                this.objectPropertyNames.add(name2);
                continue;
            }
            if (ManchesterOWLSyntax.DATA_PROPERTY.matches(token)) {
                if (name2 == null) continue;
                this.dataPropertyNames.add(name2);
                continue;
            }
            if (ManchesterOWLSyntax.INDIVIDUAL.matches(token)) {
                if (name2 == null) continue;
                this.individualNames.add(name2);
                continue;
            }
            if (ManchesterOWLSyntax.DATATYPE.matches(token)) {
                if (name2 == null) continue;
                this.dataTypeNames.add(name2);
                continue;
            }
            if (ManchesterOWLSyntax.ANNOTATION_PROPERTY.matches(token)) {
                if (name2 == null) continue;
                this.annotationPropertyNames.add(name2);
                continue;
            }
            if (!ManchesterOWLSyntax.VALUE_PARTITION.matches(token)) continue;
            if (name2 != null) {
                this.objectPropertyNames.add(name2);
            }
            if (i + 2 >= this.tokens.size()) continue;
            this.classNames.add(this.tokens.get(i + 2).getToken());
        }
    }

    private void processDeclaredEntities(OWLDeclarationAxiom ax) {
        ax.getEntity().accept(new OWLEntityVisitor(){

            @Override
            public void visit(OWLAnnotationProperty property) {
                ManchesterOWLSyntaxEditorParser.this.annotationPropertyNames.add(ManchesterOWLSyntaxEditorParser.this.pm.getShortForm(property.getIRI()));
            }

            @Override
            public void visit(OWLDatatype datatype) {
                ManchesterOWLSyntaxEditorParser.this.dataTypeNames.add(ManchesterOWLSyntaxEditorParser.this.pm.getShortForm(datatype.getIRI()));
            }

            @Override
            public void visit(OWLNamedIndividual individual) {
                ManchesterOWLSyntaxEditorParser.this.individualNames.add(ManchesterOWLSyntaxEditorParser.this.pm.getShortForm(individual.getIRI()));
            }

            @Override
            public void visit(OWLDataProperty property) {
                ManchesterOWLSyntaxEditorParser.this.dataPropertyNames.add(ManchesterOWLSyntaxEditorParser.this.pm.getShortForm(property.getIRI()));
            }

            @Override
            public void visit(OWLObjectProperty property) {
                ManchesterOWLSyntaxEditorParser.this.objectPropertyNames.add(ManchesterOWLSyntaxEditorParser.this.pm.getShortForm(property.getIRI()));
            }

            @Override
            public void visit(OWLClass cls) {
                ManchesterOWLSyntaxEditorParser.this.classNames.add(ManchesterOWLSyntaxEditorParser.this.pm.getShortForm(cls.getIRI()));
            }
        });
    }

    @Override
    public ManchesterOWLSyntaxOntologyFormat parseOntology(OWLOntology ont) throws ParserException, UnloadableImportException {
        String section;
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        OWLOntologyID ontologyID = new OWLOntologyID();
        HashSet<AddImport> imports = new HashSet<AddImport>();
        HashSet<AddOntologyAnnotation> ontologyAnnotations = new HashSet<AddOntologyAnnotation>();
        this.defaultOntology = ont;
        this.processDeclaredEntities();
        block0: while (true) {
            if (ManchesterOWLSyntax.ONTOLOGY.matches(section = this.peekToken())) {
                ManchesterOWLSyntaxOntologyHeader header = this.parseOntologyHeader(false);
                for (OWLImportsDeclaration decl : header.getImportsDeclarations()) {
                    imports.add(new AddImport(ont, decl));
                    ont.getOWLOntologyManager().makeLoadImportRequest(decl, this.configuration);
                    OWLOntology imported = ont.getOWLOntologyManager().getOntology(decl.getIRI());
                    for (OWLDeclarationAxiom declaration : imported.getAxioms(AxiomType.DECLARATION)) {
                        this.processDeclaredEntities(declaration);
                    }
                }
                for (OWLAnnotation anno : header.getAnnotations()) {
                    ontologyAnnotations.add(new AddOntologyAnnotation(ont, anno));
                }
                ontologyID = header.getOntologyID();
                continue;
            }
            if (ManchesterOWLSyntax.DISJOINT_CLASSES.matches(section)) {
                axioms.addAll(this.parseDisjointClasses());
                continue;
            }
            if (ManchesterOWLSyntax.EQUIVALENT_CLASSES.matches(section)) {
                axioms.addAll(this.parseNaryEquivalentClasses());
                continue;
            }
            if (ManchesterOWLSyntax.EQUIVALENT_PROPERTIES.matches(section)) {
                axioms.addAll(this.parseNaryEquivalentProperties());
                continue;
            }
            if (ManchesterOWLSyntax.DISJOINT_PROPERTIES.matches(section)) {
                axioms.addAll(this.parseDisjointProperties());
                continue;
            }
            if (ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS.matches(section)) {
                axioms.addAll(this.parseDifferentIndividuals());
                continue;
            }
            if (ManchesterOWLSyntax.SAME_INDIVIDUAL.matches(section)) {
                axioms.addAll(this.parseSameIndividual());
                continue;
            }
            if (ManchesterOWLSyntax.CLASS.matches(section)) {
                axioms.addAll(this.parseClassFrame());
                continue;
            }
            if (ManchesterOWLSyntax.OBJECT_PROPERTY.matches(section)) {
                axioms.addAll(this.parseObjectPropertyFrame());
                continue;
            }
            if (ManchesterOWLSyntax.DATA_PROPERTY.matches(section)) {
                axioms.addAll(this.parseDataPropertyFrame());
                continue;
            }
            if (ManchesterOWLSyntax.INDIVIDUAL.matches(section)) {
                axioms.addAll(this.parseIndividualFrame());
                continue;
            }
            if (ManchesterOWLSyntax.DATATYPE.matches(section)) {
                axioms.addAll(this.parseDatatypeFrame());
                continue;
            }
            if (ManchesterOWLSyntax.ANNOTATION_PROPERTY.matches(section)) {
                axioms.addAll(this.parseAnnotationPropertyFrame());
                continue;
            }
            if (ManchesterOWLSyntax.VALUE_PARTITION.matches(section)) {
                axioms.addAll(this.parseValuePartitionFrame());
                continue;
            }
            if (ManchesterOWLSyntax.IMPORT.matches(section)) {
                OWLImportsDeclaration decl = this.parseImportsDeclaration();
                ont.getOWLOntologyManager().makeLoadImportRequest(decl, this.configuration);
                imports.add(new AddImport(ont, decl));
                OWLOntology imported = ont.getOWLOntologyManager().getOntology(decl.getIRI());
                Iterator<OWLDeclarationAxiom> i$ = imported.getAxioms(AxiomType.DECLARATION).iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    OWLDeclarationAxiom declaration = i$.next();
                    this.processDeclaredEntities(declaration);
                }
            }
            if (ManchesterOWLSyntax.PREFIX.matches(section)) {
                Map<String, IRI> nsMap = this.parsePrefixDeclaration();
                Iterator<Object> i$ = nsMap.keySet().iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    String ns2 = (String)i$.next();
                    this.pm.setPrefix(ns2, nsMap.get(ns2).toString());
                }
            }
            if (!ManchesterOWLSyntax.RULE.matches(section)) break;
            axioms.addAll(this.parseRuleFrame());
        }
        if (!ManchesterOWLSyntaxTokenizer.EOF(section)) {
            this.consumeToken();
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.CLASS, ManchesterOWLSyntax.OBJECT_PROPERTY, ManchesterOWLSyntax.DATA_PROPERTY, ManchesterOWLSyntax.INDIVIDUAL, ManchesterOWLSyntax.DATATYPE, ManchesterOWLSyntax.ANNOTATION_PROPERTY, ManchesterOWLSyntax.IMPORT, ManchesterOWLSyntax.VALUE_PARTITION, ManchesterOWLSyntax.PREFIX, ManchesterOWLSyntax.EQUIVALENT_CLASSES, ManchesterOWLSyntax.DISJOINT_CLASSES, ManchesterOWLSyntax.DISJOINT_PROPERTIES, ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS, ManchesterOWLSyntax.SAME_INDIVIDUAL).build();
        }
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>(axioms.size());
        changes.addAll(imports);
        changes.addAll(ontologyAnnotations);
        for (OntologyAxiomPair pair : axioms) {
            changes.add(new AddAxiom(ont, pair.getAxiom()));
        }
        changes.add(new SetOntologyID(ont, ontologyID));
        ont.getOWLOntologyManager().applyChanges(changes);
        ManchesterOWLSyntaxOntologyFormat format2 = new ManchesterOWLSyntaxOntologyFormat();
        format2.copyPrefixesFrom(this.pm);
        return format2;
    }

    private ManchesterOWLSyntaxOntologyHeader parseOntologyHeader(boolean toEOF) {
        String section;
        String tok = this.consumeToken();
        if (!ManchesterOWLSyntax.ONTOLOGY.matches(tok)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.ONTOLOGY).build();
        }
        IRI ontologyIRI = null;
        IRI versionIRI = null;
        if (this.peekToken().startsWith("<")) {
            ontologyIRI = this.parseIRI();
            if (this.peekToken().startsWith("<")) {
                versionIRI = this.parseIRI();
            }
        }
        HashSet<OWLAnnotation> annotations = new HashSet<OWLAnnotation>();
        HashSet<OWLImportsDeclaration> imports = new HashSet<OWLImportsDeclaration>();
        while (true) {
            if (ManchesterOWLSyntax.IMPORT.matches(section = this.peekToken())) {
                this.consumeToken();
                tok = this.peekToken();
                IRI importedIRI = null;
                if (tok.startsWith("<")) {
                    importedIRI = this.parseIRI();
                } else if (this.isOntologyName(tok)) {
                    this.consumeToken();
                    OWLOntology ont = this.getOntology(tok);
                    if (ont != null) {
                        importedIRI = ont.getOntologyID().getOntologyIRI();
                    }
                } else {
                    this.consumeToken();
                    throw new ExceptionBuilder().withOnto().withKeyword("<$ONTOLOGYYURI$>").build();
                }
                imports.add(this.dataFactory.getOWLImportsDeclaration(importedIRI));
                continue;
            }
            if (!ManchesterOWLSyntax.ANNOTATIONS.matches(section)) break;
            this.consumeToken();
            annotations.addAll(this.parseAnnotationList());
        }
        if (!ManchesterOWLSyntaxTokenizer.EOF(section) && toEOF) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.IMPORT, ManchesterOWLSyntax.ANNOTATIONS).build();
        }
        return new ManchesterOWLSyntaxOntologyHeader(ontologyIRI, versionIRI, annotations, imports);
    }

    protected List<String> getTokenSequence() {
        ArrayList<String> seq2 = new ArrayList<String>();
        int index2 = this.tokenIndex - 1;
        if (index2 < 0) {
            index2 = 0;
        }
        while (index2 < this.tokens.size() && seq2.size() < 4 && seq2.indexOf("|EOF|") == -1) {
            seq2.add(this.tokens.get(index2).getToken());
            ++index2;
        }
        if (seq2.size() == 0) {
            seq2.add("|EOF|");
        }
        return seq2;
    }

    protected IRI getIRI(String name2) {
        IRI uri;
        String _name = name2;
        boolean fullIRI = _name.equals("<");
        if (fullIRI) {
            _name = this.consumeToken();
            this.consumeToken();
        }
        if ((uri = this.nameIRIMap.get(_name)) != null) {
            return uri;
        }
        if (fullIRI) {
            uri = IRI.create(_name);
        } else {
            int colonIndex = _name.indexOf(58);
            if (colonIndex == -1) {
                _name = ":" + _name;
            }
            uri = this.pm.getIRI(_name);
        }
        this.nameIRIMap.put(_name, uri);
        return uri;
    }

    @Override
    public OWLClassAxiom parseClassAxiom() throws ParserException {
        return (OWLClassAxiom)this.parseAxiom();
    }

    @Override
    public OWLAxiom parseAxiom() throws ParserException {
        String token = this.peekToken();
        if (this.isClassName(token)) {
            return this.parseAxiomWithClassExpressionStart();
        }
        if (this.isObjectPropertyName(token)) {
            return this.parseAxiomWithObjectPropertyStart();
        }
        if (this.isDataPropertyName(token)) {
            return this.parseAxiomWithDataPropertyStart();
        }
        if (this.isIndividualName(token)) {
            return this.parseAxiomWithIndividualStart();
        }
        if (ManchesterOWLSyntax.INV.matches(token)) {
            return this.parseAxiomWithObjectPropertyStart();
        }
        if (ManchesterOWLSyntax.OPEN.matches(token)) {
            return this.parseAxiomWithClassExpressionStart();
        }
        if (ManchesterOWLSyntax.OPENBRACE.matches(token)) {
            return this.parseAxiomWithClassExpressionStart();
        }
        if (ManchesterOWLSyntax.FUNCTIONAL.matches(token)) {
            return this.parseFunctionPropertyAxiom();
        }
        if (ManchesterOWLSyntax.INVERSE_FUNCTIONAL.matches(token)) {
            return this.parseInverseFunctionalPropertyAxiom();
        }
        if (ManchesterOWLSyntax.SYMMETRIC.matches(token)) {
            return this.parseSymmetricPropertyAxiom();
        }
        if (ManchesterOWLSyntax.ASYMMETRIC.matches(token)) {
            return this.parseAsymmetricPropertyAxiom();
        }
        if (ManchesterOWLSyntax.TRANSITIVE.matches(token)) {
            return this.parseTransitivePropertyAxiom();
        }
        if (ManchesterOWLSyntax.REFLEXIVE.matches(token)) {
            return this.parseReflexivePropertyAxiom();
        }
        if (ManchesterOWLSyntax.IRREFLEXIVE.matches(token)) {
            return this.parseIrreflexivePropertyAxiom();
        }
        throw new ExceptionBuilder().withClass().withObject().withData().withKeyword(ManchesterOWLSyntax.OPEN, ManchesterOWLSyntax.OPENBRACE, ManchesterOWLSyntax.INV, ManchesterOWLSyntax.FUNCTIONAL, ManchesterOWLSyntax.INVERSE_FUNCTIONAL, ManchesterOWLSyntax.SYMMETRIC, ManchesterOWLSyntax.ASYMMETRIC, ManchesterOWLSyntax.TRANSITIVE, ManchesterOWLSyntax.REFLEXIVE, ManchesterOWLSyntax.IRREFLEXIVE).build();
    }

    private OWLAxiom parseAxiomWithIndividualStart() {
        OWLIndividual ind = this.parseIndividual();
        String kw = this.consumeToken();
        if (ManchesterOWLSyntax.TYPE.matches(kw)) {
            OWLClassExpression type2 = this.parseClassExpression();
            return this.dataFactory.getOWLClassAssertionAxiom(type2, ind);
        }
        throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.TYPE).build();
    }

    private OWLAxiom parseAxiomWithDataPropertyStart() {
        OWLDataProperty prop = this.parseDataProperty();
        String kw = this.consumeToken();
        if (ManchesterOWLSyntax.SOME.matches(kw)) {
            OWLDataRange dataRange = this.parseDataIntersectionOf();
            return this.parseClassAxiomRemainder(this.dataFactory.getOWLDataSomeValuesFrom(prop, dataRange));
        }
        if (ManchesterOWLSyntax.ONLY.matches(kw)) {
            OWLDataRange dataRange = this.parseDataIntersectionOf();
            return this.parseClassAxiomRemainder(this.dataFactory.getOWLDataAllValuesFrom(prop, dataRange));
        }
        if (ManchesterOWLSyntax.MIN.matches(kw)) {
            int cardi = this.parseInteger();
            OWLDataRange dataRange = this.parseDataIntersectionOf();
            return this.parseClassAxiomRemainder(this.dataFactory.getOWLDataMinCardinality(cardi, prop, dataRange));
        }
        if (ManchesterOWLSyntax.MAX.matches(kw)) {
            int cardi = this.parseInteger();
            OWLDataRange dataRange = this.parseDataIntersectionOf();
            return this.parseClassAxiomRemainder(this.dataFactory.getOWLDataMaxCardinality(cardi, prop, dataRange));
        }
        if (ManchesterOWLSyntax.EXACTLY.matches(kw)) {
            int cardi = this.parseInteger();
            OWLDataRange dataRange = this.parseDataIntersectionOf();
            return this.parseClassAxiomRemainder(this.dataFactory.getOWLDataExactCardinality(cardi, prop, dataRange));
        }
        if (ManchesterOWLSyntax.SUB_PROPERTY_OF.matches(kw)) {
            OWLDataPropertyExpression superProperty = this.parseDataPropertyExpression();
            return this.dataFactory.getOWLSubDataPropertyOfAxiom(prop, superProperty);
        }
        if (ManchesterOWLSyntax.EQUIVALENT_TO.matches(kw)) {
            OWLDataPropertyExpression equivProp = this.parseDataPropertyExpression();
            return this.dataFactory.getOWLEquivalentDataPropertiesAxiom((OWLDataPropertyExpression)prop, equivProp);
        }
        if (ManchesterOWLSyntax.DISJOINT_WITH.matches(kw)) {
            OWLDataPropertyExpression disjProp = this.parseDataPropertyExpression();
            return this.dataFactory.getOWLDisjointDataPropertiesAxiom(prop, disjProp);
        }
        if (ManchesterOWLSyntax.DOMAIN.matches(kw)) {
            OWLClassExpression domain = this.parseClassExpression();
            return this.dataFactory.getOWLDataPropertyDomainAxiom(prop, domain);
        }
        if (ManchesterOWLSyntax.RANGE.matches(kw)) {
            OWLDataRange range2 = this.parseDataRange();
            return this.dataFactory.getOWLDataPropertyRangeAxiom(prop, range2);
        }
        throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.SOME, ManchesterOWLSyntax.ONLY, ManchesterOWLSyntax.MIN, ManchesterOWLSyntax.MAX, ManchesterOWLSyntax.EXACTLY, ManchesterOWLSyntax.SUB_PROPERTY_OF, ManchesterOWLSyntax.EQUIVALENT_TO, ManchesterOWLSyntax.DISJOINT_WITH, ManchesterOWLSyntax.DOMAIN, ManchesterOWLSyntax.RANGE).build();
    }

    private OWLDataPropertyExpression parseDataPropertyExpression() {
        String tok = this.consumeToken();
        if (!this.isDataPropertyName(tok)) {
            throw new ExceptionBuilder().withData().build();
        }
        return this.getOWLDataProperty(tok);
    }

    private OWLAxiom parseAxiomWithClassExpressionStart() {
        return this.parseClassAxiomRemainder(this.parseUnion());
    }

    private OWLAxiom parseClassAxiomRemainder(OWLClassExpression startExpression) {
        String kw = this.consumeToken();
        if (ManchesterOWLSyntax.SUBCLASS_OF.matches(kw)) {
            OWLClassExpression superClass = this.parseClassExpression();
            return this.dataFactory.getOWLSubClassOfAxiom(startExpression, superClass);
        }
        if (ManchesterOWLSyntax.DISJOINT_WITH.matches(kw)) {
            OWLClassExpression disjointClass = this.parseClassExpression();
            return this.dataFactory.getOWLDisjointClassesAxiom(startExpression, disjointClass);
        }
        if (ManchesterOWLSyntax.EQUIVALENT_TO.matches(kw)) {
            OWLClassExpression equivClass = this.parseClassExpression();
            return this.dataFactory.getOWLEquivalentClassesAxiom(startExpression, equivClass);
        }
        if (ManchesterOWLSyntax.AND.matches(kw)) {
            OWLClassExpression conjunct = this.parseIntersection();
            Set<OWLClassExpression> conjuncts = conjunct.asConjunctSet();
            conjuncts.add(startExpression);
            OWLObjectIntersectionOf ce = this.dataFactory.getOWLObjectIntersectionOf(conjuncts);
            return this.parseClassAxiomRemainder(ce);
        }
        if (ManchesterOWLSyntax.OR.matches(kw)) {
            OWLClassExpression disjunct = this.parseUnion();
            Set<OWLClassExpression> disjuncts = disjunct.asDisjunctSet();
            disjuncts.add(startExpression);
            OWLObjectUnionOf ce = this.dataFactory.getOWLObjectUnionOf(disjuncts);
            return this.parseClassAxiomRemainder(ce);
        }
        throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.SUBCLASS_OF, ManchesterOWLSyntax.DISJOINT_WITH, ManchesterOWLSyntax.EQUIVALENT_TO, ManchesterOWLSyntax.AND, ManchesterOWLSyntax.OR).build();
    }

    private OWLAxiom parseAxiomWithObjectPropertyStart() {
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression(false);
        String kw = this.consumeToken();
        if (ManchesterOWLSyntax.SOME.matches(kw)) {
            OWLClassExpression filler = this.parseUnion();
            return this.parseClassAxiomRemainder(this.dataFactory.getOWLObjectSomeValuesFrom(prop, filler));
        }
        if (ManchesterOWLSyntax.ONLY.matches(kw)) {
            OWLClassExpression filler = this.parseUnion();
            return this.parseClassAxiomRemainder(this.dataFactory.getOWLObjectAllValuesFrom(prop, filler));
        }
        if (ManchesterOWLSyntax.MIN.matches(kw)) {
            int cardi = this.parseInteger();
            OWLClassExpression filler = this.parseUnion();
            return this.parseClassAxiomRemainder(this.dataFactory.getOWLObjectMinCardinality(cardi, prop, filler));
        }
        if (ManchesterOWLSyntax.MAX.matches(kw)) {
            int cardi = this.parseInteger();
            OWLClassExpression filler = this.parseUnion();
            return this.parseClassAxiomRemainder(this.dataFactory.getOWLObjectMaxCardinality(cardi, prop, filler));
        }
        if (ManchesterOWLSyntax.EXACTLY.matches(kw)) {
            int cardi = this.parseInteger();
            OWLClassExpression filler = this.parseUnion();
            return this.parseClassAxiomRemainder(this.dataFactory.getOWLObjectExactCardinality(cardi, prop, filler));
        }
        if (ManchesterOWLSyntax.SUB_PROPERTY_OF.matches(kw)) {
            OWLObjectPropertyExpression superProperty = this.parseObjectPropertyExpression(false);
            return this.dataFactory.getOWLSubObjectPropertyOfAxiom(prop, superProperty);
        }
        if (ManchesterOWLSyntax.EQUIVALENT_TO.matches(kw)) {
            OWLObjectPropertyExpression equivProp = this.parseObjectPropertyExpression(false);
            return this.dataFactory.getOWLEquivalentObjectPropertiesAxiom(prop, equivProp);
        }
        if (ManchesterOWLSyntax.INVERSE_OF.matches(kw)) {
            OWLObjectPropertyExpression invProp = this.parseObjectPropertyExpression(false);
            return this.dataFactory.getOWLInverseObjectPropertiesAxiom(prop, invProp);
        }
        if (ManchesterOWLSyntax.DISJOINT_WITH.matches(kw)) {
            OWLObjectPropertyExpression disjProp = this.parseObjectPropertyExpression(false);
            return this.dataFactory.getOWLDisjointObjectPropertiesAxiom(prop, disjProp);
        }
        if (ManchesterOWLSyntax.DOMAIN.matches(kw)) {
            OWLClassExpression domain = this.parseClassExpression();
            return this.dataFactory.getOWLObjectPropertyDomainAxiom(prop, domain);
        }
        if (ManchesterOWLSyntax.RANGE.matches(kw)) {
            OWLClassExpression range2 = this.parseClassExpression();
            return this.dataFactory.getOWLObjectPropertyRangeAxiom(prop, range2);
        }
        if (ManchesterOWLSyntax.CHAIN_CONNECT.matches(kw)) {
            String sep = kw;
            ArrayList<OWLObjectPropertyExpression> chain = new ArrayList<OWLObjectPropertyExpression>();
            chain.add(prop);
            while (sep.equals("o")) {
                OWLObjectPropertyExpression chainProp = this.parseObjectPropertyExpression(false);
                chain.add(chainProp);
                sep = this.consumeToken();
            }
            if (!ManchesterOWLSyntax.SUB_PROPERTY_OF.matches(sep)) {
                throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.SUB_PROPERTY_OF).build();
            }
            OWLObjectPropertyExpression superProp = this.parseObjectPropertyExpression(false);
            return this.dataFactory.getOWLSubPropertyChainOfAxiom(chain, superProp);
        }
        throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.SOME, ManchesterOWLSyntax.ONLY, ManchesterOWLSyntax.MIN, ManchesterOWLSyntax.MAX, ManchesterOWLSyntax.EXACTLY, ManchesterOWLSyntax.SUB_PROPERTY_OF, ManchesterOWLSyntax.EQUIVALENT_TO, ManchesterOWLSyntax.INVERSE_OF, ManchesterOWLSyntax.DISJOINT_WITH, ManchesterOWLSyntax.DOMAIN, ManchesterOWLSyntax.RANGE, ManchesterOWLSyntax.CHAIN_CONNECT).build();
    }

    private OWLAxiom parseInverseFunctionalPropertyAxiom() {
        String kw = this.consumeToken();
        if (!ManchesterOWLSyntax.INVERSE_FUNCTIONAL.matches(kw)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.INVERSE_FUNCTIONAL).build();
        }
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression(false);
        return this.dataFactory.getOWLInverseFunctionalObjectPropertyAxiom(prop);
    }

    private OWLAxiom parseSymmetricPropertyAxiom() {
        String kw = this.consumeToken();
        if (!ManchesterOWLSyntax.SYMMETRIC.matches(kw)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.SYMMETRIC).build();
        }
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression(false);
        return this.dataFactory.getOWLSymmetricObjectPropertyAxiom(prop);
    }

    private OWLAxiom parseAsymmetricPropertyAxiom() {
        String kw = this.consumeToken();
        if (!ManchesterOWLSyntax.ASYMMETRIC.matches(kw)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.ASYMMETRIC).build();
        }
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression(false);
        return this.dataFactory.getOWLAsymmetricObjectPropertyAxiom(prop);
    }

    private OWLAxiom parseTransitivePropertyAxiom() {
        String kw = this.consumeToken();
        if (!ManchesterOWLSyntax.TRANSITIVE.matches(kw)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.TRANSITIVE).build();
        }
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression(false);
        return this.dataFactory.getOWLTransitiveObjectPropertyAxiom(prop);
    }

    private OWLAxiom parseReflexivePropertyAxiom() {
        String kw = this.consumeToken();
        if (!ManchesterOWLSyntax.REFLEXIVE.matches(kw)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.REFLEXIVE).build();
        }
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression(false);
        return this.dataFactory.getOWLReflexiveObjectPropertyAxiom(prop);
    }

    private OWLAxiom parseIrreflexivePropertyAxiom() {
        String kw = this.consumeToken();
        if (!ManchesterOWLSyntax.IRREFLEXIVE.matches(kw)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.IRREFLEXIVE).build();
        }
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression(false);
        return this.dataFactory.getOWLIrreflexiveObjectPropertyAxiom(prop);
    }

    private OWLAxiom parseFunctionPropertyAxiom() {
        String kw = this.consumeToken();
        if (!ManchesterOWLSyntax.FUNCTIONAL.matches(kw)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.FUNCTIONAL).build();
        }
        String name2 = this.peekToken();
        if (this.isObjectPropertyName(name2)) {
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression(false);
            return this.dataFactory.getOWLFunctionalObjectPropertyAxiom(prop);
        }
        if (this.isDataPropertyName(name2)) {
            OWLDataProperty prop = this.parseDataProperty();
            return this.dataFactory.getOWLFunctionalDataPropertyAxiom(prop);
        }
        this.consumeToken();
        throw new ExceptionBuilder().withObject().withData().build();
    }

    private <F, O> Set<OntologyAxiomPair> parseAnnotatedListItems(F s, AnnotatedListItemParser<F, O> itemParser, Set<OWLOntology> ontologies) {
        HashSet<OntologyAxiomPair> result = new HashSet<OntologyAxiomPair>();
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            Set<OWLAnnotation> annotations = this.parseAnnotations();
            O item = itemParser.parseItem(s);
            OWLAxiom axiom = itemParser.createAxiom(s, item, annotations);
            for (OWLOntology ontology : ontologies) {
                result.add(new OntologyAxiomPair(ontology, axiom));
            }
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.COMMA.matches(sep)) continue;
            this.consumeToken();
        }
        return result;
    }

    class AnnotationPropertyRangeListItemParser
    extends AnnotatedIRIListItemParser<OWLAnnotationProperty> {
        AnnotationPropertyRangeListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLAnnotationProperty s, IRI o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLAnnotationPropertyRangeAxiom(s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.RANGE;
        }
    }

    class AnnotationPropertyDomainListItemParser
    extends AnnotatedIRIListItemParser<OWLAnnotationProperty> {
        AnnotationPropertyDomainListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLAnnotationProperty s, IRI o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLAnnotationPropertyDomainAxiom(s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.DOMAIN;
        }
    }

    class AnnotationPropertySubPropertyOfListItemParser
    implements AnnotatedListItemParser<OWLAnnotationProperty, OWLAnnotationProperty> {
        AnnotationPropertySubPropertyOfListItemParser() {
        }

        @Override
        public OWLAnnotationProperty parseItem(OWLAnnotationProperty s) {
            return ManchesterOWLSyntaxEditorParser.this.parseAnnotationProperty();
        }

        @Override
        public OWLAxiom createAxiom(OWLAnnotationProperty s, OWLAnnotationProperty o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLSubAnnotationPropertyOfAxiom(s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.SUB_PROPERTY_OF;
        }
    }

    abstract class AnnotatedIRIListItemParser<F>
    implements AnnotatedListItemParser<F, IRI> {
        AnnotatedIRIListItemParser() {
        }

        @Override
        public IRI parseItem(F s) {
            return ManchesterOWLSyntaxEditorParser.this.parseIRI();
        }
    }

    class IndividualAnnotationItemParser
    implements AnnotatedListItemParser<OWLIndividual, OWLAnnotation> {
        IndividualAnnotationItemParser() {
        }

        @Override
        public OWLAnnotation parseItem(OWLIndividual s) {
            return ManchesterOWLSyntaxEditorParser.this.parseAnnotation();
        }

        @Override
        public OWLAxiom createAxiom(OWLIndividual s, OWLAnnotation o, Set<OWLAnnotation> anns) {
            if (s.isAnonymous()) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLAnnotationAssertionAxiom(s.asOWLAnonymousIndividual(), o, anns);
            }
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLAnnotationAssertionAxiom(s.asOWLNamedIndividual().getIRI(), o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.ANNOTATIONS;
        }
    }

    class IndividualDifferentIndividualsItemParser
    implements AnnotatedListItemParser<OWLIndividual, Set<OWLIndividual>> {
        IndividualDifferentIndividualsItemParser() {
        }

        @Override
        public Set<OWLIndividual> parseItem(OWLIndividual s) {
            return ManchesterOWLSyntaxEditorParser.this.parseIndividualList();
        }

        @Override
        public OWLAxiom createAxiom(OWLIndividual s, Set<OWLIndividual> o, Set<OWLAnnotation> anns) {
            HashSet<OWLIndividual> individuals = new HashSet<OWLIndividual>();
            individuals.add(s);
            individuals.addAll(o);
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDifferentIndividualsAxiom(individuals, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS;
        }
    }

    class IndividualDifferentFromItemParser
    extends AnnotatedIndividualsListItemParser<OWLIndividual> {
        IndividualDifferentFromItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLIndividual s, OWLIndividual o, Set<OWLAnnotation> anns) {
            HashSet<OWLIndividual> individuals = new HashSet<OWLIndividual>();
            individuals.add(s);
            individuals.add(o);
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDifferentIndividualsAxiom(individuals, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.DIFFERENT_FROM;
        }
    }

    class IndividualSameAsItemParser
    extends AnnotatedIndividualsListItemParser<OWLIndividual> {
        IndividualSameAsItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLIndividual s, OWLIndividual o, Set<OWLAnnotation> anns) {
            HashSet<OWLIndividual> individuals = new HashSet<OWLIndividual>();
            individuals.add(s);
            individuals.add(o);
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLSameIndividualAxiom(individuals, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.SAME_AS;
        }
    }

    class IndividualFactsItemParser
    implements AnnotatedListItemParser<OWLIndividual, OWLPropertyAssertionAxiom<?, ?>> {
        IndividualFactsItemParser() {
        }

        @Override
        public OWLPropertyAssertionAxiom<?, ?> parseItem(OWLIndividual s) {
            return ManchesterOWLSyntaxEditorParser.this.parseFact(s);
        }

        @Override
        public OWLAxiom createAxiom(OWLIndividual s, OWLPropertyAssertionAxiom<?, ?> o, Set<OWLAnnotation> anns) {
            return o.getAnnotatedAxiom(anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.FACTS;
        }
    }

    class IndividualTypesItemParser
    extends AnnotatedClassExpressionListItemParser<OWLIndividual> {
        IndividualTypesItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLIndividual s, OWLClassExpression o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLClassAssertionAxiom(o, s, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.TYPES;
        }
    }

    class DataPropertyCharacteristicsItemParser
    implements AnnotatedListItemParser<OWLDataProperty, OWLDataPropertyCharacteristicAxiom> {
        DataPropertyCharacteristicsItemParser() {
        }

        @Override
        public OWLDataPropertyCharacteristicAxiom parseItem(OWLDataProperty s) {
            return ManchesterOWLSyntaxEditorParser.this.parseDataPropertyCharacteristic(s);
        }

        @Override
        public OWLAxiom createAxiom(OWLDataProperty s, OWLDataPropertyCharacteristicAxiom o, Set<OWLAnnotation> anns) {
            return o.getAnnotatedAxiom(anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.CHARACTERISTICS;
        }
    }

    class DataPropertyRangeListItemParser
    extends AnnotatedDataRangeListItemParser<OWLDataProperty> {
        DataPropertyRangeListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLDataProperty s, OWLDataRange o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDataPropertyRangeAxiom(s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.RANGE;
        }
    }

    abstract class AnnotatedDataRangeListItemParser<F>
    implements AnnotatedListItemParser<F, OWLDataRange> {
        AnnotatedDataRangeListItemParser() {
        }

        @Override
        public OWLDataRange parseItem(F s) {
            return ManchesterOWLSyntaxEditorParser.this.parseDataRange();
        }
    }

    class DataPropertyDomainListItemParser
    extends AnnotatedClassExpressionListItemParser<OWLDataProperty> {
        DataPropertyDomainListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLDataProperty s, OWLClassExpression o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDataPropertyDomainAxiom(s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.DOMAIN;
        }
    }

    class DataPropertyDisjointWithListItemParser
    extends DataPropertyExpressionListItemParser<OWLDataProperty> {
        DataPropertyDisjointWithListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLDataProperty s, OWLDataPropertyExpression o, Set<OWLAnnotation> anns) {
            HashSet<OWLDataPropertyExpression> properties = new HashSet<OWLDataPropertyExpression>();
            properties.add(s);
            properties.add(o);
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDisjointDataPropertiesAxiom(properties, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.DISJOINT_WITH;
        }
    }

    class DataPropertyEquivalentToListItemParser
    extends DataPropertyExpressionListItemParser<OWLDataProperty> {
        DataPropertyEquivalentToListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLDataProperty s, OWLDataPropertyExpression o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLEquivalentDataPropertiesAxiom((OWLDataPropertyExpression)s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.EQUIVALENT_TO;
        }
    }

    class DataPropertySubPropertyOfListItemParser
    extends DataPropertyExpressionListItemParser<OWLDataProperty> {
        DataPropertySubPropertyOfListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLDataProperty s, OWLDataPropertyExpression o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLSubDataPropertyOfAxiom(s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.SUB_PROPERTY_OF;
        }
    }

    abstract class DataPropertyExpressionListItemParser<F>
    implements AnnotatedListItemParser<F, OWLDataPropertyExpression> {
        DataPropertyExpressionListItemParser() {
        }

        @Override
        public OWLDataProperty parseItem(F s) {
            return ManchesterOWLSyntaxEditorParser.this.parseDataProperty();
        }
    }

    class ObjectPropertyCharacteristicsItemParser
    implements AnnotatedListItemParser<OWLObjectProperty, OWLObjectPropertyCharacteristicAxiom> {
        ObjectPropertyCharacteristicsItemParser() {
        }

        @Override
        public OWLObjectPropertyCharacteristicAxiom parseItem(OWLObjectProperty s) {
            return ManchesterOWLSyntaxEditorParser.this.parseObjectPropertyCharacteristic(s);
        }

        @Override
        public OWLAxiom createAxiom(OWLObjectProperty s, OWLObjectPropertyCharacteristicAxiom o, Set<OWLAnnotation> anns) {
            return o.getAnnotatedAxiom(anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.CHARACTERISTICS;
        }
    }

    class ObjectPropertySubPropertyChainListItemParser
    implements AnnotatedListItemParser<OWLObjectProperty, List<OWLObjectPropertyExpression>> {
        ObjectPropertySubPropertyChainListItemParser() {
        }

        @Override
        public List<OWLObjectPropertyExpression> parseItem(OWLObjectProperty s) {
            return ManchesterOWLSyntaxEditorParser.this.parseObjectPropertyChain();
        }

        @Override
        public OWLAxiom createAxiom(OWLObjectProperty s, List<OWLObjectPropertyExpression> o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLSubPropertyChainOfAxiom(o, s, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.SUB_PROPERTY_CHAIN;
        }
    }

    class ObjectPropertyInverseOfListItemParser
    extends ObjectPropertyExpressionListItemParser<OWLObjectProperty> {
        ObjectPropertyInverseOfListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLObjectProperty s, OWLObjectPropertyExpression o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLInverseObjectPropertiesAxiom(s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.INVERSE_OF;
        }
    }

    class ObjectPropertyRangeListItemParser
    extends AnnotatedClassExpressionListItemParser<OWLObjectProperty> {
        ObjectPropertyRangeListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLObjectProperty s, OWLClassExpression o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLObjectPropertyRangeAxiom(s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.RANGE;
        }
    }

    class ObjectPropertyDomainListItemParser
    extends AnnotatedClassExpressionListItemParser<OWLObjectProperty> {
        ObjectPropertyDomainListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLObjectProperty s, OWLClassExpression o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLObjectPropertyDomainAxiom(s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.DOMAIN;
        }
    }

    class ObjectPropertyDisjointWithListItemParser
    extends ObjectPropertyExpressionListItemParser<OWLObjectProperty> {
        ObjectPropertyDisjointWithListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLObjectProperty s, OWLObjectPropertyExpression o, Set<OWLAnnotation> anns) {
            HashSet<OWLObjectPropertyExpression> properties = new HashSet<OWLObjectPropertyExpression>();
            properties.add(s);
            properties.add(o);
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDisjointObjectPropertiesAxiom(properties, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.DISJOINT_WITH;
        }
    }

    class ObjectPropertyEquivalentToListItemParser
    extends ObjectPropertyExpressionListItemParser<OWLObjectProperty> {
        ObjectPropertyEquivalentToListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLObjectProperty s, OWLObjectPropertyExpression o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLEquivalentObjectPropertiesAxiom((OWLObjectPropertyExpression)s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.EQUIVALENT_TO;
        }
    }

    class ObjectPropertySuperPropertyOfListItemParser
    extends ObjectPropertyExpressionListItemParser<OWLObjectProperty> {
        ObjectPropertySuperPropertyOfListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLObjectProperty s, OWLObjectPropertyExpression o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLSubObjectPropertyOfAxiom(o, s, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.SUPER_PROPERTY_OF;
        }
    }

    class ObjectPropertySubPropertyOfListItemParser
    extends ObjectPropertyExpressionListItemParser<OWLObjectProperty> {
        ObjectPropertySubPropertyOfListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLObjectProperty s, OWLObjectPropertyExpression o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLSubObjectPropertyOfAxiom(s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.SUB_PROPERTY_OF;
        }
    }

    abstract class ObjectPropertyExpressionListItemParser<F>
    implements AnnotatedListItemParser<F, OWLObjectPropertyExpression> {
        ObjectPropertyExpressionListItemParser() {
        }

        @Override
        public OWLObjectPropertyExpression parseItem(F s) {
            return ManchesterOWLSyntaxEditorParser.this.parseObjectPropertyExpression(false);
        }
    }

    class EntityAnnotationsListItemParser<E extends OWLEntity>
    extends AnnotationListItemParser<E> {
        EntityAnnotationsListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(E s, OWLAnnotation o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLAnnotationAssertionAxiom(s.getIRI(), o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.ANNOTATIONS;
        }
    }

    class ClassIndividualsListItemParser
    extends AnnotatedIndividualsListItemParser<OWLClass> {
        ClassIndividualsListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLClass s, OWLIndividual o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLClassAssertionAxiom(s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.INDIVIDUALS;
        }
    }

    class ClassSuperClassOfListItemParser
    extends AnnotatedClassExpressionListItemParser<OWLClass> {
        ClassSuperClassOfListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLClass s, OWLClassExpression o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLSubClassOfAxiom(o, s, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.SUPERCLASS_OF;
        }
    }

    class ClassHasKeyListItemParser
    extends AnnotatedPropertyListListItemParser<OWLClass> {
        ClassHasKeyListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLClass s, Set<OWLPropertyExpression<?, ?>> o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLHasKeyAxiom((OWLClassExpression)s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.HAS_KEY;
        }
    }

    class ClassDisjointUnionOfListItemParser
    extends AnnotatedClassExpressionSetListItemParser<OWLClass> {
        ClassDisjointUnionOfListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLClass s, Set<OWLClassExpression> o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDisjointUnionAxiom(s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.DISJOINT_UNION_OF;
        }
    }

    class ClassDisjointClassesListItemParser
    extends AnnotatedClassExpressionSetListItemParser<OWLClass> {
        ClassDisjointClassesListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLClass s, Set<OWLClassExpression> o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDisjointClassesAxiom(o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.DISJOINT_CLASSES;
        }
    }

    class ClassDisjointWithListItemParser
    extends AnnotatedClassExpressionListItemParser<OWLClass> {
        ClassDisjointWithListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLClass s, OWLClassExpression o, Set<OWLAnnotation> anns) {
            HashSet<OWLClassExpression> disjointClasses = new HashSet<OWLClassExpression>();
            disjointClasses.add(s);
            disjointClasses.add(o);
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDisjointClassesAxiom(disjointClasses, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.DISJOINT_WITH;
        }
    }

    class ClassEquivalentToListItemParser
    extends AnnotatedClassExpressionListItemParser<OWLClass> {
        ClassEquivalentToListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLClass s, OWLClassExpression o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLEquivalentClassesAxiom((OWLClassExpression)s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.EQUIVALENT_TO;
        }
    }

    class ClassSubClassOfListItemParser
    extends AnnotatedClassExpressionListItemParser<OWLClass> {
        ClassSubClassOfListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLClass s, OWLClassExpression o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLSubClassOfAxiom(s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.SUBCLASS_OF;
        }
    }

    abstract class AnnotationListItemParser<F>
    implements AnnotatedListItemParser<F, OWLAnnotation> {
        AnnotationListItemParser() {
        }

        @Override
        public OWLAnnotation parseItem(F s) {
            return ManchesterOWLSyntaxEditorParser.this.parseAnnotation();
        }
    }

    abstract class AnnotatedIndividualsListItemParser<F>
    implements AnnotatedListItemParser<F, OWLIndividual> {
        AnnotatedIndividualsListItemParser() {
        }

        @Override
        public OWLIndividual parseItem(F s) {
            return ManchesterOWLSyntaxEditorParser.this.parseIndividual();
        }
    }

    abstract class AnnotatedPropertyListListItemParser<F>
    implements AnnotatedListItemParser<F, Set<OWLPropertyExpression<?, ?>>> {
        AnnotatedPropertyListListItemParser() {
        }

        @Override
        public Set<OWLPropertyExpression<?, ?>> parseItem(F s) {
            return ManchesterOWLSyntaxEditorParser.this.parsePropertyList();
        }
    }

    abstract class AnnotatedClassExpressionSetListItemParser<F>
    implements AnnotatedListItemParser<F, Set<OWLClassExpression>> {
        AnnotatedClassExpressionSetListItemParser() {
        }

        @Override
        public Set<OWLClassExpression> parseItem(F s) {
            return ManchesterOWLSyntaxEditorParser.this.parseClassExpressionList();
        }
    }

    abstract class AnnotatedClassExpressionListItemParser<F>
    implements AnnotatedListItemParser<F, OWLClassExpression> {
        AnnotatedClassExpressionListItemParser() {
        }

        @Override
        public OWLClassExpression parseItem(F s) {
            return ManchesterOWLSyntaxEditorParser.this.parseIntersection();
        }
    }

    static interface AnnotatedListItemParser<F, O> {
        public O parseItem(F var1);

        public OWLAxiom createAxiom(F var1, O var2, Set<OWLAnnotation> var3);

        public ManchesterOWLSyntax getFrameSectionKeyword();
    }

    class DefaultEntityChecker
    implements OWLEntityChecker {
        private Map<String, OWLDatatype> dataTypeNameMap = new HashMap<String, OWLDatatype>();

        public DefaultEntityChecker() {
            for (XSDVocabulary v : XSDVocabulary.values()) {
                IRI iri = v.getIRI();
                this.dataTypeNameMap.put(iri.getFragment(), ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDatatype(iri));
                this.dataTypeNameMap.put("xsd:" + iri.getFragment(), ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDatatype(iri));
            }
        }

        @Override
        public OWLClass getOWLClass(String name2) {
            if (name2.equals("Thing") || name2.equals("owl:Thing")) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLThing();
            }
            if (name2.equals("Nothing") || name2.equals("owl:Nothing")) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLNothing();
            }
            if (ManchesterOWLSyntaxEditorParser.this.classNames.contains(name2)) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLClass(ManchesterOWLSyntaxEditorParser.this.getIRI(name2));
            }
            return null;
        }

        @Override
        public OWLObjectProperty getOWLObjectProperty(String name2) {
            if (ManchesterOWLSyntaxEditorParser.this.objectPropertyNames.contains(name2)) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLObjectProperty(ManchesterOWLSyntaxEditorParser.this.getIRI(name2));
            }
            return null;
        }

        @Override
        public OWLDataProperty getOWLDataProperty(String name2) {
            if (ManchesterOWLSyntaxEditorParser.this.dataPropertyNames.contains(name2)) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDataProperty(ManchesterOWLSyntaxEditorParser.this.getIRI(name2));
            }
            return null;
        }

        @Override
        public OWLNamedIndividual getOWLIndividual(String name2) {
            if (ManchesterOWLSyntaxEditorParser.this.individualNames.contains(name2)) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLNamedIndividual(ManchesterOWLSyntaxEditorParser.this.getIRI(name2));
            }
            return null;
        }

        @Override
        public OWLDatatype getOWLDatatype(String name2) {
            if (ManchesterOWLSyntaxEditorParser.this.dataTypeNames.contains(name2)) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDatatype(ManchesterOWLSyntaxEditorParser.this.getIRI(name2));
            }
            return null;
        }

        @Override
        public OWLAnnotationProperty getOWLAnnotationProperty(String name2) {
            if (ManchesterOWLSyntaxEditorParser.this.annotationPropertyNames.contains(name2)) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLAnnotationProperty(ManchesterOWLSyntaxEditorParser.this.getIRI(name2));
            }
            return null;
        }
    }

    protected class ExceptionBuilder {
        boolean ontologyNameExpected = false;
        boolean classNameExpected = false;
        boolean objectPropertyNameExpected = false;
        boolean dataPropertyNameExpected = false;
        boolean individualNameExpected = false;
        boolean datatypeNameExpected = false;
        boolean annotationPropertyNameExpected = false;
        boolean integerExpected = false;
        Set<String> keywords = new HashSet<String>();
        List<String> tokenSequence;
        int start = -1;
        int line = -1;
        int column = -1;

        ExceptionBuilder() {
            this.withKeyword(ManchesterOWLSyntaxEditorParser.this.potentialKeywords);
        }

        ExceptionBuilder(ParserException e2) {
            this.ontologyNameExpected = e2.isOntologyNameExpected();
            this.classNameExpected = e2.isClassNameExpected();
            this.objectPropertyNameExpected = e2.isObjectPropertyNameExpected();
            this.dataPropertyNameExpected = e2.isDataPropertyNameExpected();
            this.individualNameExpected = e2.isIndividualNameExpected();
            this.dataPropertyNameExpected = e2.isDatatypeNameExpected();
            this.annotationPropertyNameExpected = e2.isAnnotationPropertyNameExpected();
            this.integerExpected = e2.isIntegerExpected();
            this.withKeyword(e2.getExpectedKeywords());
            this.tokenSequence = e2.getTokenSequence();
            this.start = e2.getStartPos();
            this.line = e2.getLineNumber();
            this.column = e2.getColumnNumber();
        }

        public ExceptionBuilder withOnto() {
            this.ontologyNameExpected = true;
            return this;
        }

        public ExceptionBuilder withInt() {
            this.integerExpected = true;
            return this;
        }

        public ExceptionBuilder withClass() {
            this.classNameExpected = true;
            return this;
        }

        public ExceptionBuilder withObject() {
            this.objectPropertyNameExpected = true;
            this.withKeyword(ManchesterOWLSyntax.INVERSE);
            return this;
        }

        public ExceptionBuilder withData() {
            this.dataPropertyNameExpected = true;
            return this;
        }

        public ExceptionBuilder withInd() {
            this.individualNameExpected = true;
            return this;
        }

        public ExceptionBuilder withDt() {
            this.datatypeNameExpected = true;
            return this;
        }

        public ExceptionBuilder withAnn() {
            this.annotationPropertyNameExpected = true;
            return this;
        }

        public ExceptionBuilder withKeyword(String s) {
            this.keywords.add(s);
            return this;
        }

        public ExceptionBuilder withKeyword(ManchesterOWLSyntax s) {
            this.keywords.add(s.keyword());
            return this;
        }

        public ExceptionBuilder withKeyword(String ... strings) {
            for (String s : strings) {
                this.keywords.add(s);
            }
            return this;
        }

        public ExceptionBuilder withKeyword(ManchesterOWLSyntax ... keys2) {
            for (ManchesterOWLSyntax s : keys2) {
                this.keywords.add(s.keyword());
            }
            return this;
        }

        public <T> ExceptionBuilder withKeyword(Collection<T> keys2) {
            for (T s : keys2) {
                if (s instanceof String) {
                    this.withKeyword((String)s);
                }
                if (!(s instanceof ManchesterOWLSyntax)) continue;
                this.withKeyword((ManchesterOWLSyntax)((Object)s));
            }
            return this;
        }

        public ParserException build() {
            if (this.tokenSequence == null) {
                ManchesterOWLSyntaxTokenizer.Token lastToken = ManchesterOWLSyntaxEditorParser.this.getLastToken();
                this.tokenSequence = ManchesterOWLSyntaxEditorParser.this.getTokenSequence();
                this.start = lastToken.getPos();
                this.line = lastToken.getRow();
                this.column = lastToken.getCol();
            }
            return new ParserException(this.tokenSequence, this.start, this.line, this.column, this.ontologyNameExpected, this.classNameExpected, this.objectPropertyNameExpected, this.dataPropertyNameExpected, this.individualNameExpected, this.datatypeNameExpected, this.annotationPropertyNameExpected, this.integerExpected, this.keywords);
        }
    }
}

