/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.obo.parser;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class Modifiers {
    private Map<String, Set<String>> modifierNameValuesMap = new LinkedHashMap<String, Set<String>>();

    public static Modifiers parseModifiers(String modifiersList) {
        Modifiers modifiers = new Modifiers();
        StringTokenizer tokenizer = new StringTokenizer(modifiersList, ",");
        while (tokenizer.hasMoreTokens()) {
            String nameValuePair = tokenizer.nextToken().trim();
            String[] split2 = nameValuePair.split("=");
            if (split2.length != 2) continue;
            modifiers.addModifier(split2[0], split2[1]);
        }
        return modifiers;
    }

    public void addModifier(String name2, String value) {
        Set<String> values = this.modifierNameValuesMap.get(name2);
        if (values == null) {
            values = new HashSet<String>();
            this.modifierNameValuesMap.put(name2, values);
        }
        values.add(value);
    }

    public Set<String> getModifierNames() {
        return this.modifierNameValuesMap.keySet();
    }

    public Set<String> getModifierValues(String modifierName) {
        HashSet<String> valuesToReturn = new HashSet<String>();
        Set<String> values = this.modifierNameValuesMap.get(modifierName);
        if (values != null) {
            valuesToReturn.addAll(values);
        }
        return valuesToReturn;
    }
}

