/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.obo.renderer;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.coode.owlapi.obo.parser.OBOVocabulary;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.util.IRIShortFormProvider;
import org.semanticweb.owlapi.util.SimpleIRIShortFormProvider;

public class OBOTagValuePairList {
    private Map<String, Set<String>> knownTVPs = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> unknownTVPs = new HashMap<String, Set<String>>();
    private List<OBOVocabulary> vocab;
    private IRIShortFormProvider iriSFP;
    private Map<IRI, String> defaults = new HashMap<IRI, String>();
    private Writer writer;

    public OBOTagValuePairList(List<OBOVocabulary> knownVocab) {
        this.vocab = knownVocab;
        this.iriSFP = new SimpleIRIShortFormProvider();
    }

    public void visit(OWLAnnotation annot) {
        this.addPair(annot.getProperty().getIRI(), ((OWLLiteral)annot.getValue()).getLiteral());
    }

    public void addPair(OBOVocabulary tag, String value) {
        this.addPair(tag.getIRI(), value);
    }

    public void addPair(IRI tag, String value) {
        boolean found = false;
        for (OBOVocabulary obo : this.vocab) {
            if (!tag.equals(obo.getIRI())) continue;
            this.addPair(obo.getName(), value, this.knownTVPs);
            found = true;
            break;
        }
        if (!found) {
            String name2 = this.iriSFP.getShortForm(tag);
            this.addPair(name2, value, this.unknownTVPs);
        }
    }

    public void setPair(OBOVocabulary key2, String value) {
        this.knownTVPs.remove(key2.getName());
        this.addPair(key2.getIRI(), value);
    }

    public void setDefault(OBOVocabulary tag, String value) {
        this.defaults.put(tag.getIRI(), value);
    }

    public void setDefault(IRI tag, String value) {
        this.defaults.put(tag, value);
    }

    public Set<String> getValues(OBOVocabulary key2) {
        Set<String> values = this.knownTVPs.get(key2.getName());
        if (values == null) {
            values = Collections.emptySet();
        }
        return values;
    }

    private void addPair(String tag, String value, Map<String, Set<String>> map2) {
        Set<String> set2 = map2.get(tag);
        if (set2 == null) {
            set2 = new HashSet<String>(1);
            map2.put(tag, set2);
        }
        set2.add(value);
    }

    public void write(Writer w) {
        this.writer = w;
        for (OBOVocabulary tag : this.vocab) {
            String def;
            Set<String> values = this.knownTVPs.get(tag.getName());
            if (values == null && (def = this.defaults.get(tag.getIRI())) != null) {
                values = Collections.singleton(def);
            }
            if (values == null) continue;
            for (String value : values) {
                this.writeTagValuePair(tag, value);
            }
        }
        for (String unknownTag : this.unknownTVPs.keySet()) {
            for (String value : this.unknownTVPs.get(unknownTag)) {
                this.writeTagValuePair(unknownTag, value);
            }
        }
    }

    private void writeTagValuePair(OBOVocabulary key2, String value) {
        this.writeTagValuePair(key2.getName(), value);
    }

    private void writeTagValuePair(String key2, String value) {
        if (key2 != null && value != null) {
            this.write(key2);
            this.write(": ");
            this.write(value);
            this.writeNewLine();
        }
    }

    private void writeNewLine() {
        this.write("\n");
    }

    private void write(String s) {
        try {
            this.writer.write(s);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }
}

