/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.owlxml.renderer;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.coode.owlapi.owlxml.renderer.OWLXMLObjectRenderer;
import org.coode.owlapi.owlxml.renderer.OWLXMLWriter;
import org.semanticweb.owlapi.io.AbstractOWLRenderer;
import org.semanticweb.owlapi.io.OWLRendererException;
import org.semanticweb.owlapi.io.OWLRendererIOException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.PrefixOWLOntologyFormat;

public class OWLXMLRenderer
extends AbstractOWLRenderer {
    @Deprecated
    public OWLXMLRenderer(OWLOntologyManager owlOntologyManager) {
    }

    public OWLXMLRenderer() {
    }

    public void render(OWLOntology ontology, Writer writer2, OWLOntologyFormat format2) throws OWLRendererException {
        try {
            OWLXMLWriter w = new OWLXMLWriter(writer2, ontology);
            w.startDocument(ontology);
            if (format2 instanceof PrefixOWLOntologyFormat) {
                PrefixOWLOntologyFormat fromPrefixFormat = (PrefixOWLOntologyFormat)format2;
                Map<String, String> map2 = fromPrefixFormat.getPrefixName2PrefixMap();
                for (String prefixName : map2.keySet()) {
                    String prefix = map2.get(prefixName);
                    if (prefix == null || prefix.length() <= 0) continue;
                    w.writePrefix(prefixName, prefix);
                }
                if (!map2.containsKey("rdf:")) {
                    w.writePrefix("rdf:", Namespaces.RDF.toString());
                }
                if (!map2.containsKey("rdfs:")) {
                    w.writePrefix("rdfs:", Namespaces.RDFS.toString());
                }
                if (!map2.containsKey("xsd:")) {
                    w.writePrefix("xsd:", Namespaces.XSD.toString());
                }
                if (!map2.containsKey("owl:")) {
                    w.writePrefix("owl:", Namespaces.OWL.toString());
                }
            } else {
                w.writePrefix("rdf:", Namespaces.RDF.toString());
                w.writePrefix("rdfs:", Namespaces.RDFS.toString());
                w.writePrefix("xsd:", Namespaces.XSD.toString());
                w.writePrefix("owl:", Namespaces.OWL.toString());
            }
            OWLXMLObjectRenderer ren = new OWLXMLObjectRenderer(w);
            ontology.accept(ren);
            w.endDocument();
            writer2.flush();
        }
        catch (IOException e2) {
            throw new OWLRendererIOException(e2);
        }
    }

    @Override
    public void render(OWLOntology ontology, Writer writer2) throws OWLRendererException {
        this.render(ontology, writer2, ontology.getOWLOntologyManager().getOntologyFormat(ontology));
    }
}

