/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.owlxmlparser;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.coode.owlapi.owlxmlparser.AbbreviatedIRIElementHandler;
import org.coode.owlapi.owlxmlparser.AbstractElementHandlerFactory;
import org.coode.owlapi.owlxmlparser.IRIElementHandler;
import org.coode.owlapi.owlxmlparser.LegacyEntityAnnotationElementHandler;
import org.coode.owlapi.owlxmlparser.OWLAnnotationAssertionElementHandler;
import org.coode.owlapi.owlxmlparser.OWLAnnotationElementHandler;
import org.coode.owlapi.owlxmlparser.OWLAnnotationPropertyDomainElementHandler;
import org.coode.owlapi.owlxmlparser.OWLAnnotationPropertyElementHandler;
import org.coode.owlapi.owlxmlparser.OWLAnnotationPropertyRangeElementHandler;
import org.coode.owlapi.owlxmlparser.OWLAnonymousIndividualElementHandler;
import org.coode.owlapi.owlxmlparser.OWLAsymmetricObjectPropertyElementHandler;
import org.coode.owlapi.owlxmlparser.OWLClassAssertionAxiomElementHandler;
import org.coode.owlapi.owlxmlparser.OWLClassElementHandler;
import org.coode.owlapi.owlxmlparser.OWLDataAllValuesFromElementHandler;
import org.coode.owlapi.owlxmlparser.OWLDataComplementOfElementHandler;
import org.coode.owlapi.owlxmlparser.OWLDataExactCardinalityElementHandler;
import org.coode.owlapi.owlxmlparser.OWLDataHasValueElementHandler;
import org.coode.owlapi.owlxmlparser.OWLDataIntersectionOfElementHandler;
import org.coode.owlapi.owlxmlparser.OWLDataMaxCardinalityElementHandler;
import org.coode.owlapi.owlxmlparser.OWLDataMinCardinalityElementHandler;
import org.coode.owlapi.owlxmlparser.OWLDataOneOfElementHandler;
import org.coode.owlapi.owlxmlparser.OWLDataPropertyAssertionAxiomElementHandler;
import org.coode.owlapi.owlxmlparser.OWLDataPropertyDomainAxiomElementHandler;
import org.coode.owlapi.owlxmlparser.OWLDataPropertyElementHandler;
import org.coode.owlapi.owlxmlparser.OWLDataPropertyRangeAxiomElementHandler;
import org.coode.owlapi.owlxmlparser.OWLDataSomeValuesFromElementHandler;
import org.coode.owlapi.owlxmlparser.OWLDataUnionOfElementHandler;
import org.coode.owlapi.owlxmlparser.OWLDatatypeDefinitionElementHandler;
import org.coode.owlapi.owlxmlparser.OWLDatatypeElementHandler;
import org.coode.owlapi.owlxmlparser.OWLDatatypeFacetRestrictionElementHandler;
import org.coode.owlapi.owlxmlparser.OWLDatatypeRestrictionElementHandler;
import org.coode.owlapi.owlxmlparser.OWLDeclarationAxiomElementHandler;
import org.coode.owlapi.owlxmlparser.OWLDifferentIndividualsAxiomElementHandler;
import org.coode.owlapi.owlxmlparser.OWLDisjointClassesAxiomElementHandler;
import org.coode.owlapi.owlxmlparser.OWLDisjointDataPropertiesAxiomElementHandler;
import org.coode.owlapi.owlxmlparser.OWLDisjointObjectPropertiesAxiomElementHandler;
import org.coode.owlapi.owlxmlparser.OWLDisjointUnionElementHandler;
import org.coode.owlapi.owlxmlparser.OWLElementHandler;
import org.coode.owlapi.owlxmlparser.OWLElementHandlerFactory;
import org.coode.owlapi.owlxmlparser.OWLEquivalentClassesAxiomElementHandler;
import org.coode.owlapi.owlxmlparser.OWLEquivalentDataPropertiesAxiomElementHandler;
import org.coode.owlapi.owlxmlparser.OWLEquivalentObjectPropertiesAxiomElementHandler;
import org.coode.owlapi.owlxmlparser.OWLFunctionalDataPropertyAxiomElementHandler;
import org.coode.owlapi.owlxmlparser.OWLFunctionalObjectPropertyAxiomElementHandler;
import org.coode.owlapi.owlxmlparser.OWLHasKeyElementHandler;
import org.coode.owlapi.owlxmlparser.OWLImportsHandler;
import org.coode.owlapi.owlxmlparser.OWLIndividualElementHandler;
import org.coode.owlapi.owlxmlparser.OWLInverseFunctionalObjectPropertyAxiomElementHandler;
import org.coode.owlapi.owlxmlparser.OWLInverseObjectPropertiesAxiomElementHandler;
import org.coode.owlapi.owlxmlparser.OWLInverseObjectPropertyElementHandler;
import org.coode.owlapi.owlxmlparser.OWLIrreflexiveObjectPropertyAxiomElementHandler;
import org.coode.owlapi.owlxmlparser.OWLLiteralElementHandler;
import org.coode.owlapi.owlxmlparser.OWLNegativeDataPropertyAssertionAxiomElementHandler;
import org.coode.owlapi.owlxmlparser.OWLNegativeObjectPropertyAssertionAxiomElementHandler;
import org.coode.owlapi.owlxmlparser.OWLObjectAllValuesFromElementHandler;
import org.coode.owlapi.owlxmlparser.OWLObjectComplementOfElementHandler;
import org.coode.owlapi.owlxmlparser.OWLObjectExactCardinalityElementHandler;
import org.coode.owlapi.owlxmlparser.OWLObjectExistsSelfElementHandler;
import org.coode.owlapi.owlxmlparser.OWLObjectHasValueElementHandler;
import org.coode.owlapi.owlxmlparser.OWLObjectIntersectionOfElementHandler;
import org.coode.owlapi.owlxmlparser.OWLObjectMaxCardinalityElementHandler;
import org.coode.owlapi.owlxmlparser.OWLObjectMinCardinalityElementHandler;
import org.coode.owlapi.owlxmlparser.OWLObjectOneOfElementHandler;
import org.coode.owlapi.owlxmlparser.OWLObjectPropertyAssertionAxiomElementHandler;
import org.coode.owlapi.owlxmlparser.OWLObjectPropertyDomainElementHandler;
import org.coode.owlapi.owlxmlparser.OWLObjectPropertyElementHandler;
import org.coode.owlapi.owlxmlparser.OWLObjectPropertyRangeAxiomElementHandler;
import org.coode.owlapi.owlxmlparser.OWLObjectSomeValuesFromElementHandler;
import org.coode.owlapi.owlxmlparser.OWLObjectUnionOfElementHandler;
import org.coode.owlapi.owlxmlparser.OWLOntologyHandler;
import org.coode.owlapi.owlxmlparser.OWLReflexiveObjectPropertyAxiomElementHandler;
import org.coode.owlapi.owlxmlparser.OWLSameIndividualsAxiomElementHandler;
import org.coode.owlapi.owlxmlparser.OWLSubAnnotationPropertyOfElementHandler;
import org.coode.owlapi.owlxmlparser.OWLSubClassAxiomElementHandler;
import org.coode.owlapi.owlxmlparser.OWLSubDataPropertyOfAxiomElementHandler;
import org.coode.owlapi.owlxmlparser.OWLSubObjectPropertyChainElementHandler;
import org.coode.owlapi.owlxmlparser.OWLSubObjectPropertyOfAxiomElementHandler;
import org.coode.owlapi.owlxmlparser.OWLSymmetricObjectPropertyAxiomElementHandler;
import org.coode.owlapi.owlxmlparser.OWLTransitiveObjectPropertyAxiomElementHandler;
import org.coode.owlapi.owlxmlparser.OWLUnionOfElementHandler;
import org.coode.owlapi.owlxmlparser.OWLXMLParserException;
import org.coode.owlapi.owlxmlparser.SWRLAtomListElementHandler;
import org.coode.owlapi.owlxmlparser.SWRLBuiltInAtomElementHandler;
import org.coode.owlapi.owlxmlparser.SWRLClassAtomElementHandler;
import org.coode.owlapi.owlxmlparser.SWRLDataPropertyAtomElementHandler;
import org.coode.owlapi.owlxmlparser.SWRLDataRangeAtomElementHandler;
import org.coode.owlapi.owlxmlparser.SWRLDifferentIndividualsAtomElementHandler;
import org.coode.owlapi.owlxmlparser.SWRLObjectPropertyAtomElementHandler;
import org.coode.owlapi.owlxmlparser.SWRLRuleElementHandler;
import org.coode.owlapi.owlxmlparser.SWRLSameIndividualAtomElementHandler;
import org.coode.owlapi.owlxmlparser.SWRLVariableElementHandler;
import org.coode.owlapi.owlxmlparser.TranslatedOWLParserException;
import org.coode.owlapi.owlxmlparser.TranslatedUnloadableImportException;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.io.OWLParserURISyntaxException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWLXMLVocabulary;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OWLXMLParserHandler
extends DefaultHandler {
    private OWLOntologyManager owlOntologyManager;
    private OWLOntology ontology;
    private List<OWLElementHandler<?>> handlerStack;
    private Map<String, OWLElementHandlerFactory> handlerMap;
    private Map<String, String> prefixName2PrefixMap = new HashMap<String, String>();
    private Locator locator;
    private Stack<URI> bases;
    private OWLOntologyLoaderConfiguration configuration;
    private Map<String, IRI> iriMap = new HashMap<String, IRI>();

    @Deprecated
    public OWLXMLParserHandler(OWLOntologyManager owlOntologyManager, OWLOntology ontology) {
        this(owlOntologyManager, ontology, null, new OWLOntologyLoaderConfiguration());
    }

    public OWLXMLParserHandler(OWLOntology ontology) {
        this(ontology, null, new OWLOntologyLoaderConfiguration());
    }

    @Deprecated
    public OWLXMLParserHandler(OWLOntologyManager owlOntologyManager, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) {
        this(owlOntologyManager, ontology, null, configuration);
    }

    public OWLXMLParserHandler(OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) {
        this(ontology, null, configuration);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.locator = locator;
        URI base = null;
        try {
            String systemId = locator.getSystemId();
            if (systemId != null) {
                base = new URI(systemId);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        this.bases.push(base);
    }

    @Deprecated
    public OWLXMLParserHandler(OWLOntologyManager owlOntologyManager, OWLOntology ontology, OWLElementHandler<?> topHandler) {
        this(owlOntologyManager, ontology, topHandler, new OWLOntologyLoaderConfiguration());
    }

    public OWLXMLParserHandler(OWLOntology ontology, OWLElementHandler<?> topHandler) {
        this(ontology, topHandler, new OWLOntologyLoaderConfiguration());
    }

    public OWLXMLParserHandler(OWLOntology ontology, OWLElementHandler<?> topHandler, OWLOntologyLoaderConfiguration configuration) {
        this.owlOntologyManager = ontology.getOWLOntologyManager();
        this.ontology = ontology;
        this.bases = new Stack();
        this.configuration = configuration;
        this.handlerStack = new ArrayList();
        this.prefixName2PrefixMap = new HashMap<String, String>();
        this.prefixName2PrefixMap.put("owl:", Namespaces.OWL.toString());
        this.prefixName2PrefixMap.put("xsd:", Namespaces.XSD.toString());
        if (topHandler != null) {
            this.handlerStack.add(0, topHandler);
        }
        this.handlerMap = new HashMap<String, OWLElementHandlerFactory>();
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.ONTOLOGY){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLOntologyHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.ANNOTATION){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLAnnotationElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.LITERAL){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLLiteralElementHandler(handler);
            }
        }, "Constant");
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.IMPORT){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLImportsHandler(handler);
            }
        }, "Imports");
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.CLASS){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLClassElementHandler(handler);
            }
        }, "OWLClass");
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.ANNOTATION_PROPERTY){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLAnnotationPropertyElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.ANNOTATION_PROPERTY_DOMAIN){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLAnnotationPropertyDomainElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.ANNOTATION_PROPERTY_RANGE){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLAnnotationPropertyRangeElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.SUB_ANNOTATION_PROPERTY_OF){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLSubAnnotationPropertyOfElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_PROPERTY){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLObjectPropertyElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_INVERSE_OF){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLInverseObjectPropertyElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATA_PROPERTY){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLDataPropertyElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.NAMED_INDIVIDUAL){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLIndividualElementHandler(handler);
            }
        }, "Individual");
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATA_COMPLEMENT_OF){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLDataComplementOfElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATA_ONE_OF){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLDataOneOfElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATATYPE){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLDatatypeElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATATYPE_RESTRICTION){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLDatatypeRestrictionElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATA_INTERSECTION_OF){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLDataIntersectionOfElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATA_UNION_OF){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLDataUnionOfElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.FACET_RESTRICTION){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLDatatypeFacetRestrictionElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_INTERSECTION_OF){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLObjectIntersectionOfElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_UNION_OF){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLObjectUnionOfElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_COMPLEMENT_OF){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLObjectComplementOfElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_ONE_OF){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLObjectOneOfElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_SOME_VALUES_FROM){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLObjectSomeValuesFromElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_ALL_VALUES_FROM){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLObjectAllValuesFromElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_HAS_SELF){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLObjectExistsSelfElementHandler(handler);
            }
        }, "ObjectExistsSelf");
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_HAS_VALUE){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLObjectHasValueElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_MIN_CARDINALITY){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLObjectMinCardinalityElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_EXACT_CARDINALITY){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLObjectExactCardinalityElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_MAX_CARDINALITY){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLObjectMaxCardinalityElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATA_SOME_VALUES_FROM){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLDataSomeValuesFromElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATA_ALL_VALUES_FROM){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLDataAllValuesFromElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATA_HAS_VALUE){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLDataHasValueElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATA_MIN_CARDINALITY){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLDataMinCardinalityElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATA_EXACT_CARDINALITY){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLDataExactCardinalityElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATA_MAX_CARDINALITY){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLDataMaxCardinalityElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.SUB_CLASS_OF){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLSubClassAxiomElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.EQUIVALENT_CLASSES){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLEquivalentClassesAxiomElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DISJOINT_CLASSES){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLDisjointClassesAxiomElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DISJOINT_UNION){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLDisjointUnionElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.UNION_OF){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLUnionOfElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.SUB_OBJECT_PROPERTY_OF){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLSubObjectPropertyOfAxiomElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_PROPERTY_CHAIN){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLSubObjectPropertyChainElementHandler(handler);
            }
        }, "SubObjectPropertyChain");
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_PROPERTY_CHAIN){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLSubObjectPropertyChainElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.EQUIVALENT_OBJECT_PROPERTIES){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLEquivalentObjectPropertiesAxiomElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DISJOINT_OBJECT_PROPERTIES){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLDisjointObjectPropertiesAxiomElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_PROPERTY_DOMAIN){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLObjectPropertyDomainElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_PROPERTY_RANGE){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLObjectPropertyRangeAxiomElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.INVERSE_OBJECT_PROPERTIES){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLInverseObjectPropertiesAxiomElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.FUNCTIONAL_OBJECT_PROPERTY){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLFunctionalObjectPropertyAxiomElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.INVERSE_FUNCTIONAL_OBJECT_PROPERTY){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLInverseFunctionalObjectPropertyAxiomElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.SYMMETRIC_OBJECT_PROPERTY){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLSymmetricObjectPropertyAxiomElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.ASYMMETRIC_OBJECT_PROPERTY){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLAsymmetricObjectPropertyElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.REFLEXIVE_OBJECT_PROPERTY){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLReflexiveObjectPropertyAxiomElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.IRREFLEXIVE_OBJECT_PROPERTY){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLIrreflexiveObjectPropertyAxiomElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.TRANSITIVE_OBJECT_PROPERTY){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLTransitiveObjectPropertyAxiomElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.SUB_DATA_PROPERTY_OF){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLSubDataPropertyOfAxiomElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.EQUIVALENT_DATA_PROPERTIES){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLEquivalentDataPropertiesAxiomElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DISJOINT_DATA_PROPERTIES){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLDisjointDataPropertiesAxiomElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATA_PROPERTY_DOMAIN){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLDataPropertyDomainAxiomElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATA_PROPERTY_RANGE){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLDataPropertyRangeAxiomElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.FUNCTIONAL_DATA_PROPERTY){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLFunctionalDataPropertyAxiomElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.SAME_INDIVIDUAL){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLSameIndividualsAxiomElementHandler(handler);
            }
        }, "SameIndividuals");
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DIFFERENT_INDIVIDUALS){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLDifferentIndividualsAxiomElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.CLASS_ASSERTION){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLClassAssertionAxiomElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_PROPERTY_ASSERTION){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLObjectPropertyAssertionAxiomElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.NEGATIVE_OBJECT_PROPERTY_ASSERTION){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLNegativeObjectPropertyAssertionAxiomElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.NEGATIVE_DATA_PROPERTY_ASSERTION){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLNegativeDataPropertyAssertionAxiomElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATA_PROPERTY_ASSERTION){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLDataPropertyAssertionAxiomElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.ANNOTATION_ASSERTION){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLAnnotationAssertionElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory("EntityAnnotation"){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new LegacyEntityAnnotationElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DECLARATION){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLDeclarationAxiomElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.IRI_ELEMENT){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new IRIElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.ABBREVIATED_IRI_ELEMENT){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new AbbreviatedIRIElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.ANONYMOUS_INDIVIDUAL){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLAnonymousIndividualElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.HAS_KEY){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLHasKeyElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATATYPE_DEFINITION){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new OWLDatatypeDefinitionElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DL_SAFE_RULE){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new SWRLRuleElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.BODY){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new SWRLAtomListElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.HEAD){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new SWRLAtomListElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.VARIABLE){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new SWRLVariableElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.CLASS_ATOM){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new SWRLClassAtomElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.OBJECT_PROPERTY_ATOM){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new SWRLObjectPropertyAtomElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATA_PROPERTY_ATOM){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new SWRLDataPropertyAtomElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DATA_RANGE_ATOM){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new SWRLDataRangeAtomElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.BUILT_IN_ATOM){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new SWRLBuiltInAtomElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.DIFFERENT_INDIVIDUALS_ATOM){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new SWRLDifferentIndividualsAtomElementHandler(handler);
            }
        }, new String[0]);
        this.addFactory(new AbstractElementHandlerFactory(OWLXMLVocabulary.SAME_INDIVIDUAL_ATOM){

            @Override
            public OWLElementHandler<?> createHandler(OWLXMLParserHandler handler) {
                return new SWRLSameIndividualAtomElementHandler(handler);
            }
        }, new String[0]);
    }

    @Deprecated
    public OWLXMLParserHandler(OWLOntologyManager owlOntologyManager, OWLOntology ontology, OWLElementHandler<?> topHandler, OWLOntologyLoaderConfiguration configuration) {
        this(ontology, topHandler, configuration);
    }

    public OWLOntologyLoaderConfiguration getConfiguration() {
        return this.configuration;
    }

    public int getLineNumber() {
        if (this.locator != null) {
            return this.locator.getLineNumber();
        }
        return -1;
    }

    public int getColumnNumber() {
        if (this.locator != null) {
            return this.locator.getColumnNumber();
        }
        return -1;
    }

    public IRI getIRI(String iriStr) throws OWLParserException {
        try {
            IRI iri = this.iriMap.get(iriStr);
            if (iri == null) {
                URI uri = new URI(iriStr);
                if (!uri.isAbsolute()) {
                    URI base = this.getBase();
                    if (base == null) {
                        throw new OWLXMLParserException("Unable to resolve relative URI", this.getLineNumber(), this.getColumnNumber());
                    }
                    iri = IRI.create(base + iriStr);
                } else {
                    iri = IRI.create(uri);
                }
                this.iriMap.put(iriStr, iri);
            }
            return iri;
        }
        catch (URISyntaxException e2) {
            throw new OWLParserURISyntaxException(e2, this.getLineNumber(), this.getColumnNumber());
        }
    }

    private String getNormalisedAbbreviatedIRI(String input) {
        if (input.indexOf(58) != -1) {
            return input;
        }
        return ":" + input;
    }

    public IRI getAbbreviatedIRI(String abbreviatedIRI) throws OWLParserException {
        String normalisedAbbreviatedIRI = this.getNormalisedAbbreviatedIRI(abbreviatedIRI);
        int sepIndex = normalisedAbbreviatedIRI.indexOf(58);
        String prefixName = normalisedAbbreviatedIRI.substring(0, sepIndex + 1);
        String localName = normalisedAbbreviatedIRI.substring(sepIndex + 1);
        String base = this.prefixName2PrefixMap.get(prefixName);
        if (base == null) {
            throw new OWLXMLParserException("Prefix name not defined: " + prefixName, this.getLineNumber(), this.getColumnNumber());
        }
        StringBuilder sb = new StringBuilder();
        sb.append(base);
        sb.append(localName);
        return this.getIRI(sb.toString());
    }

    public Map<String, String> getPrefixName2PrefixMap() {
        return this.prefixName2PrefixMap;
    }

    private void addFactory(OWLElementHandlerFactory factory, String ... legacyElementNames) {
        this.handlerMap.put(factory.getElementName(), factory);
        for (String elementName : legacyElementNames) {
            this.handlerMap.put(elementName, factory);
        }
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    public OWLDataFactory getDataFactory() {
        return this.getOWLOntologyManager().getOWLDataFactory();
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.handlerStack.isEmpty()) {
            try {
                OWLElementHandler<?> handler = this.handlerStack.get(0);
                if (handler.isTextContentPossible()) {
                    handler.handleChars(ch, start, length);
                }
            }
            catch (OWLRuntimeException e2) {
                throw new SAXException(e2);
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            this.processXMLBase(attributes);
            if (localName.equals(OWLXMLVocabulary.PREFIX.getShortName())) {
                String name2 = attributes.getValue(OWLXMLVocabulary.NAME_ATTRIBUTE.getShortName());
                String iriString = attributes.getValue(OWLXMLVocabulary.IRI_ATTRIBUTE.getShortName());
                if (name2 != null && iriString != null) {
                    if (name2.endsWith(":")) {
                        this.prefixName2PrefixMap.put(name2, iriString);
                    } else {
                        this.prefixName2PrefixMap.put(name2 + ":", iriString);
                    }
                }
                return;
            }
            OWLElementHandlerFactory handlerFactory = this.handlerMap.get(localName);
            if (handlerFactory != null) {
                OWLElementHandler<?> handler = handlerFactory.createHandler(this);
                if (!this.handlerStack.isEmpty()) {
                    OWLElementHandler<?> topElement = this.handlerStack.get(0);
                    handler.setParentHandler(topElement);
                }
                this.handlerStack.add(0, handler);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    handler.attribute(attributes.getLocalName(i), attributes.getValue(i));
                }
                handler.startElement(localName);
            }
        }
        catch (OWLParserException e2) {
            throw new TranslatedOWLParserException(e2);
        }
    }

    protected void processXMLBase(Attributes attributes) {
        String base = attributes.getValue(Namespaces.XML.toString(), "base");
        if (base != null) {
            this.bases.push(URI.create(base));
        } else {
            this.bases.push(this.bases.peek());
        }
    }

    public URI getBase() {
        return this.bases.peek();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if (localName.equals(OWLXMLVocabulary.PREFIX.getShortName())) {
                return;
            }
            if (!this.handlerStack.isEmpty()) {
                OWLElementHandler<?> handler = this.handlerStack.remove(0);
                handler.endElement();
            }
            this.bases.pop();
        }
        catch (OWLParserException e2) {
            throw new TranslatedOWLParserException(e2);
        }
        catch (UnloadableImportException e3) {
            throw new TranslatedUnloadableImportException(e3);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.prefixName2PrefixMap.put(prefix, uri);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        return super.resolveEntity(publicId, systemId);
    }

    public OWLOntologyManager getOWLOntologyManager() {
        return this.owlOntologyManager;
    }
}

