/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdf.model;

import java.util.Arrays;
import java.util.List;
import org.coode.owlapi.rdf.model.RDFNode;
import org.coode.owlapi.rdf.model.RDFResourceNode;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class RDFTriple
implements Comparable<RDFTriple> {
    private RDFResourceNode subject;
    private RDFResourceNode property;
    private RDFNode object;
    private int hashCode = 0;
    private static final List<IRI> orderedURIs = Arrays.asList(OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.RDFS_LABEL.getIRI(), OWLRDFVocabulary.OWL_EQUIVALENT_CLASS.getIRI(), OWLRDFVocabulary.RDFS_SUBCLASS_OF.getIRI(), OWLRDFVocabulary.OWL_DISJOINT_WITH.getIRI(), OWLRDFVocabulary.OWL_ON_PROPERTY.getIRI(), OWLRDFVocabulary.OWL_DATA_RANGE.getIRI(), OWLRDFVocabulary.OWL_ON_CLASS.getIRI());

    public RDFTriple(RDFResourceNode subject, RDFResourceNode property, RDFNode object) {
        this.object = object;
        this.property = property;
        this.subject = subject;
    }

    public RDFResourceNode getSubject() {
        return this.subject;
    }

    public RDFResourceNode getProperty() {
        return this.property;
    }

    public RDFNode getObject() {
        return this.object;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 17;
            this.hashCode = this.hashCode * 37 + this.subject.hashCode();
            this.hashCode = this.hashCode * 37 + this.property.hashCode();
            this.hashCode = this.hashCode * 37 + this.object.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RDFTriple)) {
            return false;
        }
        RDFTriple other = (RDFTriple)obj;
        return other.subject.equals(this.subject) && other.property.equals(this.property) && other.object.equals(this.object);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.subject.toString());
        sb.append(" -> ");
        sb.append(this.property.toString());
        sb.append(" -> ");
        sb.append(this.object.toString());
        return sb.toString();
    }

    private int getIndex(IRI iri) {
        int index2 = orderedURIs.indexOf(iri);
        if (index2 == -1) {
            index2 = orderedURIs.size();
        }
        return index2;
    }

    @Override
    public int compareTo(RDFTriple b) {
        int diff2 = this.getIndex(this.getProperty().getIRI()) - this.getIndex(b.getProperty().getIRI());
        if (diff2 == 0) {
            diff2 = this.getSubject().compareTo(b.getSubject());
        }
        if (diff2 == 0) {
            diff2 = this.getObject().compareTo(b.getObject());
        }
        return diff2;
    }
}

