/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdf.rdfxml;

import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import org.coode.owlapi.rdf.rdfxml.RDFXMLRenderer;
import org.coode.xml.IllegalElementNameException;
import org.semanticweb.owlapi.io.RDFXMLOntologyFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.util.AbstractOWLOntologyStorer;

public class RDFXMLOntologyStorer
extends AbstractOWLOntologyStorer {
    private static final long serialVersionUID = 30406L;

    @Override
    public boolean canStoreOntology(OWLOntologyFormat ontologyFormat) {
        return ontologyFormat instanceof RDFXMLOntologyFormat;
    }

    @Override
    protected void storeOntology(OWLOntologyManager manager, OWLOntology ontology, Writer writer2, OWLOntologyFormat format2) throws OWLOntologyStorageException {
        this.storeOntology(ontology, writer2, format2);
    }

    @Override
    protected void storeOntology(OWLOntology ontology, Writer writer2, OWLOntologyFormat format2) throws OWLOntologyStorageException {
        try {
            RDFXMLRenderer renderer2 = new RDFXMLRenderer(ontology, writer2, format2);
            Set<OWLEntity> entities = renderer2.getUnserialisableEntities();
            if (!entities.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (OWLEntity entity : entities) {
                    sb.append(entity.toStringID());
                    sb.append("\n");
                }
                throw new OWLOntologyStorageException(sb.toString().trim(), new IllegalElementNameException(sb.toString().trim()));
            }
            renderer2.render();
        }
        catch (IOException e2) {
            throw new OWLOntologyStorageException(e2);
        }
        catch (IllegalElementNameException e3) {
            throw new OWLOntologyStorageException(e3);
        }
    }
}

