/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdf.rdfxml;

import java.io.IOException;
import org.coode.owlapi.rdf.model.RDFResourceNode;
import org.coode.xml.XMLWriter;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.vocab.Namespaces;

public class RDFXMLWriter {
    private static final IRI RDF_RDF = IRI.create(Namespaces.RDF.getPrefixIRI(), "RDF");
    private static final IRI RDF_RESOURCE = IRI.create(Namespaces.RDF.getPrefixIRI(), "resource");
    private static final String XML_LANG = "xml:lang";
    private static final IRI RDF_NODEID = IRI.create(Namespaces.RDF.getPrefixIRI(), "nodeID");
    private static final IRI RDF_ABOUT = IRI.create(Namespaces.RDF.getPrefixIRI(), "about");
    private static final IRI RDF_DATATYPE = IRI.create(Namespaces.RDF.getPrefixIRI(), "datatype");
    private static final IRI PARSETYPE_IRI = IRI.create(Namespaces.RDF.getPrefixIRI(), "parseType");
    private XMLWriter writer;

    protected RDFXMLWriter(XMLWriter writer2) {
        this.writer = writer2;
    }

    public void writeStartElement(IRI elementName) throws IOException {
        this.writer.writeStartElement(elementName);
    }

    public void writeParseTypeAttribute() throws IOException {
        this.writer.writeAttribute(PARSETYPE_IRI, "Collection");
    }

    public void writeDatatypeAttribute(IRI datatypeIRI) throws IOException {
        this.writer.writeAttribute(RDF_DATATYPE, datatypeIRI.toString());
    }

    public void writeTextContent(String text) throws IOException {
        this.writer.writeTextContent(text);
    }

    public void writeLangAttribute(String lang) throws IOException {
        this.writer.writeAttribute(XML_LANG, lang);
    }

    public void writeEndElement() throws IOException {
        this.writer.writeEndElement();
    }

    public void writeAboutAttribute(IRI value) throws IOException {
        this.writeAttribute(RDF_ABOUT, value);
    }

    public void writeNodeIDAttribute(RDFResourceNode node2) throws IOException {
        this.writer.writeAttribute(RDF_NODEID, node2.toString());
    }

    private void writeAttribute(IRI attributeName, IRI value) throws IOException {
        this.writer.writeAttribute(attributeName, value.toString());
    }

    public void writeOWLObject(OWLObject owlObject) {
    }

    public void writeResourceAttribute(IRI value) throws IOException {
        this.writeAttribute(RDF_RESOURCE, value);
    }

    public void startDocument() throws IOException {
        this.writer.startDocument(RDF_RDF);
    }

    public void endDocument() throws IOException {
        this.writer.endDocument();
    }

    public void writeComment(String comment2) throws IOException {
        this.writer.writeComment(comment2);
    }
}

