/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import java.io.IOException;
import org.coode.owlapi.rdfxml.parser.AnonymousNodeChecker;
import org.coode.owlapi.rdfxml.parser.IRIProvider;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.coode.owlapi.rdfxml.parser.OWLRDFXMLParserSAXException;
import org.coode.owlapi.rdfxml.parser.TranslatedOntologyChangeException;
import org.coode.owlapi.rdfxml.parser.TranslatedUnloadedImportException;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.io.RDFXMLOntologyFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.rdf.syntax.RDFParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RDFXMLParser
extends AbstractOWLParser {
    @Override
    public OWLOntologyFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology) throws OWLParserException, IOException, UnloadableImportException {
        return this.parse(documentSource, ontology, new OWLOntologyLoaderConfiguration());
    }

    @Override
    public OWLOntologyFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) throws OWLParserException, IOException, OWLOntologyChangeException, UnloadableImportException {
        InputSource is2 = null;
        try {
            final RDFXMLOntologyFormat format2 = new RDFXMLOntologyFormat();
            final RDFParser parser = new RDFParser(){

                @Override
                public void startPrefixMapping(String prefix, String IRI2) throws SAXException {
                    super.startPrefixMapping(prefix, IRI2);
                    format2.setPrefix(prefix, IRI2);
                }

                @Override
                public void startElement(String namespaceIRI, String localName, String qName, Attributes atts) throws SAXException {
                    super.startElement(namespaceIRI, localName, qName, atts);
                }
            };
            IRIProvider prov = new IRIProvider(){

                @Override
                public IRI getIRI(String s) {
                    return parser.getIRI(s);
                }
            };
            OWLRDFConsumer consumer = new OWLRDFConsumer(ontology, new AnonymousNodeChecker(){

                @Override
                public boolean isAnonymousNode(IRI iri) {
                    return NodeID.isAnonymousNodeIRI(iri);
                }

                @Override
                public boolean isAnonymousSharedNode(String iri) {
                    return NodeID.isAnonymousNodeID(iri);
                }

                @Override
                public boolean isAnonymousNode(String iri) {
                    return NodeID.isAnonymousNodeIRI(iri);
                }
            }, configuration);
            consumer.setIRIProvider(prov);
            consumer.setOntologyFormat(format2);
            is2 = this.getInputSource(documentSource, configuration);
            parser.parse(is2, consumer);
            RDFXMLOntologyFormat rDFXMLOntologyFormat = format2;
            return rDFXMLOntologyFormat;
        }
        catch (TranslatedOntologyChangeException e2) {
            throw e2.getCause();
        }
        catch (TranslatedUnloadedImportException e3) {
            throw e3.getCause();
        }
        catch (SAXException e4) {
            throw new OWLRDFXMLParserSAXException(e4);
        }
        finally {
            if (is2 != null && is2.getByteStream() != null) {
                is2.getByteStream().close();
            } else if (is2 != null && is2.getCharacterStream() != null) {
                is2.getCharacterStream().close();
            }
        }
    }
}

