/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import java.util.List;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.coode.owlapi.rdfxml.parser.TriplePredicateHandler;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class TPSubPropertyOfHandler
extends TriplePredicateHandler {
    public TPSubPropertyOfHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.RDFS_SUB_PROPERTY_OF.getIRI());
    }

    @Override
    public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
        if (this.getConsumer().isObjectProperty(object)) {
            this.getConsumer().addObjectProperty(subject, false);
        } else if (this.getConsumer().isDataProperty(object)) {
            this.getConsumer().addDataProperty(object, false);
        } else if (this.getConsumer().isAnnotationProperty(object)) {
            this.getConsumer().addAnnotationProperty(subject, false);
        } else if (this.getConsumer().isObjectProperty(subject)) {
            this.getConsumer().addObjectProperty(object, false);
        } else if (this.getConsumer().isDataProperty(subject)) {
            this.getConsumer().addDataProperty(object, false);
        } else if (this.getConsumer().isAnnotationProperty(subject)) {
            this.getConsumer().addAnnotationProperty(object, false);
        }
        return false;
    }

    @Override
    public void handleTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
        if (!this.isStrict() && this.getConsumer().hasPredicate(subject, OWLRDFVocabulary.OWL_PROPERTY_CHAIN.getIRI())) {
            IRI chainList = this.getConsumer().getResourceObject(subject, OWLRDFVocabulary.OWL_PROPERTY_CHAIN.getIRI(), true);
            List<OWLObjectPropertyExpression> properties = this.getConsumer().translateToObjectPropertyList(chainList);
            this.addAxiom(this.getDataFactory().getOWLSubPropertyChainOfAxiom(properties, this.translateObjectProperty(object), this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        } else if (!this.isStrict() && this.getConsumer().hasPredicate(subject, OWLRDFVocabulary.RDF_FIRST.getIRI())) {
            List<OWLObjectPropertyExpression> properties = this.getConsumer().translateToObjectPropertyList(subject);
            this.addAxiom(this.getDataFactory().getOWLSubPropertyChainOfAxiom(properties, this.translateObjectProperty(object), this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        } else if (this.getConsumer().isObjectProperty(subject) && this.getConsumer().isObjectProperty(object)) {
            this.translateSubObjectProperty(subject, predicate, object);
        } else if (this.getConsumer().isDataProperty(subject) && this.getConsumer().isDataProperty(object)) {
            this.translateSubDataProperty(subject, predicate, object);
        } else if (!this.isStrict()) {
            OWLAnnotationProperty subAnnoProp = this.getDataFactory().getOWLAnnotationProperty(subject);
            OWLAnnotationProperty superAnnoProp = this.getDataFactory().getOWLAnnotationProperty(object);
            this.addAxiom(this.getDataFactory().getOWLSubAnnotationPropertyOfAxiom(subAnnoProp, superAnnoProp, this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        }
    }

    private void translateSubObjectProperty(IRI subject, IRI predicate, IRI object) throws OWLOntologyChangeException {
        this.addAxiom(this.getDataFactory().getOWLSubObjectPropertyOfAxiom(this.translateObjectProperty(subject), this.translateObjectProperty(object), this.getPendingAnnotations()));
        this.consumeTriple(subject, predicate, object);
    }

    private void translateSubDataProperty(IRI subject, IRI predicate, IRI object) throws OWLOntologyChangeException {
        this.addAxiom(this.getDataFactory().getOWLSubDataPropertyOfAxiom(this.translateDataProperty(subject), this.translateDataProperty(object), this.getPendingAnnotations()));
        this.consumeTriple(subject, predicate, object);
    }
}

