/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.turtle;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import org.coode.owlapi.rdf.model.RDFLiteralNode;
import org.coode.owlapi.rdf.model.RDFNode;
import org.coode.owlapi.rdf.model.RDFResourceNode;
import org.coode.owlapi.rdf.model.RDFTriple;
import org.coode.owlapi.rdf.renderer.RDFRendererBase;
import org.semanticweb.owlapi.io.RDFOntologyFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.semanticweb.owlapi.util.EscapeUtils;
import org.semanticweb.owlapi.util.VersionInfo;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.PrefixOWLOntologyFormat;
import org.semanticweb.owlapi.vocab.XSDVocabulary;

public class TurtleRenderer
extends RDFRendererBase {
    private PrintWriter writer;
    private Set<RDFResourceNode> pending;
    private DefaultPrefixManager pm;
    private String base;
    private OWLOntologyFormat format;
    int bufferLength = 0;
    int lastNewLineIndex = 0;
    Stack<Integer> tabs = new Stack();
    int level = 0;

    @Deprecated
    public TurtleRenderer(OWLOntology ontology, OWLOntologyManager manager, Writer writer2, OWLOntologyFormat format2) {
        this(ontology, writer2, format2);
    }

    public TurtleRenderer(OWLOntology ontology, Writer writer2, OWLOntologyFormat format2) {
        super(ontology, format2);
        this.format = format2;
        this.writer = new PrintWriter(writer2);
        this.pending = new HashSet<RDFResourceNode>();
        this.pm = new DefaultPrefixManager();
        if (!ontology.isAnonymous()) {
            this.pm.setDefaultPrefix(ontology.getOntologyID().getOntologyIRI() + "#");
        }
        if (format2 instanceof PrefixOWLOntologyFormat) {
            PrefixOWLOntologyFormat prefixFormat = (PrefixOWLOntologyFormat)format2;
            for (String prefixName : prefixFormat.getPrefixNames()) {
                this.pm.setPrefix(prefixName, prefixFormat.getPrefix(prefixName));
            }
        }
        this.base = "";
    }

    private void writeNamespaces() {
        for (String prefixName : this.pm.getPrefixName2PrefixMap().keySet()) {
            String prefix = this.pm.getPrefix(prefixName);
            this.write("@prefix ");
            this.write(prefixName);
            this.write(" ");
            this.writeAsURI(prefix);
            this.write(" .");
            this.writeNewLine();
        }
    }

    protected void pushTab() {
        this.tabs.push(this.getIndent());
    }

    protected void popTab() {
        if (!this.tabs.isEmpty()) {
            this.tabs.pop();
        }
    }

    private void write(String s) {
        int newLineIndex = s.indexOf(10);
        if (newLineIndex != -1) {
            this.lastNewLineIndex = this.bufferLength + newLineIndex;
        }
        this.writer.write(s);
        this.bufferLength += s.length();
    }

    private int getCurrentPos() {
        return this.bufferLength;
    }

    private int getIndent() {
        return this.getCurrentPos() - this.lastNewLineIndex;
    }

    private void writeAsURI(String s) {
        this.write("<");
        if (s.startsWith(this.base)) {
            this.write(s.substring(this.base.length()));
        } else {
            this.write(s);
        }
        this.write(">");
    }

    private void write(IRI iri) {
        if (iri.equals(this.getOntology().getOntologyID().getOntologyIRI())) {
            this.writeAsURI(iri.toString());
        } else {
            String name2 = this.pm.getPrefixIRI(iri);
            if (name2 == null) {
                this.writeAsURI(iri.toString());
            } else if (name2.indexOf(58) != -1) {
                this.write(name2);
            } else {
                this.write(":");
                this.write(name2);
            }
        }
    }

    private void writeNewLine() {
        this.write("\n");
        int tabIndent = 0;
        if (!this.tabs.isEmpty()) {
            tabIndent = this.tabs.peek();
        }
        for (int i = 1; i < tabIndent; ++i) {
            this.write(" ");
        }
    }

    private void write(RDFNode node2) {
        if (node2.isLiteral()) {
            this.write((RDFLiteralNode)node2);
        } else {
            this.write((RDFResourceNode)node2);
        }
    }

    private void write(RDFLiteralNode node2) {
        if (node2.getDatatype() != null) {
            if (node2.getDatatype().equals(XSDVocabulary.INTEGER.getIRI())) {
                this.write(node2.getLiteral());
            } else if (node2.getDatatype().equals(XSDVocabulary.DECIMAL.getIRI())) {
                this.write(node2.getLiteral());
            } else {
                this.writeStringLiteral(node2.getLiteral());
                this.write("^^");
                this.write(node2.getDatatype());
            }
        } else {
            this.writeStringLiteral(node2.getLiteral());
            if (node2.getLang() != null) {
                this.write("@");
                this.write(node2.getLang());
            }
        }
    }

    private void writeStringLiteral(String literal) {
        String escapedLiteral = EscapeUtils.escapeString(literal);
        if (escapedLiteral.indexOf(10) != -1) {
            this.write("\"\"\"");
            this.write(escapedLiteral);
            this.write("\"\"\"");
        } else {
            this.write("\"");
            this.write(escapedLiteral);
            this.write("\"");
        }
    }

    private void write(RDFResourceNode node2) {
        if (!node2.isAnonymous()) {
            this.write(node2.getIRI());
        } else {
            this.pushTab();
            if (!this.isObjectList(node2)) {
                this.render(node2);
            } else {
                ArrayList<RDFNode> list = new ArrayList<RDFNode>();
                this.toJavaList(node2, list);
                this.pushTab();
                this.write("(");
                this.write(" ");
                this.pushTab();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    this.write((RDFNode)it.next());
                    if (!it.hasNext()) continue;
                    this.writeNewLine();
                }
                this.popTab();
                this.writeNewLine();
                this.write(")");
                this.popTab();
            }
            this.popTab();
        }
    }

    @Override
    protected void beginDocument() {
        this.writeNamespaces();
        this.write("@base ");
        this.write("<");
        if (!this.getOntology().isAnonymous()) {
            this.write(this.getOntology().getOntologyID().getOntologyIRI().toString());
        } else {
            this.write(Namespaces.OWL.toString());
        }
        this.write("> .");
        this.writeNewLine();
        this.writeNewLine();
    }

    @Override
    protected void endDocument() {
        this.writer.flush();
        this.writer.println();
        this.writeComment(VersionInfo.getVersionInfo().getGeneratedByMessage());
        if (this.format instanceof RDFOntologyFormat && !((RDFOntologyFormat)this.format).isAddMissingTypes()) {
            this.writeComment("Warning: type declarations were not added automatically.");
        }
        this.writer.flush();
    }

    @Override
    protected void writeClassComment(OWLClass cls) {
        this.writeComment(cls.getIRI().toString());
    }

    @Override
    protected void writeObjectPropertyComment(OWLObjectProperty prop) {
        this.writeComment(prop.getIRI().toString());
    }

    @Override
    protected void writeDataPropertyComment(OWLDataProperty prop) {
        this.writeComment(prop.getIRI().toString());
    }

    @Override
    protected void writeIndividualComments(OWLNamedIndividual ind) {
        this.writeComment(ind.getIRI().toString());
    }

    @Override
    protected void writeAnnotationPropertyComment(OWLAnnotationProperty prop) {
        this.writeComment(prop.getIRI().toString());
    }

    @Override
    protected void writeDatatypeComment(OWLDatatype datatype) {
        this.writeComment(datatype.getIRI().toString());
    }

    private void writeComment(String comment2) {
        this.write("###  ");
        this.write(comment2);
        this.writeNewLine();
        this.writeNewLine();
    }

    @Override
    protected void endObject() {
        this.writeNewLine();
        this.writeNewLine();
        this.writeNewLine();
    }

    @Override
    protected void writeBanner(String name2) {
        this.writeNewLine();
        this.writeNewLine();
        this.writer.println("#################################################################");
        this.writer.println("#");
        this.writer.print("#    ");
        this.writer.println(name2);
        this.writer.println("#");
        this.writer.println("#################################################################");
        this.writeNewLine();
        this.writeNewLine();
    }

    @Override
    public void render(RDFResourceNode node2) {
        ++this.level;
        Collection<Object> triples = this.pending.contains(node2) ? Collections.emptyList() : this.getGraph().getTriplesForSubject(node2, true);
        this.pending.add(node2);
        RDFResourceNode lastSubject = null;
        RDFResourceNode lastPredicate = null;
        boolean first2 = true;
        for (RDFTriple rDFTriple : triples) {
            RDFResourceNode subj = rDFTriple.getSubject();
            RDFResourceNode pred = rDFTriple.getProperty();
            if (lastSubject != null && (subj.equals(lastSubject) || subj.isAnonymous())) {
                if (lastPredicate != null && pred.equals(lastPredicate)) {
                    this.write(" ,");
                    this.writeNewLine();
                    this.write(rDFTriple.getObject());
                } else {
                    this.write(" ;");
                    this.popTab();
                    if (!subj.isAnonymous()) {
                        this.writeNewLine();
                    }
                    this.writeNewLine();
                    this.write(rDFTriple.getProperty());
                    this.write(" ");
                    this.pushTab();
                    this.write(rDFTriple.getObject());
                }
            } else {
                if (!first2) {
                    this.popTab();
                    this.popTab();
                    this.writeNewLine();
                }
                if (!node2.isAnonymous()) {
                    this.write(rDFTriple.getSubject());
                    this.write(" ");
                } else {
                    this.pushTab();
                    this.write("[");
                    this.write(" ");
                }
                this.pushTab();
                this.write(rDFTriple.getProperty());
                this.write(" ");
                this.pushTab();
                this.write(rDFTriple.getObject());
            }
            lastSubject = subj;
            lastPredicate = pred;
            first2 = false;
        }
        if (node2.isAnonymous()) {
            this.popTab();
            this.popTab();
            if (triples.isEmpty()) {
                this.write("[ ");
            } else {
                this.writeNewLine();
            }
            this.write("]");
            this.popTab();
        } else {
            this.popTab();
            this.popTab();
        }
        if (this.level == 1 && !triples.isEmpty()) {
            this.write(" .\n");
        }
        this.writer.flush();
        this.pending.remove(node2);
        --this.level;
    }
}

