/*
 * Decompiled with CFR 0.152.
 */
package org.coode.xml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;

public class XMLWriterNamespaceManager {
    private Map<String, String> prefixNamespaceMap = new HashMap<String, String>();
    private Map<String, String> namespacePrefixMap = new HashMap<String, String>();
    private Map<String, String> wellknownNamespaces = new HashMap<String, String>();
    private String defaultNamespace;

    public XMLWriterNamespaceManager(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    public void addWellKnownNamespace(String prefix, String namespace2) {
        this.wellknownNamespaces.put(prefix, namespace2);
    }

    public void setPrefix(String prefix, String namespace2) {
        this.prefixNamespaceMap.put(prefix, namespace2);
        this.namespacePrefixMap.put(namespace2, prefix);
    }

    public String getPrefixForNamespace(String namespace2) {
        return this.namespacePrefixMap.get(namespace2);
    }

    public void setDefaultNamespace(String namespace2) {
        this.defaultNamespace = namespace2;
    }

    public String getNamespaceForPrefix(String prefix) {
        return this.prefixNamespaceMap.get(prefix);
    }

    public String getQName(String name2) {
        if (name2.startsWith(this.defaultNamespace)) {
            return name2.substring(this.defaultNamespace.length(), name2.length());
        }
        for (String ns2 : this.namespacePrefixMap.keySet()) {
            if (!name2.startsWith(ns2)) continue;
            String localName = name2.substring(ns2.length(), name2.length());
            return this.namespacePrefixMap.get(ns2) + ":" + localName;
        }
        return name2;
    }

    public String getQName(IRI name2) {
        if (name2.getNamespace().equals(this.defaultNamespace)) {
            return name2.getFragment() == null ? "" : name2.getFragment();
        }
        String candidate = this.namespacePrefixMap.get(name2.getNamespace());
        if (candidate != null) {
            String localName = name2.getFragment() == null ? "" : name2.getFragment();
            return candidate + ":" + localName;
        }
        return name2.toString();
    }

    public void createPrefixForNamespace(String namespace2) {
        if (namespace2.equals(this.defaultNamespace)) {
            return;
        }
        if (this.wellknownNamespaces.containsKey(namespace2)) {
            this.setPrefix(this.wellknownNamespaces.get(namespace2), namespace2);
        }
        if (!this.namespacePrefixMap.containsKey(namespace2)) {
            int counter = 1;
            while (this.prefixNamespaceMap.get("p" + counter) != null) {
                ++counter;
            }
            this.setPrefix("p" + counter, namespace2);
        }
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public Set<String> getPrefixes() {
        return new HashSet<String>(this.prefixNamespaceMap.keySet());
    }

    public Set<String> getNamespaces() {
        return new HashSet<String>(this.namespacePrefixMap.keySet());
    }

    public Map<String, String> getPrefixNamespaceMap() {
        return new HashMap<String, String>(this.prefixNamespaceMap);
    }

    public String getDefaultPrefix() {
        for (String prefix : this.prefixNamespaceMap.keySet()) {
            String ns2;
            if (prefix.equals("") || !(ns2 = this.prefixNamespaceMap.get(prefix)).equals(this.defaultNamespace)) continue;
            return prefix;
        }
        return "";
    }
}

