/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.WeightedGraph;
import org.jgrapht.graph.AsUndirectedGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Graphs {
    public static <V, E> E addEdge(Graph<V, E> graph, V v, V v2, double d) {
        EdgeFactory<V, E> edgeFactory = graph.getEdgeFactory();
        E e2 = edgeFactory.createEdge(v, v2);
        assert (graph instanceof WeightedGraph) : graph.getClass();
        ((WeightedGraph)graph).setEdgeWeight(e2, d);
        return (E)(graph.addEdge(v, v2, e2) ? e2 : null);
    }

    public static <V, E> E addEdgeWithVertices(Graph<V, E> graph, V v, V v2) {
        graph.addVertex(v);
        graph.addVertex(v2);
        return graph.addEdge(v, v2);
    }

    public static <V, E> boolean addEdgeWithVertices(Graph<V, E> graph, Graph<V, E> graph2, E e2) {
        V v = graph2.getEdgeSource(e2);
        V v2 = graph2.getEdgeTarget(e2);
        graph.addVertex(v);
        graph.addVertex(v2);
        return graph.addEdge(v, v2, e2);
    }

    public static <V, E> E addEdgeWithVertices(Graph<V, E> graph, V v, V v2, double d) {
        graph.addVertex(v);
        graph.addVertex(v2);
        return Graphs.addEdge(graph, v, v2, d);
    }

    public static <V, E> boolean addGraph(Graph<? super V, ? super E> graph, Graph<V, E> graph2) {
        boolean bl = Graphs.addAllVertices(graph, graph2.vertexSet());
        return bl |= Graphs.addAllEdges(graph, graph2, graph2.edgeSet());
    }

    public static <V, E> void addGraphReversed(DirectedGraph<? super V, ? super E> directedGraph, DirectedGraph<V, E> directedGraph2) {
        Graphs.addAllVertices(directedGraph, directedGraph2.vertexSet());
        for (Object e2 : directedGraph2.edgeSet()) {
            directedGraph.addEdge(directedGraph2.getEdgeTarget(e2), directedGraph2.getEdgeSource(e2));
        }
    }

    public static <V, E> boolean addAllEdges(Graph<? super V, ? super E> graph, Graph<V, E> graph2, Collection<? extends E> collection) {
        boolean bl = false;
        for (E e2 : collection) {
            V v = graph2.getEdgeSource(e2);
            V v2 = graph2.getEdgeTarget(e2);
            graph.addVertex(v);
            graph.addVertex(v2);
            bl |= graph.addEdge(v, v2, e2);
        }
        return bl;
    }

    public static <V, E> boolean addAllVertices(Graph<? super V, ? super E> graph, Collection<? extends V> collection) {
        boolean bl = false;
        for (V v : collection) {
            bl |= graph.addVertex(v);
        }
        return bl;
    }

    public static <V, E> List<V> neighborListOf(Graph<V, E> graph, V v) {
        ArrayList<V> arrayList = new ArrayList<V>();
        for (E e2 : graph.edgesOf(v)) {
            arrayList.add(Graphs.getOppositeVertex(graph, e2, v));
        }
        return arrayList;
    }

    public static <V, E> List<V> predecessorListOf(DirectedGraph<V, E> directedGraph, V v) {
        ArrayList<V> arrayList = new ArrayList<V>();
        Set<E> set2 = directedGraph.incomingEdgesOf(v);
        for (E e2 : set2) {
            arrayList.add(Graphs.getOppositeVertex(directedGraph, e2, v));
        }
        return arrayList;
    }

    public static <V, E> List<V> successorListOf(DirectedGraph<V, E> directedGraph, V v) {
        ArrayList<V> arrayList = new ArrayList<V>();
        Set<E> set2 = directedGraph.outgoingEdgesOf(v);
        for (E e2 : set2) {
            arrayList.add(Graphs.getOppositeVertex(directedGraph, e2, v));
        }
        return arrayList;
    }

    public static <V, E> UndirectedGraph<V, E> undirectedGraph(Graph<V, E> graph) {
        if (graph instanceof DirectedGraph) {
            return new AsUndirectedGraph((DirectedGraph)graph);
        }
        if (graph instanceof UndirectedGraph) {
            return (UndirectedGraph)graph;
        }
        throw new IllegalArgumentException("Graph must be either DirectedGraph or UndirectedGraph");
    }

    public static <V, E> boolean testIncidence(Graph<V, E> graph, E e2, V v) {
        return graph.getEdgeSource(e2).equals(v) || graph.getEdgeTarget(e2).equals(v);
    }

    public static <V, E> V getOppositeVertex(Graph<V, E> graph, E e2, V v) {
        V v2 = graph.getEdgeSource(e2);
        V v3 = graph.getEdgeTarget(e2);
        if (v.equals(v2)) {
            return v3;
        }
        if (v.equals(v3)) {
            return v2;
        }
        throw new IllegalArgumentException("no such vertex");
    }

    public static <V, E> List<V> getPathVertexList(GraphPath<V, E> graphPath) {
        Graph<V, E> graph = graphPath.getGraph();
        ArrayList<V> arrayList = new ArrayList<V>();
        V v = graphPath.getStartVertex();
        arrayList.add(v);
        for (E e2 : graphPath.getEdgeList()) {
            v = Graphs.getOppositeVertex(graph, e2, v);
            arrayList.add(v);
        }
        return arrayList;
    }
}

