/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractPathElement<V, E> {
    protected int nHops;
    protected E prevEdge;
    protected AbstractPathElement<V, E> prevPathElement;
    private V vertex;

    protected AbstractPathElement(Graph<V, E> graph, AbstractPathElement<V, E> abstractPathElement, E e2) {
        this.vertex = Graphs.getOppositeVertex(graph, e2, abstractPathElement.getVertex());
        this.prevEdge = e2;
        this.prevPathElement = abstractPathElement;
        this.nHops = abstractPathElement.getHopCount() + 1;
    }

    protected AbstractPathElement(AbstractPathElement<V, E> abstractPathElement) {
        this.nHops = abstractPathElement.nHops;
        this.prevEdge = abstractPathElement.prevEdge;
        this.prevPathElement = abstractPathElement.prevPathElement;
        this.vertex = abstractPathElement.vertex;
    }

    protected AbstractPathElement(V v) {
        this.vertex = v;
        this.prevEdge = null;
        this.prevPathElement = null;
        this.nHops = 0;
    }

    public List<E> createEdgeListPath() {
        ArrayList<E> arrayList = new ArrayList<E>();
        AbstractPathElement<V, E> abstractPathElement = this;
        while (abstractPathElement.getPrevEdge() != null) {
            arrayList.add(abstractPathElement.getPrevEdge());
            abstractPathElement = abstractPathElement.getPrevPathElement();
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    public int getHopCount() {
        return this.nHops;
    }

    public E getPrevEdge() {
        return this.prevEdge;
    }

    public AbstractPathElement<V, E> getPrevPathElement() {
        return this.prevPathElement;
    }

    public V getVertex() {
        return this.vertex;
    }
}

