/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import org.jgrapht.Graph;
import org.jgrapht.alg.AbstractPathElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BellmanFordPathElement<V, E>
extends AbstractPathElement<V, E> {
    private double cost = 0.0;
    private double epsilon;

    protected BellmanFordPathElement(Graph<V, E> graph, BellmanFordPathElement<V, E> bellmanFordPathElement, E e2, double d, double d2) {
        super(graph, bellmanFordPathElement, e2);
        this.cost = d;
        this.epsilon = d2;
    }

    BellmanFordPathElement(BellmanFordPathElement<V, E> bellmanFordPathElement) {
        super(bellmanFordPathElement);
        this.cost = bellmanFordPathElement.cost;
        this.epsilon = bellmanFordPathElement.epsilon;
    }

    protected BellmanFordPathElement(V v, double d) {
        super(v);
        this.cost = 0.0;
        this.epsilon = d;
    }

    public double getCost() {
        return this.cost;
    }

    protected boolean improve(BellmanFordPathElement<V, E> bellmanFordPathElement, E e2, double d) {
        if (d < this.getCost() - this.epsilon) {
            this.prevPathElement = bellmanFordPathElement;
            this.prevEdge = e2;
            this.cost = d;
            this.nHops = bellmanFordPathElement.getHopCount() + 1;
            return true;
        }
        return false;
    }
}

