/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.HashSet;
import java.util.Set;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.alg.BlockCutpointGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BiconnectivityInspector<V, E> {
    private BlockCutpointGraph<V, E> blockCutpointGraph;

    public BiconnectivityInspector(UndirectedGraph<V, E> undirectedGraph) {
        this.blockCutpointGraph = new BlockCutpointGraph<V, E>(undirectedGraph);
    }

    public Set<Set<V>> getBiconnectedVertexComponents() {
        HashSet<Set<V>> hashSet = new HashSet<Set<V>>();
        for (UndirectedGraph undirectedGraph : this.blockCutpointGraph.vertexSet()) {
            if (undirectedGraph.edgeSet().isEmpty()) continue;
            hashSet.add(undirectedGraph.vertexSet());
        }
        return hashSet;
    }

    public Set<Set<V>> getBiconnectedVertexComponents(V v) {
        HashSet<Set<V>> hashSet = new HashSet<Set<V>>();
        for (Set<V> set2 : this.getBiconnectedVertexComponents()) {
            if (!set2.contains(v)) continue;
            hashSet.add(set2);
        }
        return hashSet;
    }

    public Set<V> getCutpoints() {
        return this.blockCutpointGraph.getCutpoints();
    }

    public boolean isBiconnected() {
        return this.blockCutpointGraph.vertexSet().size() == 1;
    }
}

